/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.common.service.impl;

import com.jxdinfo.document.common.dto.AttachmentInfoDto;
import com.jxdinfo.document.common.dto.FileInfoDto;
import com.jxdinfo.document.common.service.IFileService;
import com.jxdinfo.document.common.util.DocumentCommonUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.license.ModuleVerify;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.document.common.service.impl.OssFileServiceImpl")
@ConditionalOnClass(name={"com.jxdinfo.hussar.support.oss.api.service.OssService"})
@ConditionalOnBean(value={IFileService.class})
@Qualifier(value="oss")
public class OssFileServiceImpl
implements IFileService {
    @Autowired(required=false)
    private OssService ossService;

    @Override
    public ApiResponse<AttachmentInfoDto> upload(MultipartFile multipartFile) {
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return ApiResponse.fail((String)"\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u7533\u8bf7\u667a\u80fd\u62a5\u544a\u6a21\u5757\u6388\u6743\uff01");
        }
        AttachmentInfoDto attachmentInfoDto = new AttachmentInfoDto();
        ApiResponse upload = this.ossService.backgroundUpload(multipartFile);
        if (upload.isSuccess()) {
            attachmentInfoDto = this.getModelById((Long)upload.getData());
        }
        return ApiResponse.success((Object)attachmentInfoDto);
    }

    @Override
    public void download(HttpServletResponse response, Long fileId) {
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return;
        }
        ApiResponse<FileInfoDto> apiResponse = this.downloadFileById(fileId);
        if (HussarUtils.isEmpty((Object)apiResponse.getData())) {
            throw new HussarException("\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25");
        }
        String fileName = ((FileInfoDto)apiResponse.getData()).getFileName();
        byte[] data = ((FileInfoDto)apiResponse.getData()).getFileContent();
        String fileType = ((FileInfoDto)apiResponse.getData()).getFileType();
        long fileSize = ((FileInfoDto)apiResponse.getData()).getFileSize();
        String contentType = DocumentCommonUtil.getContentTypeByFileType(fileType);
        response.setContentType(contentType);
        try {
            String downLoadFileName = URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%2B", "+");
            response.setHeader("Content-Disposition", "attachment; filename=" + downLoadFileName);
            response.setHeader("Content-Length", String.valueOf(fileSize));
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(data);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new HussarException("\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void showImage(Long id, HttpServletResponse response) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException("\u56fe\u7247id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        response.setContentType("text/html; charset=UTF-8");
        AttachmentInfoDto attachment = this.getModelById(id);
        if (attachment == null) {
            throw new HussarException("\u56fe\u7247\u4e0d\u5b58\u5728");
        }
        String extension = FileUtil.getFileExtension((String)attachment.getAttachmentName()).toLowerCase();
        String contentType = "";
        switch (extension) {
            case "png": {
                contentType = "image/png";
                break;
            }
            case "jpg": 
            case "jpeg": {
                contentType = "image/jpeg";
                break;
            }
            case "wmf": {
                contentType = "image/wmf";
                break;
            }
            default: {
                contentType = "application/octet-stream";
            }
        }
        response.setContentType(contentType);
        byte[] image = (byte[])this.backgroundDownload(id).getData();
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(image);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new HussarException("\u56fe\u7247\u5c55\u793a\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void showPictureToCache(Long id, HttpServletResponse response) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException("\u56fe\u7247id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        response.setContentType("text/html; charset=UTF-8");
        AttachmentInfoDto attachment = this.getModelById(id);
        if (attachment == null) {
            throw new HussarException("\u56fe\u7247\u4e0d\u5b58\u5728");
        }
        String extension = FileUtil.getFileExtension((String)attachment.getAttachmentName()).toLowerCase();
        String contentType = "";
        switch (extension) {
            case "png": {
                contentType = "image/png";
                break;
            }
            case "jpg": 
            case "jpeg": {
                contentType = "image/jpeg";
                break;
            }
            case "wmf": {
                contentType = "image/wmf";
                break;
            }
            default: {
                contentType = "application/octet-stream";
            }
        }
        response.setContentType(contentType);
        response.setHeader("Cache-Control", "public, max-age=2592000");
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 1);
        response.setHeader("Expires", new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US).format(calendar.getTime()));
        byte[] image = (byte[])this.backgroundDownload(id).getData();
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(image);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new HussarException("\u56fe\u7247\u5c55\u793a\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<byte[]> backgroundDownload(Long fileId) {
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return ApiResponse.fail((String)"\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u7533\u8bf7\u667a\u80fd\u62a5\u544a\u6a21\u5757\u6388\u6743\uff01");
        }
        ApiResponse apiResponse = this.ossService.backgroundDownload(fileId);
        return apiResponse;
    }

    @Override
    public AttachmentInfoDto getModelById(Long fileId) {
        AttachmentManagerModel model = this.ossService.getModelById(fileId);
        AttachmentInfoDto attachmentInfoDto = new AttachmentInfoDto();
        if (HussarUtils.isNotEmpty((Object)model)) {
            attachmentInfoDto.setFileId(model.getId());
            attachmentInfoDto.setPath(model.getAttachmentDir());
            attachmentInfoDto.setBusinessId(model.getBusinessId());
            attachmentInfoDto.setAttachmentName(model.getAttachmentName());
            attachmentInfoDto.setAttachmentType(model.getAttachmentType());
        }
        return attachmentInfoDto;
    }

    @Override
    public ApiResponse<FileInfoDto> downloadFileById(Long fileId) {
        FileInfoDto fileInfoDto = new FileInfoDto();
        if (HussarUtils.isNotEmpty((Object)fileId)) {
            AttachmentManagerModel attachmentManagerModel = this.ossService.getModelById(fileId);
            ApiResponse response = this.ossService.backgroundDownload(attachmentManagerModel.getId());
            fileInfoDto.setFileName(attachmentManagerModel.getAttachmentName());
            fileInfoDto.setFileSize(attachmentManagerModel.getAttachmentSize());
            fileInfoDto.setFileType(attachmentManagerModel.getAttachmentType());
            fileInfoDto.setFileContent((byte[])response.getData());
            return ApiResponse.success((Object)fileInfoDto);
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

