/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.common.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.springframework.web.multipart.MultipartFile;

public class FileUtil {
    public static String posixPath(String ... segments) {
        if ((segments = FileUtil.preprocessPathSegments(segments)).length == 0) {
            return "";
        }
        boolean leadingSlash = segments[0].startsWith("/") || segments[0].startsWith("\\");
        boolean trailingSlash = segments[segments.length - 1].endsWith("/") || segments[segments.length - 1].endsWith("\\");
        String path = Arrays.stream(segments).flatMap(segment -> Arrays.stream(segment.split("[/\\\\]", -1))).filter(segment -> !segment.isEmpty()).collect(Collectors.joining("/"));
        if (path.isEmpty() && leadingSlash && trailingSlash) {
            return "/";
        }
        path = leadingSlash ? "/" + path : path;
        path = trailingSlash ? path + "/" : path;
        return path;
    }

    private static String[] preprocessPathSegments(String[] segments) {
        if (segments == null) {
            return new String[0];
        }
        ArrayList<String> filteredSegments = new ArrayList<String>();
        for (String segment : segments) {
            if (segment == null || segment.isEmpty()) continue;
            filteredSegments.add(segment);
        }
        return filteredSegments.toArray(new String[0]);
    }

    public static void writeJsonToFile(String contentJson, String path, String fileName) {
        try {
            File jsonFile = new File(path, fileName);
            File parentDir = jsonFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            FileUtils.writeStringToFile((File)jsonFile, (String)contentJson, (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new HussarException("\u5bfc\u51fa\u6570\u636e\u5931\u8d25");
        }
        catch (IOException e) {
            throw new HussarException((Throwable)e);
        }
    }

    public static void writeFileToFileFolder(byte[] data, String attachmentDir, String fileName) {
        File attachmentFileDir = new File(attachmentDir);
        if (!attachmentFileDir.exists()) {
            attachmentFileDir.mkdir();
        }
        try {
            Path filePath = Paths.get(attachmentDir, fileName);
            Files.write(filePath, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new HussarException("\u5199\u5165\u9644\u4ef6\u5931\u8d25:" + e.getMessage());
        }
    }

    public static MultipartFile convertFileToMultipartFile(File file, String attachmentType) throws IOException {
        String originalFileName = file.getName();
        String contentType = HussarUtils.isNotEmpty((Object)attachmentType) ? attachmentType : Files.probeContentType(file.toPath());
        if (HussarUtils.isEmpty((Object)contentType)) {
            contentType = "application/octet-stream";
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            HussarBaseMultipartFile hussarBaseMultipartFile = new HussarBaseMultipartFile(originalFileName, originalFileName, contentType, (InputStream)inputStream);
            return hussarBaseMultipartFile;
        }
    }

    public static <T> T readFileToObject(String filePath, Class<T> clazz) throws IOException {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            String text = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
            return (T)JSON.parseObject((String)text, clazz);
        }
        return null;
    }

    public static <T> List<T> readFileToArray(String path, Class<T> clazz) throws IOException {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            String text = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
            return JSON.parseArray((String)text, clazz);
        }
        return null;
    }
}

