/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.common.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.common.dto.AttachmentInfoDto;
import com.jxdinfo.document.common.dto.FileInfoDto;
import com.jxdinfo.document.common.service.IDocumentDealService;
import com.jxdinfo.document.common.service.IDocumentInfoService;
import com.jxdinfo.document.common.service.IFileService;
import com.jxdinfo.document.common.service.ISealService;
import com.jxdinfo.document.common.vo.DocumentDetailsVo;
import com.jxdinfo.document.common.vo.DocumentSplitVo;
import com.jxdinfo.document.common.vo.ReplacePlaceholdersVo;
import com.jxdinfo.document.common.vo.TzglPageVO;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="com.jxdinfo.document.common.controller.WordDocumentController")
@RequestMapping(value={"/hussarDocument/document/info"})
@AuditLog(moduleName="\u6587\u6863\u8be6\u60c5\u4fe1\u606f")
@Api(tags={"\u56fe\u7ae0\u67e5\u8be2\u53ca\u6587\u6863\u4e0a\u4f20"})
public class WordDocumentController {
    @Resource
    private IDocumentInfoService documentInfoService;
    @Resource
    private ISealService sealService;
    @Resource
    private IFileService fileService;
    @Resource
    private IDocumentDealService iDocumentDealService;

    @ApiOperation(value="\u6839\u636e\u6587\u6863ID\u67e5\u8be2\u6587\u6863\u4fe1\u606f")
    @AuditLog(moduleName="\u6587\u6863\u8be6\u60c5\u4fe1\u606f\u8868", eventDesc="\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/queryDocumentDetail"})
    public ApiResponse<DocumentDetailsVo> queryDocumentDetail(@RequestParam(value="docId") String docId) {
        return this.documentInfoService.queryDocumentDetail(docId);
    }

    @ApiOperation(value="\u65b0\u5efa\u4e00\u4e2a\u7a7a\u767d\u6587\u6863")
    @AuditLog(moduleName="\u6587\u6863\u8be6\u60c5\u4fe1\u606f\u8868", eventDesc="\u65b0\u589e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/addBlankDocument"})
    public ApiResponse<Long> addBlankDocument(@ApiParam(value="\u6587\u6863\u540d\u79f0") @RequestParam String documentName, @ApiParam(value="\u6587\u6863\u7c7b\u578b") @RequestParam String type) {
        Long id = this.documentInfoService.addBlankDocument(documentName, type);
        return id == -1L ? ApiResponse.fail((String)"\u65b0\u5efa\u5931\u8d25") : ApiResponse.success((Object)id);
    }

    @ApiOperation(value="\u6839\u636e\u6587\u6863ID\u590d\u5236\u6587\u6863")
    @AuditLog(moduleName="\u6587\u6863\u8be6\u60c5\u4fe1\u606f\u8868", eventDesc="\u590d\u5236", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/copyDocument"})
    public ApiResponse<Long> copyDocument(@ApiParam(value="\u6587\u6863ID") @RequestParam Long docId) {
        Long id = this.documentInfoService.copyDocument(docId);
        return id == -1L ? ApiResponse.fail((String)"\u590d\u5236\u6587\u6863\u5931\u8d25") : ApiResponse.success((Object)id);
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d")
    @PostMapping(value={"/backgroundDownload"})
    public ApiResponse<byte[]> backgroundDownload(@ApiParam(value="\u6587\u4ef6id") @RequestParam Long fileId) {
        return this.fileService.backgroundDownload(fileId);
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f")
    @PostMapping(value={"/getModelById"})
    public AttachmentInfoDto getModelById(@RequestParam Long fileId) {
        return this.fileService.getModelById(fileId);
    }

    @ApiOperation(value="\u6839\u636e\u6587\u6863ID\u67e5\u8be2\u6587\u6863\u4fe1\u606f")
    @AuditLog(moduleName="\u6587\u6863\u8be6\u60c5\u4fe1\u606f\u8868", eventDesc="\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/queryDocument"})
    public ApiResponse<Object> queryDocument(@RequestParam(value="docId") String docId) {
        return this.documentInfoService.queryOffice(docId);
    }

    @ApiOperation(value="\u6839\u636e\u6587\u6863ID\u67e5\u8be2\u6587\u6863\u4fe1\u606f")
    @AuditLog(moduleName="\u6587\u6863\u8be6\u60c5\u4fe1\u606f\u8868", eventDesc="\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getDocumentById"})
    public ApiResponse<DocumentSplitVo> getDocumentById(@RequestParam(value="docId") String docId) {
        return this.documentInfoService.getDocumentById(docId);
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20")
    @PostMapping(value={"/uploadDocument"})
    public ApiResponse<AttachmentInfoDto> uploadDocument(@RequestParam(value="file") MultipartFile file) {
        return this.fileService.upload(file);
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d", notes="\u6587\u4ef6\u4e0b\u8f7d")
    @AuditLog(moduleName="\u6587\u4ef6\u4e0b\u8f7d", eventDesc="\u6587\u4ef6\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    @GetMapping(value={"/fileDownload"})
    public void fileDownload(HttpServletResponse response, @ApiParam(value="\u6587\u4ef6id") @RequestParam Long fileId) {
        this.fileService.download(response, fileId);
    }

    @ApiOperation(value="\u6587\u4ef6\u4e0b\u8f7d", notes="\u6587\u4ef6\u4e0b\u8f7d")
    @AuditLog(moduleName="\u6587\u4ef6\u4e0b\u8f7d", eventDesc="\u6587\u4ef6\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    @GetMapping(value={"/getFileInfo"})
    public ApiResponse<FileInfoDto> getFileInfo(@ApiParam(value="\u6587\u4ef6id") @RequestParam Long fileId) {
        return this.fileService.downloadFileById(fileId);
    }

    @ApiOperation(value="\u663e\u793a\u56fe\u7247", notes="\u663e\u793a\u56fe\u7247")
    @GetMapping(value={"/showPicture"})
    @Inner
    public void showImage(@ApiParam(value="\u6587\u4ef6id") @RequestParam Long id, HttpServletResponse response) {
        this.fileService.showImage(id, response);
    }

    @ApiOperation(value="\u663e\u793a\u56fe\u7247", notes="\u663e\u793a\u56fe\u7247")
    @GetMapping(value={"/showPictureToCache"})
    @Inner
    public void showImageToCache(@ApiParam(value="\u6587\u4ef6id") @RequestParam Long id, HttpServletResponse response) {
        this.fileService.showPictureToCache(id, response);
    }

    @AuditLog(moduleName="\u56fe\u7ae0\u7ba1\u7406", eventDesc="\u8868\u683c\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/hussarQueryPage"})
    public ApiResponse<TzglPageVO> hussarQueryPage() {
        return this.sealService.hussarQueryPage();
    }

    @ApiOperation(value="\u6570\u636e\u66ff\u6362\u6587\u6863\u5360\u4f4d\u7b26")
    @PostMapping(value={"/generateReportWithData"})
    public ApiResponse<JSONObject> generateReportWithData(@RequestBody ReplacePlaceholdersVo replacePlaceholdersVo) {
        return this.documentInfoService.replacePlaceholdersAndGenerate(replacePlaceholdersVo.getId(), replacePlaceholdersVo.getData(), replacePlaceholdersVo.isFullReplace());
    }

    @ApiOperation(value="\u5904\u7406\u62a5\u544a\u4e2d\u7684\u56fe\u7247\u5927\u5c0f", notes="\u5904\u7406\u62a5\u544a\u4e2d\u7684\u56fe\u7247\u5927\u5c0f")
    @AuditLog(moduleName="\u5904\u7406\u62a5\u544a\u4e2d\u7684\u56fe\u7247\u5927\u5c0f", eventDesc="\u5904\u7406\u62a5\u544a\u4e2d\u7684\u56fe\u7247\u5927\u5c0f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @GetMapping(value={"/dealImageSize"})
    public ApiResponse<Long> dealImageSize(@ApiParam(value="\u6587\u4ef6id") @RequestParam Long docId) {
        return this.iDocumentDealService.dealImageSize(docId);
    }
}

