/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.document.common.dao.DocDataBindInfoMapper;
import com.jxdinfo.document.common.model.DocDataBindInfo;
import com.jxdinfo.document.common.service.DocumentDataBindService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.common.service.impl.DocumentDataBindServiceImpl")
public class DocumentDataBindServiceImpl
extends HussarServiceImpl<DocDataBindInfoMapper, DocDataBindInfo>
implements DocumentDataBindService {
    @Override
    public ApiResponse<Long> insertOrUpdate(DocDataBindInfo docDataBindInfo) {
        this.saveOrUpdate((BaseEntity)docDataBindInfo);
        return ApiResponse.success((Object)docDataBindInfo.getDataBindId());
    }

    @Override
    public ApiResponse<DocDataBindInfo> getDataBindById(Long docId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DocDataBindInfo::getDocId, (Object)docId);
        DocDataBindInfo docDataBindInfo = (DocDataBindInfo)((Object)this.getOne((Wrapper)queryWrapper));
        return ApiResponse.success((Object)((Object)docDataBindInfo));
    }

    @Override
    public ApiResponse<List<DocDataBindInfo>> getDataBindsInDocIds(List<Long> docIds) {
        if (HussarUtils.isNotEmpty(docIds)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(DocDataBindInfo::getDocId, docIds);
            List docDataBindInfos = ((DocDataBindInfoMapper)this.getBaseMapper()).selectList((Wrapper)queryWrapper);
            return ApiResponse.success((Object)docDataBindInfos);
        }
        return null;
    }

    public Long copyDataBind(Long oldDocId, Long newDocId) {
        ApiResponse<DocDataBindInfo> dataBindByIdAPI = this.getDataBindById(oldDocId);
        if (dataBindByIdAPI.isSuccess() && HussarUtils.isNotEmpty((Object)dataBindByIdAPI.getData()) && HussarUtils.isNotEmpty((Object)newDocId)) {
            DocDataBindInfo dataBindInfo = (DocDataBindInfo)((Object)dataBindByIdAPI.getData());
            DocDataBindInfo copyInfo = new DocDataBindInfo();
            copyInfo.setDataBindId(newDocId);
            copyInfo.setDocId(newDocId);
            copyInfo.setDataBindDetails(dataBindInfo.getDataBindDetails());
            copyInfo.setWordDataSet(dataBindInfo.getWordDataSet());
            copyInfo.setInterFaceName(dataBindInfo.getInterFaceName());
            return (Long)this.insertOrUpdate(copyInfo).getData();
        }
        return null;
    }
}

