/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.common.util;

import com.jxdinfo.document.common.DocumentType;
import com.jxdinfo.document.common.dto.AttachmentInfoDto;
import java.io.File;

public class DocumentCommonUtil {
    public static String getTypeNameByCode(int code) {
        if (code == DocumentType.WORD_MODEL.getTypeCode()) {
            return DocumentType.WORD_MODEL.getTypeName();
        }
        if (code == DocumentType.WORD_REPORT.getTypeCode()) {
            return DocumentType.WORD_REPORT.getTypeName();
        }
        if (code == DocumentType.EXCEL_REPORT_TOOL_FORM_COMPONENT_TEMPLATE.getTypeCode()) {
            return DocumentType.EXCEL_REPORT_TOOL_FORM_COMPONENT_TEMPLATE.getTypeName();
        }
        if (code == DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeCode()) {
            return DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeName();
        }
        if (code == DocumentType.EXCEL_REPORT_TOOL_FORM_INSTANCE.getTypeCode()) {
            return DocumentType.EXCEL_REPORT_TOOL_FORM_TEMPLATE.getTypeName();
        }
        return "";
    }

    public static String getFilePath(AttachmentInfoDto modelDto) {
        String path = modelDto.getPath();
        String type = modelDto.getAttachmentType();
        Long fileId = modelDto.getFileId();
        String filePath = path + File.separator + fileId + "." + type;
        return filePath;
    }

    public static String getContentTypeByFileType(String fileType) {
        String lowerFileType;
        switch (lowerFileType = fileType.toLowerCase()) {
            case "xls": {
                return "application/vnd.ms-excel";
            }
            case "xlsx": {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            case "doc": {
                return "application/msword";
            }
            case "docx": {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            case "ppt": {
                return "application/vnd.ms-powerpoint";
            }
            case "pptx": {
                return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            }
            case "pdf": {
                return "application/pdf";
            }
            case "txt": {
                return "text/plain";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "png": {
                return "image/png";
            }
            case "gif": {
                return "image/gif";
            }
            case "zip": {
                return "application/zip";
            }
            case "rar": {
                return "application/x-rar-compressed";
            }
        }
        return "application/octet-stream";
    }
}

