/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.common.model.DocumentAttachmentModel;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocumentExportUtil {
    public static List<DocumentAttachmentModel> getAttachmentList(String detailContent) {
        ArrayList<DocumentAttachmentModel> rawList = new ArrayList<DocumentAttachmentModel>();
        JSONObject jsonObject = JSON.parseObject((String)detailContent);
        DocumentExportUtil.traverseNodes(jsonObject, rawList);
        HashMap<String, Integer> fileNameCountMap = new HashMap<String, Integer>();
        for (DocumentAttachmentModel item : rawList) {
            String newFileName;
            if (item.getOriginalFileId() == null || item.getOriginalFileId().trim().isEmpty()) continue;
            String originalFileName = item.getFileName();
            int count = fileNameCountMap.getOrDefault(originalFileName, 0);
            if (count == 0) {
                newFileName = originalFileName;
            } else {
                String baseName = originalFileName;
                String extension = "";
                int dotIndex = originalFileName.lastIndexOf(46);
                if (dotIndex > 0) {
                    baseName = originalFileName.substring(0, dotIndex);
                    extension = originalFileName.substring(dotIndex);
                }
                newFileName = baseName + "(" + count + ")" + extension;
            }
            fileNameCountMap.put(originalFileName, count + 1);
            item.setFileName(newFileName);
        }
        return rawList;
    }

    private static void traverseNodes(JSONObject node, List<DocumentAttachmentModel> results) {
        JSONArray content;
        JSONObject attrs;
        String type = node.getString("type");
        if ("image".equals(type) && HussarUtils.isNotEmpty((Object)(attrs = node.getJSONObject("attrs")))) {
            DocumentAttachmentModel item;
            String fileId;
            String fileName;
            String src;
            if ("file".equals(attrs.getString("type"))) {
                src = attrs.getString("src");
                fileName = attrs.getString("fileName");
                if (HussarUtils.isNotEmpty((Object)src) && src.contains("?fileId")) {
                    fileId = src.substring(src.lastIndexOf("=") + 1);
                    fileName = HussarUtils.isNotEmpty((Object)fileName) ? fileName : fileId;
                    item = new DocumentAttachmentModel(fileName, fileId, "file");
                    results.add(item);
                } else if (src.contains("showPicture?id=")) {
                    fileId = src.substring(src.lastIndexOf("=") + 1);
                    fileName = HussarUtils.isNotEmpty((Object)fileName) ? fileName : fileId;
                    item = new DocumentAttachmentModel(fileName, fileId, "file");
                    results.add(item);
                }
            } else if ("image".equals(attrs.getString("type"))) {
                src = attrs.getString("src");
                fileName = attrs.getString("fileName");
                if (HussarUtils.isNotEmpty((Object)src) && src.contains("?fileId")) {
                    fileId = src.substring(src.lastIndexOf("=") + 1);
                    fileName = HussarUtils.isNotEmpty((Object)fileName) ? fileName : fileId;
                    item = new DocumentAttachmentModel(fileName, fileId, "image");
                    results.add(item);
                } else if (src.contains("showPicture?id=")) {
                    fileId = src.substring(src.lastIndexOf("=") + 1);
                    fileName = HussarUtils.isNotEmpty((Object)fileName) ? fileName : fileId;
                    item = new DocumentAttachmentModel(fileName, fileId, "image");
                    results.add(item);
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)(content = node.getJSONArray("content")))) {
            for (int i = 0; i < content.size(); ++i) {
                JSONObject childNode = content.getJSONObject(i);
                DocumentExportUtil.traverseNodes(childNode, results);
            }
        }
    }

    public static void changeDocumentAttachmentFileId(Map<String, JSONObject> sysDocumentMap, List<DocumentAttachmentModel> attachmentList) {
        JSONObject wordEditorDetailObj = sysDocumentMap.get("wordEditorDetail");
        String detailContent = wordEditorDetailObj.getString("detailContent");
        String contentStr = DocumentExportUtil.convertAttachmentDetailContent(detailContent, attachmentList);
        wordEditorDetailObj.put("detailContent", (Object)contentStr);
    }

    private static String convertAttachmentDetailContent(String detailContent, List<DocumentAttachmentModel> attachmentList) {
        if (HussarUtils.isEmpty((Object)detailContent)) {
            return detailContent;
        }
        JSONObject inputDoc = JSON.parseObject((String)detailContent);
        if (inputDoc.containsKey((Object)"content")) {
            JSONArray contentArray = inputDoc.getJSONArray("content");
            DocumentExportUtil.convertContent(contentArray, attachmentList);
        }
        return inputDoc.toString();
    }

    private static void convertContent(JSONArray content, List<DocumentAttachmentModel> attachmentList) {
        if (HussarUtils.isEmpty((Object)content)) {
            return;
        }
        block6: for (int i = 0; i < content.size(); ++i) {
            String type;
            JSONObject contentItem = content.getJSONObject(i);
            if (!contentItem.containsKey((Object)"type")) continue;
            switch (type = contentItem.getString("type")) {
                case "image": {
                    DocumentExportUtil.processImageNode(contentItem, attachmentList);
                    continue block6;
                }
                default: {
                    if ("headerFooter".equals(type)) {
                        DocumentExportUtil.processHeaderfooterOnlyAttrs(contentItem, attachmentList);
                    }
                    if (!contentItem.containsKey((Object)"content")) continue block6;
                    DocumentExportUtil.convertContent(contentItem.getJSONArray("content"), attachmentList);
                }
            }
        }
    }

    private static void processHeaderfooterOnlyAttrs(JSONObject headerfooterNode, List<DocumentAttachmentModel> attachmentList) {
        JSONObject attrs;
        if (HussarUtils.isEmpty((Object)headerfooterNode)) {
            return;
        }
        String nodeType = headerfooterNode.getString("type");
        if (!"headerFooter".equals(nodeType)) {
            return;
        }
        if (headerfooterNode.containsKey((Object)"attrs") && HussarUtils.isNotEmpty((Object)(attrs = headerfooterNode.getJSONObject("attrs")))) {
            DocumentExportUtil.processHeaderfooterContent(attrs.getJSONObject("headerContent"), attachmentList);
            DocumentExportUtil.processHeaderfooterContent(attrs.getJSONObject("footerContent"), attachmentList);
            DocumentExportUtil.processHeaderfooterInfo(attrs.getJSONObject("headerInfo"), attachmentList);
            DocumentExportUtil.processHeaderfooterInfo(attrs.getJSONObject("footerInfo"), attachmentList);
        }
    }

    private static void processHeaderfooterInfo(JSONObject info, List<DocumentAttachmentModel> attachmentList) {
        if (HussarUtils.isEmpty((Object)info)) {
            return;
        }
        ArrayList<String> needDealList = new ArrayList<String>(Arrays.asList("even", "common", "first", "odd"));
        JSONObject itemObj = HussarUtils.isNotEmpty((Object)info.getJSONObject("headerItem")) ? info.getJSONObject("headerItem") : info.getJSONObject("footerItem");
        block0: for (String key : needDealList) {
            String htmlStr;
            JSONObject needJsonObj = itemObj.getJSONObject(key);
            if (HussarUtils.isEmpty((Object)needJsonObj) || HussarUtils.isEmpty((Object)(htmlStr = needJsonObj.getString("html")))) continue;
            String fileId = "";
            Pattern patternFileId = Pattern.compile("fileDownload\\?fileId=(\\d+)");
            Matcher matcherFileId = patternFileId.matcher(htmlStr);
            if (matcherFileId.find()) {
                fileId = matcherFileId.group(1);
                for (DocumentAttachmentModel model : attachmentList) {
                    if (!fileId.equals(model.getOriginalFileId())) continue;
                    htmlStr = matcherFileId.replaceAll("fileDownload\\?fileId=" + model.getNewFileId());
                    needJsonObj.put("html", (Object)htmlStr);
                    continue block0;
                }
                continue;
            }
            Pattern patternID = Pattern.compile("showPicture\\?id=(\\d+)");
            Matcher matcherID = patternID.matcher(htmlStr);
            if (!matcherID.find()) continue;
            fileId = matcherID.group(1);
            for (DocumentAttachmentModel model : attachmentList) {
                if (!fileId.equals(model.getOriginalFileId())) continue;
                htmlStr = matcherID.replaceAll("showPicture\\?id=" + model.getNewFileId());
                needJsonObj.put("html", (Object)htmlStr);
                continue block0;
            }
        }
    }

    private static void processHeaderfooterContent(JSONObject content, List<DocumentAttachmentModel> attachmentList) {
        if (HussarUtils.isEmpty((Object)content)) {
            return;
        }
        ArrayList<String> needDealList = new ArrayList<String>(Arrays.asList("even", "common", "first", "odd"));
        for (String key : needDealList) {
            JSONObject needJsonObj = content.getJSONObject(key);
            if (HussarUtils.isEmpty((Object)needJsonObj)) continue;
            JSONArray contentList = needJsonObj.getJSONArray("content");
            DocumentExportUtil.convertContent(contentList, attachmentList);
        }
    }

    private static void processImageNode(JSONObject imageNode, List<DocumentAttachmentModel> attachmentList) {
        block8: {
            JSONObject attrs;
            if (HussarUtils.isEmpty((Object)imageNode)) {
                return;
            }
            String nodeType = imageNode.getString("type");
            if (!"image".equals(nodeType)) {
                return;
            }
            if (!imageNode.containsKey((Object)"attrs") || !HussarUtils.isNotEmpty((Object)(attrs = imageNode.getJSONObject("attrs")))) break block8;
            String src = attrs.getString("src");
            String type = attrs.getString("type");
            if ("file".equals(type) || "image".equals(type)) {
                if (HussarUtils.isNotEmpty((Object)src) && src.contains("?fileId")) {
                    String fileId = src.substring(src.lastIndexOf("=") + 1);
                    for (DocumentAttachmentModel model : attachmentList) {
                        if (!fileId.equals(model.getOriginalFileId())) continue;
                        attrs.put("src", (Object)("/hussarDocument/document/info/fileDownload?fileId=" + model.getNewFileId()));
                    }
                } else if (HussarUtils.isNotEmpty((Object)src) && src.contains("showPicture?id=")) {
                    String fileId = src.substring(src.lastIndexOf("=") + 1);
                    for (DocumentAttachmentModel model : attachmentList) {
                        if (!fileId.equals(model.getOriginalFileId())) continue;
                        attrs.put("src", (Object)("/hussarDocument/document/info/showPicture?id=" + model.getNewFileId()));
                    }
                }
            }
        }
    }

    public static List<Long> parseWordDataSetJsonToIdList(String dataSetJson) {
        ArrayList<Long> uniqueDatasetIds = new ArrayList<Long>();
        if (HussarUtils.isEmpty((Object)dataSetJson)) {
            return uniqueDatasetIds;
        }
        JSONArray jsonArray = JSON.parseArray((String)dataSetJson);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String id = jsonObject.getString("bindDataSetId");
            uniqueDatasetIds.add(Long.parseLong(id));
        }
        return uniqueDatasetIds;
    }
}

