/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.common.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.document.common.dto.DocumentSaveDetailsDto;
import com.jxdinfo.document.common.service.IDocumentBaseService;
import com.jxdinfo.document.common.service.IDocumentInfoService;
import com.jxdinfo.document.common.service.ISysDocumentImpExpService;
import com.jxdinfo.document.common.vo.DocumentSaveDetailsVo;
import com.jxdinfo.document.common.vo.ImportStatusVo;
import com.jxdinfo.document.common.vo.WordDocTypeInfoQueryParamVo;
import com.jxdinfo.document.common.vo.WordDocTypeInfoVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="com.jxdinfo.document.common.controller.DocBaseCustomController")
@RequestMapping(value={"/document/common/base/custom"})
@AuditLog(moduleName="\u516c\u5171-\u57fa\u7840\u4fe1\u606f")
@Api(tags={"\u516c\u5171-\u57fa\u7840\u4fe1\u606f"})
public class DocBaseCustomController {
    @Resource
    private IDocumentInfoService documentInfoService;
    @Resource
    private ISysDocumentImpExpService documentImpExpService;
    @Resource
    private IDocumentBaseService documentBaseService;

    @ApiOperation(value="\u5217\u8868\u5206\u9875\u6587\u6863\u4fe1\u606f\u67e5\u8be2")
    @AuditLog(moduleName="\u6587\u6863\u4fe1\u606f", eventDesc="\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/queryTableList"})
    public ApiResponse<Page<WordDocTypeInfoVo>> queryTableList(@RequestBody Page<WordDocTypeInfoQueryParamVo> page) {
        return this.documentInfoService.queryTableList(page);
    }

    @ApiOperation(value="\u65b0\u5efa\u7a7a\u767d\u6587\u6863")
    @AuditLog(moduleName="\u6587\u6863\u4fe1\u606f", eventDesc="\u65b0\u589e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @PostMapping(value={"/addBlankDocument"})
    public ApiResponse<Long> addBlankDocument(@ApiParam(value="\u6587\u6863\u540d\u79f0") @RequestParam String documentName, @ApiParam(value="\u6587\u6863\u7c7b\u578b") @RequestParam String type, @ApiParam(value="\u6587\u6863\u5206\u7ec4\u4e3b\u952e") @RequestParam(value="groupId", required=false) String groupId) {
        Long id = this.documentInfoService.addBlankDocument(documentName, type, groupId);
        return id == -1L ? ApiResponse.fail((String)"\u65b0\u5efa\u5931\u8d25") : ApiResponse.success((Object)id);
    }

    @ApiOperation(value="\u5220\u9664\u6587\u6863")
    @AuditLog(moduleName="\u6587\u6863\u4fe1\u606f", eventDesc="\u5220\u9664", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/batchDeleteDocument"})
    public ApiResponse<Boolean> batchDeleteDocument(@ApiParam(value="\u6587\u6863ID\u96c6\u5408") @RequestParam List<String> docIds) {
        return this.documentInfoService.batchDeleteDocument(docIds);
    }

    @ApiOperation(value="\u590d\u5236\u6587\u6863")
    @AuditLog(moduleName="\u6587\u6863\u4fe1\u606f", eventDesc="\u590d\u5236", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/copyDocument"})
    public ApiResponse<Long> copyDocument(@ApiParam(value="\u6587\u6863ID") @RequestParam(value="docId") String docId) {
        Long id = this.documentInfoService.copyDocument(Long.valueOf(docId));
        return id == -1L ? ApiResponse.fail((String)"\u590d\u5236\u6587\u6863\u5931\u8d25") : ApiResponse.success((Object)id);
    }

    @ApiOperation(value="\u4e0b\u8f7d\u6587\u6863")
    @AuditLog(moduleName="\u6587\u6863\u4fe1\u606f", eventDesc="\u4e0b\u8f7d", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/downDocument"})
    public void downDocument(HttpServletResponse response, @ApiParam(value="\u6587\u6863ID") @RequestParam(value="docId") String docId) {
        this.documentInfoService.downDocument(response, Long.valueOf(docId));
    }

    @ApiOperation(value="\u5bfc\u5165\u6587\u6863")
    @AuditLog(moduleName="\u6587\u6863\u4fe1\u606f", eventDesc="\u5bfc\u5165\u6587\u4ef6", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/importDocument"})
    public ApiResponse<Long> importDocument(@ApiParam(value="\u6587\u4ef6") @RequestParam(value="file") MultipartFile file, @ApiParam(value="\u6587\u4ef6\u540d\u79f0") @RequestParam(value="docName", required=false) String docName, @ApiParam(value="\u5206\u7ec4\u4e3b\u952e") @RequestParam(value="groupId", required=false) Long groupId, @ApiParam(value="\u7c7b\u578b") @RequestParam(value="type", required=false) String type) {
        return this.documentInfoService.importDocument(file, docName, groupId, type);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51fa\u6587\u6863")
    @GetMapping(value={"/batchExportDocument"})
    public void batchExportDocument(@RequestParam(value="docIds") String docIds, HttpServletResponse response) {
        this.documentImpExpService.exportDocument(docIds, response);
    }

    @PostMapping(value={"/batchImportDocument"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165", notes="\u6279\u91cf\u5bfc\u5165")
    public ApiResponse<Map<String, String>> batchImportDocument(@RequestParam List<MultipartFile> files) {
        return this.documentImpExpService.batchImportDocument(files);
    }

    @GetMapping(value={"/import_progress"})
    @ApiOperation(value="\u83b7\u53d6\u5bfc\u5165\u6587\u6863\u8fdb\u5ea6", notes="\u83b7\u53d6\u5bfc\u5165\u6587\u6863\u8fdb\u5ea6")
    public ApiResponse<ImportStatusVo> getImportProgress(@RequestParam String importCacheKey) {
        return this.documentImpExpService.getImportProgress(importCacheKey);
    }

    @ApiOperation(value="\u6587\u6863\u4fdd\u5b58")
    @AuditLog(moduleName="\u6587\u6863\u76f8\u5173\u8868", eventDesc="\u4fee\u6539", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/saveDocumentDetail"})
    public ApiResponse<DocumentSaveDetailsVo> saveWordEditorDetail(@RequestBody DocumentSaveDetailsDto documentSaveDetailsDto) {
        return this.documentBaseService.saveWordEditorDetail(documentSaveDetailsDto);
    }
}

