/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.calculate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.calculate.factory.DocumentCustomDataFactory;
import com.jxdinfo.document.calculate.service.DocumentGenerateService;
import com.jxdinfo.document.common.model.GenerateReportParam;
import com.jxdinfo.document.common.service.DocumentDataBindService;
import com.jxdinfo.document.common.service.IDocumentInfoService;
import com.jxdinfo.document.data.build.binddata.service.DocumentDataSetBuildService;
import com.jxdinfo.hussar.license.ModuleVerify;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.document.calculate.service.impl.DocumentGenerateServiceImpl")
public class DocumentGenerateServiceImpl
implements DocumentGenerateService {
    @Resource
    private IDocumentInfoService documentInfoService;
    @Resource
    private DocumentDataSetBuildService documentDataSetBuildService;
    @Resource
    private DocumentDataBindService documentDataBindService;

    @Override
    public ApiResponse<Object> generateReport(GenerateReportParam generateReportParam) {
        Long reportId;
        Long businessId;
        ApiResponse executeJSResponse;
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return ApiResponse.fail((String)"\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u7533\u8bf7\u667a\u80fd\u62a5\u544a\u6a21\u5757\u6388\u6743\uff01");
        }
        ApiResponse<Object> documentDSAPIR = this.constructDocumentDS(generateReportParam);
        Object data = null;
        if (HussarUtils.isNotEmpty(documentDSAPIR) && documentDSAPIR.isSuccess() && HussarUtils.isNotEmpty((Object)documentDSAPIR.getData())) {
            data = documentDSAPIR.getData();
        }
        if ((executeJSResponse = this.documentInfoService.replacePlaceholdersAndGenerate(businessId = generateReportParam.getBusinessId(), data, false)).isSuccess() && HussarUtils.isNotEmpty((Object)executeJSResponse.getData()) && HussarUtils.isNotEmpty((Object)(reportId = this.documentInfoService.generateReport(businessId, (JSONObject)executeJSResponse.getData())))) {
            return ApiResponse.success((Object)reportId);
        }
        return ApiResponse.fail((String)"\u751f\u6210\u62a5\u544a\u5931\u8d25");
    }

    @Override
    public ApiResponse<Object> constructDocumentDS(GenerateReportParam generateReportParam) {
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return ApiResponse.fail((String)"\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u7533\u8bf7\u667a\u80fd\u62a5\u544a\u6a21\u5757\u6388\u6743\uff01");
        }
        Long businessId = generateReportParam.getBusinessId();
        if (HussarUtils.isEmpty((Object)businessId)) {
            throw new HussarException("\u4e1a\u52a1id\u4e3a\u7a7a");
        }
        ApiResponse queryOfficeObj = this.documentInfoService.queryOffice(businessId.toString());
        if (!queryOfficeObj.isSuccess() || HussarUtils.isEmpty((Object)queryOfficeObj.getData())) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u6587\u4ef6");
        }
        JSONObject officeDataJson = JSON.parseObject((String)HussarUtils.toJson((Object)queryOfficeObj.getData()));
        HashMap<String, Map> inputParam = new HashMap<String, Map>();
        inputParam.put("inputParam", generateReportParam.getInputParam());
        inputParam.put("customParams", generateReportParam.getCustomParams());
        JSONObject databindDetails = officeDataJson.getJSONObject("databindDetails");
        JSONArray wordDataSet = officeDataJson.getJSONArray("wordDataSet");
        JSONObject jsonObject = this.documentDataSetBuildService.buildDataSet(databindDetails, wordDataSet, inputParam);
        String dataFlag = officeDataJson.getString("interFaceName");
        if (DocumentCustomDataFactory.isContainsFlag(dataFlag)) {
            jsonObject = DocumentCustomDataFactory.get(dataFlag).generateCustomData(businessId, generateReportParam.getInputParam(), generateReportParam.getCustomParams(), jsonObject);
        }
        return ApiResponse.success((Object)jsonObject);
    }

    @Override
    public ApiResponse<Object> constructDocumentDSIncrement(GenerateReportParam generateReportParam) {
        ModuleVerify mv = new ModuleVerify();
        if (!mv.verify("a775d647e0f64fdd8ad6db742f091ae4")) {
            return ApiResponse.fail((String)"\u6388\u6743\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u7533\u8bf7\u667a\u80fd\u62a5\u544a\u6a21\u5757\u6388\u6743\uff01");
        }
        Long businessId = generateReportParam.getBusinessId();
        if (HussarUtils.isEmpty((Object)businessId)) {
            throw new HussarException("\u4e1a\u52a1id\u4e3a\u7a7a");
        }
        ApiResponse queryOfficeObj = this.documentInfoService.queryOffice(businessId.toString());
        if (!queryOfficeObj.isSuccess() || HussarUtils.isEmpty((Object)queryOfficeObj.getData())) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u6587\u4ef6");
        }
        JSONObject officeDataJson = JSON.parseObject((String)HussarUtils.toJson((Object)queryOfficeObj.getData()));
        HashMap<String, Map> inputParam = new HashMap<String, Map>();
        inputParam.put("inputParam", generateReportParam.getInputParam());
        inputParam.put("customParams", generateReportParam.getCustomParams());
        JSONObject databindDetails = officeDataJson.getJSONObject("databindDetails");
        JSONArray wordDataSet = officeDataJson.getJSONArray("wordDataSet");
        JSONObject jsonObject = this.documentDataSetBuildService.buildDataSetIncrement(databindDetails, wordDataSet, inputParam);
        String dataFlag = officeDataJson.getString("interFaceName");
        if (DocumentCustomDataFactory.isContainsFlag(dataFlag)) {
            jsonObject = DocumentCustomDataFactory.get(dataFlag).generateCustomData(businessId, generateReportParam.getInputParam(), generateReportParam.getCustomParams(), jsonObject);
        }
        return ApiResponse.success((Object)jsonObject);
    }
}

