/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.data.build.binddata.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.data.build.binddata.content.BindConstant;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiColumnPivotTable {
    private static final String COLUMN_KEY_DELIMITER = "|";

    public static JSONArray pivot(JSONArray data, List<String> rowKeys, List<String> columnArrayNameList, Map<String, JSONArray> cloTextGroupContent, Map<String, List<String>> valueKeysMap) {
        JSONArray result = new JSONArray();
        HashMap<String, Set<String>> headerKeysGroup = new HashMap<String, Set<String>>();
        HashMap objectObjectHashMap = new HashMap();
        for (int i = 0; i < columnArrayNameList.size(); ++i) {
            JSONArray objects = cloTextGroupContent.get(columnArrayNameList.get(i));
            LinkedHashSet<String> columnCombinationSet = new LinkedHashSet<String>();
            LinkedHashSet<String> objectObjectHashMapSet = new LinkedHashSet<String>();
            for (Object item : objects) {
                JSONObject itemObj = (JSONObject)item;
                String string = itemObj.getString(BindConstant.BIND_KEY);
                for (Object datum : data) {
                    JSONObject datumObj = (JSONObject)datum;
                    columnCombinationSet.add(datumObj.getString(string));
                    objectObjectHashMapSet.add(string + " - " + datumObj.getString(string));
                }
            }
            objectObjectHashMap.put(columnArrayNameList.get(i), objectObjectHashMapSet);
            headerKeysGroup.put(columnArrayNameList.get(i), columnCombinationSet);
        }
        result.add((Object)MultiColumnPivotTable.createHeaderRow(rowKeys, headerKeysGroup, valueKeysMap));
        LinkedHashMap langMap = new LinkedHashMap();
        for (int i = 0; i < data.size(); ++i) {
            List<JSONObject> jsonObjects;
            JSONObject obj = (JSONObject)data.get(i);
            String eachLangKey = "";
            for (int j = 0; j < rowKeys.size(); ++j) {
                eachLangKey = eachLangKey + obj.getString(rowKeys.get(j)) + COLUMN_KEY_DELIMITER;
            }
            if (HussarUtils.isNotEmpty((Object)eachLangKey)) {
                eachLangKey = eachLangKey.substring(0, eachLangKey.length() - 1);
            }
            if (!langMap.containsKey(eachLangKey)) {
                jsonObjects = new ArrayList<JSONObject>();
                jsonObjects.add(obj);
                langMap.put(eachLangKey, jsonObjects);
                continue;
            }
            jsonObjects = (List)langMap.get(eachLangKey);
            jsonObjects.add(obj);
        }
        for (Map.Entry stringListEntry : langMap.entrySet()) {
            String key = (String)stringListEntry.getKey();
            JSONArray row = new JSONArray();
            String[] rowKeyParts = key.split("\\|");
            for (String part : rowKeyParts) {
                row.add((Object)part);
            }
            for (Map.Entry entry : valueKeysMap.entrySet()) {
                List valueKeyList = (List)entry.getValue();
                Set keyKeyList = (Set)objectObjectHashMap.get(entry.getKey());
                List dataValue = (List)stringListEntry.getValue();
                int x = keyKeyList.size() / valueKeyList.size();
                int count = 1;
                int stringIndex = 0;
                for (String s : keyKeyList) {
                    int dashIndex = s.indexOf(" - ");
                    String keyFist = s.substring(0, dashIndex);
                    String keySec = s.substring(dashIndex + 3);
                    if (count > x) {
                        ++stringIndex;
                        count = 1;
                    }
                    for (int i = 0; i < dataValue.size(); ++i) {
                        JSONObject jsonObject = (JSONObject)dataValue.get(i);
                        if (jsonObject.containsKey((Object)keyFist) && jsonObject.get((Object)keyFist).equals(keySec)) {
                            row.add((Object)jsonObject.getString((String)valueKeyList.get(stringIndex)));
                            break;
                        }
                        if (i < dataValue.size() - 1) continue;
                        row.add((Object)"");
                    }
                    ++count;
                }
            }
            result.add((Object)row);
        }
        return result;
    }

    private static String generateRowKey(JSONObject obj, List<String> rowKeys) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (String key : rowKeys) {
            sb.append(delimiter);
            Object value = obj.get((Object)key);
            sb.append(value != null ? String.valueOf(value) : "");
            delimiter = COLUMN_KEY_DELIMITER;
        }
        return sb.toString();
    }

    private static String generateColumnKey(JSONObject obj, List<String> columnKeys) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (String key : columnKeys) {
            sb.append(delimiter);
            Object value = obj.get((Object)key);
            sb.append(value != null ? String.valueOf(value) : "");
            delimiter = COLUMN_KEY_DELIMITER;
        }
        return sb.toString();
    }

    private static String generateColumnKeyNew(JSONObject obj, Map<String, List<String>> columnKeysMap) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (Map.Entry<String, List<String>> entry : columnKeysMap.entrySet()) {
            List<String> keyList = entry.getValue();
            for (String key : keyList) {
                sb.append(delimiter);
                Object value = obj.get((Object)key);
                sb.append(value != null ? String.valueOf(value) : "");
                delimiter = COLUMN_KEY_DELIMITER;
            }
        }
        return sb.toString();
    }

    private static JSONArray createHeaderRow(List<String> rowKeys, Map<String, Set<String>> columnCombinations, Map<String, List<String>> valueKeysMap) {
        JSONArray header = new JSONArray();
        header.addAll(rowKeys);
        for (Map.Entry<String, Set<String>> entry : columnCombinations.entrySet()) {
            Set<String> value = entry.getValue();
            String key = entry.getKey();
            List<String> strings1 = valueKeysMap.get(key);
            int i = value.size() / strings1.size();
            int count = 1;
            int stringIndex = 0;
            for (String s : value) {
                if (count > i) {
                    ++stringIndex;
                    count = 1;
                }
                header.add((Object)(s + " - " + strings1.get(stringIndex)));
                ++count;
            }
        }
        return header;
    }
}

