/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.document.data.build.binddata.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.document.data.build.binddata.content.BindConstant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiColumnPivotTable {
    private static final String COLUMN_KEY_DELIMITER = "|";

    public static JSONArray pivot(JSONArray data, List<String> rowKeys, List<String> columnArrayNameList, Map<String, JSONArray> cloTextGroupContent, Map<String, List<String>> valueKeysMap) {
        JSONArray result = new JSONArray();
        LinkedHashSet<String> columnCombinationSet = new LinkedHashSet<String>();
        for (String string : rowKeys) {
            columnCombinationSet.add(string);
        }
        ArrayList preprocessedData = new ArrayList();
        for (Object datum : data) {
            JSONObject datumObj = (JSONObject)datum;
            HashMap<String, String> keyValueMap = new HashMap<String, String>();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < columnArrayNameList.size(); ++i) {
                JSONArray objects = cloTextGroupContent.get(columnArrayNameList.get(i));
                for (Object item : objects) {
                    JSONObject itemObj = (JSONObject)item;
                    String string = itemObj.getString(BindConstant.BIND_KEY);
                    String value = datumObj.getString(string);
                    stringBuilder.append(string).append(" |- ");
                    stringBuilder.append(value).append(" |- ");
                    keyValueMap.put(string, value);
                }
            }
            int lastIndex = stringBuilder.lastIndexOf(" |- ");
            if (lastIndex != -1) {
                stringBuilder.delete(lastIndex, lastIndex + 4);
            }
            columnCombinationSet.add(stringBuilder.toString());
            preprocessedData.add(keyValueMap);
        }
        result.add(new ArrayList(columnCombinationSet));
        HashMap<String, List> hashMap = new HashMap<String, List>();
        for (int i = 0; i < data.size(); ++i) {
            JSONObject obj = (JSONObject)data.get(i);
            String eachLangKey = MultiColumnPivotTable.generateRowKey(obj, rowKeys);
            hashMap.computeIfAbsent(eachLangKey, k -> new ArrayList()).add(i);
        }
        List columnList = new ArrayList(columnCombinationSet);
        columnList = columnList.subList(rowKeys.size(), columnList.size());
        ArrayList preprocessedColumns = new ArrayList();
        for (String string : columnList) {
            String[] parts = string.split(" \\|- ");
            ArrayList<String[]> pairs = new ArrayList<String[]>();
            for (int i = 0; i < parts.length; i += 2) {
                if (i + 1 >= parts.length) continue;
                pairs.add(new String[]{parts[i], parts[i + 1]});
            }
            preprocessedColumns.add(pairs);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String key = (String)entry.getKey();
            List indices = (List)entry.getValue();
            JSONArray row = new JSONArray();
            String[] rowKeyParts = key.split("\\|");
            for (String part : rowKeyParts) {
                row.add((Object)part);
            }
            for (Map.Entry entry2 : valueKeysMap.entrySet()) {
                List valueKeyList = (List)entry2.getValue();
                String valueKey = (String)valueKeyList.get(0);
                if (!valueKey.startsWith("{") || !valueKey.endsWith("}")) continue;
                ArrayList groupData = new ArrayList();
                for (Integer index : indices) {
                    groupData.add(preprocessedData.get(index));
                }
                for (int colIdx = 0; colIdx < preprocessedColumns.size(); ++colIdx) {
                    List columnPairs = (List)preprocessedColumns.get(colIdx);
                    String matchedValue = "";
                    for (Map dataMap : groupData) {
                        boolean allMatched = true;
                        for (String[] pair : columnPairs) {
                            String colKey = pair[0];
                            String colValue = pair[1];
                            if (dataMap.containsKey(colKey) && ((String)dataMap.get(colKey)).equals(colValue)) continue;
                            allMatched = false;
                            break;
                        }
                        if (!allMatched) continue;
                        JSONObject originalObj = (JSONObject)data.get(((Integer)indices.get(groupData.indexOf(dataMap))).intValue());
                        matchedValue = originalObj.getString(valueKey);
                        break;
                    }
                    row.add((Object)matchedValue);
                }
            }
            result.add((Object)row);
        }
        return result;
    }

    private static String generateRowKey(JSONObject obj, List<String> rowKeys) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (String key : rowKeys) {
            sb.append(delimiter);
            Object value = obj.get((Object)key);
            sb.append(value != null ? String.valueOf(value) : "");
            delimiter = COLUMN_KEY_DELIMITER;
        }
        return sb.toString();
    }

    private static String generateColumnKey(JSONObject obj, List<String> columnKeys) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (String key : columnKeys) {
            sb.append(delimiter);
            Object value = obj.get((Object)key);
            sb.append(value != null ? String.valueOf(value) : "");
            delimiter = COLUMN_KEY_DELIMITER;
        }
        return sb.toString();
    }

    private static String generateColumnKeyNew(JSONObject obj, Map<String, List<String>> columnKeysMap) {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (Map.Entry<String, List<String>> entry : columnKeysMap.entrySet()) {
            List<String> keyList = entry.getValue();
            for (String key : keyList) {
                sb.append(delimiter);
                Object value = obj.get((Object)key);
                sb.append(value != null ? String.valueOf(value) : "");
                delimiter = COLUMN_KEY_DELIMITER;
            }
        }
        return sb.toString();
    }

    private static JSONArray createHeaderRow(List<String> rowKeys, Map<String, Set<String>> columnCombinations, Map<String, List<String>> valueKeysMap) {
        JSONArray header = new JSONArray();
        header.addAll(rowKeys);
        for (Map.Entry<String, Set<String>> entry : columnCombinations.entrySet()) {
            Set<String> value = entry.getValue();
            String key = entry.getKey();
            List<String> strings1 = valueKeysMap.get(key);
            int i = value.size() / strings1.size();
            int count = 1;
            int stringIndex = 0;
            for (String s : value) {
                if (count > i) {
                    ++stringIndex;
                    count = 1;
                }
                header.add((Object)(s + " - " + strings1.get(stringIndex)));
                ++count;
            }
        }
        return header;
    }
}

