/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.operationsmanage.ledger.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.DroolsUtil;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.transaction.api.service.IInvoiceDataRightModuleService;
import com.jxdinfo.crm.transaction.operationsmanage.invoice.crminvoice.model.CrmInvoiceDetailMerge;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dao.BillPeriodLedgerMapper;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dto.BillPeriodLedgerAssociativeQueryDto;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.dto.BillPeriodLedgerDto;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.model.BillPeriodLedger;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.service.IBillPeriodLedgerAssociativeQueryService;
import com.jxdinfo.crm.transaction.operationsmanage.ledger.service.IBillPeriodLedgerService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component(value="BillPeriodLedgerServiceImpl")
public class BillPeriodLedgerServiceImpl
implements IBillPeriodLedgerService {
    private static final Logger log = LoggerFactory.getLogger(BillPeriodLedgerServiceImpl.class);
    @Resource
    private CommonService commonService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private BillPeriodLedgerMapper baseMapper;
    @Resource
    private IBillPeriodLedgerAssociativeQueryService billPeriodLedgerAssociativeQueryService;
    @Resource
    private IInvoiceDataRightModuleService invoiceDataRightModuleService;

    @Override
    public List<AssociativeQueryVo> associativeQuery(BillPeriodLedgerAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getKeyWord();
        }
        IBillPeriodLedgerAssociativeQueryService adapterService = this.billPeriodLedgerAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("keyWord");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    @Override
    public Map<String, Object> billPeriodReceiveLedgerList(BillPeriodLedgerDto queryDto) {
        PermissionDto permissionDto = this.invoiceDataRightModuleService.getCurrentUserRolePermissions();
        BillPeriodLedgerDto billPeriodLedgerDto = queryDto;
        if (queryDto.getQueryType() != null) {
            billPeriodLedgerDto = this.getBillPeriodLedgerDtoList(queryDto);
        }
        billPeriodLedgerDto.setCurrentUserId(BaseSecurityUtil.getUser().getUserId().toString());
        billPeriodLedgerDto.setDelFlag("0");
        Page page = queryDto.getPage();
        List<BillPeriodLedger> list = this.getReceiveLedgerList(billPeriodLedgerDto, (Page<BillPeriodLedger>)page, permissionDto);
        list = this.billPeriod(list);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("billPeriodReceiveLedgerList", list);
        resultMap.put("totalCount", page.getTotal());
        return resultMap;
    }

    @Override
    public List<BillPeriodLedger> getReceiveLedgerList(BillPeriodLedgerDto billPeriodLedgerDto, Page<BillPeriodLedger> page, PermissionDto permissionDto) {
        List<BillPeriodLedger> list = this.baseMapper.receiveLedgerList(billPeriodLedgerDto, page, permissionDto);
        if (CollectionUtil.isEmpty(list)) {
            return new ArrayList<BillPeriodLedger>();
        }
        Map<Long, List<BillPeriodLedger>> invoiceIdMap = list.stream().collect(Collectors.groupingBy(BillPeriodLedger::getInvoiceId));
        ArrayList billPeriodLedgerList = new ArrayList();
        for (Long invoiceId : invoiceIdMap.keySet()) {
            List<BillPeriodLedger> itemList = invoiceIdMap.get(invoiceId);
            if (!CollectionUtil.isEmpty(itemList)) continue;
            BillPeriodLedger billPeriodLedger = itemList.get(0);
            if ("0".equals(billPeriodLedger.getWhetherQualityAmount())) {
                billPeriodLedger.setConfirmReceivableDate(billPeriodLedger.getInvoiceDate());
            } else if ("1".equals(billPeriodLedger.getWhetherQualityAmount())) {
                billPeriodLedger.setConfirmReceivableDate(billPeriodLedger.getReceivableDate());
            }
            Duration duration = Duration.between(billPeriodLedger.getConfirmReceivableDate(), LocalDate.now());
            billPeriodLedger.setDaysDifference(duration.toDays());
            BigDecimal receivableAmount = itemList.stream().map(BillPeriodLedger::getReceivableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            billPeriodLedger.setReceivableAmount(receivableAmount);
            BigDecimal refundAmount = itemList.stream().map(BillPeriodLedger::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal qualityReduceAmount = itemList.stream().map(BillPeriodLedger::getQualityReduceAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal qualityAmount = itemList.stream().map(BillPeriodLedger::getQualityAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal accountsReceivable = itemList.stream().map(BillPeriodLedger::getAccountsReceivable).reduce(BigDecimal.ZERO, BigDecimal::add);
            accountsReceivable = accountsReceivable.add(qualityAmount).subtract(qualityReduceAmount);
            if (accountsReceivable.compareTo(BigDecimal.ZERO) > 0 && accountsReceivable.compareTo(refundAmount) > 0) {
                billPeriodLedger.setCollectionStatus("\u90e8\u5206\u56de\u6b3e");
                continue;
            }
            if (accountsReceivable.compareTo(BigDecimal.ZERO) > 0 && accountsReceivable.compareTo(refundAmount) <= 0) {
                billPeriodLedger.setCollectionStatus("\u5b8c\u5168\u56de\u6b3e");
                continue;
            }
            if (refundAmount.compareTo(BigDecimal.ZERO) != 0) continue;
            billPeriodLedger.setCollectionStatus("\u672a\u56de\u6b3e");
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BillPeriodLedger> billPeriod(List<BillPeriodLedger> billPeriodLedger) {
        KieSession kieSession = DroolsUtil.getKieSession((String)"myKbase1", (String)"ksession-rule");
        try {
            if (billPeriodLedger == null || billPeriodLedger.isEmpty()) {
                System.out.println("\u8d26\u671f\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u9700\u5904\u7406");
                List<BillPeriodLedger> list = billPeriodLedger;
                return list;
            }
            for (BillPeriodLedger item : billPeriodLedger) {
                CrmInvoiceDetailMerge warrantyLedger = new CrmInvoiceDetailMerge();
                ArrayList<FactHandle> factHandles = new ArrayList<FactHandle>();
                try {
                    if (ToolUtil.isNotEmpty((Object)item.getConfirmReceivableDate()) && ToolUtil.isEmpty((Object)item.getPayProvision())) {
                        item.setAgreementConventPaymentDate(item.getConfirmReceivableDate());
                    }
                    Long days = item.getDaysDifference();
                    if (item.getRefundDate() == null) continue;
                    FactHandle daysHandle = kieSession.insert((Object)days);
                    FactHandle warrantyLedgerHandle = kieSession.insert((Object)warrantyLedger);
                    factHandles.add(daysHandle);
                    factHandles.add(warrantyLedgerHandle);
                    kieSession.fireAllRules();
                    item.setTermOfPayment(warrantyLedger.getTermOfPayment());
                }
                finally {
                    for (FactHandle factHandle : factHandles) {
                        kieSession.delete(factHandle);
                    }
                }
            }
        }
        finally {
            DroolsUtil.disposeKieSession((String)"myKbase1", (String)"ksession-rule");
        }
        return billPeriodLedger;
    }

    private BillPeriodLedgerDto getBillPeriodLedgerDtoList(BillPeriodLedgerDto billPeriodLedgerDto) {
        BillPeriodLedgerDto queryDto = new BillPeriodLedgerDto();
        String view = billPeriodLedgerDto.getQueryType();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long queryType = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)queryType);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"billPeriodLedger");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        queryDto = (BillPeriodLedgerDto)((Object)JSONObject.parseObject((String)queryValue, BillPeriodLedgerDto.class));
                    }
                }
                catch (Exception var14) {
                    Exception e = var14;
                    throw new RuntimeException(e);
                }
            }
        }
        if (ToolUtil.isNotEmpty((Object)billPeriodLedgerDto.getQueryType())) {
            queryDto.setQueryType(billPeriodLedgerDto.getQueryType());
        }
        if (ToolUtil.isNotEmpty((Object)billPeriodLedgerDto.getKeyWord())) {
            queryDto.setKeyWord(billPeriodLedgerDto.getKeyWord());
        }
        if (ToolUtil.isNotEmpty((Object)billPeriodLedgerDto.getBillPeriodFlag())) {
            queryDto.setBillPeriodFlag(billPeriodLedgerDto.getBillPeriodFlag());
        }
        if (ToolUtil.isNotEmpty((Object)queryDto.getBillPeriodFlag())) {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate now = LocalDate.now();
            LocalDate threeMonthAgo = now.minusMonths(3L);
            LocalDate sixMonthAgo = now.minusMonths(6L);
            LocalDate nineMonthAgo = now.minusMonths(9L);
            LocalDate twelveMonthAgo = now.minusMonths(12L);
            LocalDate yearsAgo = now.minusYears(1L);
            switch (queryDto.getBillPeriodFlag()) {
                case "0": {
                    queryDto.setBillPeriodStartDate(dtf.format(threeMonthAgo));
                    queryDto.setBillPeriodFinalDate(dtf.format(now));
                    break;
                }
                case "1": {
                    queryDto.setBillPeriodStartDate(dtf.format(sixMonthAgo));
                    queryDto.setBillPeriodFinalDate(dtf.format(threeMonthAgo));
                    break;
                }
                case "2": {
                    queryDto.setBillPeriodStartDate(dtf.format(nineMonthAgo));
                    queryDto.setBillPeriodFinalDate(dtf.format(sixMonthAgo));
                    break;
                }
                case "3": {
                    queryDto.setBillPeriodStartDate(dtf.format(twelveMonthAgo));
                    queryDto.setBillPeriodFinalDate(dtf.format(nineMonthAgo));
                    break;
                }
                case "6": {
                    queryDto.setBillPeriodFinalDate(dtf.format(yearsAgo));
                }
            }
        }
        if (ToolUtil.isNotEmpty((Object)billPeriodLedgerDto.getSignDateFlag()) && !"6".equals(queryDto.getSignDateFlag())) {
            DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)billPeriodLedgerDto.getSignDateFlag());
            if (dateConvertVo != null) {
                queryDto.setSignStartDate(dateConvertVo.getStartDate());
                queryDto.setSignFinalDate(dateConvertVo.getEndDate());
            } else {
                queryDto.setSignStartDate(billPeriodLedgerDto.getSignStartDate());
                queryDto.setSignFinalDate(billPeriodLedgerDto.getSignFinalDate());
            }
        }
        return queryDto;
    }
}

