/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.operationsmanage.contract.crmagreement.service.impl;

import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeFiledQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeLabelVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.transaction.api.service.IAgreementDataRightModuleService;
import com.jxdinfo.crm.transaction.contract.crmagreement.dao.CrmAgreementMapper;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementAssociativeQueryDto;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementPageDto;
import com.jxdinfo.crm.transaction.contract.crmagreement.model.CrmAgreement;
import com.jxdinfo.crm.transaction.operationsmanage.contract.crmagreement.service.ICrmAgreementAssociativeQueryService;
import com.jxdinfo.crm.transaction.operationsmanage.contract.crmagreement.vo.CrmAgreementAssociativeQueryEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmAgreementAssociativeQueryServiceImpl
implements ICrmAgreementAssociativeQueryService {
    @Resource
    private IAssociativeFiledQueryAPIService associativeFiledQueryAPIService;
    @Autowired
    private CrmAgreementMapper agreementMapper;
    @Resource
    private IAgreementDataRightModuleService agreementDataRightModuleService;

    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        CrmAgreementAssociativeQueryDto crmAgreementAssociativeQueryDto = null;
        if (associativeQueryDto instanceof CrmAgreementAssociativeQueryDto) {
            crmAgreementAssociativeQueryDto = (CrmAgreementAssociativeQueryDto)associativeQueryDto;
        }
        assert (crmAgreementAssociativeQueryDto != null);
        CrmAgreementPageDto dto = crmAgreementAssociativeQueryDto.getDto();
        List agreementTypeList = null;
        List agreementCategoryList = null;
        List forecastStateList = null;
        List chargePersonIdList = null;
        List ownDepartmentList = null;
        List flowStatusList = null;
        String customerName = null;
        String agreementName = null;
        String modelSupervisorName = null;
        List<String> areaList = null;
        ArrayList<String> productModel = new ArrayList<String>();
        ArrayList<String> modelIdList = new ArrayList();
        List<String> newOrSignList = null;
        String createTimeTage = null;
        String deliveryFlag = null;
        if (dto != null) {
            agreementTypeList = dto.getAgreementType();
            agreementCategoryList = dto.getAgreementCategory();
            forecastStateList = dto.getForecastState();
            chargePersonIdList = dto.getChargePersonId();
            ownDepartmentList = dto.getOwnDepartmentId();
            flowStatusList = dto.getFlowStatusList();
            customerName = dto.getCustomerName();
            agreementName = dto.getAgreementName();
            modelSupervisorName = dto.getModelSupervisorName();
            areaList = dto.getAreaList();
            String productModelOne = dto.getProductModel();
            productModel.add(productModelOne);
            newOrSignList = dto.getNewOrSignList();
            createTimeTage = dto.getCreateTimeFlag();
            deliveryFlag = dto.getDeliveryFlag();
            modelIdList = dto.getModelIdList();
        }
        List selectedCategory = excludeInfoMap.get("selectedCategory");
        selectedCategory = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCategory, agreementCategoryList, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.AGREEMENT_CATEGORY));
        excludeInfoMap.put("selectedCategory", selectedCategory);
        List selectedType = excludeInfoMap.get("selectedType");
        selectedType = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedType, agreementTypeList, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.AGREEMENT_TYPE));
        excludeInfoMap.put("selectedType", selectedType);
        List selectedForecastState = excludeInfoMap.get("selectedForecastState");
        selectedForecastState = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedForecastState, forecastStateList, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.AGREEMENT_FORECAST_STATE));
        excludeInfoMap.put("selectedForecastState", selectedForecastState);
        List selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryAPIService.getDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.AGREEMENT_OWN_DEPARTMENT));
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        List selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryAPIService.getUsersAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.AGREEMENT_CHARGE_PERSON));
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        List selectedFlowStatus = excludeInfoMap.get("selectedFlowStatus");
        selectedFlowStatus = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedFlowStatus, flowStatusList, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.AGREEMENT_FLOW_STATUS));
        excludeInfoMap.put("selectedFlowStatus", selectedFlowStatus);
        List selectedArea = excludeInfoMap.get("selectedArea");
        selectedArea = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedArea, areaList, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.AREA));
        excludeInfoMap.put("selectedArea", selectedArea);
        List selectedNewOrSign = excludeInfoMap.get("selectedNewOrSign");
        selectedNewOrSign = this.associativeFiledQueryAPIService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedNewOrSign, newOrSignList, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.NEW_OR_SIGN));
        excludeInfoMap.put("selectedNewOrSign", selectedNewOrSign);
        List selectedCreateTimes = excludeInfoMap.get("selectedCreateTimes");
        selectedCreateTimes = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedCreateTimes, createTimeTage, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.AGREEMENT_CREATE_TIME));
        excludeInfoMap.put("selectedCreateTimes", selectedCreateTimes);
        List selectedDeliveryTimes = excludeInfoMap.get("selectedDeliveryTimes");
        selectedDeliveryTimes = this.associativeFiledQueryAPIService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedDeliveryTimes, deliveryFlag, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.AGREEMENT_DELIVERY_TIME));
        excludeInfoMap.put("selectedDeliveryTimes", selectedDeliveryTimes);
        List<String> selectedCustomerName = excludeInfoMap.get("selectedCustomerName");
        selectedCustomerName = this.getAgreementInfoAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerName, customerName, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.CUSTOMER_NAME), "customerName");
        excludeInfoMap.put("selectedCustomerName", selectedCustomerName);
        List<String> selectedAgreementName = excludeInfoMap.get("selectedAgreementName");
        selectedAgreementName = this.getAgreementInfoAssociativeQuery(associativeQueryVoList, keyword, selectedAgreementName, agreementName, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.AGREEMENT_NAME), "agreementName");
        excludeInfoMap.put("selectedAgreementName", selectedAgreementName);
        List<String> selectedModelSupervisorName = excludeInfoMap.get("selectedModelSupervisorName");
        selectedModelSupervisorName = this.getAgreementInfoAssociativeQuery(associativeQueryVoList, keyword, selectedModelSupervisorName, modelSupervisorName, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.MODEL_SUPERVISOR_NAME), "modelSupervisorName");
        excludeInfoMap.put("selectedModelSupervisorName", selectedModelSupervisorName);
        List<String> selectedModelIds = excludeInfoMap.get("selectedModelIds");
        selectedModelIds = this.getModelList(associativeQueryVoList, keyword, selectedModelIds, modelIdList, this.getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum.MODEL_ID));
        excludeInfoMap.put("selectedModelIds", selectedModelIds);
        return associativeQueryVoList;
    }

    private List<String> getModelList(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedModelIds, List<String> modelIdList, AssociativeLabelVo associateLabelVoByEnum) {
        ArrayList<String> selectedModelIdList = new ArrayList<String>();
        if (CollectionUtil.isEmpty(selectedModelIds)) {
            selectedModelIds = new ArrayList<String>();
            selectedModelIdList.addAll(selectedModelIds);
        }
        if (CollectionUtil.isNotEmpty(modelIdList)) {
            selectedModelIdList.addAll(modelIdList);
        }
        CrmAgreementPageDto pageDto = new CrmAgreementPageDto();
        pageDto.setAgreementView("1");
        PermissionDto permissionDto = this.agreementOperate(pageDto);
        pageDto.setPermissionDto(permissionDto);
        List<CrmAgreement> list = this.agreementMapper.getCustomerInfoList(keyword, selectedModelIdList, "modelId", pageDto);
        if (CollectionUtil.isNotEmpty(list)) {
            for (CrmAgreement one : list) {
                AssociativeQueryVo modelAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associateLabelVoByEnum, one.getProductName(), String.valueOf(one.getModelId()));
                associativeQueryVoList.add(modelAssociative);
                selectedModelIds.add(one.getModelId());
            }
        }
        return selectedModelIds;
    }

    private List<String> getAgreementInfoAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedNames, String queryName, AssociativeLabelVo associateLabelVoByEnum, String type) {
        ArrayList<String> selectedNamesList = new ArrayList<String>();
        if (CollectionUtil.isEmpty(selectedNames)) {
            selectedNames = new ArrayList<String>();
            selectedNamesList.addAll(selectedNames);
        }
        if (StringUtils.isNotBlank((CharSequence)queryName)) {
            selectedNamesList.add(queryName);
        }
        CrmAgreementPageDto pageDto = new CrmAgreementPageDto();
        pageDto.setAgreementView("1");
        PermissionDto permissionDto = this.agreementOperate(pageDto);
        pageDto.setPermissionDto(permissionDto);
        List<CrmAgreement> agreementList = this.agreementMapper.getCustomerInfoList(keyword, selectedNamesList, type, pageDto);
        if (ToolUtil.isNotEmpty(agreementList)) {
            for (CrmAgreement item : agreementList) {
                if ("customerName".equals(type)) {
                    AssociativeQueryVo customerAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associateLabelVoByEnum, item.getCustomerName(), item.getCustomerName());
                    associativeQueryVoList.add(customerAssociative);
                    selectedNames.add(item.getCustomerName());
                    continue;
                }
                if ("agreementName".equals(type)) {
                    AssociativeQueryVo agreementNameAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associateLabelVoByEnum, item.getAgreementName(), item.getAgreementName());
                    associativeQueryVoList.add(agreementNameAssociative);
                    selectedNames.add(item.getAgreementName());
                    continue;
                }
                if (!"modelSupervisorName".equals(type)) continue;
                AssociativeQueryVo productAssociative = this.associativeFiledQueryAPIService.getAssociativeQueryVo(associateLabelVoByEnum, item.getModelSupervisorName(), item.getModelSupervisorName());
                associativeQueryVoList.add(productAssociative);
                selectedNames.add(item.getModelSupervisorName());
            }
        }
        return selectedNames;
    }

    public PermissionDto agreementOperate(CrmAgreementPageDto dto) {
        PermissionDto permissionDto = new PermissionDto();
        String agreementView = dto.getAgreementView();
        if (StringUtil.isNotEmpty((Object)agreementView) && !"0".equals(agreementView) && !"10".equals(agreementView)) {
            permissionDto = this.agreementDataRightModuleService.getCurrentUserRolePermissions();
        }
        return permissionDto;
    }

    private AssociativeLabelVo getAssociateLabelVoByEnum(CrmAgreementAssociativeQueryEnum queryEnum) {
        return new AssociativeLabelVo(queryEnum.getLabelName(), queryEnum.getDataName(), queryEnum.getDictTypeName(), queryEnum.getMultiOption());
    }
}

