/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.customer.customerdomain.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.transaction.customer.customerdomain.dao.CustomerDomainMapper;
import com.jxdinfo.crm.transaction.customer.customerdomain.dto.CustomerDomainSelectCondition;
import com.jxdinfo.crm.transaction.customer.customerdomain.dto.CustomerDomainTotalQuery;
import com.jxdinfo.crm.transaction.customer.customerdomain.model.CustomerDomain;
import com.jxdinfo.crm.transaction.customer.customerdomain.service.CustomerDomainService;
import com.jxdinfo.crm.transaction.customer.customerdomain.vo.CustomerDomainPageVO;
import com.jxdinfo.hussar.common.dto.Increment;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="customer.customerdomain.CustomerDomainServiceImpl")
@HussarTokenDs
public class CustomerDomainServiceImpl
extends HussarServiceImpl<CustomerDomainMapper, CustomerDomain>
implements CustomerDomainService {
    private static final Logger logger = LoggerFactory.getLogger(CustomerDomainServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    @Autowired
    private CustomerDomainMapper customerDomainMapper;
    @Resource
    private ISysDicRefService dicRefService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;

    public List<CustomerDomain> getByMap(Map<String, Object> map) {
        return this.list((Wrapper)new LambdaQueryWrapper(BeanUtil.copy(map, CustomerDomain.class)));
    }

    @Override
    public ApiResponse<CustomerDomainPageVO> hussarQuery() {
        try {
            CustomerDomainPageVO customerDomainPageVO = new CustomerDomainPageVO();
            List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().ne(CustomerDomain::getDelFlag, (Object)"1")).or()).isNull(CustomerDomain::getDelFlag));
            customerDomainPageVO.setData(list);
            if (HussarUtils.isNotEmpty((Object)list)) {
                customerDomainPageVO.setCount(Long.valueOf(list.size()));
            }
            customerDomainPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)customerDomainPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CustomerDomainPageVO> totalCalculate(CustomerDomainTotalQuery customerDomainTotalQuery) {
        try {
            CustomerDomainPageVO customerDomainPageVO = new CustomerDomainPageVO();
            QueryWrapper queryWrapper = Wrappers.query();
            List<SuperQueryConditionDto> superQueryConditionDtoList = customerDomainTotalQuery.getSuperQueryConditionDto();
            SuperQueryGenerator superQueryGenerator = new SuperQueryGenerator(CustomerDomain.class);
            superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
            Map<String, Object> columnFields = this.customerDomainMapper.totalCalculateValue(customerDomainTotalQuery, (QueryWrapper<CustomerDomain>)queryWrapper);
            customerDomainPageVO.setColumnFields(columnFields);
            customerDomainPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)customerDomainPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> insertOrUpdate(CustomerDomain customerDomain) {
        try {
            if (customerDomain.getDomainId() == null || this.getById(customerDomain.getDomainId()) == null) {
                customerDomain.setCreatePerson(BaseSecurityUtil.getUser().getId());
                customerDomain.setCreateTime(LocalDateTime.now());
                customerDomain.setChangePerson(BaseSecurityUtil.getUser().getId());
                customerDomain.setChangeTime(LocalDateTime.now());
                customerDomain.setDelFlag(RETURN_CODE);
            } else {
                customerDomain.setChangePerson(BaseSecurityUtil.getUser().getId());
                customerDomain.setChangeTime(LocalDateTime.now());
            }
            String domainTypeList = customerDomain.getDomainType();
            if (HussarUtils.isNotEmpty((Object)domainTypeList)) {
                String[] domainTypeArray;
                for (String domainType : domainTypeArray = domainTypeList.split(",")) {
                    customerDomain.setDomainId(null);
                    customerDomain.setDomainType(domainType);
                    this.saveOrUpdate(customerDomain);
                    String areaTypeLabel = this.dicRefService.getDictLabel("area", domainType);
                    this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.CUSTOMER_DOMAIN, customerDomain.getCustomerId(), areaTypeLabel, LocalDateTime.now(), false, Arrays.asList(customerDomain.getCustomerId(), customerDomain.getDomainId()));
                }
            }
            return ApiResponse.success((Object)String.valueOf(customerDomain.getDomainId()), (String)"");
        }
        catch (Exception e) {
            throw new HussarException("\u65b0\u589e\u6216\u4fee\u6539\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CustomerDomain> formQuery(String id) {
        try {
            return ApiResponse.success((Object)this.getById((Serializable)((Object)id)));
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<Boolean> deleteCascade(List<String> ids) {
        try {
            return ApiResponse.success((Object)this.removeByIds(ids));
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<Boolean> tableSave(JSONObject tableData) {
        try {
            List importList = JSONObject.parseArray((String)tableData.getString("importList"), CustomerDomain.class);
            for (CustomerDomain customerDomain : importList) {
                if (ToolUtil.isEmpty((Object)customerDomain.getCreatePerson())) {
                    customerDomain.setCreatePerson(BaseSecurityUtil.getUser().getId());
                }
                if (ToolUtil.isEmpty((Object)customerDomain.getCreateTime())) {
                    customerDomain.setCreateTime(LocalDateTime.now());
                }
                customerDomain.setDelFlag(RETURN_CODE);
            }
            return ApiResponse.success((Object)this.saveOrUpdateBatch(importList));
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<Boolean> editTableSave(Increment<CustomerDomain> tableData) {
        try {
            List itemList = tableData.getDel();
            if (HussarUtils.isNotEmpty((Object)itemList)) {
                for (CustomerDomain customerDomain : itemList) {
                    customerDomain.setDelFlag("1");
                }
                this.updateBatchById(itemList);
            }
            ArrayList insertAndUpdateList = new ArrayList();
            List insertList = tableData.getAdd();
            List updateList = tableData.getEdit();
            if (HussarUtils.isNotEmpty((Object)insertList)) {
                insertAndUpdateList.addAll(insertList);
            }
            if (HussarUtils.isNotEmpty((Object)updateList)) {
                insertAndUpdateList.addAll(updateList);
            }
            for (CustomerDomain customerDomain : insertAndUpdateList) {
                if (customerDomain.getDomainId() == null || this.getById(customerDomain.getDomainId()) == null) {
                    customerDomain.setCreatePerson(BaseSecurityUtil.getUser().getId());
                    customerDomain.setCreateTime(LocalDateTime.now());
                    customerDomain.setChangePerson(BaseSecurityUtil.getUser().getId());
                    customerDomain.setChangeTime(LocalDateTime.now());
                    customerDomain.setDelFlag(RETURN_CODE);
                    continue;
                }
                customerDomain.setChangePerson(BaseSecurityUtil.getUser().getId());
                customerDomain.setChangeTime(LocalDateTime.now());
            }
            return ApiResponse.success((Object)this.saveOrUpdateBatch(insertAndUpdateList));
        }
        catch (Exception e) {
            throw new HussarException("\u53ef\u7f16\u8f91\u8868\u683c\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<Boolean> flagDelete(List<String> ids) {
        try {
            List insertAndUpdateList = this.list((Wrapper)new LambdaQueryWrapper().in(CustomerDomain::getDomainId, ids));
            for (CustomerDomain address : insertAndUpdateList) {
                String areaTypeLabel = this.dicRefService.getDictLabel("area", address.getDomainType());
                OperateRecordAPIVo operateRecordAPIVo = new OperateRecordAPIVo();
                operateRecordAPIVo.setProduceType(RecordProductTypeEnum.PRODUCE_DELETE.getId());
                this.operateRecordAPIService.saveOperateLog(operateRecordAPIVo, CrmBusinessTypeEnum.CUSTOMER_DOMAIN, address.getCustomerId(), areaTypeLabel, LocalDateTime.now(), false, Arrays.asList(address.getDomainId(), address.getCustomerId()));
            }
            return ApiResponse.success((Object)this.customerDomainMapper.flagDelete(ids, LocalDateTime.now()));
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CustomerDomainPageVO> ConditionFilterPage(CustomerDomainSelectCondition customerDomainSelectCondition) {
        try {
            Page pager = new Page((long)customerDomainSelectCondition.getCurrent(), (long)customerDomainSelectCondition.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayList<String> orderRule = new ArrayList<String>();
            if (customerDomainSelectCondition.getOrders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : customerDomainSelectCondition.getOrders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                        continue;
                    }
                    order.append(orderItem.getColumn()).append(DESC);
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CustomerDomain(), parameterMap);
            if (HussarUtils.isNotEmpty(customerDomainSelectCondition.getSuperQueryConditionDto())) {
                List<SuperQueryConditionDto> superQueryConditionDtoList = customerDomainSelectCondition.getSuperQueryConditionDto();
                SuperQueryGenerator superQueryGenerator = new SuperQueryGenerator(CustomerDomain.class);
                superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
            }
            IPage list = this.page((IPage)pager, (Wrapper)queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ne(CustomerDomain::getDelFlag, (Object)"1")).or()).isNull(CustomerDomain::getDelFlag);
            }));
            CustomerDomainPageVO customerDomainPageVO = new CustomerDomainPageVO();
            customerDomainPageVO.setData(list.getRecords());
            customerDomainPageVO.setCount(list.getTotal());
            customerDomainPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)customerDomainPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CustomerDomainPageVO> ConditionFilterCustomerDomainCondition_1Page(CustomerDomainSelectCondition customerDomainSelectCondition) {
        try {
            Page pager = new Page((long)customerDomainSelectCondition.getCurrent(), (long)customerDomainSelectCondition.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayList<String> orderRule = new ArrayList<String>();
            if (customerDomainSelectCondition.getOrders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : customerDomainSelectCondition.getOrders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                        continue;
                    }
                    order.append(orderItem.getColumn()).append(DESC);
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CustomerDomain(), parameterMap);
            if (HussarUtils.isNotEmpty(customerDomainSelectCondition.getSuperQueryConditionDto())) {
                List<SuperQueryConditionDto> superQueryConditionDtoList = customerDomainSelectCondition.getSuperQueryConditionDto();
                SuperQueryGenerator superQueryGenerator = new SuperQueryGenerator(CustomerDomain.class);
                superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
            }
            IPage list = this.page((IPage)pager, (Wrapper)queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ne(CustomerDomain::getDelFlag, (Object)"1")).or()).isNull(CustomerDomain::getDelFlag);
            }));
            CustomerDomainPageVO customerDomainPageVO = new CustomerDomainPageVO();
            customerDomainPageVO.setData(list.getRecords());
            customerDomainPageVO.setCount(list.getTotal());
            customerDomainPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)customerDomainPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CustomerDomainPageVO> ConditionFilterCustomerDomainCondition_1CustomerDomainSort_1Page(CustomerDomainSelectCondition customerDomainSelectCondition) {
        try {
            Page pager = new Page((long)customerDomainSelectCondition.getCurrent(), (long)customerDomainSelectCondition.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayList<String> orderRule = new ArrayList<String>();
            if (customerDomainSelectCondition.getOrders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : customerDomainSelectCondition.getOrders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                        continue;
                    }
                    order.append(orderItem.getColumn()).append(DESC);
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }
            ArrayList<String> defaultOrderRule = new ArrayList<String>();
            String defaultOrder = "";
            defaultOrder = defaultOrder + "changeTime,desc;";
            defaultOrderRule.add(defaultOrder);
            parameterMap.put(DEFAULT_ORDER_RULE, defaultOrderRule.toArray(new String[0]));
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CustomerDomain(), parameterMap);
            if (HussarUtils.isNotEmpty(customerDomainSelectCondition.getSuperQueryConditionDto())) {
                List<SuperQueryConditionDto> superQueryConditionDtoList = customerDomainSelectCondition.getSuperQueryConditionDto();
                SuperQueryGenerator superQueryGenerator = new SuperQueryGenerator(CustomerDomain.class);
                superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
            }
            IPage list = this.page((IPage)pager, (Wrapper)queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ne(CustomerDomain::getDelFlag, (Object)"1")).or()).isNull(CustomerDomain::getDelFlag);
            }));
            CustomerDomainPageVO customerDomainPageVO = new CustomerDomainPageVO();
            customerDomainPageVO.setData(list.getRecords());
            customerDomainPageVO.setCount(list.getTotal());
            customerDomainPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)customerDomainPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }
}

