/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.customer.customeraddress.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.operateRecord.DataCompareUtils;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmopportunity2.service.CrmOpportunity2Service;
import com.jxdinfo.crm.transaction.customer.customeraddress.dao.CustomerAddressMapper;
import com.jxdinfo.crm.transaction.customer.customeraddress.dto.CustomerAddressSelectCondition;
import com.jxdinfo.crm.transaction.customer.customeraddress.dto.CustomerAddressTotalQuery;
import com.jxdinfo.crm.transaction.customer.customeraddress.model.CustomerAddress;
import com.jxdinfo.crm.transaction.customer.customeraddress.service.CustomerAddressService;
import com.jxdinfo.crm.transaction.customer.customeraddress.vo.CustomerAddressPageVO;
import com.jxdinfo.hussar.common.dto.Increment;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="customer.customeraddress.CustomerAddressServiceImpl")
@HussarTokenDs
public class CustomerAddressServiceImpl
extends HussarServiceImpl<CustomerAddressMapper, CustomerAddress>
implements CustomerAddressService {
    private static final Logger logger = LoggerFactory.getLogger(CustomerAddressServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    @Autowired
    private CustomerAddressMapper customerAddressMapper;
    @Autowired
    private IOperateRecordAPIService operateRecordAPIService;
    @Autowired
    private CrmOpportunity2Service crmOpportunity2Service;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private ISysDicRefService dicRefService;

    public List<CustomerAddress> getByMap(Map<String, Object> map) {
        return this.list((Wrapper)new LambdaQueryWrapper(BeanUtil.copy(map, CustomerAddress.class)));
    }

    @Override
    public ApiResponse<CustomerAddressPageVO> hussarQuery() {
        try {
            CustomerAddressPageVO customerAddressPageVO = new CustomerAddressPageVO();
            List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().ne(CustomerAddress::getDelFlag, (Object)"1")).or()).isNull(CustomerAddress::getDelFlag));
            customerAddressPageVO.setData(list);
            if (HussarUtils.isNotEmpty((Object)list)) {
                customerAddressPageVO.setCount(Long.valueOf(list.size()));
            }
            customerAddressPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)customerAddressPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CustomerAddressPageVO> totalCalculate(CustomerAddressTotalQuery customerAddressTotalQuery) {
        try {
            CustomerAddressPageVO customerAddressPageVO = new CustomerAddressPageVO();
            QueryWrapper queryWrapper = Wrappers.query();
            List<SuperQueryConditionDto> superQueryConditionDtoList = customerAddressTotalQuery.getSuperQueryConditionDto();
            SuperQueryGenerator superQueryGenerator = new SuperQueryGenerator(CustomerAddress.class);
            superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
            Map<String, Object> columnFields = this.customerAddressMapper.totalCalculateValue(customerAddressTotalQuery, (QueryWrapper<CustomerAddress>)queryWrapper);
            customerAddressPageVO.setColumnFields(columnFields);
            customerAddressPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)customerAddressPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> insertOrUpdate(CustomerAddress customerAddress) {
        try {
            boolean addFlag;
            CustomerAddress oldCustomerAddress = (CustomerAddress)this.getById(customerAddress.getAddressId());
            boolean bl = addFlag = customerAddress.getAddressId() == null || oldCustomerAddress == null;
            if (addFlag) {
                customerAddress.setCreatePerson(BaseSecurityUtil.getUser().getId());
                customerAddress.setCreateTime(LocalDateTime.now());
                customerAddress.setChangePerson(BaseSecurityUtil.getUser().getId());
                customerAddress.setChangeTime(LocalDateTime.now());
                customerAddress.setDelFlag(RETURN_CODE);
            } else {
                customerAddress.setChangePerson(BaseSecurityUtil.getUser().getId());
                customerAddress.setChangeTime(LocalDateTime.now());
            }
            StringBuilder sb = new StringBuilder();
            if (ToolUtil.isEmpty((Object)customerAddress.getProvince())) {
                customerAddress.setProvince(null);
            } else {
                SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerAddress.getProvince().intValue()));
                if (ToolUtil.isNotEmpty((Object)province)) {
                    sb.append(province.getName());
                }
            }
            if (ToolUtil.isEmpty((Object)customerAddress.getCity())) {
                customerAddress.setCity(null);
            } else {
                SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerAddress.getCity().intValue()));
                if (ToolUtil.isNotEmpty((Object)city)) {
                    sb.append("/").append(city.getName());
                }
            }
            if (ToolUtil.isEmpty((Object)customerAddress.getCounty())) {
                customerAddress.setCounty(null);
            } else {
                SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerAddress.getCounty().intValue()));
                if (ToolUtil.isNotEmpty((Object)county)) {
                    sb.append("/").append(county.getName());
                }
            }
            customerAddress.setRegionLabel(sb.toString());
            boolean resultFlag = this.saveOrUpdate(customerAddress);
            if (!resultFlag) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
            String addressTypeLabel = this.dicRefService.getDictLabel("addressType", customerAddress.getAddressType());
            if (addFlag) {
                this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.CUSTOMER_ADDRESS, customerAddress.getCustomerId(), addressTypeLabel, LocalDateTime.now(), false, Arrays.asList(customerAddress.getCustomerId(), customerAddress.getAddressId()));
            } else {
                Map map = DataCompareUtils.getRecordInfo((Object)oldCustomerAddress, (Object)customerAddress);
                if (((String)map.get("changeFlag")).equals("true")) {
                    OperateRecordAPIVo trackRecord = this.crmOpportunity2Service.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), (String)map.get("oldJson"), (String)map.get("newJson"), (String)map.get("changeFieldStr"));
                    trackRecord.setChangeBatch(1);
                    this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.CUSTOMER_ADDRESS, customerAddress.getCustomerId(), addressTypeLabel, LocalDateTime.now(), false, Arrays.asList(customerAddress.getCustomerId(), customerAddress.getAddressId()));
                }
            }
            return ApiResponse.success((Object)String.valueOf(customerAddress.getAddressId()), (String)"");
        }
        catch (Exception e) {
            throw new HussarException("\u65b0\u589e\u6216\u4fee\u6539\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CustomerAddress> formQuery(String id) {
        try {
            return ApiResponse.success((Object)this.getById((Serializable)((Object)id)));
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<Boolean> deleteCascade(List<String> ids) {
        try {
            return ApiResponse.success((Object)this.removeByIds(ids));
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<Boolean> tableSave(JSONObject tableData) {
        try {
            List importList = JSONObject.parseArray((String)tableData.getString("importList"), CustomerAddress.class);
            for (CustomerAddress customerAddress : importList) {
                if (ToolUtil.isEmpty((Object)customerAddress.getCreatePerson())) {
                    customerAddress.setCreatePerson(BaseSecurityUtil.getUser().getId());
                }
                if (ToolUtil.isEmpty((Object)customerAddress.getCreateTime())) {
                    customerAddress.setCreateTime(LocalDateTime.now());
                }
                customerAddress.setDelFlag(RETURN_CODE);
            }
            return ApiResponse.success((Object)this.saveOrUpdateBatch(importList));
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<Boolean> editTableSave(Increment<CustomerAddress> tableData) {
        try {
            List itemList = tableData.getDel();
            if (HussarUtils.isNotEmpty((Object)itemList)) {
                for (CustomerAddress customerAddress : itemList) {
                    customerAddress.setDelFlag("1");
                }
                this.updateBatchById(itemList);
            }
            ArrayList insertAndUpdateList = new ArrayList();
            List insertList = tableData.getAdd();
            List updateList = tableData.getEdit();
            if (HussarUtils.isNotEmpty((Object)insertList)) {
                insertAndUpdateList.addAll(insertList);
            }
            if (HussarUtils.isNotEmpty((Object)updateList)) {
                insertAndUpdateList.addAll(updateList);
            }
            for (CustomerAddress customerAddress : insertAndUpdateList) {
                if (customerAddress.getAddressId() == null || this.getById(customerAddress.getAddressId()) == null) {
                    customerAddress.setCreatePerson(BaseSecurityUtil.getUser().getId());
                    customerAddress.setCreateTime(LocalDateTime.now());
                    customerAddress.setChangePerson(BaseSecurityUtil.getUser().getId());
                    customerAddress.setChangeTime(LocalDateTime.now());
                    customerAddress.setDelFlag(RETURN_CODE);
                    continue;
                }
                customerAddress.setChangePerson(BaseSecurityUtil.getUser().getId());
                customerAddress.setChangeTime(LocalDateTime.now());
            }
            return ApiResponse.success((Object)this.saveOrUpdateBatch(insertAndUpdateList));
        }
        catch (Exception e) {
            throw new HussarException("\u53ef\u7f16\u8f91\u8868\u683c\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<Boolean> flagDelete(List<String> ids) {
        try {
            List insertAndUpdateList = this.list((Wrapper)new LambdaQueryWrapper().in(CustomerAddress::getAddressId, ids));
            for (CustomerAddress address : insertAndUpdateList) {
                String addressTypeLabel = this.dicRefService.getDictLabel("addressType", address.getAddressType());
                OperateRecordAPIVo operateRecordAPIVo = new OperateRecordAPIVo();
                operateRecordAPIVo.setProduceType(RecordProductTypeEnum.PRODUCE_DELETE.getId());
                this.operateRecordAPIService.saveOperateLog(operateRecordAPIVo, CrmBusinessTypeEnum.CUSTOMER_ADDRESS, address.getCustomerId(), addressTypeLabel, LocalDateTime.now(), false, Arrays.asList(address.getAddressId(), address.getCustomerId()));
            }
            return ApiResponse.success((Object)this.customerAddressMapper.flagDelete(ids, LocalDateTime.now()));
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CustomerAddressPageVO> ConditionFilterPage(CustomerAddressSelectCondition customerAddressSelectCondition) {
        try {
            Page pager = new Page((long)customerAddressSelectCondition.getCurrent(), (long)customerAddressSelectCondition.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayList<String> orderRule = new ArrayList<String>();
            if (customerAddressSelectCondition.getOrders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : customerAddressSelectCondition.getOrders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                        continue;
                    }
                    order.append(orderItem.getColumn()).append(DESC);
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CustomerAddress(), parameterMap);
            if (HussarUtils.isNotEmpty(customerAddressSelectCondition.getSuperQueryConditionDto())) {
                List<SuperQueryConditionDto> superQueryConditionDtoList = customerAddressSelectCondition.getSuperQueryConditionDto();
                SuperQueryGenerator superQueryGenerator = new SuperQueryGenerator(CustomerAddress.class);
                superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
            }
            IPage list = this.page((IPage)pager, (Wrapper)queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ne(CustomerAddress::getDelFlag, (Object)"1")).or()).isNull(CustomerAddress::getDelFlag);
            }));
            CustomerAddressPageVO customerAddressPageVO = new CustomerAddressPageVO();
            customerAddressPageVO.setData(list.getRecords());
            customerAddressPageVO.setCount(list.getTotal());
            customerAddressPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)customerAddressPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CustomerAddressPageVO> ConditionFilterCustomerAddressCondition_1Page(CustomerAddressSelectCondition customerAddressSelectCondition) {
        try {
            Page pager = new Page((long)customerAddressSelectCondition.getCurrent(), (long)customerAddressSelectCondition.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayList<String> orderRule = new ArrayList<String>();
            if (customerAddressSelectCondition.getOrders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : customerAddressSelectCondition.getOrders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                        continue;
                    }
                    order.append(orderItem.getColumn()).append(DESC);
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CustomerAddress(), parameterMap);
            if (HussarUtils.isNotEmpty(customerAddressSelectCondition.getSuperQueryConditionDto())) {
                List<SuperQueryConditionDto> superQueryConditionDtoList = customerAddressSelectCondition.getSuperQueryConditionDto();
                SuperQueryGenerator superQueryGenerator = new SuperQueryGenerator(CustomerAddress.class);
                superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
            }
            IPage list = this.page((IPage)pager, (Wrapper)queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ne(CustomerAddress::getDelFlag, (Object)"1")).or()).isNull(CustomerAddress::getDelFlag);
            }));
            CustomerAddressPageVO customerAddressPageVO = new CustomerAddressPageVO();
            customerAddressPageVO.setData(list.getRecords());
            customerAddressPageVO.setCount(list.getTotal());
            customerAddressPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)customerAddressPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<CustomerAddressPageVO> ConditionFilterCustomerAddressCondition_1CustomerAddressSort_1Page(CustomerAddressSelectCondition customerAddressSelectCondition) {
        try {
            Page pager = new Page((long)customerAddressSelectCondition.getCurrent(), (long)customerAddressSelectCondition.getSize());
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            ArrayList<String> orderRule = new ArrayList<String>();
            if (customerAddressSelectCondition.getOrders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : customerAddressSelectCondition.getOrders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                        continue;
                    }
                    order.append(orderItem.getColumn()).append(DESC);
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }
            ArrayList<String> defaultOrderRule = new ArrayList<String>();
            String defaultOrder = "";
            defaultOrder = defaultOrder + "changeTime,desc;";
            defaultOrderRule.add(defaultOrder);
            parameterMap.put(DEFAULT_ORDER_RULE, defaultOrderRule.toArray(new String[0]));
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CustomerAddress(), parameterMap);
            if (HussarUtils.isNotEmpty(customerAddressSelectCondition.getSuperQueryConditionDto())) {
                List<SuperQueryConditionDto> superQueryConditionDtoList = customerAddressSelectCondition.getSuperQueryConditionDto();
                SuperQueryGenerator superQueryGenerator = new SuperQueryGenerator(CustomerAddress.class);
                superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
            }
            IPage list = this.page((IPage)pager, (Wrapper)queryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ne(CustomerAddress::getDelFlag, (Object)"1")).or()).isNull(CustomerAddress::getDelFlag);
            }));
            CustomerAddressPageVO customerAddressPageVO = new CustomerAddressPageVO();
            customerAddressPageVO.setData(list.getRecords());
            customerAddressPageVO.setCount(list.getTotal());
            customerAddressPageVO.setCode(RETURN_CODE);
            return ApiResponse.success((Object)customerAddressPageVO);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }
}

