/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.contract.crmcontractnumber.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IStruUserAPIService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.common.api.util.operateRecord.DataCompareUtils;
import com.jxdinfo.crm.core.bid.service.BidService;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.crm.transaction.api.service.IContralNumberDataRightModuleService;
import com.jxdinfo.crm.transaction.constants.CommonHtConstant;
import com.jxdinfo.crm.transaction.constants.ContractNumberStatusEnum;
import com.jxdinfo.crm.transaction.constants.ContractNumberStepEnum;
import com.jxdinfo.crm.transaction.contract.crmagreement.model.CrmAgreement;
import com.jxdinfo.crm.transaction.contract.crmagreement.service.CrmAgreementService;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.dao.CrmContractNumberMapper;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.dto.BidOrProPageDto;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.dto.CrmContractNumberDto;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.dto.CrmContractNumberPageDto;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.dto.CrmNumberAssociativeQueryDto;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.model.CrmContractNumber;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.service.CrmContractNumberService;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.service.ICrmNumberAssociativeQueryService;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.vo.CrmContractNumberVO;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.vo.CrmOpportunityBidVO;
import com.jxdinfo.crm.transaction.utils.InitUnitDataUtill;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contract.crmcontractnumber.CrmContractNumberServiceImpl")
@HussarTokenDs
public class CrmContractNumberServiceImpl
extends HussarServiceImpl<CrmContractNumberMapper, CrmContractNumber>
implements CrmContractNumberService {
    private static final Logger logger = LoggerFactory.getLogger(CrmContractNumberServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    @Resource
    private BidService bidService;
    @Resource
    private ProductService productService;
    @Autowired
    private CrmAgreementService crmAgreementService;
    @Autowired
    private CrmContractNumberMapper carNumberMapper;
    @Resource
    private IStruUserAPIService struUserAPIService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Resource
    private IContralNumberDataRightModuleService contralNumberDataRightModuleService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private CommonService commonService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Autowired
    private ICrmNumberAssociativeQueryService numberAssociativeQueryService;

    public List<CrmContractNumber> getByMap(Map<String, Object> map) {
        return this.list((Wrapper)new LambdaQueryWrapper(BeanUtil.copy(map, CrmContractNumber.class)));
    }

    @Override
    public ApiResponse<CrmContractNumber> formQuery(String id) {
        try {
            return ApiResponse.success((Object)this.getById((Serializable)((Object)id)));
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> flowFormSubmit(CrmContractNumberDto crmContractNumberDto) {
        CrmContractNumber crmContractNumber = crmContractNumberDto.getFormdata();
        try {
            SecurityUser user = BaseSecurityUtil.getUser();
            Boolean flag = false;
            CrmContractNumber oldEntity = null;
            if (StringUtil.isEmpty((Object)crmContractNumber.getId())) {
                flag = true;
                Long contractNumberId = Long.parseLong(CommonUtills.generateAssignId());
                crmContractNumber.setId(String.valueOf(contractNumberId));
                crmContractNumber.setStatus(ContractNumberStatusEnum.CONTRACT_STATUS_CHECK_ING.getContractStatus());
                crmContractNumber.setFlowStep(ContractNumberStepEnum.CONTRACT_STEP_DEPT_CHECK.getContractStep());
                this.saveBaseInfo(crmContractNumber, user);
            } else {
                oldEntity = (CrmContractNumber)this.getById((Serializable)((Object)crmContractNumber.getId()));
                this.updateBaseInfo(crmContractNumber, user);
                if (StringUtil.isNotBlank((CharSequence)crmContractNumber.getFlowStep())) {
                    BpmResponseResult bpmResponseResult = InstanceEngineService.queryProcessInstance(null, (String)String.valueOf(crmContractNumber.getId()));
                    String taskId = bpmResponseResult.getResult().getJSONObject(0).getJSONArray("todo").getJSONObject(0).getString("taskId");
                    crmContractNumberDto.setTaskId(taskId);
                    if (ContractNumberStepEnum.CONTRACT_STEP_APPLY.getContractStep().equals(crmContractNumber.getFlowStep())) {
                        crmContractNumberDto.setProcessDefinitionKey("bpm_ht_num_approve");
                        crmContractNumber.setStatus(ContractNumberStatusEnum.CONTRACT_STATUS_CHECK_ING.getContractStatus());
                        crmContractNumber.setFlowStep(ContractNumberStepEnum.CONTRACT_STEP_DEPT_CHECK.getContractStep());
                    } else if (ContractNumberStepEnum.CONTRACT_STEP_DEPT_CHECK.getContractStep().equals(crmContractNumber.getFlowStep())) {
                        crmContractNumber.setStatus(ContractNumberStatusEnum.CONTRACT_STATUS_CHECK_ING.getContractStatus());
                        crmContractNumber.setFlowStep(ContractNumberStepEnum.CONTRACT_STEP_JGC_PRODUCE_CHECK.getContractStep());
                    } else if (ContractNumberStepEnum.CONTRACT_STEP_JGC_PRODUCE_CHECK.getContractStep().equals(crmContractNumber.getFlowStep())) {
                        crmContractNumber.setStatus(ContractNumberStatusEnum.CONTRACT_STATUS_CHECK_FINISHED.getContractStatus());
                        crmContractNumber.setFlowStep(ContractNumberStepEnum.CONTRACT_STEP_FINISH.getContractStep());
                        this.getConNumber(crmContractNumberDto);
                    }
                } else {
                    crmContractNumberDto.setProcessDefinitionKey("bpm_ht_num_approve");
                    crmContractNumber.setStatus(ContractNumberStatusEnum.CONTRACT_STATUS_CHECK_ING.getContractStatus());
                    crmContractNumber.setFlowStep(ContractNumberStepEnum.CONTRACT_STEP_DEPT_CHECK.getContractStep());
                }
            }
            crmContractNumber.setSecrectLevel(50);
            boolean resultFlag = this.saveOrUpdate(crmContractNumber);
            if (!resultFlag) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
            if (flag.booleanValue()) {
                this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.CONTRACT_NUMBER, Long.valueOf(crmContractNumber.getId()), crmContractNumber.getName(), LocalDateTime.now(), false, null);
            } else {
                Map map = DataCompareUtils.getRecordInfo((Object)oldEntity, (Object)crmContractNumber);
                if (((String)map.get("changeFlag")).equals("true")) {
                    OperateRecordAPIVo trackRecord = this.operateRecordAPIService.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), (String)map.get("oldJson"), (String)map.get("newJson"), (String)map.get("changeFieldStr"));
                    trackRecord.setChangeBatch(1);
                    this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.CONTRACT_NUMBER, Long.valueOf(crmContractNumber.getId()), oldEntity.getName(), LocalDateTime.now(), false, null);
                }
            }
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
        this.formsubmit(crmContractNumberDto, String.valueOf(crmContractNumber.getId()));
        return ApiResponse.success((Object)String.valueOf(crmContractNumber.getId()), (String)"\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355\u6210\u529f");
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public void formsubmit(CrmContractNumberDto crmContractNumberDto, String businessKey) {
        BpmResponseResult bpmResponseResult;
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        HashMap<String, String> appointMap = new HashMap<String, String>();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        String taskId = crmContractNumberDto.getTaskId();
        String comment = crmContractNumberDto.getComment();
        if (crmContractNumberDto.getFlowSelect() == null) {
            appointMap.put("static_appoint_assignee", crmContractNumberDto.getParticipantSelect());
        } else {
            appointMap.put(crmContractNumberDto.getFlowSelect(), crmContractNumberDto.getParticipantSelect());
            variable.put("bpm_next_node", crmContractNumberDto.getFlowSelect());
        }
        if (crmContractNumberDto.getFormdata() != null && HussarUtils.isNotEmpty((Object)crmContractNumberDto.getFormdata().getSecrectLevel())) {
            variable.put("security_level", crmContractNumberDto.getFormdata().getSecrectLevel());
        }
        if (crmContractNumberDto.getSelectBranches() != null) {
            ArrayList<String> nextNodeIds = new ArrayList<String>();
            HashMap<String, String> multiTypeMap = new HashMap<String, String>();
            for (Map<String, String> map : crmContractNumberDto.getSelectBranches()) {
                appointMap.put(map.get("flowSelect"), map.get("participants"));
                if (HussarUtils.isNotEmpty((Object)map.get("multiNodeType"))) {
                    multiTypeMap.put(map.get("flowSelect"), map.get("multiNodeType"));
                }
                nextNodeIds.add(map.get("flowSelect"));
            }
            if (HussarUtils.isNotEmpty(multiTypeMap)) {
                variable.put("multi_node_type", multiTypeMap);
            }
            variable.put("bpm_next_node", String.join((CharSequence)",", nextNodeIds));
        }
        String processDefinitionKey = crmContractNumberDto.getProcessDefinitionKey();
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        if (HussarUtils.isEmpty((Object)taskId)) {
            String deptId = BaseSecurityUtil.getUser().getDeptId() == null ? "" : String.valueOf(BaseSecurityUtil.getUser().getDeptId());
            BpmResponseResult startResult = InstanceEngineService.startProcessInstanceByKey((String)processDefinitionKey, (String)userId, (String)deptId, (String)businessKey, variable);
            if ("1".equals(startResult.getCode())) {
                taskId = (String)startResult.getResult().getJSONObject(0).get((Object)"taskId");
            } else {
                throw new HussarException(startResult.getMsg());
            }
        }
        if (!"1".equals((bpmResponseResult = TaskEngineService.completeTask((String)taskId, (String)userId, appointMap, null, (String)comment, variable)).getCode())) {
            throw new HussarException(bpmResponseResult.getMsg());
        }
        CrmContractNumber number = (CrmContractNumber)this.getById((Serializable)((Object)businessKey));
        if (!"\u7ed3\u675f".equals(bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskDefinitionName"))) {
            taskId = (String)bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskId");
            number.setTaskId(taskId);
        } else {
            number.setStatus(ContractNumberStatusEnum.CONTRACT_STATUS_CHECK_FINISHED.getContractStatus());
            number.setFlowStep(ContractNumberStepEnum.CONTRACT_STEP_FINISH.getContractStep());
        }
        this.saveOrUpdate(number);
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> prevNodeReject(CrmContractNumberDto crmContractNumberDto) {
        try {
            String comment;
            CrmContractNumber crmContractNumber = crmContractNumberDto.getFormdata();
            String taskId = crmContractNumberDto.getTaskId() == null ? "" : crmContractNumberDto.getTaskId();
            String string = comment = crmContractNumberDto.getComment() == null ? "" : crmContractNumberDto.getComment();
            if (ContractNumberStepEnum.CONTRACT_STEP_JGC_PRODUCE_CHECK.getContractStep().equals(crmContractNumber.getFlowStep())) {
                crmContractNumber.setStatus(ContractNumberStatusEnum.CONTRACT_STATUS_CHECK_ING.getContractStatus());
                crmContractNumber.setFlowStep(ContractNumberStepEnum.CONTRACT_STEP_DEPT_CHECK.getContractStep());
            } else if (ContractNumberStepEnum.CONTRACT_STEP_DEPT_CHECK.getContractStep().equals(crmContractNumber.getFlowStep())) {
                crmContractNumber.setStatus(ContractNumberStatusEnum.CONTRACT_STATUS_TODO_SUBMIT.getContractStatus());
                crmContractNumber.setFlowStep(ContractNumberStepEnum.CONTRACT_STEP_APPLY.getContractStep());
            }
            boolean resultFlag = this.saveOrUpdate(crmContractNumber);
            if (!resultFlag) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
            ApiResponse<String> stringApiResponse = this.startAnyNodeRejectInstance(taskId, comment);
            taskId = stringApiResponse.getMsg();
            crmContractNumber.setTaskId(taskId);
            this.updateById(crmContractNumber);
            return ApiResponse.success((String)"");
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public ApiResponse<String> startAnyNodeRejectInstance(String taskId, String comment) {
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        try {
            BpmResponseResult bpmResponseResult = TaskEngineService.rejectToLastTask((String)taskId, (String)userId, (String)comment, null, (boolean)true, null);
            if ("1".equals(bpmResponseResult.getCode())) {
                return ApiResponse.success((String)((String)bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskId")));
            }
            throw new HussarException(bpmResponseResult.getMsg());
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    private void getConNumber(CrmContractNumberDto crmContractNumberDto) {
        CrmContractNumber crmContractNumber = crmContractNumberDto.getFormdata();
        String conNumber = "";
        if ("1".equals(crmContractNumber.getAddContractFlag())) {
            String mainContractId = crmContractNumber.getMainContractId();
            CrmAgreement mainAgreement = (CrmAgreement)this.crmAgreementService.getById((Serializable)((Object)mainContractId));
            conNumber = mainAgreement.getAgreementNumber();
            List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmContractNumber::getDelFlag, (Object)RETURN_CODE)).eq(CrmContractNumber::getMainContractId, (Object)mainContractId)).isNotNull(CrmContractNumber::getContractNumber)).ne(CrmContractNumber::getContractNumber, (Object)"")).orderByDesc(CrmContractNumber::getContractNumber));
            int num = 0;
            if (list.size() > 0) {
                String mainNumber = ((CrmContractNumber)list.get(0)).getContractNumber();
                String number2 = mainNumber.substring(mainNumber.length() - 3);
                num = Integer.parseInt(number2);
            }
            String countStr = String.format("%03d", num + 1);
            conNumber = conNumber + "-" + countStr;
        } else {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yy");
            String twoDigitYear = LocalDate.now().format(formatter);
            SysStru companyInfo = this.struUserAPIService.getCompanyInfoByCurrentDeptId(BaseSecurityUtil.getUser().getDeptId().toString());
            SysOrgan organ = (SysOrgan)this.sysOrganService.getById((Serializable)companyInfo.getOrganId());
            conNumber = "10" + twoDigitYear;
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmContractNumber::getDelFlag, (Object)RETURN_CODE)).isNotNull(CrmContractNumber::getContractNumber)).ne(CrmContractNumber::getContractNumber, (Object)"")).ne(CrmContractNumber::getAddContractFlag, (Object)"1")).like(CrmContractNumber::getContractNumber, (Object)conNumber)).orderByDesc(CrmContractNumber::getContractNumber);
            List list = this.list((Wrapper)queryWrapper);
            int num = 0;
            if (list.size() > 0) {
                num = list.stream().map(CrmContractNumber::getContractNumber).filter(number -> number != null && number.length() >= 4).map(number -> number.substring(number.length() - 4)).filter(lastFour -> lastFour.matches("\\d{4}")).mapToInt(Integer::parseInt).max().orElse(0);
            }
            String countStr = String.format("%04d", num + 1);
            conNumber = conNumber + organ.getOrganCode() + countStr;
        }
        crmContractNumber.setContractNumber(conNumber);
    }

    @Override
    public ApiResponse selectBidOrProInfoList(BidOrProPageDto bidOrProPageDto) {
        String deptId;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer userSecurityLevel = BaseSecurityUtil.getUser().getSecurityLevel();
        String string = deptId = BaseSecurityUtil.getUser().getDeptId() == null ? "" : String.valueOf(BaseSecurityUtil.getUser().getDeptId());
        if ("1".equals(bidOrProPageDto.getBidProductFlag())) {
            Page page = new Page((long)bidOrProPageDto.getCurrent().intValue(), (long)bidOrProPageDto.getSize().intValue());
            bidOrProPageDto.setUserSecurityLevel(userSecurityLevel);
            SysStru unit = this.commonService.getLoginUserUnit(Long.valueOf(deptId));
            if (unit != null) {
                bidOrProPageDto.setUnitId(unit.getId());
            }
            List<CrmOpportunityBidVO> list = this.carNumberMapper.opportunityBidList((Page<CrmOpportunityBidVO>)page, bidOrProPageDto);
            resultMap.put("totalCount", list.size());
            resultMap.put("list", list);
        } else if (RETURN_CODE.equals(bidOrProPageDto.getBidProductFlag())) {
            Page page = new Page((long)bidOrProPageDto.getCurrent().intValue(), (long)bidOrProPageDto.getSize().intValue());
            LambdaQueryWrapper productQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Product::getDelFlag, (Object)RETURN_CODE);
            if (HussarUtils.isNotEmpty((Object)userSecurityLevel)) {
                productQueryWrapper.le(Product::getSecurityLevel, (Object)userSecurityLevel);
            }
            if (HussarUtils.isNotEmpty((Object)bidOrProPageDto.getBidProductSearchName())) {
                productQueryWrapper.like(Product::getProductName, (Object)bidOrProPageDto.getBidProductSearchName());
            }
            List records = ((Page)this.productService.page((IPage)page, (Wrapper)productQueryWrapper)).getRecords();
            resultMap.put("totalCount", records.size());
            resultMap.put("list", records);
        } else {
            return ApiResponse.fail((String)"\u8bf7\u9009\u62e9\u662f\u5426\u662f\u975e\u6807\u4ea7\u54c1");
        }
        return ApiResponse.success(resultMap);
    }

    @Override
    public ApiResponse selectMainContractList(BidOrProPageDto bidOrProPageDto) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer userSecurityLevel = BaseSecurityUtil.getUser().getSecurityLevel();
        String deptId = BaseSecurityUtil.getUser().getDeptId() == null ? "" : String.valueOf(BaseSecurityUtil.getUser().getDeptId());
        Page page = new Page((long)bidOrProPageDto.getCurrent().intValue(), (long)bidOrProPageDto.getSize().intValue());
        LambdaQueryWrapper contractQueryWrapper = new LambdaQueryWrapper();
        contractQueryWrapper.eq(CrmAgreement::getDelFlag, (Object)RETURN_CODE);
        if (HussarUtils.isNotEmpty((Object)userSecurityLevel)) {
            contractQueryWrapper.le(CrmAgreement::getSecurityLevel, (Object)userSecurityLevel);
        }
        if (HussarUtils.isNotEmpty((Object)bidOrProPageDto.getContractSearchName())) {
            contractQueryWrapper.like(CrmAgreement::getAgreementName, (Object)bidOrProPageDto.getContractSearchName());
        }
        if (HussarUtils.isNotEmpty((Object)bidOrProPageDto.getContractId())) {
            contractQueryWrapper.like(CrmAgreement::getAgreementNumber, (Object)bidOrProPageDto.getContractId());
        }
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            contractQueryWrapper.eq(CrmAgreement::getCreateDepartment, (Object)deptId);
        }
        List records = ((Page)this.crmAgreementService.page((IPage)page, (Wrapper)contractQueryWrapper)).getRecords();
        resultMap.put("totalCount", records.size());
        resultMap.put("list", records);
        return ApiResponse.success(resultMap);
    }

    @Override
    public Page<CrmContractNumber> listPage(CrmContractNumberPageDto dto) {
        List<Object> list;
        PermissionDto contractNumberPermissionDto = new PermissionDto();
        SecurityUser user = BaseSecurityUtil.getUser();
        contractNumberPermissionDto = this.contralNumberDataRightModuleService.getUserRolePermission(user);
        if (StringUtil.isNotEmpty((Object)dto.getCustomerScreening())) {
            String[] split = dto.getCustomerScreening().split(" ");
            list = Arrays.asList(split);
            dto.setCustomerScreenList(list);
        }
        dto.setPermissionDto(contractNumberPermissionDto);
        InitUnitDataUtill.initForNumber(dto);
        Page page = dto.getPage();
        list = this.carNumberMapper.conNumberList((Page<CrmContractNumber>)page, dto);
        page.setRecords(list);
        return page;
    }

    @Override
    public ApiResponse<String> deleteConNumber(Long id) {
        CrmContractNumber entity = (CrmContractNumber)this.getById(id);
        if (ContractNumberStatusEnum.CONTRACT_STATUS_DRAFT.getContractStatus().equals(entity.getStatus())) {
            this.removeById(id);
            return ApiResponse.success();
        }
        if (ContractNumberStepEnum.CONTRACT_STEP_APPLY.getContractStep().equals(entity.getFlowStep())) {
            InstanceEngineService.deleteProcessInstanceByBusinessKey((String)String.valueOf(entity.getId()));
            this.removeById(id);
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u5220\u9664");
    }

    @Override
    public Page<CrmContractNumberVO> queryUnAppliedContractNum(CrmContractNumberPageDto dto) {
        PermissionDto contractNumberPermissionDto = new PermissionDto();
        SecurityUser user = BaseSecurityUtil.getUser();
        contractNumberPermissionDto = this.contralNumberDataRightModuleService.getUserRolePermission(user);
        dto.setPermissionDto(contractNumberPermissionDto);
        Page page = new Page((long)dto.getCurrent().intValue(), (long)dto.getSize().intValue());
        List<CrmContractNumberVO> list = this.carNumberMapper.queryUnAppliedContractNum((Page<CrmContractNumberVO>)page, dto);
        page.setRecords(list);
        page.setSize((long)list.size());
        return page;
    }

    @Override
    public ApiResponse updateConNumber(CrmContractNumber entity) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (null == entity.getId()) {
            Long contractNumberId = Long.parseLong(CommonUtills.generateAssignId());
            entity.setId(String.valueOf(contractNumberId));
            this.saveBaseInfo(entity, user);
            entity.setStatus(ContractNumberStatusEnum.CONTRACT_STATUS_DRAFT.getContractStatus());
            entity.setDelFlag(RETURN_CODE);
            this.save(entity);
            this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.CONTRACT_NUMBER, Long.valueOf(entity.getId()), entity.getName(), LocalDateTime.now(), false, null);
        } else {
            if (ContractNumberStatusEnum.CONTRACT_STATUS_CHECK_ING.getContractStatus().equals(entity.getStatus()) || ContractNumberStatusEnum.CONTRACT_STATUS_CHECK_FINISHED.getContractStatus().equals(entity.getStatus())) {
                return ApiResponse.fail((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u8fdb\u884c\u7f16\u8f91\uff01");
            }
            this.updateBaseInfo(entity, user);
            CrmContractNumber oldEntity = (CrmContractNumber)this.getById((Serializable)((Object)entity.getId()));
            this.updateById(entity);
            Map map = DataCompareUtils.getRecordInfo((Object)oldEntity, (Object)entity);
            if (((String)map.get("changeFlag")).equals("true")) {
                OperateRecordAPIVo trackRecord = this.operateRecordAPIService.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), (String)map.get("oldJson"), (String)map.get("newJson"), (String)map.get("changeFieldStr"));
                trackRecord.setChangeBatch(1);
                this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.CONTRACT_NUMBER, Long.valueOf(entity.getId()), oldEntity.getName(), LocalDateTime.now(), false, null);
            }
        }
        return ApiResponse.success((String)entity.getId());
    }

    @Override
    public OperateVo operate(Long id) {
        OperateVo operateVo = new OperateVo();
        if (id == null) {
            return operateVo;
        }
        CrmContractNumber conNumber = (CrmContractNumber)this.getById(id);
        if (conNumber == null || "1".equals(conNumber.getDelFlag())) {
            return operateVo;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (conNumber.getCreator().equals(user.getUserId().toString())) {
            operateVo.setEditOperate(Integer.valueOf(1));
            operateVo.setViewOperate(Boolean.valueOf(true));
            return operateVo;
        }
        List rolesList = user.getRolesList();
        rolesList.stream().forEach(one -> {
            if (one.equals(CommonHtConstant.ROLE_ID_DEPT_LEADER) || one.equals(CommonHtConstant.ROLE_ID_JGC_LEADER)) {
                operateVo.setViewOperate(Boolean.valueOf(true));
                operateVo.setEditOperate(Integer.valueOf(1));
            }
        });
        return operateVo;
    }

    @Override
    public String exportList(HttpServletResponse response, CrmContractNumberPageDto dto) {
        DateConvertVo dateConverVo;
        PermissionDto contractNumberPermissionDto = new PermissionDto();
        SecurityUser user = BaseSecurityUtil.getUser();
        contractNumberPermissionDto = this.contralNumberDataRightModuleService.getUserRolePermission(user);
        if (StringUtil.isNotEmpty((Object)dto.getCustomerScreening())) {
            String[] split = dto.getCustomerScreening().split(" ");
            List<String> list = Arrays.asList(split);
            dto.setCustomerScreenList(list);
        }
        dto.setPermissionDto(contractNumberPermissionDto);
        if (StringUtil.isNotBlank((CharSequence)dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && (dateConverVo = IndexUtil.getCurrentTime((String)dto.getCreateTimeFlag())) != null) {
            dto.setStartTime(dateConverVo.getStartDate());
            dto.setFinalTime(dateConverVo.getEndDate());
        }
        InitUnitDataUtill.initForNumber(dto);
        List<CrmContractNumber> list = this.carNumberMapper.conNumberList(null, dto);
        this.tranDictData(list);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u8981\u53f7\u5217\u8868", CrmContractNumber.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(CrmNumberAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        ICrmNumberAssociativeQueryService adapterService = this.numberAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("keyword");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    private void tranDictData(List<CrmContractNumber> list) {
        Map<String, String> yesnoDict = this.sysDicRefService.getDicListByType("yes_no").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel, (oldValue, newValue) -> oldValue));
        Map<String, String> securityLevelDic = this.sysDicRefService.getDicListByType("security_level").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
        list.stream().forEach(one -> {
            one.setContractNumber(StringUtil.isBlank((CharSequence)one.getContractNumber()) ? "\u7b49\u5f85\u751f\u6210" : one.getContractNumber());
            one.setBidProductFlag((String)yesnoDict.get(one.getBidProductFlag()));
            one.setAddContractFlag((String)yesnoDict.get(one.getAddContractFlag()));
            one.setIsUseFlag((String)yesnoDict.get(one.getIsUseFlag()));
            one.setStatus(ContractNumberStatusEnum.getDescriptionByStatus(one.getStatus()));
        });
    }

    private void saveBaseInfo(CrmContractNumber crmContractNumber, SecurityUser user) {
        crmContractNumber.setDelFlag(RETURN_CODE);
        crmContractNumber.setCreateTime(LocalDateTime.now());
        crmContractNumber.setCreator(user.getUserId().toString());
        crmContractNumber.setCreateDeptId(user.getDeptId().toString());
        crmContractNumber.setCreateDeptName(user.getDeptName());
        SysStru companyInfo = this.struUserAPIService.getCompanyInfoByCurrentDeptId(user.getDeptId().toString());
        crmContractNumber.setCreateCompanyId(companyInfo.getId().toString());
        crmContractNumber.setCreateCompanyName(companyInfo.getOrganAlias());
    }

    private void updateBaseInfo(CrmContractNumber entity, SecurityUser user) {
        entity.setLastEditorName(user.getUserName());
        entity.setLastEditorTime(LocalDateTime.now());
        entity.setLastEditor(user.getId().toString());
    }
}

