/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.contract.crmagreementchange.task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.crm.transaction.contract.crmagreementchange.model.CrmAgreementChangeSysTask;
import com.jxdinfo.crm.transaction.contract.crmagreementchange.service.CrmAgreementChangeSysTaskService;
import com.jxdinfo.crm.transaction.contract.crmagreementchange.service.CrmAgreementChangeTaskService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ProcessNode;
import com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto;
import com.jxdinfo.hussar.workflow.task.model.dto.WorkflowUserDto;
import com.jxdinfo.hussar.workflow.task.model.service.TaskModelService;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="bpm_htbg_change")
@HussarDs(value="master")
public class CrmAgreementChangeSysTaskDataBackFillServiceImpl
implements TaskModelService {
    @Autowired
    private CrmAgreementChangeSysTaskService crmAgreementChangeSysTaskService;
    @Autowired
    private CrmAgreementChangeTaskService crmAgreementChangeTaskService;

    public boolean changeProcessInfo(ProcessInfoDto processInfoDto) {
        UpdateWrapper updateWrapper = Wrappers.update();
        updateWrapper.eq((Object)"AGREEMENT_CHANGE_ID", (Object)processInfoDto.getBusinessId());
        updateWrapper.set((Object)"PROCESS_KEY", (Object)processInfoDto.getProcessKey());
        updateWrapper.set((Object)"PROCESS_STATE", (Object)processInfoDto.getProcessState());
        updateWrapper.set((Object)"PROCESS_INST_ID", (Object)processInfoDto.getProcessInstanceId());
        updateWrapper.set((Object)"START_TIME", (Object)processInfoDto.getStartTime());
        updateWrapper.set((Object)"FINISH_TIME", (Object)processInfoDto.getFinishTime());
        return this.crmAgreementChangeTaskService.update((Wrapper)updateWrapper);
    }

    public boolean deleteProcess(List<DeletedProcessInfoDto> deletedProcessInfoDtos) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (deletedProcessInfoDtos != null && deletedProcessInfoDtos.size() > 0) {
            UpdateWrapper updateWrapper = Wrappers.update();
            for (DeletedProcessInfoDto deletedProcessInfoDto : deletedProcessInfoDtos) {
                ids.add(Long.valueOf(deletedProcessInfoDto.getBusinessId()));
            }
            updateWrapper.in((Object)"AGREEMENT_CHANGE_ID", ids);
            DeletedProcessInfoDto deletedProcessInfo = deletedProcessInfoDtos.get(0);
            updateWrapper.set((Object)"PROCESS_STATE", (Object)deletedProcessInfo.getProcessState());
            updateWrapper.set((Object)"FINISH_TIME", (Object)deletedProcessInfo.getFinishTime());
            this.crmAgreementChangeTaskService.update((Wrapper)updateWrapper);
            return true;
        }
        return false;
    }

    public boolean changeProcessNode(ProcessNodeInfoDto processNodeInfoDto) {
        UpdateWrapper updateWrapper = Wrappers.update();
        updateWrapper.eq((Object)"AGREEMENT_CHANGE_ID", (Object)processNodeInfoDto.getBusinessId());
        updateWrapper.set((Object)"PROCESS_NODE", (Object)this.analyzeProcessNode(processNodeInfoDto.getProcessNodeList()));
        this.crmAgreementChangeTaskService.update((Wrapper)updateWrapper);
        return true;
    }

    private String analyzeProcessNode(List<ProcessNode> nodeList) {
        String processNode = "";
        if (nodeList != null && nodeList.size() > 0) {
            for (ProcessNode node : nodeList) {
                String nodeName = node.getTaskDefinitionName();
                if (node.getChildrenList() != null && node.getChildrenList().size() > 0) {
                    nodeName = nodeName + "(";
                    for (ProcessNode childNode : node.getChildrenList()) {
                        nodeName = nodeName + childNode.getTaskDefinitionName() + "\u3001";
                    }
                    nodeName = nodeName.substring(0, nodeName.length() - 1) + ")";
                }
                if (processNode.length() == 0) {
                    processNode = processNode + nodeName;
                    continue;
                }
                processNode = processNode + "-" + nodeName;
            }
        }
        return processNode;
    }

    public Integer addTaskInfo(TaskInfoDto taskInfoDto) {
        if (taskInfoDto.getUsers() == null || taskInfoDto.getUsers().size() == 0) {
            CrmAgreementChangeSysTask crmAgreementChangeSysTask = this.taskInfoDtoToTaskEntity(taskInfoDto);
            return this.crmAgreementChangeSysTaskService.save(crmAgreementChangeSysTask) ? 1 : 0;
        }
        ArrayList<CrmAgreementChangeSysTask> crmAgreementChangeSysTaskList = new ArrayList<CrmAgreementChangeSysTask>();
        for (WorkflowUserDto user : taskInfoDto.getUsers()) {
            CrmAgreementChangeSysTask crmAgreementChangeSysTask = this.taskInfoDtoToTaskEntity(taskInfoDto);
            crmAgreementChangeSysTask.setAssignee(user.getUserId());
            crmAgreementChangeSysTaskList.add(crmAgreementChangeSysTask);
        }
        return this.crmAgreementChangeSysTaskService.saveBatch(crmAgreementChangeSysTaskList, taskInfoDto.getUsers().size()) ? taskInfoDto.getUsers().size() : 0;
    }

    private CrmAgreementChangeSysTask taskInfoDtoToTaskEntity(TaskInfoDto taskInfoDto) {
        CrmAgreementChangeSysTask crmAgreementChangeSysTask = new CrmAgreementChangeSysTask();
        crmAgreementChangeSysTask.setBusinessId(taskInfoDto.getBusinessId());
        crmAgreementChangeSysTask.setTaskId(Long.parseLong(taskInfoDto.getTaskId()));
        crmAgreementChangeSysTask.setTaskDefKey(taskInfoDto.getTaskDefinitionKey());
        crmAgreementChangeSysTask.setTaskDefName(taskInfoDto.getTaskDefinitionName());
        crmAgreementChangeSysTask.setFormKey(taskInfoDto.getFormKey());
        crmAgreementChangeSysTask.setFormDetailKey(taskInfoDto.getFormDetailKey());
        crmAgreementChangeSysTask.setTaskCreateTime(taskInfoDto.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        crmAgreementChangeSysTask.setTaskState(taskInfoDto.getTaskState());
        crmAgreementChangeSysTask.setTaskType(taskInfoDto.getTaskType());
        return crmAgreementChangeSysTask;
    }

    public boolean completeTask(List<CompleteTaskInfoDto> completeTaskInfoDtos) {
        boolean flag = true;
        for (CompleteTaskInfoDto completeTaskInfoDto : completeTaskInfoDtos) {
            if (completeTaskInfoDto.getTaskId() == null || completeTaskInfoDto.getTaskId().length() <= 0) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TASK_ID", (Object)completeTaskInfoDto.getTaskId());
            queryWrapper.last("limit 1");
            CrmAgreementChangeSysTask crmAgreementChangeSysTask = (CrmAgreementChangeSysTask)this.crmAgreementChangeSysTaskService.getOne((Wrapper)queryWrapper);
            QueryWrapper removeWrapper = new QueryWrapper();
            removeWrapper.eq((Object)"TASK_ID", (Object)completeTaskInfoDto.getTaskId());
            this.crmAgreementChangeSysTaskService.remove((Wrapper)removeWrapper);
            crmAgreementChangeSysTask.setEndTime(completeTaskInfoDto.getEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            crmAgreementChangeSysTask.setTaskType(completeTaskInfoDto.getTaskType());
            crmAgreementChangeSysTask.setTaskState(completeTaskInfoDto.getTaskState());
            crmAgreementChangeSysTask.setAssignee(completeTaskInfoDto.getAssignee());
            boolean saveFlag = this.crmAgreementChangeSysTaskService.save(crmAgreementChangeSysTask);
            if (saveFlag) continue;
            flag = saveFlag;
        }
        return flag;
    }

    public Integer updateTaskUser(List<UpdateTaskUserDto> updateTaskUserDtos) {
        Integer article = 0;
        for (UpdateTaskUserDto updateTaskUserDto : updateTaskUserDtos) {
            if (updateTaskUserDto.getTaskId() == null || updateTaskUserDto.getTaskId().length() <= 0) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TASK_ID", (Object)updateTaskUserDto.getTaskId());
            queryWrapper.last("limit 1");
            CrmAgreementChangeSysTask crmAgreementChangeSysTask = (CrmAgreementChangeSysTask)this.crmAgreementChangeSysTaskService.getOne((Wrapper)queryWrapper);
            crmAgreementChangeSysTask.setTaskInfoId(null);
            QueryWrapper removeWrapper = new QueryWrapper();
            removeWrapper.eq((Object)"TASK_ID", (Object)updateTaskUserDto.getTaskId());
            this.crmAgreementChangeSysTaskService.remove((Wrapper)removeWrapper);
            if (updateTaskUserDto.getUsers() == null || updateTaskUserDto.getUsers().size() == 0) {
                crmAgreementChangeSysTask.setAssignee(null);
                boolean saveFlag = this.crmAgreementChangeSysTaskService.save(crmAgreementChangeSysTask);
                if (!saveFlag) continue;
                Integer n = article;
                Integer n2 = article = Integer.valueOf(article + 1);
                continue;
            }
            ArrayList<CrmAgreementChangeSysTask> crmAgreementChangeSysTaskList = new ArrayList<CrmAgreementChangeSysTask>();
            for (WorkflowUserDto user : updateTaskUserDto.getUsers()) {
                CrmAgreementChangeSysTask cloneTaskModelEntity = (CrmAgreementChangeSysTask)HussarUtils.clone((Object)crmAgreementChangeSysTask);
                cloneTaskModelEntity.setAssignee(user.getUserId());
                crmAgreementChangeSysTaskList.add(cloneTaskModelEntity);
            }
            boolean saveBatchFlag = this.crmAgreementChangeSysTaskService.saveBatch(crmAgreementChangeSysTaskList, updateTaskUserDto.getUsers().size());
            if (!saveBatchFlag) continue;
            article = article + updateTaskUserDto.getUsers().size();
        }
        return article;
    }

    public boolean deleteTaskInfo(List<DeletedTaskInfoDto> deletedTaskInfoDtos) {
        QueryWrapper queryWrapper;
        ArrayList taskIdList = new ArrayList();
        ArrayList businessIdList = new ArrayList();
        for (DeletedTaskInfoDto deletedTaskInfoDto : deletedTaskInfoDtos) {
            if (deletedTaskInfoDto.getTaskIdList() != null && deletedTaskInfoDto.getTaskIdList().size() > 0) {
                taskIdList.addAll(deletedTaskInfoDto.getTaskIdList());
                continue;
            }
            businessIdList.addAll(deletedTaskInfoDto.getBusinessIdList());
        }
        if (taskIdList.size() > 0) {
            queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"TASK_ID", taskIdList);
            return this.crmAgreementChangeSysTaskService.remove((Wrapper)queryWrapper);
        }
        if (businessIdList.size() > 0) {
            queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"BUSINESS_ID", businessIdList);
            return this.crmAgreementChangeSysTaskService.remove((Wrapper)queryWrapper);
        }
        return false;
    }
}

