/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.contract.crmagreement.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.common.api.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAPIService;
import com.jxdinfo.crm.common.api.associativeQuery.service.IAssociativeQueryAdapterService;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IStruUserAPIService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.common.api.util.operateRecord.DataCompareUtils;
import com.jxdinfo.crm.core.api.fileinfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.core.api.teammember.service.ITeamMemberApiService;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.fileinfo.dto.FileInfoDto;
import com.jxdinfo.crm.core.fileinfo.model.FileImport;
import com.jxdinfo.crm.core.fileinfo.service.FileImportService;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.ExcelImportUtil;
import com.jxdinfo.crm.core.utills.ReadLeadsExcelUtil;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.transaction.api.service.IAgreementDataRightModuleService;
import com.jxdinfo.crm.transaction.constants.ContractAgreementNodeEnum;
import com.jxdinfo.crm.transaction.constants.ContractAgreementStatusEnum;
import com.jxdinfo.crm.transaction.constants.ExcelConstant;
import com.jxdinfo.crm.transaction.contract.crmagreement.dao.CrmAgreementMapper;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementAssociativeQueryDto;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementCrmagreementdataset1;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementDto;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementPageDto;
import com.jxdinfo.crm.transaction.contract.crmagreement.model.CrmAgreement;
import com.jxdinfo.crm.transaction.contract.crmagreement.model.CrmAgreementWarningConfig;
import com.jxdinfo.crm.transaction.contract.crmagreement.service.CrmAgreementService;
import com.jxdinfo.crm.transaction.contract.crmagreement.vo.CrmAgreementPageVo;
import com.jxdinfo.crm.transaction.contract.crmagreement.vo.CrmAgreementVO;
import com.jxdinfo.crm.transaction.contract.crmagreement.vo.CrmAgreementWarningPageVO;
import com.jxdinfo.crm.transaction.contract.crmagreement.vo.CrmAgreementWarningVO;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.model.CrmContractNumber;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.service.CrmContractNumberService;
import com.jxdinfo.crm.transaction.operationsmanage.contract.crmagreement.model.CrmAgreementProduct;
import com.jxdinfo.crm.transaction.operationsmanage.contract.crmagreement.service.CrmAgreementProductService;
import com.jxdinfo.crm.transaction.operationsmanage.contract.crmagreement.service.ICrmAgreementAssociativeQueryService;
import com.jxdinfo.crm.transaction.utils.InitUnitDataUtill;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="contract.crmagreement.CrmAgreementServiceImpl")
@HussarTokenDs
public class CrmAgreementServiceImpl
extends HussarServiceImpl<CrmAgreementMapper, CrmAgreement>
implements CrmAgreementService {
    private static final Logger logger = LoggerFactory.getLogger(CrmAgreementServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    @Resource
    private IStruUserAPIService struUserAPIService;
    @Autowired
    private CrmAgreementMapper crmAgreementMapper;
    @Resource
    private IAgreementDataRightModuleService agreementDataRightModuleService;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Autowired
    private CrmContractNumberService crmContractNumberService;
    @Resource
    private ITeamMemberApiService teamMemberApiService;
    @Autowired
    private CrmAgreementProductService crmAgreementProductService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private FileImportService fileImportService;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ICrmAgreementAssociativeQueryService crmAgreementAssociativeQueryService;
    @Resource
    private IAssociativeQueryAPIService associativeQueryService;
    @Resource
    private IFileInfoAPIService fileInfoAPIService;
    @Resource
    private FileInfoService fileInfoService;

    public List<CrmAgreement> getByMap(Map<String, Object> map) {
        return this.list((Wrapper)new LambdaQueryWrapper(BeanUtil.copy(map, CrmAgreement.class)));
    }

    @Override
    public ApiResponse<CrmAgreement> formQuery(String id) {
        try {
            CrmContractNumber one;
            CrmAgreement crmAgreement = (CrmAgreement)this.getById((Serializable)((Object)id));
            if (StringUtil.isNotEmpty((Object)crmAgreement.getMasterContractId())) {
                CrmAgreement masterAgreement = (CrmAgreement)this.getById((Serializable)((Object)crmAgreement.getMasterContractId()));
                crmAgreement.setMasterContractNumber(masterAgreement.getAgreementNumber());
            }
            if (null != (one = (CrmContractNumber)this.crmContractNumberService.getOne((Wrapper)new LambdaQueryWrapper().eq(CrmContractNumber::getContractNumber, (Object)crmAgreement.getAgreementNumber())))) {
                crmAgreement.setBidProductFlag(one.getBidProductFlag());
                crmAgreement.setAddContractFlag(one.getAddContractFlag());
            } else if (StringUtil.isNotEmpty((Object)crmAgreement.getMasterContractId())) {
                crmAgreement.setAddContractFlag("1");
            } else {
                crmAgreement.setAddContractFlag(RETURN_CODE);
            }
            LambdaQueryWrapper listew0 = new LambdaQueryWrapper();
            listew0.eq(CrmAgreementProduct::getAgreementId, (Object)crmAgreement.getAgreementId());
            List agreementProductList = this.crmAgreementProductService.list((Wrapper)listew0);
            if (null != agreementProductList) {
                crmAgreement.setCrmAgreementProduct(agreementProductList);
            }
            FileInfoDto fileInfoDto = new FileInfoDto();
            fileInfoDto.setBusinessId(crmAgreement.getAgreementId());
            Page fileInfoPage = this.fileInfoService.selectFileInfoByBusinessId(fileInfoDto);
            if (null != fileInfoPage && null != fileInfoPage.getRecords()) {
                crmAgreement.setFileCount(fileInfoPage.getRecords().size());
            }
            crmAgreement.setMemberCount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)crmAgreement.getAgreementId())).eq(TeamMeberEntity::getBusinessType, (Object)"6")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
            return ApiResponse.success((Object)crmAgreement);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> flowFormSubmit(CrmAgreementDto crmAgreementDto) {
        CrmAgreement crmAgreement = crmAgreementDto.getFormdata();
        CrmAgreement oldCrmAgreement = null;
        Boolean fourFlag = false;
        try {
            SecurityUser user = BaseSecurityUtil.getUser();
            Boolean flag = false;
            if (HussarUtils.isEmpty((Object)crmAgreement.getAgreementId())) {
                Boolean numberFlag = this.checkNumber(crmAgreement.getAgreementNumber());
                if (!numberFlag.booleanValue()) {
                    return ApiResponse.fail((String)(crmAgreement.getAgreementNumber() + "\u8be5\u5408\u540c\u7f16\u53f7\u5df2\u88ab\u4f7f\u7528\uff01"));
                }
                flag = true;
                crmAgreement.setDelFlag(RETURN_CODE);
                crmAgreement.setProcessKey("bpm_ht_manage");
                this.saveBaseInfo(crmAgreement, user);
                if (StringUtil.isNotEmpty((Object)crmAgreement.getSuffixId())) {
                    crmAgreement.setAgreementId(String.valueOf(crmAgreement.getSuffixId()));
                } else {
                    Long agreementId = Long.parseLong(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId());
                    crmAgreement.setAgreementId(String.valueOf(agreementId));
                }
                if (crmAgreement.getOwnUnit().equals("1008462858264256512")) {
                    fourFlag = true;
                    crmAgreement.setFlowStatus(ContractAgreementStatusEnum.STATUS_CHECK_FINISHED.getStatus());
                    crmAgreement.setProcessState("2");
                }
                this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.CONTRACT, Long.valueOf(crmAgreement.getAgreementId()), crmAgreement.getAgreementName(), LocalDateTime.now(), false, null);
            } else {
                Map map;
                CrmContractNumber one;
                oldCrmAgreement = (CrmAgreement)this.getById((Serializable)((Object)crmAgreement.getAgreementId()));
                this.updateBaseInfo(crmAgreement, user);
                this.getAgreementStatus(crmAgreement);
                if (StringUtil.isNotBlank((CharSequence)oldCrmAgreement.getProcessInstId())) {
                    BpmResponseResult bpmResponseResult = InstanceEngineService.queryProcessInstance(null, (String)crmAgreement.getAgreementId());
                    String taskId = bpmResponseResult.getResult().getJSONObject(0).getJSONArray("todo").getJSONObject(0).getString("taskId");
                    crmAgreementDto.setTaskId(taskId);
                }
                if ((one = (CrmContractNumber)this.crmContractNumberService.getOne((Wrapper)new LambdaQueryWrapper().eq(CrmContractNumber::getContractNumber, (Object)oldCrmAgreement.getAgreementNumber()))) != null) {
                    oldCrmAgreement.setBidProductFlag(one.getBidProductFlag());
                    oldCrmAgreement.setAddContractFlag(one.getAddContractFlag());
                }
                if (((String)(map = DataCompareUtils.getRecordInfo((Object)oldCrmAgreement, (Object)crmAgreement)).get("changeFlag")).equals("true")) {
                    OperateRecordAPIVo trackRecord = this.operateRecordAPIService.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), (String)map.get("oldJson"), (String)map.get("newJson"), (String)map.get("changeFieldStr"));
                    trackRecord.setChangeBatch(1);
                    this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.CONTRACT, Long.valueOf(crmAgreement.getAgreementId()), crmAgreement.getAgreementName(), LocalDateTime.now(), false, null);
                }
            }
            boolean resultFlag = this.saveOrUpdate(crmAgreement);
            this.fileInfoAPIService.deleteHighSecurityLevelFileInfo(Long.valueOf(crmAgreement.getAgreementId()), crmAgreement.getSecurityLevel());
            if (!resultFlag) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
            if (flag.booleanValue()) {
                this.teamMeberService.insertTeamMember(user.getUserName(), user.getId(), Long.valueOf(crmAgreement.getAgreementId()), "1", "1", LocalDateTime.now(), CrmBusinessTypeEnum.CONTRACT.getId());
            }
            this.updateNumberUseFlag(crmAgreement.getAgreementNumber(), "1");
            LambdaQueryWrapper ew0 = new LambdaQueryWrapper();
            ew0.eq(CrmAgreementProduct::getAgreementId, (Object)crmAgreement.getAgreementId());
            this.crmAgreementProductService.remove((Wrapper)ew0);
            List<CrmAgreementProduct> crmAgreementProducts = crmAgreement.getCrmAgreementProduct();
            CrmContractNumber contractNumber = (CrmContractNumber)this.crmContractNumberService.getOne((Wrapper)new LambdaQueryWrapper().eq(CrmContractNumber::getContractNumber, (Object)crmAgreement.getAgreementNumber()));
            String contractNumberId = crmAgreement.getAgreementNumber();
            if (null != contractNumber) {
                contractNumberId = contractNumber.getId();
            }
            if (null != crmAgreementProducts) {
                for (CrmAgreementProduct crmAgreementProduct : crmAgreementProducts) {
                    crmAgreementProduct.setAgreementId(Long.valueOf(crmAgreement.getAgreementId()));
                    crmAgreementProduct.setAgreementName(crmAgreement.getAgreementName());
                    crmAgreementProduct.setContractNumberId(Long.valueOf(contractNumberId));
                    if (crmAgreementProduct.getAgreementProductId() == null || this.crmAgreementProductService.getById(crmAgreementProduct.getAgreementProductId()) == null) {
                        crmAgreementProduct.setCreator(BaseSecurityUtil.getUser().getId());
                        crmAgreementProduct.setCreateTime(LocalDateTime.now());
                        crmAgreementProduct.setLastEditor(BaseSecurityUtil.getUser().getId());
                        crmAgreementProduct.setLastTime(LocalDateTime.now());
                        crmAgreementProduct.setDelFlag(RETURN_CODE);
                        continue;
                    }
                    crmAgreementProduct.setLastEditor(BaseSecurityUtil.getUser().getId());
                    crmAgreementProduct.setLastTime(LocalDateTime.now());
                }
                this.crmAgreementProductService.saveOrUpdateBatch(crmAgreementProducts);
            }
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
        if (!fourFlag.booleanValue()) {
            this.formsubmit(crmAgreementDto, String.valueOf(crmAgreement.getAgreementId()));
        }
        return ApiResponse.success((Object)String.valueOf(crmAgreement.getAgreementId()), (String)"\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355\u6210\u529f");
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public void formsubmit(CrmAgreementDto crmAgreementDto, String businessKey) {
        BpmResponseResult bpmResponseResult;
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        HashMap<String, String> appointMap = new HashMap<String, String>();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        String taskId = crmAgreementDto.getTaskId();
        String comment = crmAgreementDto.getComment();
        if (crmAgreementDto.getFlowSelect() == null) {
            appointMap.put("static_appoint_assignee", crmAgreementDto.getParticipantSelect());
        } else {
            appointMap.put(crmAgreementDto.getFlowSelect(), crmAgreementDto.getParticipantSelect());
            variable.put("bpm_next_node", crmAgreementDto.getFlowSelect());
        }
        if (crmAgreementDto.getFormdata() != null && HussarUtils.isNotEmpty((Object)crmAgreementDto.getFormdata().getSecurityLevel())) {
            variable.put("security_level", crmAgreementDto.getFormdata().getSecurityLevel());
        }
        if (crmAgreementDto.getSelectBranches() != null) {
            ArrayList<String> nextNodeIds = new ArrayList<String>();
            HashMap<String, String> multiTypeMap = new HashMap<String, String>();
            for (Map<String, String> map : crmAgreementDto.getSelectBranches()) {
                appointMap.put(map.get("flowSelect"), map.get("participants"));
                if (HussarUtils.isNotEmpty((Object)map.get("multiNodeType"))) {
                    multiTypeMap.put(map.get("flowSelect"), map.get("multiNodeType"));
                }
                nextNodeIds.add(map.get("flowSelect"));
            }
            if (HussarUtils.isNotEmpty(multiTypeMap)) {
                variable.put("multi_node_type", multiTypeMap);
            }
            variable.put("bpm_next_node", String.join((CharSequence)",", nextNodeIds));
        }
        String processDefinitionKey = crmAgreementDto.getProcessDefinitionKey();
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        if (HussarUtils.isEmpty((Object)taskId)) {
            String deptId = BaseSecurityUtil.getUser().getDeptId() == null ? "" : String.valueOf(BaseSecurityUtil.getUser().getDeptId());
            BpmResponseResult startResult = InstanceEngineService.startProcessInstanceByKey((String)processDefinitionKey, (String)userId, (String)deptId, (String)businessKey, variable);
            if ("1".equals(startResult.getCode())) {
                taskId = (String)startResult.getResult().getJSONObject(0).get((Object)"taskId");
                CrmAgreement entity = crmAgreementDto.getFormdata();
                entity.setProcessInstId(taskId);
                this.updateById(entity);
            } else {
                throw new HussarException(startResult.getMsg());
            }
        }
        if (!"1".equals((bpmResponseResult = TaskEngineService.completeTask((String)taskId, (String)userId, appointMap, null, (String)comment, variable)).getCode())) {
            throw new HussarException(bpmResponseResult.getMsg());
        }
        CrmAgreement byId = (CrmAgreement)this.getById((Serializable)((Object)businessKey));
        if (!"\u7ed3\u675f".equals(bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskDefinitionName"))) {
            taskId = (String)bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskId");
            byId.setProcessInstId(taskId);
        } else {
            byId.setProcessNode(ContractAgreementNodeEnum.AGREEMENT_FINISH.getNode());
            byId.setFlowStatus(ContractAgreementStatusEnum.STATUS_CHECK_FINISHED.getStatus());
        }
        this.saveOrUpdate(byId);
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> prevNodeReject(CrmAgreementDto crmAgreementDto) {
        try {
            String comment;
            CrmAgreement crmAgreement = crmAgreementDto.getFormdata();
            CrmAgreement oldCrmAgreement = (CrmAgreement)this.getById((Serializable)((Object)crmAgreement.getAgreementId()));
            String taskId = crmAgreementDto.getTaskId() == null ? "" : crmAgreementDto.getTaskId();
            String string = comment = crmAgreementDto.getComment() == null ? "" : crmAgreementDto.getComment();
            if (ContractAgreementNodeEnum.AGREEMENT_UPLOAD_FILE_ACCESS.getNode().equals(crmAgreement.getProcessNode())) {
                return ApiResponse.fail((String)"\u5f53\u524d\u8282\u70b9\u4e0d\u53ef\u9a73\u56de");
            }
            boolean resultFlag = this.saveOrUpdate(crmAgreement);
            if (!resultFlag) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
            ApiResponse<String> stringApiResponse = this.startAnyNodeRejectInstance(taskId, comment);
            taskId = stringApiResponse.getMsg();
            crmAgreement.setProcessInstId(taskId);
            this.updateById(crmAgreement);
            return ApiResponse.success((String)"");
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public ApiResponse<String> startAnyNodeRejectInstance(String taskId, String comment) {
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        try {
            BpmResponseResult bpmResponseResult = TaskEngineService.rejectToLastTask((String)taskId, (String)userId, (String)comment, null, (boolean)true, null);
            if ("1".equals(bpmResponseResult.getCode())) {
                return ApiResponse.success((String)((String)bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskId")));
            }
            throw new HussarException(bpmResponseResult.getMsg());
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Page<CrmAgreement> listPage(CrmAgreementPageDto dto) {
        return null;
    }

    @Override
    public ApiResponse<CrmAgreementPageVo> listPageNew(CrmAgreementPageDto pageDto) {
        PermissionDto permissionDto = this.agreementOperate(pageDto);
        CrmAgreementPageVo crmAgreementPageVO = new CrmAgreementPageVo();
        pageDto.setSecurityLevel(BaseSecurityUtil.getUser().getSecurityLevel());
        Page pager = new Page((long)pageDto.getCurrent(), (long)pageDto.getSize());
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        ArrayList<String> orderRule = new ArrayList<String>();
        if (pageDto.getOrders() != null) {
            StringBuilder order = new StringBuilder();
            for (OrderItem orderItem : pageDto.getOrders()) {
                if (orderItem.isAsc()) {
                    order.append(orderItem.getColumn()).append(ASC);
                    continue;
                }
                order.append(orderItem.getColumn()).append(DESC);
            }
            orderRule.add(order.toString());
            parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
        }
        ArrayList<String> defaultOrderRule = new ArrayList<String>();
        String defaultOrder = "";
        defaultOrder = defaultOrder + "T2.signDate,desc;";
        defaultOrder = defaultOrder + "T2.createTime,desc;";
        defaultOrderRule.add(defaultOrder);
        parameterMap.put(DEFAULT_ORDER_RULE, defaultOrderRule.toArray(new String[0]));
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CrmAgreement(), parameterMap);
        Long currentUserId = BaseSecurityUtil.getUser().getId();
        pageDto.setCurrentUserId(currentUserId);
        InitUnitDataUtill.initForAgreement(pageDto);
        List<CrmAgreementPageDto> dtoList = this.getOrderUnityDtoList(pageDto);
        pageDto.setDtoList(dtoList);
        pageDto.setCurrentUserId(currentUserId);
        pageDto.setPermissionDto(permissionDto);
        List<CrmAgreementVO> list = this.crmAgreementMapper.listPageNew((Page<CrmAgreement>)pager, pageDto, (QueryWrapper<CrmAgreement>)queryWrapper);
        crmAgreementPageVO.setData(list);
        crmAgreementPageVO.setCount(pager.getTotal());
        crmAgreementPageVO.setCode(RETURN_CODE);
        return ApiResponse.success((Object)crmAgreementPageVO);
    }

    @Override
    public OperateVo operate(Long agreementId) {
        OperateVo operateVo = new OperateVo();
        operateVo.setViewOperate(Boolean.valueOf(true));
        if (agreementId == null) {
            return operateVo;
        }
        CrmAgreement crmAgreement = (CrmAgreement)this.getById(agreementId);
        if (crmAgreement == null || "1".equals(crmAgreement.getDelFlag())) {
            return operateVo;
        }
        if ("1".equals(crmAgreement.getAbandonState())) {
            operateVo.setViewOperate(Boolean.valueOf(true));
            operateVo.setEditOperate(Integer.valueOf(-1));
            operateVo.setAmountFlag(Integer.valueOf(-1));
            operateVo.setTransOperate(Integer.valueOf(-1));
            return operateVo;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)user.getSecurityLevel()) && user.getSecurityLevel() < Integer.valueOf(crmAgreement.getSecurityLevel())) {
            return operateVo;
        }
        SysStru companyInfo = this.struUserAPIService.getCompanyInfoByCurrentDeptId(user.getDeptId().toString());
        if (ContractAgreementStatusEnum.STATUS_DRAFT.getStatus().equals(crmAgreement.getFlowStatus()) || ContractAgreementStatusEnum.STATUS_REJECT_SUBMIT.getStatus().equals(crmAgreement.getFlowStatus())) {
            this.teamMemberApiService.teamMemberOperate(agreementId, user, operateVo, "6");
            if (Objects.equals(crmAgreement.getChargePerson(), user.getUserId().toString()) || "1008463642804625408".equals(companyInfo.getId() + "")) {
                operateVo.setEditOperate(Integer.valueOf(1));
                operateVo.setDeleteOperate(Integer.valueOf(1));
                operateVo.setTransOperate(Integer.valueOf(1));
            }
        } else if (ContractAgreementStatusEnum.STATUS_CHECK_FINISHED.getStatus().equals(crmAgreement.getFlowStatus())) {
            this.teamMemberApiService.teamMemberOperate(agreementId, user, operateVo, "6");
            if (Objects.equals(crmAgreement.getChargePerson(), user.getUserId().toString())) {
                operateVo.setEditOperate(Integer.valueOf(1));
                operateVo.setTransOperate(Integer.valueOf(1));
                operateVo.setAbandonFlag(Integer.valueOf(1));
            }
            if ("1008463642804625408".equals(companyInfo.getId() + "")) {
                operateVo.setEditOperate(Integer.valueOf(1));
                operateVo.setTransOperate(Integer.valueOf(1));
                operateVo.setAbandonFlag(Integer.valueOf(1));
                operateVo.setAmountFlag(Integer.valueOf(1));
            }
        }
        return operateVo;
    }

    @Override
    public List<CrmAgreementPageDto> getOrderUnityDtoList(CrmAgreementPageDto dto) {
        ArrayList<CrmAgreementPageDto> queryDtoList = new ArrayList<CrmAgreementPageDto>();
        String view = dto.getAgreementView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long agreementView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)agreementView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"contract");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && RETURN_CODE.equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        CrmAgreementPageDto queryDto = (CrmAgreementPageDto)JSONObject.parseObject((String)queryValue, CrmAgreementPageDto.class);
                        queryDto.setAgreementView(String.valueOf(agreementView));
                        queryDtoList.add(queryDto);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.crmagreementdataset1Condition(dto));
        return queryDtoList;
    }

    @Override
    public String exportAgreementWarning(HttpServletResponse response, CrmAgreementPageDto pageDto) {
        DateConvertVo dateConvertVo;
        List<CrmAgreementWarningConfig> crmAgreementWarningConfigList = this.crmAgreementMapper.selectCrmAgreementWarningConfig(pageDto);
        if (HussarUtils.isEmpty(crmAgreementWarningConfigList)) {
            return "\u672a\u914d\u7f6e\u9884\u8b66\u65f6\u95f4\uff01";
        }
        LocalDate now = LocalDate.now();
        pageDto.setAgreementView("1");
        PermissionDto permissionDto = this.agreementOperate(pageDto);
        Integer minDays = 0;
        Integer maxDays = 0;
        for (CrmAgreementWarningConfig config : crmAgreementWarningConfigList) {
            if (config.getMaxDays() > maxDays) {
                maxDays = config.getMaxDays();
            }
            if (HussarUtils.isEmpty((Object)config.getMinDays()) || HussarUtils.isEmpty((Object)minDays)) {
                minDays = null;
                continue;
            }
            if (config.getMinDays() >= minDays) continue;
            minDays = config.getMinDays();
        }
        LocalDate maxDay = now.plusDays(maxDays.intValue());
        pageDto.setMaxDay(maxDay);
        if (HussarUtils.isNotEmpty((Object)minDays)) {
            LocalDate minDay = now.plusDays(minDays.intValue());
            pageDto.setMinDay(minDay);
        }
        pageDto.setPermissionDto(permissionDto);
        if (ToolUtil.isNotEmpty((Object)pageDto.getEndDateFlag()) && !"6".equals(pageDto.getEndDateFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)pageDto.getEndDateFlag())) != null) {
            pageDto.setEndDateStart(LocalDate.parse(dateConvertVo.getStartDate()));
            pageDto.setEndDateEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (HussarUtils.isNotBlank((CharSequence)pageDto.getCrmAgreementNameFullLike())) {
            pageDto.setCrmAgreementNameFullLike(CommonUtills.escapeLike((String)pageDto.getCrmAgreementNameFullLike()));
        }
        List<CrmAgreementWarningVO> crmAgreementWarningVOList = this.crmAgreementMapper.agreementWarning(pageDto, null);
        block1: for (CrmAgreementWarningVO crmAgreementWarningVO : crmAgreementWarningVOList) {
            LocalDate endDate = crmAgreementWarningVO.getEndDate();
            if (endDate == null) continue;
            long daysBetween = ChronoUnit.DAYS.between(now, endDate);
            for (CrmAgreementWarningConfig config : crmAgreementWarningConfigList) {
                boolean matched = false;
                if (config.getMinDays() == null) {
                    matched = daysBetween < 0L;
                } else {
                    boolean bl = matched = daysBetween >= (long)config.getMinDays().intValue() && daysBetween < (long)config.getMaxDays().intValue();
                }
                if (!matched) continue;
                crmAgreementWarningVO.setWarningState(config.getWarningState());
                crmAgreementWarningVO.setWarningDescription(config.getWarningDescription());
                continue block1;
            }
        }
        this.dictionaryTranslatForWarn(crmAgreementWarningVOList);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, crmAgreementWarningVOList, "\u5408\u540c\u9884\u8b66\u5217\u8868", CrmAgreementWarningVO.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    private void dictionaryTranslatForWarn(List<CrmAgreementWarningVO> crmAgreementWarningVOList) {
        Map<String, String> secureDic = this.sysDicRefService.getDicListByType("security_level").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        Map<String, String> productTypeDic = this.sysDicRefService.getDicListByType("product_type").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        crmAgreementWarningVOList.stream().forEach(one -> {
            one.setSecurityLevelLabel((String)secureDic.get(one.getSecurityLevel()) + "");
            one.setProductType((String)productTypeDic.get(one.getProductType()));
        });
    }

    private CrmAgreementPageDto crmagreementdataset1Condition(CrmAgreementPageDto dto) {
        DateConvertVo dateConvertVo;
        if (ToolUtil.isNotEmpty((Object)dto.getSignTimeFlag()) && !"6".equals(dto.getSignTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getSignTimeFlag())) != null) {
            dto.setSignStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setSignEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getOwnDepartmentId())) {
            List departments = dto.getOwnDepartmentId();
            ArrayList odpIds = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)departments) && !departments.isEmpty()) {
                for (Object longOdpId : departments) {
                    ArrayList Ids;
                    String odpId = String.valueOf(longOdpId);
                    String odpIsTemp = com.jxdinfo.crm.core.utills.CommonUtills.translateDepId((String)odpId);
                    List idsTemp = com.jxdinfo.crm.core.utills.CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                    if (idsTemp.isEmpty()) continue;
                    for (int i = 0; i < idsTemp.size(); ++i) {
                        odpIds.add(idsTemp.get(i));
                    }
                }
                dto.setOwnDepartmentId(odpIds);
            }
        }
        return dto;
    }

    @Override
    public PermissionDto agreementOperate(CrmAgreementPageDto dto) {
        PermissionDto permissionDto = new PermissionDto();
        String agreementView = dto.getAgreementView();
        if (StringUtil.isNotEmpty((Object)agreementView) && !RETURN_CODE.equals(agreementView) && !"10".equals(agreementView)) {
            permissionDto = this.agreementDataRightModuleService.getCurrentUserRolePermissions();
        }
        return permissionDto;
    }

    private void getAgreementStatus(CrmAgreement crmAgreement) {
        String specialFlag = crmAgreement.getSpecialFlag();
        Double totalAmountTax = crmAgreement.getTotalAmountTax();
        Boolean divisionFlag = false;
        if ("1".equals(specialFlag) || null != totalAmountTax && totalAmountTax > 1000.0) {
            divisionFlag = false;
        }
        if (StringUtil.isBlank((CharSequence)crmAgreement.getProcessNode())) {
            if (divisionFlag.booleanValue()) {
                crmAgreement.setProcessNode(ContractAgreementNodeEnum.AGREEMENT_DEPT_LEADER_APPOVE_ACCESS.getNode());
            } else {
                crmAgreement.setProcessNode(ContractAgreementNodeEnum.AGREEMENT_COMPANY_LEADER_APPOVE.getNode());
            }
        } else if (!divisionFlag.booleanValue() && ContractAgreementNodeEnum.AGREEMENT_APPLY.getNode().equals(crmAgreement.getProcessNode())) {
            crmAgreement.setProcessNode(ContractAgreementNodeEnum.AGREEMENT_COMPANY_LEADER_APPOVE.getNode());
        } else {
            crmAgreement.setProcessNode(Integer.valueOf(crmAgreement.getProcessNode()) + 1 + "");
        }
        if (ContractAgreementNodeEnum.AGREEMENT_FINISH.getNode().equals(crmAgreement.getProcessNode())) {
            crmAgreement.setFlowStatus(ContractAgreementStatusEnum.STATUS_CHECK_FINISHED.getStatus());
            crmAgreement.setProcessState("2");
            crmAgreement.setProcessEndTime(LocalDateTime.now());
        }
    }

    public void getProcessNodeForReject(CrmAgreement crmAgreement) {
        String specialFlag = crmAgreement.getSpecialFlag();
        Double totalAmountTax = crmAgreement.getTotalAmountTax();
        if (RETURN_CODE.equals(specialFlag) && totalAmountTax <= 1000.0 && ContractAgreementNodeEnum.AGREEMENT_COMPANY_LEADER_APPOVE.getNode().equals(crmAgreement.getProcessNode())) {
            crmAgreement.setProcessNode(ContractAgreementNodeEnum.AGREEMENT_APPLY.getNode());
        } else {
            crmAgreement.setProcessNode(Integer.valueOf(crmAgreement.getProcessNode()) - 1 + "");
        }
        if (ContractAgreementNodeEnum.AGREEMENT_APPLY.getNode().equals(crmAgreement.getProcessNode())) {
            crmAgreement.setFlowStatus(ContractAgreementStatusEnum.STATUS_REJECT_SUBMIT.getStatus());
        }
    }

    @Override
    public CrmAgreementWarningPageVO agreementWarning(CrmAgreementPageDto pageDto) {
        DateConvertVo dateConvertVo;
        CrmAgreementWarningPageVO crmAgreementWarningPageVO = new CrmAgreementWarningPageVO();
        Page pager = new Page((long)pageDto.getCurrent(), (long)pageDto.getSize());
        List<CrmAgreementWarningConfig> crmAgreementWarningConfigList = this.crmAgreementMapper.selectCrmAgreementWarningConfig(pageDto);
        if (HussarUtils.isEmpty(crmAgreementWarningConfigList)) {
            return crmAgreementWarningPageVO;
        }
        LocalDate now = LocalDate.now();
        pageDto.setAgreementView("1");
        PermissionDto permissionDto = this.agreementOperate(pageDto);
        Integer minDays = 0;
        Integer maxDays = 0;
        for (CrmAgreementWarningConfig config : crmAgreementWarningConfigList) {
            if (config.getMaxDays() > maxDays) {
                maxDays = config.getMaxDays();
            }
            if (HussarUtils.isEmpty((Object)config.getMinDays()) || HussarUtils.isEmpty((Object)minDays)) {
                minDays = null;
                continue;
            }
            if (config.getMinDays() >= minDays) continue;
            minDays = config.getMinDays();
        }
        LocalDate maxDay = now.plusDays(maxDays.intValue());
        pageDto.setMaxDay(maxDay);
        if (HussarUtils.isNotEmpty((Object)minDays)) {
            LocalDate minDay = now.plusDays(minDays.intValue());
            pageDto.setMinDay(minDay);
        }
        pageDto.setPermissionDto(permissionDto);
        if (ToolUtil.isNotEmpty((Object)pageDto.getEndDateFlag()) && !"6".equals(pageDto.getEndDateFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)pageDto.getEndDateFlag())) != null) {
            pageDto.setEndDateStart(LocalDate.parse(dateConvertVo.getStartDate()));
            pageDto.setEndDateEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (HussarUtils.isNotBlank((CharSequence)pageDto.getCrmAgreementNameFullLike())) {
            pageDto.setCrmAgreementNameFullLike(CommonUtills.escapeLike((String)pageDto.getCrmAgreementNameFullLike()));
        }
        List<CrmAgreementWarningVO> crmAgreementWarningVOList = this.crmAgreementMapper.agreementWarning(pageDto, (Page<CrmAgreementWarningVO>)pager);
        block1: for (CrmAgreementWarningVO crmAgreementWarningVO : crmAgreementWarningVOList) {
            LocalDate endDate = crmAgreementWarningVO.getEndDate();
            if (endDate == null) continue;
            long daysBetween = ChronoUnit.DAYS.between(now, endDate);
            for (CrmAgreementWarningConfig config : crmAgreementWarningConfigList) {
                boolean matched = false;
                if (config.getMinDays() == null) {
                    matched = daysBetween < 0L;
                } else {
                    boolean bl = matched = daysBetween >= (long)config.getMinDays().intValue() && daysBetween < (long)config.getMaxDays().intValue();
                }
                if (!matched) continue;
                crmAgreementWarningVO.setWarningState(config.getWarningState());
                crmAgreementWarningVO.setWarningDescription(config.getWarningDescription());
                continue block1;
            }
        }
        crmAgreementWarningPageVO.setData(crmAgreementWarningVOList);
        crmAgreementWarningPageVO.setCount(pager.getTotal());
        crmAgreementWarningPageVO.setCode(RETURN_CODE);
        return crmAgreementWarningPageVO;
    }

    @Override
    public ApiResponse updateCrmAgreement(CrmAgreement entity) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)entity.getAgreementId())) {
            Boolean numberFlag = this.checkNumber(entity.getAgreementNumber());
            if (!numberFlag.booleanValue()) {
                return ApiResponse.fail((String)(entity.getAgreementNumber() + "\u8be5\u5408\u540c\u7f16\u53f7\u5df2\u88ab\u4f7f\u7528\uff01"));
            }
            entity.setFlowStatus(ContractAgreementStatusEnum.STATUS_DRAFT.getStatus());
            this.saveBaseInfo(entity, user);
            if (null != entity.getSuffixId()) {
                entity.setAgreementId(String.valueOf(entity.getSuffixId()));
            } else {
                Long agreementId = Long.parseLong(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId());
                entity.setAgreementId(String.valueOf(agreementId));
            }
            this.save(entity);
            this.updateNumberUseFlag(entity.getAgreementNumber(), "1");
            this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.CONTRACT, Long.valueOf(entity.getAgreementId()), entity.getAgreementName(), LocalDateTime.now(), false, null);
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getId(), Long.valueOf(entity.getAgreementId()), "1", "1", LocalDateTime.now(), CrmBusinessTypeEnum.CONTRACT.getId());
        } else {
            this.fileInfoAPIService.deleteHighSecurityLevelFileInfo(Long.valueOf(entity.getAgreementId()), entity.getSecurityLevel());
            CrmAgreement oldCrmAgreement = (CrmAgreement)this.getById((Serializable)((Object)entity.getAgreementId()));
            if ("1".equals(entity.getType())) {
                if (!ContractAgreementStatusEnum.STATUS_DRAFT.getStatus().equals(oldCrmAgreement.getFlowStatus())) {
                    InstanceEngineService.deleteProcessInstanceByBusinessKey((String)String.valueOf(entity.getAgreementId()));
                }
                oldCrmAgreement.setDelFlag("1");
                this.updateById(oldCrmAgreement);
                this.updateNumberUseFlag(oldCrmAgreement.getAgreementNumber(), RETURN_CODE);
            } else if ("2".equals(entity.getType())) {
                oldCrmAgreement.setAbandonState("1");
                this.updateById(oldCrmAgreement);
            } else {
                Map map;
                Boolean numberFlag;
                if (ContractAgreementStatusEnum.STATUS_CHECK_ING.getStatus().equals(entity.getFlowStatus())) {
                    return ApiResponse.fail((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u7f16\u8f91");
                }
                if (!entity.getAgreementNumber().equals(oldCrmAgreement.getAgreementNumber()) && !(numberFlag = this.checkNumber(entity.getAgreementNumber())).booleanValue()) {
                    return ApiResponse.fail((String)(entity.getAgreementNumber() + "\u8be5\u5408\u540c\u7f16\u53f7\u5df2\u88ab\u4f7f\u7528\uff01"));
                }
                if (!oldCrmAgreement.getAgreementNumber().equals(entity.getAgreementNumber())) {
                    this.updateNumberUseFlag(oldCrmAgreement.getAgreementNumber(), RETURN_CODE);
                    this.updateNumberUseFlag(entity.getAgreementNumber(), "1");
                }
                this.updateBaseInfo(entity, user);
                this.updateById(entity);
                CrmContractNumber one = (CrmContractNumber)this.crmContractNumberService.getOne((Wrapper)new LambdaQueryWrapper().eq(CrmContractNumber::getContractNumber, (Object)oldCrmAgreement.getAgreementNumber()));
                if (one != null) {
                    oldCrmAgreement.setBidProductFlag(one.getBidProductFlag());
                    oldCrmAgreement.setAddContractFlag(one.getAddContractFlag());
                }
                if (((String)(map = DataCompareUtils.getRecordInfo((Object)oldCrmAgreement, (Object)entity)).get("changeFlag")).equals("true")) {
                    OperateRecordAPIVo trackRecord = this.operateRecordAPIService.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), (String)map.get("oldJson"), (String)map.get("newJson"), (String)map.get("changeFieldStr"));
                    trackRecord.setChangeBatch(1);
                    this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.CONTRACT, Long.valueOf(entity.getAgreementId()), entity.getAgreementName(), LocalDateTime.now(), false, null);
                }
            }
        }
        if (!"1".equals(entity.getType()) && !"2".equals(entity.getType())) {
            LambdaQueryWrapper ew0 = new LambdaQueryWrapper();
            ew0.eq(CrmAgreementProduct::getAgreementId, (Object)entity.getAgreementId());
            this.crmAgreementProductService.remove((Wrapper)ew0);
            List<CrmAgreementProduct> crmAgreementProducts = entity.getCrmAgreementProduct();
            CrmContractNumber contractNumber = (CrmContractNumber)this.crmContractNumberService.getOne((Wrapper)new LambdaQueryWrapper().eq(CrmContractNumber::getContractNumber, (Object)entity.getAgreementNumber()));
            String contractNumberId = entity.getAgreementNumber();
            if (null != contractNumber) {
                contractNumberId = contractNumber.getId();
            }
            if (null != crmAgreementProducts) {
                for (CrmAgreementProduct crmAgreementProduct : crmAgreementProducts) {
                    crmAgreementProduct.setAgreementId(Long.valueOf(entity.getAgreementId()));
                    crmAgreementProduct.setAgreementName(entity.getAgreementName());
                    crmAgreementProduct.setContractNumberId(Long.valueOf(contractNumberId));
                    if (crmAgreementProduct.getAgreementProductId() == null || this.crmAgreementProductService.getById(crmAgreementProduct.getAgreementProductId()) == null) {
                        crmAgreementProduct.setCreator(BaseSecurityUtil.getUser().getId());
                        crmAgreementProduct.setCreateTime(LocalDateTime.now());
                        crmAgreementProduct.setLastEditor(BaseSecurityUtil.getUser().getId());
                        crmAgreementProduct.setLastTime(LocalDateTime.now());
                        crmAgreementProduct.setDelFlag(RETURN_CODE);
                        continue;
                    }
                    crmAgreementProduct.setLastEditor(BaseSecurityUtil.getUser().getId());
                    crmAgreementProduct.setLastTime(LocalDateTime.now());
                }
                this.crmAgreementProductService.saveOrUpdateBatch(crmAgreementProducts);
            }
        }
        return ApiResponse.success((String)entity.getAgreementId());
    }

    @Override
    public ApiResponse agreementImport(MultipartFile file) {
        String msg = ExcelImportUtil.checkTemplate((MultipartFile)file, (String[])ExcelConstant.agreementProductStatusTitle);
        if (StringUtil.isNotBlank((CharSequence)msg)) {
            return ApiResponse.fail((String)msg);
        }
        int flag = 0;
        if (file == null) {
            flag = -1;
        }
        if (!file.getOriginalFilename().endsWith("xlsx")) {
            flag = -2;
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        AttachmentManagerModelVo attachment = null;
        AttachmentManagerModelVo suspectedAttachment = null;
        Long fileImportId = Long.valueOf(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId());
        ArrayList<Map<String, String>> failInfoList = new ArrayList<Map<String, String>>();
        int importCount = 0;
        List list = ReadLeadsExcelUtil.getExcelInfoForAgreement((MultipartFile)file);
        if (CollectionUtil.isEmpty((Collection)list)) {
            throw new BaseException("\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0a\u4f20\u5931\u8d25");
        }
        for (Map item : list) {
            StringBuffer buf = new StringBuffer();
            CrmAgreement agreement = new CrmAgreement();
            if (StringUtil.isBlank((CharSequence)((CharSequence)item.get("agreementNumber")))) {
                buf.append("\u5408\u540c\u7f16\u7801\u672a\u586b\u5199;");
            } else {
                List agreementList = this.crmAgreementMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(CrmAgreement::getAgreementNumber, item.get("agreementNumber")));
                if (CollectionUtil.isNotEmpty((Collection)agreementList)) {
                    agreement = (CrmAgreement)agreementList.get(0);
                }
                if (CollectionUtil.isEmpty((Collection)agreementList)) {
                    buf.append("\u5408\u540c\u7f16\u7801\u4e0d\u5b58\u5728;");
                } else if ("1".equals(agreement.getDelFlag())) {
                    buf.append("\u5408\u540c\u5df2\u5220\u9664;");
                } else if ("1".equals(agreement.getAbandonState())) {
                    buf.append("\u5408\u540c\u5df2\u4f5c\u5e9f;");
                } else if (!"4".equals(agreement.getFlowStatus())) {
                    buf.append("\u5408\u540c\u672a\u5ba1\u6279\u5b8c\u6210;");
                }
            }
            if (StringUtil.isBlank((CharSequence)((CharSequence)item.get("productionStatus")))) {
                buf.append("\u751f\u4ea7\u72b6\u6001\u672a\u586b\u5199;");
            } else {
                String productionStatus = this.leadsMapper.selectValueByLabel("productionStatus", (String)item.get("productionStatus"));
                if (HussarUtils.isBlank((CharSequence)productionStatus)) {
                    buf.append("\u751f\u4ea7\u72b6\u6001\u586b\u5199\u4e0d\u7b26\u5408\u8981\u6c42;");
                } else {
                    agreement.setProductionStatus(productionStatus);
                }
            }
            if (StringUtil.isNotBlank((CharSequence)buf)) {
                item.put("type", buf.toString());
                failInfoList.add(item);
                continue;
            }
            try {
                this.crmAgreementMapper.updateById(agreement);
                ++importCount;
            }
            catch (Exception e) {
                item.put("type", "\u5bfc\u5165\u5931\u8d25");
                failInfoList.add(item);
            }
        }
        FileInputStream inputStream = null;
        try {
            ApiResponse response = this.attachmentManagerService.uploadFileWithDrag(file, fileImportId);
            attachment = (AttachmentManagerModelVo)response.getData();
            if (CollectionUtil.isNotEmpty(failInfoList)) {
                File file1 = this.exportExcelPaperForAgreement(failInfoList);
                inputStream = new FileInputStream(file1);
                MockMultipartFile multipartFile = new MockMultipartFile(file1.getName(), file1.getName(), "application/octet-stream", (InputStream)inputStream);
                ApiResponse suspectedResponse = this.attachmentManagerService.uploadFileWithDrag((MultipartFile)multipartFile, null);
                suspectedAttachment = (AttachmentManagerModelVo)suspectedResponse.getData();
                file1.delete();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        FileImport fileImport = new FileImport();
        String sourceFileName = attachment.getFileName();
        String finishMessage = "";
        if (flag >= 0) {
            fileImport.setSuccessFail("1");
            finishMessage = importCount != list.size() ? "\u5bfc\u5165\u6210\u529f" + importCount + "\u6761\uff0c\u672a\u5bfc\u5165" + (list.size() - importCount) + "\u6761\u6570\u636e\u3002" : "\u5bfc\u5165\u6210\u529f" + importCount + "\u6761\u3002";
        } else {
            fileImport.setSuccessFail(RETURN_CODE);
            if (flag == -1) {
                finishMessage = "\u5bfc\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728";
            } else if (flag == -2) {
                finishMessage = "\u8bf7\u4e0a\u4f20\u6307\u5b9a\u683c\u5f0f\u6587\u4ef6";
            } else if (flag == -3) {
                finishMessage = "\u4e0a\u4f20\u5931\u8d25";
            }
        }
        fileImport.setFileImportId(fileImportId);
        Long sourceFileId = attachment.getId();
        fileImport.setSourceFileId(sourceFileId);
        fileImport.setSourceFileName(sourceFileName);
        fileImport.setImportResult(finishMessage);
        fileImport.setModuleId("productionStatus");
        if (CollectionUtil.isNotEmpty(failInfoList)) {
            Long suspectedFileId = suspectedAttachment.getId();
            fileImport.setSuspectedFileId(suspectedFileId);
            fileImport.setSuspectedFileName(suspectedAttachment.getFileName());
        }
        fileImport.setCreateTime(date);
        fileImport.setCreator(userId);
        fileImport.setCreatorName(userName);
        fileImport.setLastTime(date);
        fileImport.setLastEditor(userId);
        fileImport.setLastEditorName(userName);
        fileImport.setDelFlag(RETURN_CODE);
        this.fileImportService.save((Object)fileImport);
        return ApiResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File exportExcelPaperForAgreement(List<Map<String, String>> failInfoList) {
        String[] title = ExcelConstant.agreementProductStatusFailTitle;
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        CrmAgreementServiceImpl.setColumnWidth(sheet, 8);
        int lastColumnIndex = title.length - 1;
        sheet.setColumnWidth(lastColumnIndex, 15360);
        XSSFRow row = sheet.createRow(0);
        XSSFCell cell = null;
        for (int i = 0; i < title.length; ++i) {
            cell = row.createCell(i);
            XSSFCellStyle cellStyle = workbook.createCellStyle();
            XSSFFont font = workbook.createFont();
            font.setFontName("\u5b8b\u4f53");
            font.setFontHeightInPoints((short)13);
            cellStyle.setFont((Font)font);
            cell.setCellStyle((CellStyle)cellStyle);
            cell.setCellValue(title[i]);
        }
        System.out.println(failInfoList);
        XSSFCellStyle dataCellStyle = workbook.createCellStyle();
        dataCellStyle.setWrapText(true);
        dataCellStyle.setAlignment(HorizontalAlignment.LEFT);
        XSSFCellStyle normalDataStyle = workbook.createCellStyle();
        normalDataStyle.setAlignment(HorizontalAlignment.LEFT);
        for (int i = 0; i < failInfoList.size(); ++i) {
            XSSFRow nextRow = sheet.createRow(i + 1);
            for (int j = 0; j < title.length; ++j) {
                Map<String, String> item = failInfoList.get(i);
                XSSFCell cell2 = nextRow.createCell(j);
                if (j == 0) {
                    cell2.setCellValue(item.get("agreementNumber"));
                    cell2.setCellStyle((CellStyle)normalDataStyle);
                }
                if (j == 1) {
                    cell2.setCellValue(item.get("productionStatus"));
                    cell2.setCellStyle((CellStyle)normalDataStyle);
                }
                if (j != 2) continue;
                cell2.setCellValue(item.get("type"));
                cell2.setCellStyle((CellStyle)dataCellStyle);
            }
        }
        LocalDateTime dateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
        String dateStr = dateTime.format(formatter);
        File file = new File("\u5408\u540c\u751f\u4ea7\u72b6\u6001\u7684\u672a\u5bfc\u5165\u4fe1\u606f_" + dateStr + ".xlsx");
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            workbook.write((OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return file;
    }

    private static void setColumnWidth(XSSFSheet sheet, int colNum) {
        for (int i = 0; i < colNum; ++i) {
            int v = 0;
            v = Math.round(Float.parseFloat("15.0") * 37.0f);
            v = Math.round(Float.parseFloat("20.0") * 267.5f);
            sheet.setColumnWidth(i, v);
        }
    }

    @Override
    public void agreementImportTemplate(HttpServletResponse response) {
        try {
            XSSFWorkbook leads = new XSSFWorkbook();
            XSSFSheet sheet = leads.createSheet("\u5408\u540c\u751f\u4ea7\u72b6\u6001\u5bfc\u5165\u6a21\u677f");
            XSSFCellStyle style = leads.createCellStyle();
            Row row = sheet.createRow(0);
            String[] colsName = ExcelConstant.agreementProductStatusTitle;
            List<String> cols = Arrays.asList(colsName);
            int j = cols.size();
            for (int i = 0; i < j; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle((CellStyle)style);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(cols.get(i));
                int columnWidth = sheet.getColumnWidth(i) / 256 + 10;
                int length = cols.get(i).getBytes("UTF-8").length + 1;
                if (columnWidth < length + 1) {
                    columnWidth = length + 1;
                }
                sheet.setColumnWidth(i, columnWidth * 256);
            }
            response.reset();
            String fileName = "\u5408\u540c\u751f\u4ea7\u72b6\u6001\u5bfc\u5165\u6a21\u677f";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes(), "iso-8859-1") + ".xlsx");
            leads.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new BaseException("\u6a21\u677f\u5bfc\u51fa\u5931\u8d25!" + e.getMessage());
        }
    }

    public void saveBaseInfo(CrmAgreement crmAgreement, SecurityUser user) {
        crmAgreement.setChargePerson(user.getId().toString());
        crmAgreement.setChargePersonName(user.getUserName());
        crmAgreement.setOwnDepartment(user.getDeptId().toString());
        crmAgreement.setOwnDepartmentName(user.getDeptName());
        SysStru companyInfo = this.struUserAPIService.getCompanyInfoByCurrentDeptId(user.getDeptId().toString());
        crmAgreement.setOwnUnit(companyInfo.getId().toString());
        crmAgreement.setOwnUnitName(companyInfo.getOrganAlias());
        crmAgreement.setCreator(user.getUserId().toString());
        crmAgreement.setCreatorName(user.getUserName());
        crmAgreement.setCreateTime(LocalDateTime.now());
        crmAgreement.setCreateDepartment(user.getDeptId().toString());
        crmAgreement.setCreateDepartmentName(user.getDeptName());
    }

    private void updateBaseInfo(CrmAgreement entity, SecurityUser user) {
        entity.setLastEditorName(user.getUserName());
        entity.setLastTime(LocalDateTime.now());
        entity.setLastEditor(user.getId().toString());
    }

    private Boolean checkNumber(String agreementNumber) {
        CrmContractNumber one = (CrmContractNumber)this.crmContractNumberService.getOne((Wrapper)new LambdaUpdateWrapper().eq(CrmContractNumber::getContractNumber, (Object)agreementNumber));
        if (null != one && "1".equals(one.getIsUseFlag())) {
            return false;
        }
        return true;
    }

    public void updateNumberUseFlag(String number, String useFlag) {
        this.crmContractNumberService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmContractNumber::getContractNumber, (Object)number)).set(CrmContractNumber::getIsUseFlag, (Object)useFlag));
    }

    @Override
    public CrmAgreement downloadAgreement(String agreementId) {
        CrmAgreement agreement = (CrmAgreement)this.getById((Serializable)((Object)agreementId));
        this.transDataToStr(agreement);
        List productList = this.crmAgreementProductService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmAgreementProduct::getAgreementId, (Object)Long.valueOf(agreementId))).eq(CrmAgreementProduct::getDelFlag, (Object)RETURN_CODE));
        agreement.setCrmAgreementProduct(productList);
        JSONArray list = InstanceEngineService.queryCompleteComment((String)agreementId, null).getResult();
        if (null != list && list.size() > 0) {
            List<JSONObject> processList = list.stream().filter(obj -> {
                JSONObject jsonObj = (JSONObject)obj;
                return !ContractAgreementNodeEnum.AGREEMENT_START.getBpmNodeKey().equals(jsonObj.getString("taskDefinitionKey")) && !ContractAgreementNodeEnum.AGREEMENT_APPLY.getBpmNodeKey().equals(jsonObj.getString("taskDefinitionKey")) && !ContractAgreementNodeEnum.AGREEMENT_UPLOAD_FILE_ACCESS.getBpmNodeKey().equals(jsonObj.getString("taskDefinitionKey")) && !ContractAgreementNodeEnum.AGREEMENT_FINISH.getBpmNodeKey().equals(jsonObj.getString("taskDefinitionKey"));
            }).collect(Collectors.groupingBy(obj -> ((JSONObject)obj).getString("taskDefinitionKey"), Collectors.collectingAndThen(Collectors.maxBy(Comparator.comparing(obj -> {
                JSONObject jsonObj = (JSONObject)obj;
                return jsonObj.getDate("endTime");
            })), optional -> optional.orElse(null)))).values().stream().filter(obj -> obj != null).sorted(Comparator.comparing(obj -> ((JSONObject)obj).getDate("start"))).map(obj -> (JSONObject)obj).collect(Collectors.toList());
            agreement.setProcessList(processList);
        }
        this.translateDict(agreement);
        return agreement;
    }

    private void transDataToStr(CrmAgreement agreement) {
        String signDateStr = agreement.getSignDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String endDateStr = agreement.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String createTimeStr = agreement.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        agreement.setSignDateStr(signDateStr);
        agreement.setEndDateStr(endDateStr);
        agreement.setCreateTimeStr(createTimeStr);
    }

    private void translateDict(CrmAgreement agreement) {
        Map<String, String> yesNoDict = this.sysDicRefService.getDicListByType("yes_no").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel, (oldValue, newValue) -> oldValue));
        Map<String, String> priceMethodDic = this.sysDicRefService.getDicListByType("price_method").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel, (oldValue, newValue) -> oldValue));
        agreement.setIfMilitaryInspection(yesNoDict.get(agreement.getIfMilitaryInspection()));
        agreement.setFormalAgreementFlag(yesNoDict.get(agreement.getFormalAgreementFlag()));
        if (null != priceMethodDic) {
            agreement.setPriceMethod(priceMethodDic.get(agreement.getPriceMethod()));
        }
        if (null != agreement.getCrmAgreementProduct() && agreement.getCrmAgreementProduct().size() > 0) {
            Map<String, String> unitDict = this.sysDicRefService.getDicListByType("sale_unit").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel, (oldValue, newValue) -> oldValue));
            agreement.getCrmAgreementProduct().stream().forEach(one -> one.setProductUnit((String)unitDict.get(one.getProductUnit())));
        }
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(CrmAgreementAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getCrmAgreementNameFullLike();
        }
        ICrmAgreementAssociativeQueryService adapterService = this.crmAgreementAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("crmAgreementNameFullLike");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(Boolean.valueOf(false));
        return this.associativeQueryService.associativeQuery((AssociativeQueryDto)dto, keyWord, queryScreening, (IAssociativeQueryAdapterService)adapterService, associativeKeyword);
    }

    @Override
    public List<Map<String, String>> statisticsByMonth() {
        CrmAgreementPageDto pageDto = new CrmAgreementPageDto();
        pageDto.setAgreementView("1");
        PermissionDto permissionDto = this.agreementOperate(pageDto);
        pageDto.setPermissionDto(permissionDto);
        List<Map<String, String>> list = this.crmAgreementMapper.statisticsByMonth(pageDto);
        return list;
    }

    @Override
    public List<CrmAgreement> currentAgreement() {
        CrmAgreementPageDto pageDto = new CrmAgreementPageDto();
        pageDto.setAgreementView("1");
        PermissionDto permissionDto = this.agreementOperate(pageDto);
        pageDto.setPermissionDto(permissionDto);
        return this.crmAgreementMapper.currentAgreement(pageDto);
    }

    @Override
    public List<Map<String, String>> statisticsByCategory() {
        CrmAgreementPageDto pageDto = new CrmAgreementPageDto();
        pageDto.setAgreementView("1");
        PermissionDto permissionDto = this.agreementOperate(pageDto);
        pageDto.setPermissionDto(permissionDto);
        List<Map<String, String>> list = this.crmAgreementMapper.statisticsByCategory(pageDto);
        if (list.size() > 0) {
            Map<String, String> productModelDic = this.sysDicRefService.getDicListByType("military_contracts_type").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
            list.stream().forEach(one -> {
                String label = (String)productModelDic.get(one.get("agreementCategory"));
                if (StringUtil.isNotBlank((CharSequence)label)) {
                    one.put("agreementCategory", label);
                }
            });
        }
        return list;
    }

    @Override
    public CrmAgreementPageVo selectAgreementForPlan(CrmAgreementPageDto dto) {
        dto.setQueryType("planDown");
        dto.setAbandonState(RETURN_CODE);
        ApiResponse<CrmAgreementPageVo> res = this.listPageNew(dto);
        if (res.getCode() == 10000) {
            CrmAgreementPageVo data = (CrmAgreementPageVo)res.getData();
            if (null != data && data.getData().size() > 0) {
                Map<String, String> securityLevelDic = this.sysDicRefService.getDictByType("security_level").stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
                data.getData().stream().forEach(one -> one.setSecurityLevelLabel((String)securityLevelDic.get(one.getSecurityLevel() + "")));
            }
            return data;
        }
        return null;
    }

    @Override
    public ApiResponse transferChargePerson(CrmAgreementCrmagreementdataset1 dto) {
        if (dto.getOldChargePersonId().equals(dto.getNewChargePersonId())) {
            return ApiResponse.fail((String)"\u8f6c\u79fb\u7684\u8d1f\u8d23\u4eba\u4e3a\u5f53\u524d\u8d1f\u8d23\u4eba\uff01");
        }
        CrmAgreement agreement = (CrmAgreement)this.getById((Serializable)((Object)dto.getAgreementId()));
        if (null == agreement) {
            return ApiResponse.fail((String)"\u64cd\u4f5c\u6709\u8bef\uff01");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        String newChargePersonId = dto.getNewChargePersonId();
        String newChargePersonName = dto.getNewChargePersonName();
        SysStru companyInfo = this.struUserAPIService.getCompanyInfoByUserId(newChargePersonId);
        PersonWithDepInfo mapDepartment = com.jxdinfo.crm.core.utills.CommonUtills.selectDepIdName((String)newChargePersonId);
        Long newOwnDepartment = mapDepartment.getDepartmentId();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String ownUnit = companyInfo.getId() + "";
        String ownUnitName = companyInfo.getOrganAlias();
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmAgreement::getAgreementId, (Object)dto.getAgreementId())).set(CrmAgreement::getChargePerson, (Object)newChargePersonId)).set(CrmAgreement::getChargePersonName, (Object)newChargePersonName)).set(CrmAgreement::getOwnDepartment, (Object)newOwnDepartment)).set(CrmAgreement::getOwnDepartmentName, (Object)newOwnDepartmentName)).set(CrmAgreement::getOwnUnit, (Object)ownUnit)).set(CrmAgreement::getOwnUnitName, (Object)ownUnitName));
        if ("true".equals(dto.getKeepFlag())) {
            this.teamMeberService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TeamMeberEntity::getBusinessId, (Object)dto.getAgreementId())).eq(TeamMeberEntity::getIsCharge, (Object)"1")).eq(TeamMeberEntity::getDelFlag, (Object)RETURN_CODE)).eq(TeamMeberEntity::getPersonId, (Object)dto.getOldChargePersonId())).set(TeamMeberEntity::getIsCharge, (Object)RETURN_CODE)).set(TeamMeberEntity::getState, (Object)"2"));
        } else {
            this.teamMeberService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TeamMeberEntity::getBusinessId, (Object)dto.getAgreementId())).eq(TeamMeberEntity::getPersonId, (Object)dto.getOldChargePersonId())).eq(TeamMeberEntity::getIsCharge, (Object)"1")).set(TeamMeberEntity::getDelFlag, (Object)"1"));
        }
        TeamMeberEntity one = (TeamMeberEntity)this.teamMeberService.getOne((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TeamMeberEntity::getBusinessId, (Object)dto.getAgreementId())).eq(TeamMeberEntity::getDelFlag, (Object)RETURN_CODE)).eq(TeamMeberEntity::getPersonId, (Object)dto.getNewChargePersonId()));
        if (null == one) {
            this.teamMeberService.insertTeamMember(newChargePersonName, Long.valueOf(newChargePersonId), Long.valueOf(dto.getAgreementId()), "1", "1", LocalDateTime.now(), CrmBusinessTypeEnum.CONTRACT.getId());
        } else {
            try {
                InstanceEngineService.deleteProcessInstanceByBusinessKey((String)String.valueOf(one.getTeamMeberId()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            one.setIsCharge("1");
            one.setState("2");
            this.teamMeberService.updateById((Object)one);
        }
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setContactId(Long.valueOf(newChargePersonId));
        operateRecordDO.setContactName(newChargePersonName);
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
        operateRecordDO.setOldContactId(Long.valueOf(dto.getOldChargePersonId()));
        operateRecordDO.setOldContactName(dto.getOldChargePersonName());
        operateRecordDO.setRecordId(Long.valueOf(com.jxdinfo.crm.core.utills.CommonUtills.generateAssignId()));
        operateRecordDO.setBusinessType(CrmBusinessTypeEnum.CONTRACT.getId());
        operateRecordDO.setTypeId(Long.valueOf(dto.getAgreementId()));
        operateRecordDO.setBusinessName(agreement.getAgreementName());
        operateRecordDO.setCreatePerson(user.getUserId());
        operateRecordDO.setCreatePersonName(user.getUserName());
        operateRecordDO.setCreateTime(LocalDateTime.now());
        operateRecordDO.setChangePerson(user.getUserId());
        operateRecordDO.setChangeTime(LocalDateTime.now());
        operateRecordDO.setChangePersonName(user.getUserName());
        operateRecordDO.setDelflag(RETURN_CODE);
        this.operateRecordAPIService.saveOperateLogForTransfer(operateRecordDO);
        return ApiResponse.success();
    }
}

