/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.contract.crmagreement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.organUser.IStruUserAPIService;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.chanpinguanli.datasourcefolder.crmproduct1.service.CrmProduct1Service;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmcustomer1.model.CrmCustomer1;
import com.jxdinfo.crm.core.crm.datasourcefolder.customer.crmcustomer1.service.CrmCustomer1Service;
import com.jxdinfo.crm.core.fileinfo.model.FileImport;
import com.jxdinfo.crm.core.fileinfo.service.FileImportService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.ExcelImportUtil;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.transaction.constants.CommonHtConstant;
import com.jxdinfo.crm.transaction.constants.ContractAgreementStatusEnum;
import com.jxdinfo.crm.transaction.constants.ExcelConstant;
import com.jxdinfo.crm.transaction.contract.crmagreement.dao.CrmAgreementMapper;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementDto;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementPageDto;
import com.jxdinfo.crm.transaction.contract.crmagreement.model.CrmAgreement;
import com.jxdinfo.crm.transaction.contract.crmagreement.service.CrmAgreementImportAndExportService;
import com.jxdinfo.crm.transaction.contract.crmagreement.service.CrmAgreementService;
import com.jxdinfo.crm.transaction.contract.crmagreement.vo.CrmAgreementPageVo;
import com.jxdinfo.crm.transaction.contract.crmagreement.vo.CrmAgreementVO;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.model.CrmContractNumber;
import com.jxdinfo.crm.transaction.contract.crmcontractnumber.service.CrmContractNumberService;
import com.jxdinfo.crm.transaction.contract.crmfieldmanagerelation.service.CrmFieldManageRelationService;
import com.jxdinfo.crm.transaction.modelmanage.crmmodelmanage.model.CrmModelManage;
import com.jxdinfo.crm.transaction.modelmanage.crmmodelmanage.service.CrmModelManageService;
import com.jxdinfo.crm.transaction.operationsmanage.contract.crmagreement.model.CrmAgreementProduct;
import com.jxdinfo.crm.transaction.operationsmanage.contract.crmagreement.service.CrmAgreementProductService;
import com.jxdinfo.crm.transaction.utils.InitUnitDataUtill;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CrmAgreementImportAndExportImpl
extends ServiceImpl<CrmAgreementMapper, CrmAgreement>
implements CrmAgreementImportAndExportService {
    private static int totalRows = 0;
    private static int totalCells = 0;
    private static String errorMsg;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Autowired
    private CrmAgreementMapper crmAgreementMapper;
    @Resource
    private FileImportService fileImportService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private CrmAgreementService crmAgreementService;
    @Resource
    private CrmFieldManageRelationService fieldManageRelationService;
    @Resource
    private CrmProduct1Service productService;
    @Autowired
    private CrmModelManageService modelManageService;
    @Resource
    private CrmAgreementProductService agreementProductService;
    @Resource
    private CrmContractNumberService numberService;
    @Resource
    private CrmCustomer1Service customerService;
    @Resource
    private IStruUserAPIService struUserAPIService;
    @Resource
    private CrmAgreementService agreementService;
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";

    private int agreementJudgeData(List<CrmAgreement> list, List<CrmAgreement> backupList, List<CrmAgreement> failList, int importCount) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        Long deptId = user.getDeptId();
        String deptName = user.getDeptName();
        for (int j = 0; j < list.size(); ++j) {
            String msg;
            StringBuffer buf = new StringBuffer();
            CrmAgreement one = list.get(j);
            CrmAgreement backUpOne = backupList.get(j);
            String numberId = "";
            String productType = "";
            Boolean addproductFlag = false;
            String modelManageId = "";
            String modelManageName = "";
            this.baseInfoFill(one, user, userId, userName, deptId, deptName);
            Boolean bpmFlag = false;
            if (StringUtil.isBlank((CharSequence)one.getAgreementNumber())) {
                buf.append("\u5408\u540c\u7f16\u7801\u672a\u586b\u5199;");
            } else {
                List numberAgreementList = this.crmAgreementService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmAgreement::getAgreementNumber, (Object)one.getAgreementNumber())).eq(CrmAgreement::getDelFlag, (Object)RETURN_CODE));
                if (numberAgreementList.size() > 0) {
                    String msg2 = this.checkNotInfo((CrmAgreement)numberAgreementList.get(0), one);
                    if (StringUtil.isNotBlank((CharSequence)msg2)) {
                        buf.append("\u5408\u540c\u7f16\u7801\u5b58\u5728\u65f6\uff1a" + msg2);
                    }
                    if (!ContractAgreementStatusEnum.STATUS_CHECK_FINISHED.getStatus().equals(((CrmAgreement)numberAgreementList.get(0)).getFlowStatus())) {
                        if (StringUtil.isNotBlank((CharSequence)msg2)) {
                            buf.append("\u5408\u540c\u672a\u5ba1\u6838\u901a\u8fc7;");
                        } else {
                            buf.append("\u5408\u540c\u7f16\u7801\u5b58\u5728\u65f6\uff1a\u5408\u540c\u672a\u5ba1\u6838\u901a\u8fc7;");
                        }
                        backUpOne.setType(buf.toString());
                        failList.add(backUpOne);
                        continue;
                    }
                    if (StringUtil.isNotBlank((CharSequence)buf)) {
                        backUpOne.setType(buf.toString());
                        failList.add(backUpOne);
                        continue;
                    }
                    try {
                        this.updateById(numberAgreementList.get(0));
                        ++importCount;
                    }
                    catch (Exception e) {
                        buf.append("\u975e\u5fc5\u586b\u4fe1\u606f\u66f4\u65b0\u5931\u8d25;");
                        backUpOne.setType(buf.toString());
                        failList.add(backUpOne);
                    }
                    continue;
                }
                bpmFlag = true;
                List numberList = this.numberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmContractNumber::getDelFlag, (Object)RETURN_CODE)).eq(CrmContractNumber::getIsUseFlag, (Object)RETURN_CODE)).eq(CrmContractNumber::getContractNumber, (Object)one.getAgreementNumber()));
                if (numberList.size() > 0) {
                    numberId = ((CrmContractNumber)numberList.get(0)).getId();
                }
            }
            if (StringUtil.isBlank((CharSequence)one.getAgreementName())) {
                buf.append("\u5408\u540c\u540d\u79f0\u672a\u586b\u5199;");
            }
            if (StringUtil.isBlank((CharSequence)one.getCustomerName())) {
                buf.append("\u5ba2\u6237\u540d\u79f0\u672a\u586b\u5199;");
            } else {
                List customerList = this.customerService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmCustomer1::getDelFlag, (Object)RETURN_CODE)).eq(CrmCustomer1::getCustomerName, (Object)one.getCustomerName()));
                if (customerList.size() == 0) {
                    buf.append("\u5ba2\u6237\u4e0d\u5b58\u5728;");
                } else {
                    one.setCustomerId(((CrmCustomer1)customerList.get(0)).getCustomerId() + "");
                }
            }
            if (StringUtil.isBlank((CharSequence)one.getProductType())) {
                buf.append("\u4ea7\u54c1\u7c7b\u578b\u672a\u586b\u5199;");
            } else if (one.getProductType().contains("-1")) {
                buf.append("\u4ea7\u54c1\u7c7b\u578b\u586b\u5199\u6709\u8bef;");
            } else {
                productType = one.getProductType();
            }
            if (StringUtil.isBlank((CharSequence)one.getSpecialFlag())) {
                buf.append("\u662f\u5426\u4e13\u9879\u9879\u76ee\u672a\u586b\u5199;");
            } else if (one.getSpecialFlag().contains("-1")) {
                buf.append("\u662f\u5426\u4e13\u9879\u9879\u76ee\u586b\u5199\u6709\u8bef;");
            }
            if (null == one.getTotalAmountTax()) {
                buf.append("\u5408\u540c\u91d1\u989d\u672a\u586b\u5199;");
            } else if (Double.compare(one.getTotalAmountTax(), -1.0) == 0) {
                buf.append("\u5408\u540c\u91d1\u989d\u586b\u5199\u683c\u5f0f\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getAddContractFlag())) {
                buf.append("\u662f\u5426\u589e\u8865\u5408\u540c\u672a\u586b\u5199;");
            } else if (one.getAddContractFlag().contains("-1")) {
                buf.append("\u662f\u5426\u589e\u8865\u5408\u540c\u586b\u5199\u6709\u8bef;");
            } else if ("1".equals(one.getAddContractFlag())) {
                if (StringUtil.isBlank((CharSequence)one.getMasterContractNumber())) {
                    buf.append("\u5f53\u4e3a\u589e\u8865\u5408\u540c\u65f6\uff0c\u4e3b\u5408\u540c\u7f16\u53f7\u672a\u586b\u5199;");
                } else {
                    List numberList = this.crmAgreementService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmAgreement::getAgreementNumber, (Object)one.getMasterContractNumber())).eq(CrmAgreement::getDelFlag, (Object)RETURN_CODE));
                    if (numberList.size() == 0) {
                        buf.append("\u5f53\u4e3a\u589e\u8865\u5408\u540c\u65f6\uff0c\u4e3b\u5408\u540c\u7f16\u53f7\u4e0d\u5b58\u5728;");
                    } else {
                        one.setMasterContractId(((CrmAgreement)numberList.get(0)).getAgreementId());
                        one.setMasterContractName(((CrmAgreement)numberList.get(0)).getAgreementName());
                    }
                }
            }
            if (StringUtil.isBlank((CharSequence)one.getAgreementType())) {
                buf.append("\u5408\u540c\u7c7b\u578b\u672a\u586b\u5199;");
            } else if (one.getAgreementType().contains("-1")) {
                buf.append("\u5408\u540c\u7c7b\u578b\u586b\u5199\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getIfDutyProject())) {
                buf.append("\u662f\u5426\u8d23\u4efb\u4ee4\u9879\u76ee\u672a\u586b\u5199;");
            } else if (one.getIfDutyProject().contains("-1")) {
                buf.append("\u662f\u5426\u8d23\u4efb\u4ee4\u9879\u76ee\u586b\u5199\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getProductModel())) {
                buf.append("\u578b\u53f7\u672a\u586b\u5199;");
            } else {
                CrmModelManage modelOne = (CrmModelManage)this.modelManageService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmModelManage::getModelName, (Object)one.getProductModel())).eq(CrmModelManage::getDelFlag, (Object)RETURN_CODE));
                if (null == modelOne) {
                    buf.append("\u8be5\u3010" + one.getProductModel() + "\u3011\u578b\u53f7\u5728\u578b\u53f7\u7ba1\u7406\u4e2d\u4e0d\u5b58\u5728;");
                } else {
                    one.setModelId(modelOne.getBusinessId());
                    modelManageId = modelOne.getModelManageId();
                    modelManageName = modelOne.getModelManageName();
                }
            }
            if (null == one.getEndDate()) {
                buf.append("\u5408\u540c\u4ea4\u4ed8\u65e5\u671f\u672a\u586b\u5199;");
            } else if (one.getEndDate().equals(CommonHtConstant.INVALID_DATETIME)) {
                buf.append("\u5408\u540c\u4ea4\u4ed8\u65e5\u671f\u586b\u5199\u683c\u5f0f\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getAgreementCategory())) {
                buf.append("\u9879\u76ee\u7c7b\u578b\u672a\u586b\u5199;");
            } else if (one.getAgreementCategory().contains("-1")) {
                buf.append("\u9879\u76ee\u7c7b\u578b\u586b\u5199\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getIfMilitaryInspection())) {
                buf.append("\u662f\u5426\u519b\u68c0\u672a\u586b\u5199;");
            } else if (one.getIfMilitaryInspection().contains("-1")) {
                buf.append("\u662f\u5426\u519b\u68c0\u586b\u5199\u6709\u8bef;");
            } else if ("1".equals(one.getIfMilitaryInspection()) && StringUtil.isNotBlank((CharSequence)(msg = this.checkSupervisionInfo(one, one)))) {
                buf.append(msg);
            }
            if (StringUtil.isBlank((CharSequence)one.getArea())) {
                buf.append("\u9886\u57df\u672a\u586b\u5199;");
            } else if (one.getArea().contains("-1")) {
                buf.append("\u9886\u57df\u586b\u5199\u6709\u8bef;");
            }
            if (null != one.getIfFourteenFiveProject() && one.getIfFourteenFiveProject().contains("-1")) {
                buf.append("\u662f\u5426\u5341\u56db\u4e94\u653b\u575a\u6218\u9879\u76ee\u586b\u5199\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getProductionStatus())) {
                buf.append("\u751f\u4ea7\u72b6\u6001\u672a\u586b\u5199;");
            } else if (one.getProductionStatus().contains("-1")) {
                buf.append("\u751f\u4ea7\u72b6\u6001\u586b\u5199\u6709\u8bef;");
            }
            if ("1".equals(productType) || "2".equals(productType)) {
                this.checkInfoByProductType(true, buf, one, modelManageId, modelManageName);
            } else {
                this.checkInfoByProductType(false, buf, one, modelManageId, modelManageName);
            }
            ArrayList<CrmAgreementProduct> addProduct = new ArrayList<CrmAgreementProduct>();
            if (StringUtil.isNotBlank((CharSequence)one.getProductNames()) || StringUtil.isNotBlank((CharSequence)one.getProductAmounts()) || StringUtil.isNotBlank((CharSequence)one.getProductUnits())) {
                if (StringUtil.isBlank((CharSequence)one.getProductNames()) || StringUtil.isBlank((CharSequence)one.getProductAmounts()) || StringUtil.isBlank((CharSequence)one.getProductUnits())) {
                    buf.append("\u4ea7\u54c1\u540d\u79f0\u3001\u6570\u91cf\u3001\u8ba1\u91cf\u5355\u4f4d\u6709\u6f0f\u586b\u4fe1\u606f;");
                } else if (one.getProductNames().split("/").length == one.getProductAmounts().split("/").length && one.getProductAmounts().split("/").length == one.getProductUnits().split("/").length) {
                    String[] nameArr = one.getProductNames().split("/");
                    String[] amountArr = one.getProductAmounts().split("/");
                    String[] unitArr = one.getProductUnits().split("/");
                    Boolean productAmountFlag = true;
                    Boolean productUnitFlag = true;
                    Map<String, String> saleUnitDic = this.sysDicRefService.getDicListByType("sale_unit").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
                    for (int i = 0; i < nameArr.length; ++i) {
                        CrmAgreementProduct oneProduct2 = new CrmAgreementProduct();
                        oneProduct2.setCreateTime(LocalDateTime.now());
                        oneProduct2.setCreator(userId);
                        oneProduct2.setCreatorName(userName);
                        oneProduct2.setCreateDepartment(deptId);
                        oneProduct2.setCreateDepartmentName(deptName);
                        oneProduct2.setProductName(nameArr[i]);
                        String s = saleUnitDic.get(unitArr[i]);
                        if (StringUtil.isBlank((CharSequence)s)) {
                            productUnitFlag = false;
                            break;
                        }
                        oneProduct2.setProductUnit(s);
                        try {
                            String amountStr = amountArr[i];
                            Double v = Double.valueOf(amountStr);
                            oneProduct2.setAmount(v);
                        }
                        catch (Exception e) {
                            productAmountFlag = false;
                            break;
                        }
                        addProduct.add(oneProduct2);
                    }
                    if (!productAmountFlag.booleanValue()) {
                        buf.append("\u4ea7\u54c1\u6570\u91cf\u683c\u5f0f\u4e66\u5199\u6709\u8bef;");
                    }
                    if (!productUnitFlag.booleanValue()) {
                        buf.append("\u4ea7\u54c1\u8ba1\u91cf\u5355\u4f4d\u586b\u5199\u6709\u8bef;");
                    }
                } else {
                    buf.append("\u4ea7\u54c1\u540d\u79f0\u3001\u6570\u91cf\u3001\u8ba1\u91cf\u5355\u4f4d\u6570\u91cf\u9700\u76f8\u540c;");
                }
            }
            if (StringUtil.isBlank((CharSequence)one.getSecurityLevelLabel())) {
                buf.append("\u5408\u540c\u5bc6\u7ea7\u672a\u586b\u5199;");
            } else if (one.getSecurityLevelLabel().contains("-1")) {
                buf.append("\u5408\u540c\u5bc6\u7ea7\u586b\u5199\u6709\u8bef;");
            } else {
                one.setSecurityLevel(Integer.valueOf(one.getSecurityLevelLabel()));
            }
            if (StringUtil.isNotBlank((CharSequence)buf)) {
                backUpOne.setType(buf.toString());
                failList.add(backUpOne);
                continue;
            }
            try {
                this.crmAgreementService.save(one);
                ++importCount;
                if (addproductFlag.booleanValue() && addProduct.size() > 0) {
                    addProduct.stream().forEach(oneProduct -> {
                        oneProduct.setAgreementId(Long.valueOf(one.getAgreementId()));
                        oneProduct.setAgreementName(one.getAgreementName());
                        this.agreementProductService.save(oneProduct);
                    });
                }
                if (StringUtil.isNotBlank((CharSequence)numberId)) {
                    this.numberService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(CrmContractNumber::getId, (Object)numberId)).set(CrmContractNumber::getIsUseFlag, (Object)"1"));
                }
                if (!bpmFlag.booleanValue()) continue;
                CrmAgreementDto crmAgreementDto = new CrmAgreementDto();
                crmAgreementDto.setProcessDefinitionKey("bpm_ht_manage");
                crmAgreementDto.setFormdata(one);
                this.agreementService.formsubmit(crmAgreementDto, String.valueOf(one.getAgreementId()));
                continue;
            }
            catch (Exception e) {
                backUpOne.setType("\u5bfc\u5165\u5931\u8d25");
                failList.add(backUpOne);
            }
        }
        return importCount;
    }

    public void checkInfoByProductType(Boolean checkMustFillFlag, StringBuffer buf, CrmAgreement one, String modelManageId, String modelManageName) {
        if (checkMustFillFlag.booleanValue()) {
            if (StringUtil.isBlank((CharSequence)one.getIfAppraisal())) {
                buf.append("\u8be5\u8239\u4ea7\u54c1\u662f\u5426\u7ecf\u8fc7\u9274\u5b9a\u672a\u586b\u5199;");
            } else if (one.getIfAppraisal().contains("-1")) {
                buf.append("\u8be5\u8239\u4ea7\u54c1\u662f\u5426\u7ecf\u8fc7\u9274\u5b9a\u586b\u5199\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getIfNewProduct())) {
                buf.append("\u662f\u5426\u65b0\u4ea7\u54c1\u672a\u586b\u5199;");
            } else if (one.getIfNewProduct().contains("-1")) {
                buf.append("\u662f\u5426\u65b0\u4ea7\u54c1\u586b\u5199\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getaContractNumber())) {
                buf.append("\u7532\u65b9\u5408\u540c\u7f16\u53f7\u672a\u586b\u5199;");
            }
            if (null == one.getSignDate()) {
                buf.append("\u7b7e\u8ba2\u65e5\u671f\u672a\u586b\u5199;");
            } else if (one.getSignDate().equals(CommonHtConstant.INVALID_DATETIME)) {
                buf.append("\u7b7e\u8ba2\u65e5\u671f\u586b\u5199\u683c\u5f0f\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getIfNewSigning())) {
                buf.append("\u65b0\u7b7e/\u7ed3\u8f6c\u672a\u586b\u5199;");
            } else if (one.getIfNewSigning().contains("-1")) {
                buf.append("\u65b0\u7b7e/\u7ed3\u8f6c\u586b\u5199\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getExecutive())) {
                buf.append("\u4e3b\u7ba1\u9886\u5bfc\u672a\u586b\u5199;");
            }
            if (StringUtil.isBlank((CharSequence)one.getTechnicalLeader())) {
                buf.append("\u5ba4\u5185\u6280\u672f\u8d1f\u8d23\u4eba\u672a\u586b\u5199;");
            }
            if (StringUtil.isBlank((CharSequence)one.getProductionLeader())) {
                buf.append("\u5ba4\u5185\u751f\u4ea7\u7ba1\u7406\u8d1f\u8d23\u4eba\u672a\u586b\u5199;");
            }
            if (StringUtil.isBlank((CharSequence)one.getModelSupervisorName())) {
                buf.append("\u578b\u53f7\u4e3b\u7ba1\u672a\u586b\u5199;");
            } else if (one.getModelSupervisorName().equals(modelManageName)) {
                one.setModelSupervisorId(modelManageId);
            } else {
                List list1 = this.modelManageService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmModelManage::getFieldKey, (Object)one.getArea())).eq(CrmModelManage::getDelFlag, (Object)RETURN_CODE)).eq(CrmModelManage::getModelManageName, (Object)one.getModelSupervisorName()));
                if (list1.size() == 0) {
                    buf.append("\u8be5\u3010" + one.getModelSupervisorName() + "\u3011\u578b\u53f7\u4e3b\u7ba1\u672a\u5339\u914d\u5230;");
                } else {
                    one.setModelSupervisorId(String.valueOf(((CrmModelManage)list1.get(0)).getModelManageId()));
                }
            }
            if (null == one.getInUnitAmount()) {
                buf.append("\u5185\u534f\u5355\u4f4d/\u91d1\u989d\u672a\u586b\u5199;");
            } else if (Double.compare(one.getInUnitAmount(), -1.0) == 0) {
                buf.append("\u5185\u534f\u5355\u4f4d/\u91d1\u989d\u586b\u5199\u683c\u5f0f\u6709\u8bef;");
            }
            if (null != one.getProductionTaskTime() && one.getProductionTaskTime().equals(CommonHtConstant.INVALID_DATETIME)) {
                buf.append("\u751f\u4ea7\u4efb\u52a1\u901a\u77e5\u4e0b\u8fbe\u65f6\u95f4\u586b\u5199\u683c\u5f0f\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getLawCheckNumber())) {
                buf.append("\u6cd5\u5f8b\u5ba1\u67e5\u6d41\u7a0b\u53f7\u672a\u586b\u5199;");
            }
            if (StringUtil.isBlank((CharSequence)one.getImportantParts())) {
                buf.append("\u5173\u91cd\u4ef6\u672a\u586b\u5199;");
            }
            if (StringUtil.isBlank((CharSequence)one.getKeyProcess())) {
                buf.append("\u5173\u952e\u8fc7\u7a0b\u3001\u7279\u6b8a\u8fc7\u7a0b\u672a\u586b\u5199;");
            }
            if (null != one.getTechnicalDoc() && one.getTechnicalDoc().contains("-1")) {
                buf.append("\u6709\u65e0\u6280\u672f\u7c7b\u6587\u4ef6\u586b\u5199\u6709\u8bef;");
            }
            if (null != one.getQualityDoc() && one.getQualityDoc().contains("-1")) {
                buf.append("\u6709\u65e0\u8d28\u91cf\u7c7b\u6587\u4ef6\u586b\u5199\u6709\u8bef;");
            }
            if (null != one.getOtherDoc() && one.getOtherDoc().contains("-1")) {
                buf.append("\u6709\u65e0\u5176\u4ed6\u7c7b\u6587\u4ef6\u586b\u5199\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getClientHandleUser())) {
                buf.append("\u7532\u65b9\u7ecf\u529e\u4eba\u672a\u586b\u5199;");
            }
            if (StringUtil.isBlank((CharSequence)one.getClientHandlePhone())) {
                buf.append("\u7532\u65b9\u7ecf\u529e\u4eba\u8054\u7cfb\u65b9\u5f0f\u672a\u586b\u5199;");
            }
            if (StringUtil.isBlank((CharSequence)one.getFormalAgreementFlag())) {
                buf.append("\u662f\u5426\u8fd4\u56de\u6b63\u5f0f\u5408\u540c\u672a\u586b\u5199;");
            } else if (one.getFormalAgreementFlag().contains("-1")) {
                buf.append("\u662f\u5426\u8fd4\u56de\u6b63\u5f0f\u5408\u540c\u586b\u5199\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getQualityTechRemark())) {
                buf.append("\u8d28\u91cf\u6280\u672f\u8981\u6c42\u672a\u586b\u5199;");
            }
            if (StringUtil.isBlank((CharSequence)one.getDeliveryRemark())) {
                buf.append("\u9001\u8d27\u65b9\u5f0f\u5730\u70b9\u8981\u6c42\u672a\u586b\u5199;");
            }
            if (StringUtil.isBlank((CharSequence)one.getPackCostRemark())) {
                buf.append("\u5305\u88c5\u8981\u6c42\u3001\u8d39\u7528\u627f\u62c5\u672a\u586b\u5199;");
            }
            if (StringUtil.isBlank((CharSequence)one.getPriceMethod())) {
                buf.append("\u5b9a\u4ef7\u65b9\u5f0f\u672a\u586b\u5199;");
            } else if (one.getPriceMethod().contains("-1")) {
                buf.append("\u5b9a\u4ef7\u65b9\u5f0f\u586b\u5199\u6709\u8bef;");
            }
            if (StringUtil.isBlank((CharSequence)one.getPayMethod())) {
                buf.append("\u4ed8\u6b3e\u65b9\u5f0f\u672a\u586b\u5199;");
            }
        } else {
            if (StringUtil.isNotBlank((CharSequence)one.getIfAppraisal()) && one.getIfAppraisal().contains("-1")) {
                one.setIfAppraisal(null);
            }
            if (StringUtil.isNotBlank((CharSequence)one.getIfNewProduct()) && one.getIfNewProduct().contains("-1")) {
                one.setIfNewProduct(null);
            }
            if (null != one.getSignDate() && one.getSignDate().equals(CommonHtConstant.INVALID_DATETIME)) {
                one.setSignDate(null);
                buf.append("\u7b7e\u8ba2\u65e5\u671f\u672a\u586b\u5199;");
            }
            if (StringUtil.isNotBlank((CharSequence)one.getIfNewSigning()) && one.getIfNewProduct().contains("-1")) {
                one.setIfNewProduct(null);
            }
            if (StringUtil.isNotBlank((CharSequence)one.getModelSupervisorName())) {
                if (one.getModelSupervisorName().equals(modelManageName)) {
                    one.setModelSupervisorId(modelManageId);
                } else {
                    List list1 = this.modelManageService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmModelManage::getFieldKey, (Object)one.getArea())).eq(CrmModelManage::getDelFlag, (Object)RETURN_CODE)).eq(CrmModelManage::getModelManageName, (Object)one.getModelSupervisorName()));
                    if (list1.size() == 0) {
                        one.setModelSupervisorName(null);
                    } else {
                        one.setModelSupervisorId(String.valueOf(((CrmModelManage)list1.get(0)).getModelManageId()));
                    }
                }
            }
            if (null != one.getInUnitAmount() && Double.compare(one.getInUnitAmount(), -1.0) == 0) {
                one.setInUnitAmount(null);
            }
            if (null != one.getProductionTaskTime() && one.getProductionTaskTime().equals(CommonHtConstant.INVALID_DATETIME)) {
                one.setProductionTaskTime(null);
            }
            if (null != one.getTechnicalDoc() && one.getTechnicalDoc().contains("-1")) {
                one.setTechnicalDoc(null);
            }
            if (null != one.getQualityDoc() && one.getQualityDoc().contains("-1")) {
                one.setQualityDoc(null);
            }
            if (null != one.getOtherDoc() && one.getOtherDoc().contains("-1")) {
                one.setOtherDoc(null);
            }
            if (StringUtil.isNotBlank((CharSequence)one.getFormalAgreementFlag()) && one.getFormalAgreementFlag().contains("-1")) {
                one.setFormalAgreementFlag(null);
            }
            if (StringUtil.isNotBlank((CharSequence)one.getPriceMethod()) && one.getPriceMethod().contains("-1")) {
                one.setPriceMethod(null);
            }
        }
    }

    private String checkSupervisionInfo(CrmAgreement dataAgreement, CrmAgreement importData) {
        StringBuffer buf = new StringBuffer();
        if ("1".equals(importData.getIfMilitaryInspection())) {
            dataAgreement.setSupervisionAgreementNumber(importData.getSupervisionAgreementNumber());
            if (null != importData.getSupervisionTaskTime() && importData.getSupervisionTaskTime().equals(CommonHtConstant.INVALID_DATETIME)) {
                buf.append("\u76d1\u7ba1\u4efb\u52a1\u8f93\u5165\u65f6\u95f4\u683c\u5f0f\u586b\u5199\u6709\u8bef;");
            } else {
                dataAgreement.setSupervisionTaskTime(importData.getSupervisionTaskTime());
            }
            if (null != importData.getTaskIssued() && importData.getTaskIssued().contains("-1")) {
                buf.append("\u76d1\u7ba1\u9700\u6c42/\u4efb\u52a1\u662f\u5426\u53d1\u51fa\u586b\u5199\u6709\u8bef;");
            } else {
                dataAgreement.setTaskIssued(importData.getTaskIssued());
            }
            dataAgreement.setSerialNumber(importData.getSerialNumber());
            if (null != importData.getIfReceive() && importData.getIfReceive().contains("-1")) {
                buf.append("509\u662f\u5426\u63a5\u6536\u586b\u5199\u6709\u8bef;");
            } else {
                dataAgreement.setIfReceive(importData.getIfReceive());
            }
            if (null != importData.getSentOutTime() && importData.getSentOutTime().equals(CommonHtConstant.INVALID_DATETIME)) {
                buf.append("509\u53d1\u51fa\u65f6\u95f4\u683c\u5f0f\u586b\u5199\u6709\u8bef;");
            } else {
                dataAgreement.setSentOutTime(importData.getSentOutTime());
            }
            if (null != importData.getReceptionTime() && importData.getReceptionTime().equals(CommonHtConstant.INVALID_DATETIME)) {
                buf.append("509\u63a5\u6536\u65f6\u95f4\u683c\u5f0f\u586b\u5199\u6709\u8bef;");
            } else {
                dataAgreement.setReceptionTime(importData.getReceptionTime());
            }
            dataAgreement.setSigningStatus(importData.getSigningStatus());
            if (null != importData.getSubordinateSupervision() && importData.getSubordinateSupervision().contains("-1")) {
                buf.append("\u662f\u5426\u4e0b\u7ea7\u76d1\u7ba1\u586b\u5199\u6709\u8bef;");
            } else {
                dataAgreement.setSubordinateSupervision(importData.getSubordinateSupervision());
            }
        }
        return buf.toString();
    }

    private String checkNotInfo(CrmAgreement dataAgreement, CrmAgreement importData) {
        StringBuffer buf = new StringBuffer();
        dataAgreement.setProductionProgress(importData.getProductionProgress());
        if (null != importData.getProductionTaskTime() && importData.getProductionTaskTime().equals(CommonHtConstant.INVALID_DATETIME)) {
            buf.append("\u751f\u4ea7\u4efb\u52a1\u901a\u77e5\u4e0b\u8fbe\u65f6\u95f4\u683c\u5f0f\u586b\u5199\u6709\u8bef;");
        } else {
            dataAgreement.setProductionTaskTime(importData.getProductionTaskTime());
        }
        dataAgreement.setTechnicalUnit(importData.getTechnicalUnit());
        if (null != importData.getQualityDoc() && importData.getQualityDoc().contains("-1")) {
            buf.append("\u8d28\u91cf\u7c7b\u6587\u4ef6\u586b\u5199\u6709\u8bef;");
        } else {
            dataAgreement.setQualityDoc(importData.getQualityDoc());
        }
        if (null != importData.getTechnicalDoc() && importData.getTechnicalDoc().contains("-1")) {
            buf.append("\u6280\u672f\u7c7b\u6587\u4ef6\u586b\u5199\u6709\u8bef;");
        } else {
            dataAgreement.setTechnicalDoc(importData.getTechnicalDoc());
        }
        if (null != importData.getOtherDoc() && importData.getOtherDoc().contains("-1")) {
            buf.append("\u5176\u4ed6\u7c7b\u6587\u4ef6\u586b\u5199\u6709\u8bef;");
        } else {
            dataAgreement.setOtherDoc(importData.getOtherDoc());
        }
        String msg = this.checkSupervisionInfo(dataAgreement, importData);
        if (StringUtil.isNotBlank((CharSequence)msg)) {
            buf.append(msg);
        }
        return buf.toString();
    }

    @Override
    @Transactional
    public ApiResponse contractAgreementImport(MultipartFile file) {
        String msg = ExcelImportUtil.checkTemplate((MultipartFile)file, (String[])ExcelConstant.agreementImportTitle);
        if (StringUtil.isNotBlank((CharSequence)msg)) {
            return ApiResponse.fail((String)msg);
        }
        int flag = 0;
        if (file == null) {
            flag = -1;
        }
        if (!file.getOriginalFilename().endsWith("xlsx")) {
            flag = -2;
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        AttachmentManagerModelVo attachment = null;
        Long fileImportId = Long.valueOf(CommonUtills.generateAssignId());
        int importCount = 0;
        ArrayList<CrmAgreement> failList = new ArrayList<CrmAgreement>();
        List<CrmAgreement> list = this.getExcelInfo(file);
        if (CollectionUtil.isEmpty(list)) {
            throw new BaseException("\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0a\u4f20\u5931\u8d25");
        }
        List<CrmAgreement> backupList = list.stream().map(dataOne -> {
            CrmAgreement backOne = new CrmAgreement();
            BeanUtil.copyProperties((Object)dataOne, (Object)backOne);
            return backOne;
        }).collect(Collectors.toList());
        this.translateToDictionary(list);
        importCount = this.agreementJudgeData(list, backupList, failList, importCount);
        FileInputStream inputStream = null;
        AttachmentManagerModelVo suspectedAttachment = null;
        try {
            ApiResponse response = this.attachmentManagerService.uploadFileWithDrag(file, fileImportId);
            attachment = (AttachmentManagerModelVo)response.getData();
            if (CollectionUtil.isNotEmpty(failList)) {
                File file1 = this.exportExcelPaper(failList);
                inputStream = new FileInputStream(file1);
                MockMultipartFile multipartFile = new MockMultipartFile(file1.getName(), file1.getName(), "application/octet-stream", (InputStream)inputStream);
                ApiResponse suspectedResponse = this.attachmentManagerService.uploadFileWithDrag((MultipartFile)multipartFile, null);
                suspectedAttachment = (AttachmentManagerModelVo)suspectedResponse.getData();
                file1.delete();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        FileImport fileImport = new FileImport();
        String sourceFileName = attachment.getFileName();
        String finishMessage = "";
        if (flag >= 0) {
            fileImport.setSuccessFail("1");
            finishMessage = importCount != list.size() ? "\u5bfc\u5165\u6210\u529f" + importCount + "\u6761\uff0c\u672a\u5bfc\u5165" + (list.size() - importCount) + "\u6761\u6570\u636e\u3002" : "\u5bfc\u5165\u6210\u529f" + importCount + "\u6761\u3002";
        } else {
            fileImport.setSuccessFail(RETURN_CODE);
            if (flag == -1) {
                finishMessage = "\u5bfc\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728";
            } else if (flag == -2) {
                finishMessage = "\u8bf7\u4e0a\u4f20\u6307\u5b9a\u683c\u5f0f\u6587\u4ef6";
            } else if (flag == -3) {
                finishMessage = "\u4e0a\u4f20\u5931\u8d25";
            }
        }
        fileImport.setFileImportId(fileImportId);
        Long sourceFileId = attachment.getId();
        fileImport.setSourceFileId(sourceFileId);
        fileImport.setSourceFileName(sourceFileName);
        fileImport.setImportResult(finishMessage);
        fileImport.setModuleId("agreement");
        if (CollectionUtil.isNotEmpty(failList)) {
            Long suspectedFileId = suspectedAttachment.getId();
            fileImport.setSuspectedFileId(suspectedFileId);
            fileImport.setSuspectedFileName(suspectedAttachment.getFileName());
        }
        fileImport.setCreateTime(date);
        fileImport.setCreator(userId);
        fileImport.setCreatorName(userName);
        fileImport.setLastTime(date);
        fileImport.setLastEditor(userId);
        fileImport.setLastEditorName(userName);
        fileImport.setDelFlag(RETURN_CODE);
        this.fileImportService.save((Object)fileImport);
        return ApiResponse.success((String)"\u5bfc\u5165\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File exportExcelPaper(List<CrmAgreement> failInfoList) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        XSSFCellStyle textStyle = workbook.createCellStyle();
        XSSFDataFormat format = workbook.createDataFormat();
        textStyle.setDataFormat(format.getFormat("@"));
        XSSFRow row = sheet.createRow(0);
        XSSFCell cell = null;
        List<String> cols = Arrays.asList(ExcelConstant.agreementFailTitle);
        int lastColumnIndex = cols.size() - 1;
        sheet.setColumnWidth(lastColumnIndex, 25600);
        try {
            for (int i = 0; i < cols.size(); ++i) {
                cell = row.createCell(i);
                XSSFCellStyle cellStyle = workbook.createCellStyle();
                cellStyle.setWrapText(true);
                XSSFFont font = workbook.createFont();
                font.setFontName("\u5b8b\u4f53");
                font.setFontHeightInPoints((short)14);
                font.setBold(true);
                cellStyle.setFont((Font)font);
                cell.setCellStyle((CellStyle)cellStyle);
                cell.setCellValue(ExcelConstant.agreementFailTitle[i]);
                int columnWidth = sheet.getColumnWidth(i) / 256 + 10;
                int length = cols.get(i).getBytes("UTF-8").length + 1;
                if (columnWidth < length + 1) {
                    columnWidth = length + 1;
                }
                sheet.setColumnWidth(i, columnWidth * 256);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        XSSFCellStyle dataCellStyle = workbook.createCellStyle();
        dataCellStyle.setWrapText(true);
        dataCellStyle.setAlignment(HorizontalAlignment.LEFT);
        XSSFCellStyle normalDataStyle = workbook.createCellStyle();
        normalDataStyle.setAlignment(HorizontalAlignment.LEFT);
        for (int i = 1; i < failInfoList.size() + 1; ++i) {
            XSSFRow nextRow = sheet.createRow(i);
            block76: for (int j = 0; j < ExcelConstant.agreementFailTitle.length; ++j) {
                CrmAgreement crmAgreement = failInfoList.get(i - 1);
                XSSFCell cell2 = nextRow.createCell(j);
                cell2.setCellStyle((CellStyle)normalDataStyle);
                switch (j) {
                    case 0: {
                        cell2.setCellValue(crmAgreement.getAgreementNumber());
                        continue block76;
                    }
                    case 1: {
                        cell2.setCellValue(crmAgreement.getAgreementName());
                        continue block76;
                    }
                    case 2: {
                        cell2.setCellValue(crmAgreement.getCustomerName());
                        continue block76;
                    }
                    case 3: {
                        cell2.setCellValue(crmAgreement.getProductType());
                        continue block76;
                    }
                    case 4: {
                        cell2.setCellValue(crmAgreement.getSpecialFlag());
                        continue block76;
                    }
                    case 5: {
                        if (null == crmAgreement.getTotalAmountTax()) continue block76;
                        cell2.setCellValue(crmAgreement.getTotalAmountTax().doubleValue());
                        continue block76;
                    }
                    case 6: {
                        cell2.setCellValue(crmAgreement.getAddContractFlag());
                        continue block76;
                    }
                    case 7: {
                        cell2.setCellValue(crmAgreement.getMasterContractNumber());
                        continue block76;
                    }
                    case 8: {
                        cell2.setCellValue(crmAgreement.getAgreementType());
                        continue block76;
                    }
                    case 9: {
                        cell2.setCellValue(crmAgreement.getSecurityLevelLabel());
                        continue block76;
                    }
                    case 10: {
                        cell2.setCellValue(crmAgreement.getIfDutyProject());
                        continue block76;
                    }
                    case 11: {
                        cell2.setCellValue(crmAgreement.getProductModel());
                        continue block76;
                    }
                    case 12: {
                        cell2.setCellStyle((CellStyle)textStyle);
                        this.setDateCellValue(cell2, crmAgreement.getEndDate());
                        continue block76;
                    }
                    case 13: {
                        cell2.setCellValue(crmAgreement.getAgreementCategory());
                        continue block76;
                    }
                    case 14: {
                        cell2.setCellValue(crmAgreement.getIfMilitaryInspection());
                        continue block76;
                    }
                    case 15: {
                        cell2.setCellValue(crmAgreement.getIfMilitaryInspection());
                        continue block76;
                    }
                    case 16: {
                        cell2.setCellValue(crmAgreement.getIfFourteenFiveProject());
                        continue block76;
                    }
                    case 17: {
                        cell2.setCellValue(crmAgreement.getBidProductFlag());
                        continue block76;
                    }
                    case 18: {
                        cell2.setCellValue(crmAgreement.getProductionStatus());
                        continue block76;
                    }
                    case 19: {
                        cell2.setCellValue(crmAgreement.getIfAppraisal());
                        continue block76;
                    }
                    case 20: {
                        cell2.setCellValue(crmAgreement.getIfNewProduct());
                        continue block76;
                    }
                    case 21: {
                        cell2.setCellValue(crmAgreement.getaContractNumber());
                        continue block76;
                    }
                    case 22: {
                        cell2.setCellStyle((CellStyle)textStyle);
                        this.setDateCellValue(cell2, crmAgreement.getSignDate());
                        continue block76;
                    }
                    case 23: {
                        cell2.setCellValue(crmAgreement.getIfNewSigning());
                        continue block76;
                    }
                    case 24: {
                        cell2.setCellValue(crmAgreement.getExecutive());
                        continue block76;
                    }
                    case 25: {
                        cell2.setCellValue(crmAgreement.getTechnicalLeader());
                        continue block76;
                    }
                    case 26: {
                        cell2.setCellValue(crmAgreement.getProductionLeader());
                        continue block76;
                    }
                    case 27: {
                        cell2.setCellValue(crmAgreement.getModelSupervisorName());
                        continue block76;
                    }
                    case 28: {
                        if (null == crmAgreement.getInUnitAmount()) continue block76;
                        cell2.setCellValue(crmAgreement.getInUnitAmount().doubleValue());
                        continue block76;
                    }
                    case 29: {
                        cell2.setCellValue(crmAgreement.getProductionProgress());
                        continue block76;
                    }
                    case 30: {
                        cell2.setCellStyle((CellStyle)textStyle);
                        this.setDateCellValue(cell2, crmAgreement.getProductionTaskTime());
                        continue block76;
                    }
                    case 31: {
                        cell2.setCellValue(crmAgreement.getLawCheckNumber());
                        continue block76;
                    }
                    case 32: {
                        cell2.setCellValue(crmAgreement.getTechnicalUnit());
                        continue block76;
                    }
                    case 33: {
                        cell2.setCellValue(crmAgreement.getImportantParts());
                        continue block76;
                    }
                    case 34: {
                        cell2.setCellValue(crmAgreement.getKeyProcess());
                        continue block76;
                    }
                    case 35: {
                        cell2.setCellValue(crmAgreement.getTechnicalDoc());
                        continue block76;
                    }
                    case 36: {
                        cell2.setCellValue(crmAgreement.getQualityDoc());
                        continue block76;
                    }
                    case 37: {
                        cell2.setCellValue(crmAgreement.getOtherDoc());
                        continue block76;
                    }
                    case 38: {
                        cell2.setCellValue(crmAgreement.getClientHandleUser());
                        continue block76;
                    }
                    case 39: {
                        cell2.setCellValue(crmAgreement.getClientHandlePhone());
                        continue block76;
                    }
                    case 40: {
                        cell2.setCellValue(crmAgreement.getFormalAgreementFlag());
                        continue block76;
                    }
                    case 41: {
                        cell2.setCellValue(crmAgreement.getQualityTechRemark());
                        continue block76;
                    }
                    case 42: {
                        cell2.setCellValue(crmAgreement.getDeliveryRemark());
                        continue block76;
                    }
                    case 43: {
                        cell2.setCellValue(crmAgreement.getPackCostRemark());
                        continue block76;
                    }
                    case 44: {
                        cell2.setCellValue(crmAgreement.getSupervisionAgreementNumber());
                        continue block76;
                    }
                    case 45: {
                        cell2.setCellStyle((CellStyle)textStyle);
                        this.setDateCellValue(cell2, crmAgreement.getSupervisionTaskTime());
                        continue block76;
                    }
                    case 46: {
                        cell2.setCellValue(crmAgreement.getTaskIssued());
                        continue block76;
                    }
                    case 47: {
                        cell2.setCellValue(crmAgreement.getSerialNumber());
                        continue block76;
                    }
                    case 48: {
                        cell2.setCellValue(crmAgreement.getIfReceive());
                        continue block76;
                    }
                    case 49: {
                        cell2.setCellStyle((CellStyle)textStyle);
                        this.setDateCellValue(cell2, crmAgreement.getSentOutTime());
                        continue block76;
                    }
                    case 50: {
                        cell2.setCellStyle((CellStyle)textStyle);
                        this.setDateCellValue(cell2, crmAgreement.getReceptionTime());
                        continue block76;
                    }
                    case 51: {
                        cell2.setCellValue(crmAgreement.getSigningStatus());
                        continue block76;
                    }
                    case 52: {
                        cell2.setCellValue(crmAgreement.getSubordinateSupervision());
                        continue block76;
                    }
                    case 53: {
                        cell2.setCellValue(crmAgreement.getPriceMethod());
                        continue block76;
                    }
                    case 54: {
                        cell2.setCellValue(crmAgreement.getPayMethod());
                        continue block76;
                    }
                    case 55: {
                        cell2.setCellValue(crmAgreement.getProductNames());
                        continue block76;
                    }
                    case 56: {
                        cell2.setCellValue(crmAgreement.getProductAmounts());
                        continue block76;
                    }
                    case 57: {
                        cell2.setCellValue(crmAgreement.getProductUnits());
                        continue block76;
                    }
                    case 58: {
                        cell2.setCellValue(crmAgreement.getType());
                        cell2.setCellStyle((CellStyle)dataCellStyle);
                    }
                }
            }
        }
        LocalDateTime dateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
        String dateStr = dateTime.format(formatter);
        File file = new File("\u5408\u540c\u7684\u672a\u5bfc\u5165\u4fe1\u606f_" + dateStr + ".xlsx");
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            workbook.write((OutputStream)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return file;
    }

    private void setDateCellValue(XSSFCell cell, Object dateValue) {
        if (dateValue != null) {
            String dateStr;
            if (dateValue instanceof LocalDateTime) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
                dateStr = ((LocalDateTime)dateValue).format(formatter);
            } else if (dateValue instanceof LocalDate) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
                dateStr = ((LocalDate)dateValue).format(formatter);
            } else if (dateValue instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                dateStr = sdf.format((Date)dateValue);
            } else {
                dateStr = dateValue.toString();
            }
            cell.setCellValue(dateStr);
        }
    }

    private void baseInfoFill(CrmAgreement agreement, SecurityUser user, Long userId, String userName, Long deptId, String deptName) {
        SysStru companyInfo = this.struUserAPIService.getCompanyInfoByCurrentDeptId(user.getDeptId().toString());
        agreement.setCreator(user.getUserId().toString());
        agreement.setCreatorName(user.getUserName());
        agreement.setCreateTime(LocalDateTime.now());
        agreement.setCreateDepartment(user.getDeptId().toString());
        agreement.setCreateDepartmentName(user.getDeptName());
        agreement.setChargePerson(user.getUserId().toString());
        agreement.setChargePersonName(user.getUserName());
        agreement.setOwnDepartment(user.getDeptId().toString());
        agreement.setOwnDepartmentName(user.getDeptName());
        agreement.setOwnUnitName(companyInfo.getOrganAlias());
    }

    @Override
    public void contractAgreementImportTemplate(HttpServletResponse response) {
        try {
            int i;
            XSSFWorkbook leads = new XSSFWorkbook();
            XSSFSheet sheet = leads.createSheet("\u5408\u540c\u7ba1\u7406\u5bfc\u5165\u6a21\u677f");
            XSSFCellStyle style = leads.createCellStyle();
            XSSFFont font = leads.createFont();
            font.setFontName("\u5b8b\u4f53");
            font.setFontHeightInPoints((short)14);
            font.setBold(true);
            style.setFont((Font)font);
            XSSFCellStyle textStyle = leads.createCellStyle();
            XSSFDataFormat format = leads.createDataFormat();
            textStyle.setDataFormat(format.getFormat("@"));
            Row row = sheet.createRow(0);
            List<String> cols = Arrays.asList(ExcelConstant.agreementImportTitle);
            int j = cols.size();
            for (i = 0; i < j; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle((CellStyle)style);
                cell.setCellType(CellType.STRING);
                cell.setCellValue(cols.get(i));
                int columnWidth = sheet.getColumnWidth(i) / 256 + 10;
                int length = cols.get(i).getBytes("UTF-8").length + 1;
                if (columnWidth < length + 1) {
                    columnWidth = length + 1;
                }
                sheet.setColumnWidth(i, columnWidth * 256);
            }
            j = cols.size();
            for (i = 0; i < j; ++i) {
                sheet.setDefaultColumnStyle(i, (CellStyle)textStyle);
            }
            response.reset();
            String fileName = "\u5408\u540c\u7ba1\u7406\u5bfc\u5165\u6a21\u677f";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes(), "iso-8859-1") + ".xlsx");
            leads.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new BaseException("\u6a21\u677f\u5bfc\u51fa\u5931\u8d25!" + e.getMessage());
        }
    }

    @Override
    public String contractAgreementExport(HttpServletResponse response, CrmAgreementPageDto pageDto) {
        PermissionDto permissionDto = this.crmAgreementService.agreementOperate(pageDto);
        CrmAgreementPageVo crmAgreementPageVO = new CrmAgreementPageVo();
        pageDto.setSecurityLevel(BaseSecurityUtil.getUser().getSecurityLevel());
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        ArrayList<String> orderRule = new ArrayList<String>();
        if (pageDto.getOrders() != null) {
            StringBuilder order = new StringBuilder();
            for (OrderItem orderItem : pageDto.getOrders()) {
                if (orderItem.isAsc()) {
                    order.append(orderItem.getColumn()).append(ASC);
                    continue;
                }
                order.append(orderItem.getColumn()).append(DESC);
            }
            orderRule.add(order.toString());
            parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
        }
        ArrayList<String> defaultOrderRule = new ArrayList<String>();
        String defaultOrder = "";
        defaultOrder = defaultOrder + "T2.signDate,desc;";
        defaultOrder = defaultOrder + "T2.createTime,desc;";
        defaultOrderRule.add(defaultOrder);
        parameterMap.put(DEFAULT_ORDER_RULE, defaultOrderRule.toArray(new String[0]));
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)new CrmAgreement(), parameterMap);
        Long currentUserId = BaseSecurityUtil.getUser().getId();
        pageDto.setCurrentUserId(currentUserId);
        InitUnitDataUtill.initForAgreement(pageDto);
        List<CrmAgreementPageDto> dtoList = this.crmAgreementService.getOrderUnityDtoList(pageDto);
        pageDto.setDtoList(dtoList);
        pageDto.setCurrentUserId(currentUserId);
        pageDto.setPermissionDto(permissionDto);
        List<CrmAgreementVO> list = this.crmAgreementMapper.listPageNew(null, pageDto, (QueryWrapper<CrmAgreement>)queryWrapper);
        this.dictionaryTranslate(list);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u5408\u540c\u5217\u8868", CrmAgreementVO.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    public List<CrmAgreement> getExcelInfo(MultipartFile mFile) {
        String fileName = mFile.getOriginalFilename();
        try {
            if (!CrmAgreementImportAndExportImpl.validateExcel(fileName)) {
                return null;
            }
            boolean isExcel2003 = true;
            if (CrmAgreementImportAndExportImpl.isExcel2007(fileName)) {
                isExcel2003 = false;
            }
            List<CrmAgreement> userList = CrmAgreementImportAndExportImpl.createExcel(mFile.getInputStream(), isExcel2003);
            return userList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<CrmAgreement> createExcel(InputStream is, boolean isExcel2003) {
        try {
            Object wb = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            List<CrmAgreement> agreementList = CrmAgreementImportAndExportImpl.readExcelValue((Workbook)wb);
            return agreementList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<CrmAgreement> readExcelValue(Workbook wb) {
        Sheet sheet = wb.getSheetAt(0);
        totalRows = sheet.getPhysicalNumberOfRows();
        if (totalRows > 1 && sheet.getRow(0) != null) {
            totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        ArrayList<CrmAgreement> agreementList = new ArrayList<CrmAgreement>();
        for (int r = 1; r < totalRows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            Cell cell0 = row.getCell(0);
            if (row == null || cell0 == null || CellType.STRING.equals((Object)cell0.getCellType()) && "".equals(cell0.getStringCellValue())) continue;
            CrmAgreement agreement = new CrmAgreement();
            block71: for (int c = 0; c < totalCells; ++c) {
                Cell cell = row.getCell(c);
                if (!ToolUtil.isNotEmpty((Object)cell)) continue;
                switch (c) {
                    case 0: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setAgreementNumber(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 1: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setAgreementName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 2: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setCustomerName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 3: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setProductType(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 4: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setSpecialFlag(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 5: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        String totalAmountTax = cell.getStringCellValue().replaceAll("\\s*|\r|\n", "");
                        try {
                            Double l = Double.valueOf(totalAmountTax);
                            agreement.setTotalAmountTax(l);
                        }
                        catch (Exception e) {
                            agreement.setTotalAmountTax(-1.0);
                        }
                        continue block71;
                    }
                    case 6: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setAddContractFlag(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 7: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setMasterContractNumber(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 8: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setAgreementType(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 9: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setSecurityLevelLabel(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 10: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setIfDutyProject(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 11: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setProductModel(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 12: {
                        LocalDate findTime;
                        DateTimeFormatter df;
                        Object find;
                        try {
                            if (cell.getCellTypeEnum() == CellType.STRING) {
                                find = cell.getStringCellValue().replace(".", "-").replace("/", "-");
                                df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                                findTime = LocalDate.parse((CharSequence)find, df);
                                agreement.setEndDate(findTime.atStartOfDay());
                                continue block71;
                            }
                            if (cell.getCellTypeEnum() != CellType.NUMERIC) continue block71;
                            cell.setCellType(CellType.STRING);
                            find = HSSFDateUtil.getJavaDate((double)Double.valueOf(cell.getStringCellValue()));
                            agreement.setEndDate(((Date)find).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                        }
                        catch (Exception e) {
                            agreement.setEndDate(CommonHtConstant.INVALID_DATETIME);
                        }
                        continue block71;
                    }
                    case 13: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setAgreementCategory(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 14: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setIfMilitaryInspection(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 15: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setArea(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 16: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setIfFourteenFiveProject(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 17: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setBidProductFlag(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 18: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setProductionStatus(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 19: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setIfAppraisal(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 20: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setIfNewProduct(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 21: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setaContractNumber(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 22: {
                        LocalDate findTime;
                        DateTimeFormatter df;
                        Object find;
                        try {
                            if (cell.getCellTypeEnum() == CellType.STRING) {
                                find = cell.getStringCellValue().replace(".", "-").replace("/", "-");
                                df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                                findTime = LocalDate.parse((CharSequence)find, df);
                                agreement.setSignDate(findTime.atStartOfDay());
                                continue block71;
                            }
                            if (cell.getCellTypeEnum() != CellType.NUMERIC) continue block71;
                            cell.setCellType(CellType.STRING);
                            find = HSSFDateUtil.getJavaDate((double)Double.valueOf(cell.getStringCellValue()));
                            agreement.setSignDate(((Date)find).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                        }
                        catch (Exception e) {
                            agreement.setSignDate(CommonHtConstant.INVALID_DATETIME);
                        }
                        continue block71;
                    }
                    case 23: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setIfNewSigning(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 24: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setExecutive(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 25: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setTechnicalLeader(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 26: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setProductionLeader(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 27: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setModelSupervisorName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 28: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        String amount = cell.getStringCellValue().replaceAll("\\s*|\r|\n", "");
                        try {
                            Double l = Double.valueOf(amount);
                            agreement.setInUnitAmount(l);
                        }
                        catch (Exception e) {
                            agreement.setInUnitAmount(-1.0);
                        }
                        continue block71;
                    }
                    case 29: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setProductionProgress(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 30: {
                        LocalDate findTime;
                        DateTimeFormatter df;
                        Object find;
                        try {
                            if (cell.getCellTypeEnum() == CellType.STRING) {
                                find = cell.getStringCellValue().replace(".", "-").replace("/", "-");
                                df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                                findTime = LocalDate.parse((CharSequence)find, df);
                                agreement.setProductionTaskTime(findTime.atStartOfDay());
                                continue block71;
                            }
                            if (cell.getCellTypeEnum() != CellType.NUMERIC) continue block71;
                            cell.setCellType(CellType.STRING);
                            find = HSSFDateUtil.getJavaDate((double)Double.valueOf(cell.getStringCellValue()));
                            agreement.setProductionTaskTime(((Date)find).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                        }
                        catch (Exception e) {
                            agreement.setProductionTaskTime(CommonHtConstant.INVALID_DATETIME);
                        }
                        continue block71;
                    }
                    case 31: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setLawCheckNumber(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 32: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setTechnicalUnit(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 33: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setImportantParts(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 34: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setKeyProcess(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 35: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setTechnicalDoc(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 36: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setQualityDoc(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 37: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setOtherDoc(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 38: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setClientHandleUser(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 39: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setClientHandlePhone(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 40: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setFormalAgreementFlag(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 41: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setQualityTechRemark(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 42: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setDeliveryRemark(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 43: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setPackCostRemark(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 44: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setSupervisionAgreementNumber(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 45: {
                        LocalDate findTime;
                        DateTimeFormatter df;
                        Object find;
                        if (cell.getCellTypeEnum() == CellType.STRING) {
                            find = cell.getStringCellValue().replace(".", "-").replace("/", "-");
                            df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            findTime = LocalDate.parse((CharSequence)find, df);
                            agreement.setSupervisionTaskTime(findTime.atStartOfDay());
                            continue block71;
                        }
                        if (cell.getCellTypeEnum() != CellType.NUMERIC) continue block71;
                        cell.setCellType(CellType.STRING);
                        find = HSSFDateUtil.getJavaDate((double)Double.valueOf(cell.getStringCellValue()));
                        agreement.setSupervisionTaskTime(((Date)find).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                        continue block71;
                    }
                    case 46: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setTaskIssued(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 47: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setSerialNumber(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 48: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setIfReceive(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 49: {
                        LocalDate findTime;
                        DateTimeFormatter df;
                        Object find;
                        if (cell.getCellTypeEnum() == CellType.STRING) {
                            find = cell.getStringCellValue().replace(".", "-").replace("/", "-");
                            df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            findTime = LocalDate.parse((CharSequence)find, df);
                            agreement.setSentOutTime(findTime.atStartOfDay());
                            continue block71;
                        }
                        if (cell.getCellTypeEnum() != CellType.NUMERIC) continue block71;
                        cell.setCellType(CellType.STRING);
                        find = HSSFDateUtil.getJavaDate((double)Double.valueOf(cell.getStringCellValue()));
                        agreement.setSentOutTime(((Date)find).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                        continue block71;
                    }
                    case 50: {
                        LocalDate findTime;
                        DateTimeFormatter df;
                        Object find;
                        if (cell.getCellTypeEnum() == CellType.STRING) {
                            find = cell.getStringCellValue().replace(".", "-").replace("/", "-");
                            df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                            findTime = LocalDate.parse((CharSequence)find, df);
                            agreement.setReceptionTime(findTime.atStartOfDay());
                            continue block71;
                        }
                        if (cell.getCellTypeEnum() != CellType.NUMERIC) continue block71;
                        cell.setCellType(CellType.STRING);
                        find = HSSFDateUtil.getJavaDate((double)Double.valueOf(cell.getStringCellValue()));
                        agreement.setReceptionTime(((Date)find).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
                        continue block71;
                    }
                    case 51: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setSigningStatus(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 52: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setSubordinateSupervision(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 53: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setPriceMethod(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 54: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setPayMethod(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 55: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setProductNames(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 56: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setProductAmounts(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block71;
                    }
                    case 57: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        agreement.setProductUnits(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                    }
                }
            }
            agreementList.add(agreement);
        }
        return agreementList;
    }

    public static boolean validateExcel(String filePath) {
        if (filePath == null || !CrmAgreementImportAndExportImpl.isExcel2003(filePath) && !CrmAgreementImportAndExportImpl.isExcel2007(filePath)) {
            errorMsg = "\u6587\u4ef6\u540d\u4e0d\u662fexcel\u683c\u5f0f";
            return false;
        }
        return true;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }

    private void dictionaryTranslate(List<CrmAgreementVO> list) {
        Map<String, String> YesNoDic = this.sysDicRefService.getDicListByType("yes_no").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        Map<String, String> CateDic = this.sysDicRefService.getDicListByType("military_contracts_type").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        Map<String, String> TypeDic = this.sysDicRefService.getDicListByType("contract_type").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        Map<String, String> SecureDic = this.sysDicRefService.getDicListByType("security_level").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        Map<String, String> ProTypeDic = this.sysDicRefService.getDicListByType("product_type").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        Map<String, String> areaDic = this.sysDicRefService.getDicListByType("area").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        Map<String, String> productionStatusDic = this.sysDicRefService.getDicListByType("productionStatus").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        Map<String, String> productModelDic = this.sysDicRefService.getDicListByType("product_model").stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        for (CrmAgreementVO crmAgreement : list) {
            String type;
            if (YesNoDic != null) {
                crmAgreement.setIfDutyProject(YesNoDic.get(crmAgreement.getIfDutyProject()));
                crmAgreement.setIfReceive(YesNoDic.get(crmAgreement.getIfReceive()));
                crmAgreement.setIfAppraisal(YesNoDic.get(crmAgreement.getIfAppraisal()));
                crmAgreement.setIfMilitaryInspection(YesNoDic.get(crmAgreement.getIfMilitaryInspection()));
                crmAgreement.setIfFourteenFiveProject(YesNoDic.get(crmAgreement.getIfFourteenFiveProject()));
                crmAgreement.setSpecialFlag(YesNoDic.get(crmAgreement.getSpecialFlag()));
                crmAgreement.setSubordinateSupervision(YesNoDic.get(crmAgreement.getSubordinateSupervision()));
                crmAgreement.setBidProductFlag(YesNoDic.get(crmAgreement.getBidProductFlag()));
                crmAgreement.setIfNewSigning(YesNoDic.get(crmAgreement.getIfNewSigning()));
                crmAgreement.setIfNewProduct(YesNoDic.get(crmAgreement.getIfNewProduct()));
            }
            if (CateDic != null) {
                crmAgreement.setAgreementCategory(CateDic.get(crmAgreement.getAgreementCategory()));
            }
            if (TypeDic != null) {
                crmAgreement.setAgreementType(TypeDic.get(crmAgreement.getAgreementType()));
            }
            if (SecureDic != null) {
                crmAgreement.setSecurityLevelLabel(SecureDic.get(crmAgreement.getSecurityLevel() + ""));
            }
            if (StringUtil.isNotBlank((CharSequence)crmAgreement.getTechnicalDoc())) {
                type = crmAgreement.getTechnicalDoc();
                crmAgreement.setTechnicalDoc(RETURN_CODE.equals(type) ? "\u65e0" : "\u6709");
            }
            if (StringUtil.isNotBlank((CharSequence)crmAgreement.getQualityDoc())) {
                type = crmAgreement.getQualityDoc();
                crmAgreement.setQualityDoc(RETURN_CODE.equals(type) ? "\u65e0" : "\u6709");
            }
            if (StringUtil.isNotBlank((CharSequence)crmAgreement.getOtherDoc())) {
                type = crmAgreement.getOtherDoc();
                crmAgreement.setOtherDoc(RETURN_CODE.equals(type) ? "\u65e0" : "\u6709");
            }
            crmAgreement.setFlowStatus(ContractAgreementStatusEnum.getDescriptionByStatus(crmAgreement.getFlowStatus()));
            if (StringUtil.isNotBlank((CharSequence)crmAgreement.getProcessNode()) && Integer.valueOf(crmAgreement.getProcessNode()) > 6) {
                crmAgreement.setProcessNode("\u5408\u540c\u76d6\u7ae0");
            } else {
                crmAgreement.setProcessNode("\u6240\u7ea7\u8bc4\u5ba1");
            }
            if (null != areaDic) {
                crmAgreement.setArea(areaDic.get(crmAgreement.getArea()));
            }
            if (null != productionStatusDic) {
                crmAgreement.setProductionStatus(productionStatusDic.get(crmAgreement.getProductionStatus()));
            }
            if (StringUtil.isBlank((CharSequence)crmAgreement.getMasterContractId())) {
                crmAgreement.setAddContractFlag("\u5426");
            } else {
                crmAgreement.setAddContractFlag("\u662f");
                int lastDashIndex = crmAgreement.getAgreementNumber().lastIndexOf("-");
                if (lastDashIndex != -1) {
                    crmAgreement.setMasterContractNumber(crmAgreement.getAgreementNumber().substring(0, lastDashIndex));
                }
            }
            if (null != ProTypeDic) {
                crmAgreement.setProductType(ProTypeDic.get(crmAgreement.getProductType()));
            }
            if (null == productModelDic) continue;
            crmAgreement.setProductModel(productModelDic.get(crmAgreement.getProductModel()));
        }
    }

    private void translateToDictionary(List<CrmAgreement> list) {
        Map<String, String> YesNoDic = this.sysDicRefService.getDicListByType("yes_no").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
        Map<String, String> CateDic = this.sysDicRefService.getDicListByType("military_contracts_type").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
        Map<String, String> TypeDic = this.sysDicRefService.getDicListByType("contract_type").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
        Map<String, String> SecureDic = this.sysDicRefService.getDicListByType("security_level").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
        Map<String, String> ProTypeDic = this.sysDicRefService.getDicListByType("product_type").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
        Map<String, String> FieldTypeDic = this.sysDicRefService.getDicListByType("area").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
        Map<String, String> ProductionStatusTypeDic = this.sysDicRefService.getDicListByType("productionStatus").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
        Map<String, String> signDic = this.sysDicRefService.getDicListByType("sign_or_transform").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
        Map<String, String> priceMethodDic = this.sysDicRefService.getDicListByType("price_method").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
        Map<String, String> productModelDic = this.sysDicRefService.getDicListByType("product_model").stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue, (oldValue, newValue) -> oldValue));
        for (CrmAgreement crmAgreement : list) {
            String type;
            if (YesNoDic != null) {
                crmAgreement.setSpecialFlag(this.getDictValueVtLabel(YesNoDic, crmAgreement.getSpecialFlag()));
                crmAgreement.setAddContractFlag(this.getDictValueVtLabel(YesNoDic, crmAgreement.getAddContractFlag()));
                crmAgreement.setIfDutyProject(this.getDictValueVtLabel(YesNoDic, crmAgreement.getIfDutyProject()));
                crmAgreement.setIfNewProduct(this.getDictValueVtLabel(YesNoDic, crmAgreement.getIfNewProduct()));
                crmAgreement.setBidProductFlag(this.getDictValueVtLabel(YesNoDic, crmAgreement.getBidProductFlag()));
                crmAgreement.setIfAppraisal(this.getDictValueVtLabel(YesNoDic, crmAgreement.getIfAppraisal()));
                crmAgreement.setIfMilitaryInspection(this.getDictValueVtLabel(YesNoDic, crmAgreement.getIfMilitaryInspection()));
                crmAgreement.setArea(this.getDictValueVtLabel(FieldTypeDic, crmAgreement.getArea()));
                crmAgreement.setIfNewSigning(this.getDictValueVtLabel(signDic, crmAgreement.getIfNewSigning()));
                crmAgreement.setProductionStatus(this.getDictValueVtLabel(ProductionStatusTypeDic, crmAgreement.getProductionStatus()));
                crmAgreement.setIfReceive(this.getDictValueVtLabel(YesNoDic, crmAgreement.getIfReceive()));
                crmAgreement.setSubordinateSupervision(this.getDictValueVtLabel(YesNoDic, crmAgreement.getSubordinateSupervision()));
                crmAgreement.setIfFourteenFiveProject(this.getDictValueVtLabel(YesNoDic, crmAgreement.getIfFourteenFiveProject()));
                crmAgreement.setFormalAgreementFlag(this.getDictValueVtLabel(YesNoDic, crmAgreement.getFormalAgreementFlag()));
            }
            if (CateDic != null) {
                crmAgreement.setAgreementCategory(this.getDictValueVtLabel(CateDic, crmAgreement.getAgreementCategory()));
            }
            if (TypeDic != null) {
                crmAgreement.setAgreementType(this.getDictValueVtLabel(TypeDic, crmAgreement.getAgreementType()));
            }
            if (SecureDic != null) {
                crmAgreement.setSecurityLevelLabel(this.getDictValueVtLabel(SecureDic, crmAgreement.getSecurityLevelLabel()));
            }
            if (StringUtil.isNotBlank((CharSequence)crmAgreement.getTechnicalDoc())) {
                type = crmAgreement.getTechnicalDoc();
                if ("\u65e0".equals(type)) {
                    crmAgreement.setTechnicalDoc(RETURN_CODE);
                } else if ("\u6709".equals(type)) {
                    crmAgreement.setTechnicalDoc("1");
                } else {
                    crmAgreement.setTechnicalDoc("-1");
                }
            }
            if (StringUtil.isNotBlank((CharSequence)crmAgreement.getQualityDoc())) {
                type = crmAgreement.getQualityDoc();
                if ("\u65e0".equals(type)) {
                    crmAgreement.setQualityDoc(RETURN_CODE);
                } else if ("\u6709".equals(type)) {
                    crmAgreement.setQualityDoc("1");
                } else {
                    crmAgreement.setQualityDoc("-1");
                }
            }
            if (StringUtil.isNotBlank((CharSequence)crmAgreement.getOtherDoc())) {
                type = crmAgreement.getOtherDoc();
                if ("\u65e0".equals(type)) {
                    crmAgreement.setOtherDoc(RETURN_CODE);
                } else if ("\u6709".equals(type)) {
                    crmAgreement.setOtherDoc("1");
                } else {
                    crmAgreement.setOtherDoc("-1");
                }
            }
            if (null != priceMethodDic) {
                crmAgreement.setPriceMethod(this.getDictValueVtLabel(priceMethodDic, crmAgreement.getPriceMethod()));
            }
            if (null == ProTypeDic) continue;
            crmAgreement.setProductType(this.getDictValueVtLabel(ProTypeDic, crmAgreement.getProductType()));
        }
    }

    private String getDictValueVtLabel(Map<String, String> dictMap, String lable) {
        if (StringUtil.isNotEmpty((Object)lable)) {
            if (StringUtil.isNotEmpty((Object)dictMap.get(lable))) {
                return dictMap.get(lable);
            }
            return "-1," + lable;
        }
        return null;
    }
}

