/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.contract.crmagreement.controller;

import cn.hutool.core.io.resource.ResourceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.plugin.table.LoopRowTableRenderPolicy;
import com.deepoove.poi.policy.RenderPolicy;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementAssociativeQueryDto;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementCrmagreementdataset1;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementDto;
import com.jxdinfo.crm.transaction.contract.crmagreement.dto.CrmAgreementPageDto;
import com.jxdinfo.crm.transaction.contract.crmagreement.model.CrmAgreement;
import com.jxdinfo.crm.transaction.contract.crmagreement.service.CrmAgreementImportAndExportService;
import com.jxdinfo.crm.transaction.contract.crmagreement.service.CrmAgreementService;
import com.jxdinfo.crm.transaction.contract.crmagreement.vo.CrmAgreementPageVo;
import com.jxdinfo.crm.transaction.contract.crmagreement.vo.CrmAgreementWarningPageVO;
import com.jxdinfo.crm.transaction.modelmanage.crmmodelmanage.model.CrmModelManage;
import com.jxdinfo.crm.transaction.modelmanage.crmmodelmanage.service.CrmModelManageService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="contract.crmagreement.CrmAgreementController")
@AuditLog(moduleName="\u5408\u540c\u8868")
@RequestMapping(value={"/contract/crmAgreement"})
public class CrmAgreementController
extends HussarBaseController<CrmAgreement, CrmAgreementService> {
    private static final Logger logger = LoggerFactory.getLogger(CrmAgreementController.class);
    @Autowired
    private CrmAgreementService crmAgreementService;
    @Autowired
    private CrmAgreementImportAndExportService importAndExportService;
    @Autowired
    private CrmModelManageService crmModelManageService;

    @AuditLog(moduleName="\u5408\u540c\u8868", eventDesc="\u8868\u5355\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"formQuery"})
    public ApiResponse<CrmAgreement> formQuery(@RequestParam(value="id") String id) {
        return this.crmAgreementService.formQuery(id);
    }

    @AuditLog(moduleName="\u5408\u540c\u8868", eventDesc="\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/flowFormSubmit"})
    public ApiResponse<String> flowFormSubmit(@RequestBody CrmAgreementDto crmAgreementDto) {
        return this.crmAgreementService.flowFormSubmit(crmAgreementDto);
    }

    @AuditLog(moduleName="\u5408\u540c\u8868", eventDesc="\u9a73\u56de\u81f3\u4e0a\u4e00\u8282\u70b9", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/prevNodeReject"})
    public ApiResponse<String> prevNodeReject(@RequestBody CrmAgreementDto crmAgreementDto) {
        return this.crmAgreementService.prevNodeReject(crmAgreementDto);
    }

    @AuditLog(moduleName="\u5408\u540c\u8868", eventDesc="\u5217\u8868\u5206\u9875\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/listPage"})
    public ApiResponse<Page<CrmAgreement>> listPage(@RequestBody CrmAgreementPageDto crmAgreementPageDto) {
        Page<CrmAgreement> page = this.crmAgreementService.listPage(crmAgreementPageDto);
        return ApiResponse.success(page);
    }

    @AuditLog(moduleName="\u5408\u540c\u8868", eventDesc="\u5217\u8868\u5206\u9875\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/listPageNew"})
    public ApiResponse<CrmAgreementPageVo> listPageNew(@RequestBody CrmAgreementPageDto crmAgreementPageDto) {
        return this.crmAgreementService.listPageNew(crmAgreementPageDto);
    }

    @AuditLog(moduleName="\u8ba1\u5212\u4e0b\u53d1\u9009\u62e9\u5408\u540c", eventDesc="\u5217\u8868\u5206\u9875\u67e5\u8be2", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @PostMapping(value={"/selectAgreementForPlan"})
    public CrmAgreementPageVo selectAgreementForPlan(@RequestBody CrmAgreementPageDto crmAgreementPageDto) {
        return this.crmAgreementService.selectAgreementForPlan(crmAgreementPageDto);
    }

    @AuditLog(moduleName="\u5408\u540c\u8868", eventDesc="\u66f4\u65b0", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/update"})
    public ApiResponse<String> update(@RequestBody CrmAgreement entity) {
        return this.crmAgreementService.updateCrmAgreement(entity);
    }

    @GetMapping(value={"/operate"})
    @ApiOperation(value="\u6743\u9650\u7ba1\u7406", notes="\u6743\u9650\u7ba1\u7406")
    @AuditLog(moduleName="\u5408\u540c\u7ba1\u7406", eventDesc="\u6743\u9650\u7ba1\u7406", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<OperateVo> operate(@RequestParam(value="agreementId") @ApiParam(value="\u5408\u540cID") Long agreementId) {
        return ApiResponse.success((Object)this.crmAgreementService.operate(agreementId));
    }

    @AuditLog(moduleName="\u5408\u540c\u8868", eventDesc="\u5408\u540c\u9884\u8b66", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/agreementWarning"})
    public ApiResponse<CrmAgreementWarningPageVO> agreementWarning(@RequestBody CrmAgreementPageDto pageDto) {
        return ApiResponse.success((Object)this.crmAgreementService.agreementWarning(pageDto));
    }

    @AuditLog(moduleName="\u5408\u540c\u8868", eventDesc="\u5408\u540c\u9884\u8b66", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/exportAgreementWarning"})
    public String exportAgreementWarning(HttpServletResponse response, @RequestBody CrmAgreementPageDto pageDto) {
        return this.crmAgreementService.exportAgreementWarning(response, pageDto);
    }

    @AuditLog(moduleName="\u67e5\u8be2\u9886\u57df", eventDesc="\u67e5\u8be2\u9886\u57df", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/queryManageByFieldkey"})
    public ApiResponse queryManageByFieldkey(@RequestParam(value="fieldKey") @ApiParam(value="\u9886\u57df\u5b57\u5178\u503c") String fieldKey) {
        LambdaQueryWrapper qw = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(CrmModelManage::getDelFlag, (Object)"0");
        if (HussarUtils.isNotEmpty((Object)fieldKey)) {
            qw.eq(CrmModelManage::getFieldKey, (Object)fieldKey);
        }
        List list = this.crmModelManageService.list((Wrapper)qw);
        List distinctList = list.stream().collect(Collectors.toMap(CrmModelManage::getModelManageName, Function.identity(), (existing, replacement) -> existing)).values().stream().collect(Collectors.toList());
        return ApiResponse.success(distinctList);
    }

    @AuditLog(moduleName="\u5408\u540c\u8868\u6279\u91cf\u66f4\u65b0\u751f\u4ea7\u72b6\u6001", eventDesc="\u66f4\u65b0", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @PostMapping(value={"/batchUpdate"})
    public ApiResponse<String> batchUpdate(@RequestBody List<String> agreementIdList) {
        List crmAgreements = this.crmAgreementService.listByIds(agreementIdList);
        boolean b = crmAgreements.stream().anyMatch(one -> "1".equals(one.getAbandonState()));
        if (b) {
            return ApiResponse.fail((String)"\u5df2\u88ab\u4f5c\u5e9f\u7684\u5408\u540c\u4e0d\u53ef\u66f4\u6539\u4e3a\u5df2\u4ea4\u4ed8\u72b6\u6001");
        }
        boolean c = crmAgreements.stream().anyMatch(one -> !"4".equals(one.getFlowStatus()));
        if (c) {
            return ApiResponse.fail((String)"\u672a\u901a\u8fc7\u5ba1\u6279\u7684\u5408\u540c\u4e0d\u53ef\u66f4\u6539\u4e3a\u5df2\u4ea4\u4ed8\u72b6\u6001");
        }
        crmAgreements.stream().forEach(one -> one.setProductionStatus("4"));
        this.crmAgreementService.updateBatchById(crmAgreements);
        return ApiResponse.success();
    }

    @PostMapping(value={"/importProductionStatus"})
    @ApiOperation(value="\u5408\u540c\u751f\u4ea7\u72b6\u6001\u5bfc\u5165", notes="\u5408\u540c\u751f\u4ea7\u72b6\u6001\u5bfc\u5165")
    @AuditLog(moduleName="\u5408\u540c\u7ba1\u7406", eventDesc="\u5408\u540c\u751f\u4ea7\u72b6\u6001\u5bfc\u5165", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public ApiResponse<String> importProductionStatus(@RequestBody @ApiParam(value="\u6587\u4ef6\u7c7b") MultipartFile file) {
        return this.crmAgreementService.agreementImport(file);
    }

    @PostMapping(value={"downProductionStatusTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u5408\u540c\u751f\u4ea7\u72b6\u6001\u5bfc\u5165\u6a21\u677f", notes="\u4e0b\u8f7d\u5408\u540c\u751f\u4ea7\u72b6\u6001\u5bfc\u5165\u6a21\u677f")
    @AuditLog(moduleName="\u5408\u540c\u7ba1\u7406", eventDesc="\u4e0b\u8f7d\u5408\u540c\u751f\u4ea7\u72b6\u6001\u5bfc\u5165\u6a21\u677f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public void downProductionStatusTemplate(@ApiParam(value="\u670d\u52a1\u5668\u54cd\u5e94\u7c7b") HttpServletResponse response) {
        this.crmAgreementService.agreementImportTemplate(response);
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u5408\u540c\u5bfc\u5165", notes="\u5408\u540c\u5bfc\u5165")
    @AuditLog(moduleName="\u5408\u540c\u7ba1\u7406", eventDesc="\u5408\u540c\u5bfc\u5165", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public ApiResponse<String> opportunityImport(@RequestBody @ApiParam(value="\u6587\u4ef6\u7c7b") MultipartFile file) {
        return this.importAndExportService.contractAgreementImport(file);
    }

    @PostMapping(value={"/importTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u5408\u540c\u5bfc\u5165\u6a21\u677f", notes="\u4e0b\u8f7d\u5408\u540c\u5bfc\u5165\u6a21\u677f")
    @AuditLog(moduleName="\u5408\u540c\u7ba1\u7406", eventDesc="\u4e0b\u8f7d\u5408\u540c\u5bfc\u5165\u6a21\u677f", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public void opportunityImportTemplate(@ApiParam(value="\u670d\u52a1\u5668\u54cd\u5e94\u7c7b") HttpServletResponse response) {
        this.importAndExportService.contractAgreementImportTemplate(response);
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5408\u540c\u7ba1\u7406\u5bfc\u51fa", notes="\u5408\u540c\u7ba1\u7406\u5bfc\u51fa")
    @AuditLog(moduleName="\u5408\u540c\u7ba1\u7406", eventDesc="\u5408\u540c\u7ba1\u7406\u5bfc\u51fa", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.NULL_EVENT_TYPE)
    public void exportCrmAgreementData(@ApiParam(value="\u670d\u52a1\u5668\u54cd\u5e94\u7c7b") HttpServletResponse response, @RequestBody @ApiParam(value="\u5408\u540cdto") CrmAgreementPageDto dto) {
        this.importAndExportService.contractAgreementExport(response, dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/downloadAgreement/{agreementId}"})
    public void downloadAgreement(HttpServletResponse response, @PathVariable(value="agreementId") String agreementId) {
        CrmAgreement agreement = this.crmAgreementService.downloadAgreement(agreementId);
        String templatePath = "classpath:template/agreement_template.docx";
        response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        response.setCharacterEncoding("UTF-8");
        String fileName = "agreement_" + agreementId + ".docx";
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        LoopRowTableRenderPolicy product = new LoopRowTableRenderPolicy();
        LoopRowTableRenderPolicy process = new LoopRowTableRenderPolicy();
        Configure config = Configure.builder().bind("crmAgreementProduct", (RenderPolicy)product).bind("processList", (RenderPolicy)process).build();
        XWPFTemplate template = null;
        try (InputStream is = ResourceUtil.getStream((String)templatePath);
             ServletOutputStream out = response.getOutputStream();){
            template = XWPFTemplate.compile((InputStream)is, (Configure)config).render((Object)agreement);
            if (null == agreement.getCrmAgreementProduct() || agreement.getCrmAgreementProduct().size() == 0) {
                XWPFTable xwpfTable = (XWPFTable)template.getXWPFDocument().getTables().get(0);
                XWPFTableRow newRow = xwpfTable.insertNewTableRow(9);
                for (int i = 0; i < 5; ++i) {
                    newRow.createCell();
                }
                if (newRow.getCell(0) != null) {
                    this.setCellTextWithFont(newRow.getCell(0), "\u4ea7\u54c1\u540d\u79f0", "\u5b8b\u4f53");
                }
                if (newRow.getCell(2) != null) {
                    this.setCellTextWithFont(newRow.getCell(2), "\u4ea7\u54c1\u6570\u91cf", "\u5b8b\u4f53");
                }
                if (newRow.getCell(4) != null) {
                    this.setCellTextWithFont(newRow.getCell(4), "\u8ba1\u91cf\u5355\u4f4d", "\u5b8b\u4f53");
                }
            }
            template.write((OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(500);
        }
        finally {
            if (template != null) {
                try {
                    template.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void setCellTextWithFont(XWPFTableCell cell, String text, String fontFamily) {
        cell.removeParagraph(0);
        XWPFParagraph paragraph = cell.addParagraph();
        XWPFRun run = paragraph.createRun();
        run.setText(text);
        run.setFontFamily(fontFamily);
    }

    @PostMapping(value={"/associativeQuery"})
    @ApiOperation(value="\u5408\u540c\u7ba1\u7406\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", notes="\u5408\u540c\u7ba1\u7406\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u5408\u540c\u7ba1\u7406", eventDesc="\u5408\u540c\u7ba1\u7406\u667a\u80fd\u68c0\u7d22\u67e5\u8be2\u6761\u4ef6", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AssociativeQueryVo>> associativeQuery(@RequestBody CrmAgreementAssociativeQueryDto dto) {
        return ApiResponse.success(this.crmAgreementService.associativeQuery(dto));
    }

    @GetMapping(value={"/statisticsByMonth"})
    @ApiOperation(value="\u7edf\u8ba1\u6bcf\u6708\u65b0\u589e\u5408\u540c\u6570\u91cf", notes="\u7edf\u8ba1\u6bcf\u6708\u65b0\u589e\u5408\u540c\u6570\u91cf")
    @AuditLog(moduleName="\u5408\u540c\u7ba1\u7406", eventDesc="\u7edf\u8ba1\u6bcf\u6708\u65b0\u589e\u5408\u540c\u6570\u91cf", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Map<String, String>>> statisticsByMonth() {
        return ApiResponse.success(this.crmAgreementService.statisticsByMonth());
    }

    @GetMapping(value={"/currentAgreement"})
    @ApiOperation(value="\u6700\u8fd1\u4e00\u5e74\u65b0\u589e\u7684\u5408\u540c", notes="\u6700\u8fd1\u4e00\u5e74\u65b0\u589e\u7684\u5408\u540c")
    @AuditLog(moduleName="\u5408\u540c\u7ba1\u7406", eventDesc="\u6700\u8fd1\u4e00\u5e74\u65b0\u589e\u7684\u5408\u540c", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CrmAgreement>> currentAgreement() {
        List<CrmAgreement> list = this.crmAgreementService.currentAgreement();
        return ApiResponse.success(list);
    }

    @GetMapping(value={"/statisticsByCategory"})
    @ApiOperation(value="\u6309\u7167\u9879\u76ee\u5206\u7c7b\u7edf\u8ba1", notes="\u6309\u7167\u9879\u76ee\u5206\u7c7b\u7edf\u8ba1")
    @AuditLog(moduleName="\u5408\u540c\u7ba1\u7406", eventDesc="\u6309\u7167\u9879\u76ee\u5206\u7c7b\u7edf\u8ba1", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Map<String, String>>> statisticsByCategory() {
        return ApiResponse.success(this.crmAgreementService.statisticsByCategory());
    }

    @PostMapping(value={"/transferChargePerson"})
    @ApiOperation(value="\u8f6c\u79fb\u8d1f\u8d23\u4eba", notes="\u8f6c\u79fb\u8d1f\u8d23\u4eba")
    @AuditLog(moduleName="\u5408\u540c\u7ba1\u7406", eventDesc="\u8f6c\u79fb\u8d1f\u8d23\u4eba", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse transferChargePerson(@RequestBody CrmAgreementCrmagreementdataset1 dto) {
        return this.crmAgreementService.transferChargePerson(dto);
    }
}

