/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.transaction.bid.zcbid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.dataRightManage.vo.OperateVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.organUser.IStruUserAPIService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.operateRecord.DataCompareUtils;
import com.jxdinfo.crm.core.api.fileinfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.api.teammember.service.ITeamMemberApiService;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.transaction.bid.zcbid.constants.BidStatusEnum;
import com.jxdinfo.crm.transaction.bid.zcbid.constants.BidStepEnum;
import com.jxdinfo.crm.transaction.bid.zcbid.dao.ZcbidMapper;
import com.jxdinfo.crm.transaction.bid.zcbid.dto.ZcbidDto;
import com.jxdinfo.crm.transaction.bid.zcbid.model.Zcbid;
import com.jxdinfo.crm.transaction.bid.zcbid.service.ZcbidService;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.common.designer.vo.ResultProcessVO;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="bid.zcbid.ZcbidServiceImpl")
@HussarTokenDs
public class ZcbidServiceImpl
extends HussarServiceImpl<ZcbidMapper, Zcbid>
implements ZcbidService {
    private static final Logger logger = LoggerFactory.getLogger(ZcbidServiceImpl.class);
    private static final String RETURN_CODE = "0";
    private static final String ORDER_RULE = "orderRule";
    private static final String DEFAULT_ORDER_RULE = "defaultOrderRule";
    private static final String ASC = ",asc;";
    private static final String DESC = ",desc;";
    @Resource
    private IStruUserAPIService struUserAPIService;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private IFileInfoAPIService fileInfoAPIService;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private ITeamMemberApiService teamMemberApiService;

    public List<Zcbid> getByMap(Map<String, Object> map) {
        return this.list((Wrapper)new LambdaQueryWrapper(BeanUtil.copy(map, Zcbid.class)));
    }

    @Override
    public ApiResponse<Zcbid> formQuery(String id) {
        try {
            return ApiResponse.success((Object)this.getById((Serializable)((Object)id)));
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> flowFormSubmit(ZcbidDto zcbidDto) {
        Zcbid zcbid = zcbidDto.getFormdata();
        try {
            SecurityUser user = BaseSecurityUtil.getUser();
            String userName = user.getUserName();
            if (HussarUtils.isEmpty((Object)zcbid.getBidId())) {
                if (StringUtil.isNotEmpty((Object)zcbid.getSuffixId())) {
                    zcbid.setBidId(zcbid.getSuffixId());
                } else {
                    Long bidId = Long.parseLong(CommonUtills.generateAssignId());
                    zcbid.setBidId(bidId);
                }
                zcbid.setDelState(RETURN_CODE);
                zcbid.setCreateTime(LocalDateTime.now());
                zcbid.setCreateUser(user.getUserId());
                zcbid.setCreateUserName(userName);
                zcbid.setCreateDepartment(user.getDeptId());
                zcbid.setCreateDepartmentName(user.getDeptName());
                SysStru companyInfo = this.struUserAPIService.getCompanyInfoByCurrentDeptId(BaseSecurityUtil.getUser().getDeptId().toString());
                zcbid.setCreateUnit(companyInfo.getId());
                zcbid.setCreateUnitName(companyInfo.getOrganAlias());
                zcbid.setCreateTime(LocalDateTime.now());
                zcbid.setOwnUnit(companyInfo.getId());
                zcbid.setOwnUnitName(companyInfo.getOrganAlias());
                zcbid.setFlowStatus(BidStatusEnum.BID_STATUS_CHECK_ING.getBidtatus());
                zcbid.setProcessState("1");
                zcbid.setProcessKey("bpm_tbsp");
                zcbid.setProcessNode(BidStepEnum.BID_STEP_SLD_CHECK.getBidStep());
                zcbid.setProcessStartTime(LocalDateTime.now());
                Long chargePersonId = zcbid.getChargePerson();
                String chargePersonName = zcbid.getChargePersonName();
                if (chargePersonId != null && chargePersonName != null) {
                    zcbid.setChargePerson(chargePersonId);
                    zcbid.setChargePersonName(chargePersonName);
                    this.teamMeberService.insertTeamMember(zcbid.getChargePersonName(), zcbid.getChargePerson(), zcbid.getBidId(), "1", "1", LocalDateTime.now(), "31");
                }
                this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.BID, zcbid.getBidId(), zcbid.getBidName(), LocalDateTime.now(), false, Arrays.asList(zcbid.getBidId()));
                zcbid.setState("1");
                zcbid.setBidStage("1");
            } else {
                Zcbid oldBid = (Zcbid)this.getById(zcbid.getBidId());
                zcbid.setUpdateUser(user.getUserId());
                zcbid.setUpdateUserName(userName);
                zcbid.setUpdateTime(LocalDateTime.now());
                if (BidStepEnum.BID_STEP_APPLY.getBidStep().equals(zcbid.getProcessNode())) {
                    zcbid.setFlowStatus(BidStatusEnum.BID_STATUS_CHECK_ING.getBidtatus());
                    zcbid.setProcessState("1");
                    zcbid.setProcessKey("bpm_tbsp");
                    zcbid.setProcessNode(BidStepEnum.BID_STEP_SLD_CHECK.getBidStep());
                    zcbid.setProcessStartTime(LocalDateTime.now());
                    this.fileInfoAPIService.deleteHighSecurityLevelFileInfo(zcbid.getBidId(), zcbid.getSecurityLevel());
                    this.taskAPIService.updateTaskSecurityLevel(zcbid.getBidId(), zcbid.getSecurityLevel());
                    this.fileInfoAPIService.updateTrackFileInfoSecurityLevel(zcbid.getBidId(), zcbid.getSecurityLevel());
                } else if (BidStepEnum.BID_STEP_SLD_CHECK.getBidStep().equals(zcbid.getProcessNode())) {
                    zcbid.setProcessNode(BidStepEnum.BID_STEP_JGCLD_CHECK.getBidStep());
                } else if (BidStepEnum.BID_STEP_JGCLD_CHECK.getBidStep().equals(zcbid.getProcessNode())) {
                    zcbid.setProcessNode(BidStepEnum.BID_STEP_SJLD_CHECK.getBidStep());
                } else if (BidStepEnum.BID_STEP_SJLD_CHECK.getBidStep().equals(zcbid.getProcessNode())) {
                    zcbid.setProcessNode(BidStepEnum.BID_STEP_FINISH.getBidStep());
                    zcbid.setProcessState("2");
                    zcbid.setFlowStatus(BidStatusEnum.BID_STATUS_CHECK_FINISHED.getBidtatus());
                }
                Map map = DataCompareUtils.getRecordInfo((Object)oldBid, (Object)zcbid);
                if (((String)map.get("changeFlag")).equals("true")) {
                    OperateRecordAPIVo trackRecord = this.operateRecordAPIService.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), (String)map.get("oldJson"), (String)map.get("newJson"), (String)map.get("changeFieldStr"));
                    trackRecord.setChangeBatch(1);
                    this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.BID, Long.valueOf(oldBid.getBidId()), oldBid.getBidName(), LocalDateTime.now(), false, null);
                }
            }
            boolean resultFlag = this.saveOrUpdate(zcbid);
            if (!resultFlag) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
        this.formsubmit(zcbidDto, String.valueOf(zcbid.getBidId()));
        return ApiResponse.success((Object)String.valueOf(zcbid.getBidId()), (String)"\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355\u6210\u529f");
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public void formsubmit(ZcbidDto zcbidDto, String businessKey) {
        BpmResponseResult bpmResponseResult;
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        HashMap<String, String> appointMap = new HashMap<String, String>();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        String taskId = zcbidDto.getTaskId();
        String comment = zcbidDto.getComment();
        if (zcbidDto.getFlowSelect() == null) {
            appointMap.put("static_appoint_assignee", zcbidDto.getParticipantSelect());
        } else {
            appointMap.put(zcbidDto.getFlowSelect(), zcbidDto.getParticipantSelect());
            variable.put("bpm_next_node", zcbidDto.getFlowSelect());
        }
        if (zcbidDto.getFormdata() != null && HussarUtils.isNotEmpty((Object)zcbidDto.getFormdata().getSecurityLevel())) {
            variable.put("security_level", zcbidDto.getFormdata().getSecurityLevel());
        }
        if (zcbidDto.getSelectBranches() != null) {
            ArrayList<String> nextNodeIds = new ArrayList<String>();
            HashMap<String, String> multiTypeMap = new HashMap<String, String>();
            for (Map<String, String> map : zcbidDto.getSelectBranches()) {
                appointMap.put(map.get("flowSelect"), map.get("participants"));
                if (HussarUtils.isNotEmpty((Object)map.get("multiNodeType"))) {
                    multiTypeMap.put(map.get("flowSelect"), map.get("multiNodeType"));
                }
                nextNodeIds.add(map.get("flowSelect"));
            }
            if (HussarUtils.isNotEmpty(multiTypeMap)) {
                variable.put("multi_node_type", multiTypeMap);
            }
            variable.put("bpm_next_node", String.join((CharSequence)",", nextNodeIds));
        }
        String processDefinitionKey = zcbidDto.getProcessDefinitionKey();
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        if (HussarUtils.isEmpty((Object)taskId)) {
            String deptId = BaseSecurityUtil.getUser().getDeptId() == null ? "" : String.valueOf(BaseSecurityUtil.getUser().getDeptId());
            BpmResponseResult startResult = InstanceEngineService.startProcessInstanceByKey((String)processDefinitionKey, (String)userId, (String)deptId, (String)businessKey, variable);
            if ("1".equals(startResult.getCode())) {
                taskId = (String)startResult.getResult().getJSONObject(0).get((Object)"taskId");
            } else {
                throw new HussarException(startResult.getMsg());
            }
        }
        if (!"1".equals((bpmResponseResult = TaskEngineService.completeTask((String)taskId, (String)userId, appointMap, null, (String)comment, variable)).getCode())) {
            throw new HussarException(bpmResponseResult.getMsg());
        }
        Zcbid byId = (Zcbid)this.getById((Serializable)((Object)businessKey));
        if (!"\u7ed3\u675f".equals(bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskDefinitionName"))) {
            taskId = (String)bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskId");
            byId.setProcessInstId(taskId);
        } else {
            byId.setFlowStatus(BidStatusEnum.BID_STATUS_CHECK_FINISHED.getBidtatus());
            byId.setProcessNode(BidStepEnum.BID_STEP_FINISH.getBidStep());
        }
        this.saveOrUpdate(byId);
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> prevNodeReject(ZcbidDto zcbidDto) {
        try {
            String comment;
            Zcbid zcbid = zcbidDto.getFormdata();
            String taskId = zcbidDto.getTaskId() == null ? "" : zcbidDto.getTaskId();
            String string = comment = zcbidDto.getComment() == null ? "" : zcbidDto.getComment();
            if (BidStepEnum.BID_STEP_SLD_CHECK.getBidStep().equals(zcbid.getProcessNode())) {
                zcbid.setProcessNode(BidStepEnum.BID_STEP_APPLY.getBidStep());
                zcbid.setFlowStatus(BidStatusEnum.BID_STATUS_REJECT_SUBMIT.getBidtatus());
            } else if (BidStepEnum.BID_STEP_JGCLD_CHECK.getBidStep().equals(zcbid.getProcessNode())) {
                zcbid.setProcessNode(BidStepEnum.BID_STEP_SLD_CHECK.getBidStep());
            } else if (BidStepEnum.BID_STEP_SJLD_CHECK.getBidStep().equals(zcbid.getProcessNode())) {
                zcbid.setProcessNode(BidStepEnum.BID_STEP_JGCLD_CHECK.getBidStep());
            }
            boolean resultFlag = this.saveOrUpdate(zcbid);
            if (!resultFlag) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
            ApiResponse<String> stringApiResponse = this.startAnyNodeRejectInstance(taskId, comment);
            taskId = stringApiResponse.getMsg();
            zcbid.setProcessInstId(taskId);
            this.saveOrUpdate(zcbid);
            return ApiResponse.success((String)"");
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public ApiResponse<String> startAnyNodeRejectInstance(String taskId, String comment) {
        if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
            throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        try {
            BpmResponseResult bpmResponseResult = TaskEngineService.rejectToLastTask((String)taskId, (String)userId, (String)comment, null, (boolean)true, null);
            if ("1".equals(bpmResponseResult.getCode())) {
                return ApiResponse.success((String)((String)bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskId")));
            }
            throw new HussarException(bpmResponseResult.getMsg());
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<ResultProcessVO> flowFormSaveStart(ZcbidDto zcbidDto) {
        try {
            Integer securityLevel;
            Zcbid zcbid = zcbidDto.getFormdata();
            String processDefinitionKey = zcbidDto.getProcessDefinitionKey() == null ? "" : zcbidDto.getProcessDefinitionKey();
            boolean resultFlag = this.saveOrUpdate(zcbid);
            if (!resultFlag) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
            String businessKey = String.valueOf(zcbid.getBidId());
            ApiResponse<ResultProcessVO> flowApiResponse = this.startSaveProcessInstance(processDefinitionKey, businessKey, securityLevel = HussarUtils.isEmpty((Object)zcbid.getSecurityLevel()) ? null : Integer.valueOf(zcbid.getSecurityLevel()));
            if (flowApiResponse.isSuccess()) {
                return ApiResponse.success((Object)flowApiResponse.getData());
            }
            throw new HussarException(flowApiResponse.getMsg());
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    @HussarTokenDs
    public ApiResponse<ResultProcessVO> startSaveProcessInstance(String processDefinitionKey, String businessKey, Integer securityLevel) {
        ResultProcessVO resultProcessVO = new ResultProcessVO();
        resultProcessVO.setProcessKey(processDefinitionKey);
        resultProcessVO.setBusinessId(businessKey);
        try {
            BpmResponseResult isstartResult = InstanceEngineService.checkProcessInstByBusinessKey((String)businessKey);
            if ("1".equals(isstartResult.getCode())) {
                if (HussarUtils.isEmpty((Object)BaseSecurityUtil.getUser())) {
                    throw new HussarException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                }
                String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
                String deptId = BaseSecurityUtil.getUser().getDeptId() == null ? "" : String.valueOf(BaseSecurityUtil.getUser().getDeptId());
                HashMap<String, Integer> variables = new HashMap<String, Integer>();
                variables.put("security_level", securityLevel);
                BpmResponseResult startResult = InstanceEngineService.startProcessInstanceByKey((String)processDefinitionKey, (String)userId, (String)deptId, (String)businessKey, variables);
                if ("1".equals(startResult.getCode())) {
                    if (HussarUtils.isNotEmpty((Object)startResult.getResult()) && HussarUtils.isNotEmpty((Object)startResult.getResult().get(0))) {
                        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)startResult.getResult().get(0)));
                        resultProcessVO.setTaskDefKey(jsonObject.getString("taskDefinitionKey"));
                        resultProcessVO.setTaskId(jsonObject.getString("taskId"));
                        resultProcessVO.setTaskType(jsonObject.getString("taskType"));
                    }
                    return ApiResponse.success((Object)resultProcessVO);
                }
                throw new HussarException(startResult.getMsg());
            }
            return ApiResponse.success((Object)resultProcessVO);
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> insertOrUpdate(Zcbid zcbid) {
        try {
            SecurityUser user = BaseSecurityUtil.getUser();
            String userName = user.getUserName();
            if (HussarUtils.isEmpty((Object)zcbid.getBidId())) {
                if (StringUtil.isNotEmpty((Object)zcbid.getSuffixId())) {
                    zcbid.setBidId(zcbid.getSuffixId());
                } else {
                    Long bidId = Long.parseLong(CommonUtills.generateAssignId());
                    zcbid.setBidId(bidId);
                }
                zcbid.setDelState(RETURN_CODE);
                zcbid.setCreateTime(LocalDateTime.now());
                zcbid.setCreateUser(user.getUserId());
                zcbid.setCreateUserName(userName);
                zcbid.setCreateDepartment(user.getDeptId());
                zcbid.setCreateDepartmentName(user.getDeptName());
                SysStru companyInfo = this.struUserAPIService.getCompanyInfoByCurrentDeptId(BaseSecurityUtil.getUser().getDeptId().toString());
                zcbid.setCreateUnit(companyInfo.getId());
                zcbid.setCreateUnitName(companyInfo.getOrganAlias());
                zcbid.setCreateTime(LocalDateTime.now());
                zcbid.setOwnUnit(companyInfo.getId());
                zcbid.setOwnUnitName(companyInfo.getOrganAlias());
                zcbid.setFlowStatus(BidStatusEnum.BID_STATUS_DRAFT.getBidtatus());
                Long chargePersonId = zcbid.getChargePerson();
                String chargePersonName = zcbid.getChargePersonName();
                if (chargePersonId != null && chargePersonName != null) {
                    zcbid.setChargePerson(chargePersonId);
                    zcbid.setChargePersonName(chargePersonName);
                    this.teamMeberService.insertTeamMember(zcbid.getChargePersonName(), zcbid.getChargePerson(), zcbid.getBidId(), "1", "1", LocalDateTime.now(), "31");
                }
                zcbid.setState("1");
                zcbid.setBidStage("1");
                this.operateRecordAPIService.saveOperateLog(null, CrmBusinessTypeEnum.BID, zcbid.getBidId(), zcbid.getBidName(), LocalDateTime.now(), false, Arrays.asList(zcbid.getBidId()));
            } else {
                Zcbid oldBid = (Zcbid)this.getById(zcbid.getBidId());
                zcbid.setUpdateUser(user.getUserId());
                zcbid.setUpdateUserName(userName);
                zcbid.setUpdateTime(LocalDateTime.now());
                this.fileInfoAPIService.deleteHighSecurityLevelFileInfo(zcbid.getBidId(), zcbid.getSecurityLevel());
                this.taskAPIService.updateTaskSecurityLevel(zcbid.getBidId(), zcbid.getSecurityLevel());
                this.fileInfoAPIService.updateTrackFileInfoSecurityLevel(zcbid.getBidId(), zcbid.getSecurityLevel());
                Map map = DataCompareUtils.getRecordInfo((Object)oldBid, (Object)zcbid);
                if (((String)map.get("changeFlag")).equals("true")) {
                    OperateRecordAPIVo trackRecord = this.operateRecordAPIService.initializeOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE.getId(), (String)map.get("oldJson"), (String)map.get("newJson"), (String)map.get("changeFieldStr"));
                    trackRecord.setChangeBatch(1);
                    this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.BID, Long.valueOf(oldBid.getBidId()), oldBid.getBidName(), LocalDateTime.now(), false, null);
                }
            }
            boolean resultFlag = this.saveOrUpdate(zcbid);
            if (!resultFlag) {
                return ApiResponse.fail((String)"NOPERMISSION");
            }
            return ApiResponse.success((Object)String.valueOf(zcbid.getBidId()), (String)"");
        }
        catch (Exception e) {
            throw new HussarException("\u65b0\u589e\u6216\u4fee\u6539\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public OperateVo operate(Long bidId) {
        OperateVo operateVo = new OperateVo();
        if (bidId == null) {
            return operateVo;
        }
        Zcbid bid = (Zcbid)this.getById(bidId);
        if (bid == null || "1".equals(bid.getDelState())) {
            return operateVo;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        SysStru companyInfo = this.struUserAPIService.getCompanyInfoByCurrentDeptId(user.getDeptId().toString());
        if (HussarUtils.isNotEmpty((Object)user.getSecurityLevel()) && user.getSecurityLevel() < bid.getSecurityLevel()) {
            return operateVo;
        }
        operateVo.setEditOperate(Integer.valueOf(-1));
        operateVo.setDeleteOperate(Integer.valueOf(-1));
        operateVo.setTransOperate(Integer.valueOf(-1));
        operateVo.setJgcBidFlag(Integer.valueOf(-1));
        operateVo.setViewOperate(Boolean.valueOf(true));
        if (BidStatusEnum.BID_STATUS_DRAFT.getBidtatus().equals(bid.getFlowStatus()) || BidStatusEnum.BID_STATUS_REJECT_SUBMIT.getBidtatus().equals(bid.getFlowStatus())) {
            this.teamMemberApiService.teamMemberOperate(bidId, user, operateVo, "31");
            if (bid.getChargePerson().equals(user.getUserId())) {
                operateVo.setEditOperate(Integer.valueOf(1));
                operateVo.setDeleteOperate(Integer.valueOf(1));
                operateVo.setTransOperate(Integer.valueOf(1));
            }
            if ("1008463642804625408".equals(companyInfo.getId() + "")) {
                operateVo.setDeleteOperate(Integer.valueOf(1));
                operateVo.setTransOperate(Integer.valueOf(1));
            }
        } else if (BidStatusEnum.BID_STATUS_CHECK_FINISHED.getBidtatus().equals(bid.getFlowStatus())) {
            if (bid.getChargePerson().equals(user.getUserId())) {
                operateVo.setDeleteOperate(Integer.valueOf(1));
                operateVo.setTransOperate(Integer.valueOf(1));
            }
            if ("1008463642804625408".equals(companyInfo.getId() + "")) {
                operateVo.setDeleteOperate(Integer.valueOf(1));
                operateVo.setTransOperate(Integer.valueOf(1));
                operateVo.setJgcBidFlag(Integer.valueOf(1));
            }
        }
        return operateVo;
    }
}

