/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.utils;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.crm.knowledge.knowledge.knowledgepermission.dto.PermissionUpdateDTO;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.dto.ComplexParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.dto.EsParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.response.ESResponse;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EsUtilNew {
    @Value(value="${elasticsearch.es-index-name}")
    private String INDEX_OF_KNOWLEDGEBASE;
    private final String[] FIELDS_OF_DOC = new String[]{"title", "content", "contributor", "contributorDept", "contractSerial", "keywords.keyword", "description"};
    private final String[] RED_LINE = new String[]{"title"};
    private final String[] FIELDS_OF_CONTENT = new String[]{"content"};
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ISysDicRefService dictService;

    public int addDoc(EsParam esParam) {
        IndexRequest indexRequest = new IndexRequest(this.INDEX_OF_KNOWLEDGEBASE).id(esParam.getId());
        indexRequest.source(JSON.toJSONString((Object)esParam), XContentType.JSON);
        IndexResponse response = null;
        try {
            response = this.client.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RestStatus status = response.status();
        return status.getStatus();
    }

    public Map<String, Object> getDoc(String docId) {
        GetRequest request = new GetRequest(this.INDEX_OF_KNOWLEDGEBASE).id(docId);
        GetResponse response = null;
        try {
            response = this.client.get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (response.isExists()) {
            return response.getSourceAsMap();
        }
        return null;
    }

    public int deleteDoc(String docId) {
        DeleteRequest deleteRequest = new DeleteRequest(this.INDEX_OF_KNOWLEDGEBASE).id(docId);
        DeleteResponse response = null;
        try {
            response = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RestStatus status = response.status();
        return status.getStatus();
    }

    public int updateDoc(EsParam esParam) {
        UpdateRequest request = new UpdateRequest(this.INDEX_OF_KNOWLEDGEBASE, esParam.getId()).doc(JSON.toJSONString((Object)esParam), XContentType.JSON);
        UpdateResponse response = null;
        try {
            response = this.client.update(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RestStatus status = response.status();
        return status.getStatus();
    }

    public int copyDoc(String oldDocId, String newDocId) {
        GetRequest request = new GetRequest(this.INDEX_OF_KNOWLEDGEBASE).id(oldDocId);
        GetResponse response = null;
        try {
            response = this.client.get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map sourceMap = response.getSourceAsMap();
        System.out.println("****************************************************************************\u79d2\u4f20\u65f6\u8f93\u51fa\u7684\u6587\u6863\uff1a" + sourceMap);
        sourceMap.put("recycle", "1");
        sourceMap.put("folderId", "");
        IndexRequest indexRequest = new IndexRequest(this.INDEX_OF_KNOWLEDGEBASE).id(newDocId).source(sourceMap);
        IndexResponse indexResponse = null;
        try {
            indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RestStatus status = indexResponse.status();
        return status.getStatus();
    }

    public ESResponse<Map<String, Object>> matchQuery(String field, String keyword, Integer page, Integer size) {
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)field, (Object)keyword);
        SearchResponse response = this.doQuery((QueryBuilder)queryBuilder, page, size, null, "", "", "");
        return this.handleHits(response);
    }

    private SearchResponse doQuery(QueryBuilder queryBuilder, Integer page, Integer size, String order, String typeMain, String searchKeys, String searchType) {
        if (size == null) {
            size = 10;
        }
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        if (!"relate".equals(searchType)) {
            highlightBuilder.preTags(new String[]{"<span style='color:red'>"});
            highlightBuilder.postTags(new String[]{"</span>"});
            for (String field : this.FIELDS_OF_DOC) {
                HighlightBuilder.Field fld;
                if ("advance".equals(searchType)) {
                    fld = (HighlightBuilder.Field)new HighlightBuilder.Field(field).requireFieldMatch(Boolean.valueOf(true));
                    highlightBuilder.field(fld);
                    continue;
                }
                fld = new HighlightBuilder.Field(field);
                highlightBuilder.field(fld);
            }
            if ("picture_collection".equals(typeMain) || "video".equals(typeMain)) {
                highlightBuilder.numOfFragments(Integer.valueOf(0));
            }
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (StringUtils.isNotBlank((CharSequence)searchKeys)) {
            if (StringUtils.isNotBlank((CharSequence)order)) {
                if ("_score".equals(order)) {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort(order, SortOrder.DESC).sort("processDate", SortOrder.DESC);
                } else if ("processDateDesc".equals(order)) {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("processDate", SortOrder.DESC).sort("_score", SortOrder.DESC);
                } else if ("processDateAsc".equals(order)) {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("processDate", SortOrder.ASC).sort("_score", SortOrder.DESC);
                } else {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("_score", SortOrder.DESC).sort("processDate", SortOrder.DESC);
                }
            } else {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("_score", SortOrder.DESC).sort("processDate", SortOrder.DESC);
            }
        } else if (StringUtils.isNotBlank((CharSequence)order)) {
            if ("processDateDesc".equals(order)) {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("processDate", SortOrder.DESC);
            } else if ("processDateAsc".equals(order)) {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("processDate", SortOrder.ASC);
            } else {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("processDate", SortOrder.DESC);
            }
        } else {
            searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("processDate", SortOrder.DESC);
        }
        SearchRequest request = new SearchRequest(new String[]{this.INDEX_OF_KNOWLEDGEBASE}).source(searchSourceBuilder).searchType(SearchType.DFS_QUERY_THEN_FETCH);
        try {
            return this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private SearchResponse doQueryNoHighlight(QueryBuilder queryBuilder, Integer page, Integer size, String order, String typeMain, String searchKeys, String searchType) {
        if (size == null) {
            size = 10;
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (StringUtils.isNotBlank((CharSequence)searchKeys)) {
            if (StringUtils.isNotBlank((CharSequence)order)) {
                if ("_score".equals(order)) {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).query(queryBuilder).sort(order, SortOrder.DESC).sort("processDate", SortOrder.DESC);
                } else if ("processDateDesc".equals(order)) {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).query(queryBuilder).sort("processDate", SortOrder.DESC).sort("_score", SortOrder.DESC);
                } else if ("processDateAsc".equals(order)) {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).query(queryBuilder).sort("processDate", SortOrder.ASC).sort("_score", SortOrder.DESC);
                } else {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).query(queryBuilder).sort("_score", SortOrder.DESC).sort("processDate", SortOrder.DESC);
                }
            } else {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).query(queryBuilder).sort("_score", SortOrder.DESC).sort("processDate", SortOrder.DESC);
            }
        } else if (StringUtils.isNotBlank((CharSequence)order)) {
            if ("processDateDesc".equals(order)) {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).query(queryBuilder).sort("processDate", SortOrder.DESC);
            } else if ("processDateAsc".equals(order)) {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).query(queryBuilder).sort("processDate", SortOrder.ASC);
            } else {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).query(queryBuilder).sort("processDate", SortOrder.DESC);
            }
        } else {
            searchSourceBuilder.from((page - 1) * size).size(size.intValue()).query(queryBuilder).sort("processDate", SortOrder.DESC);
        }
        SearchRequest request = new SearchRequest(new String[]{this.INDEX_OF_KNOWLEDGEBASE}).source(searchSourceBuilder).searchType(SearchType.DFS_QUERY_THEN_FETCH);
        try {
            return this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private SearchResponse doRecommendQuery(QueryBuilder queryBuilder, Integer page, Integer size, String order, String typeMain, String searchKeys, String searchType) {
        if (size == null) {
            size = 10;
        }
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        if (!"relate".equals(searchType)) {
            highlightBuilder.preTags(new String[]{"<span style='color:red'>"});
            highlightBuilder.postTags(new String[]{"</span>"});
            for (String field : this.FIELDS_OF_DOC) {
                HighlightBuilder.Field fld;
                if ("advance".equals(searchType)) {
                    fld = (HighlightBuilder.Field)new HighlightBuilder.Field(field).requireFieldMatch(Boolean.valueOf(true));
                    highlightBuilder.field(fld);
                    continue;
                }
                fld = new HighlightBuilder.Field(field);
                highlightBuilder.field(fld);
            }
            if ("picture_collection".equals(typeMain) || "video".equals(typeMain)) {
                highlightBuilder.numOfFragments(Integer.valueOf(0));
            }
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (StringUtils.isNotBlank((CharSequence)searchKeys)) {
            if (StringUtils.isNotBlank((CharSequence)order)) {
                if ("_recommend".equals(order)) {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("hot", SortOrder.DESC).sort("_score", SortOrder.DESC).sort("processDate", SortOrder.DESC);
                } else {
                    searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("hot", SortOrder.DESC).sort("_score", SortOrder.DESC).sort("processDate", SortOrder.DESC);
                }
            } else {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("hot", SortOrder.DESC).sort("_score", SortOrder.DESC).sort("processDate", SortOrder.DESC);
            }
        } else if (StringUtils.isNotBlank((CharSequence)order)) {
            if ("_recommend".equals(order)) {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("hot", SortOrder.DESC).sort("processDate", SortOrder.DESC);
            } else {
                searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("hot", SortOrder.DESC).sort("processDate", SortOrder.DESC);
            }
        } else {
            searchSourceBuilder.from((page - 1) * size).size(size.intValue()).highlighter(highlightBuilder).query(queryBuilder).sort("hot", SortOrder.DESC).sort("processDate", SortOrder.DESC);
        }
        SearchRequest request = new SearchRequest(new String[]{this.INDEX_OF_KNOWLEDGEBASE}).source(searchSourceBuilder).searchType(SearchType.DFS_QUERY_THEN_FETCH);
        try {
            return this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private ESResponse<Map<String, Object>> handleHits(SearchResponse response) {
        SearchHits hits = response.getHits();
        ESResponse<Map<String, Object>> result = new ESResponse<Map<String, Object>>();
        long totalHits = hits.getTotalHits().value;
        result.setTotal(totalHits);
        int totalPage = (int)(totalHits / 10L) + 1;
        result.setTotalPages(totalPage);
        List items = result.getItems();
        for (SearchHit searchHit : hits) {
            String content;
            Map source = searchHit.getSourceAsMap();
            source.put("id", searchHit.getId());
            Map highLightFields = searchHit.getHighlightFields();
            for (String key : highLightFields.keySet()) {
                HighlightField field = (HighlightField)highLightFields.get(key);
                Text[] fragments = field.fragments();
                StringBuffer sb = new StringBuffer();
                for (Text text : fragments) {
                    sb.append(text);
                }
                source.put(key, sb.toString());
            }
            String title = String.valueOf(source.get("title"));
            String description = String.valueOf(source.get("description"));
            String string = content = source.get("content") == null ? "" : String.valueOf(source.get("content"));
            if (!title.contains("<span>") && !description.contains("<span>") && content.contains("<span>")) {
                source.put("content", description);
                source.put("description", content);
            }
            items.add(source);
        }
        return result;
    }

    private List<Map<String, Object>> getAggList(Map<String, Aggregation> aggregationMap, String aggName) {
        Terms levelTypeTerms = (Terms)aggregationMap.get(aggName);
        ArrayList<Map<String, Object>> typeList = new ArrayList<Map<String, Object>>();
        for (Terms.Bucket next : levelTypeTerms.getBuckets()) {
            List dicts;
            HashMap<String, Object> levelTypeMap = new HashMap<String, Object>();
            Object key = next.getKey();
            levelTypeMap.put("fieldId", key);
            if ("agg_type".equals(aggName)) {
                dicts = this.dictService.getDictByType("KNOWLEDGE_TYPE");
                for (DicSingle dict : dicts) {
                    if (!dict.getTypeName().equals(key)) continue;
                    key = dict.getTypeDesc();
                    break;
                }
            }
            if ("agg_levelType".equals(aggName)) {
                dicts = this.dictService.getDictByType("level_type");
                for (DicSingle dict : dicts) {
                    if (!dict.getTypeName().equals(key)) continue;
                    key = dict.getTypeDesc();
                    break;
                }
            }
            if (("agg_produceDate".equals(aggName) || "agg_processDate".equals(aggName)) && StringUtils.isNotBlank((CharSequence)next.getKeyAsString())) {
                key = next.getKeyAsString().substring(0, 10);
            }
            if ("agg_contractSerial".equals(aggName) && StringUtils.isBlank((CharSequence)key.toString())) {
                key = "\u65e0\u5408\u540c\u7f16\u53f7";
            }
            levelTypeMap.put("id", aggName + " " + key + " (" + next.getDocCount() + ")");
            levelTypeMap.put("title", key + " (" + next.getDocCount() + ")");
            typeList.add(levelTypeMap);
        }
        return typeList;
    }

    public ESResponse<Map<String, Object>> multiMatchQuery(ComplexParam complexParam) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)complexParam.getSearchKeys())) {
            MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery((Object)complexParam.getSearchKeys(), (String[])this.FIELDS_OF_DOC);
            multiMatchQueryBuilder.field("title", 5.0f);
            multiMatchQueryBuilder.field("description", 3.0f);
            multiMatchQueryBuilder.field("keywords.keyword", 3.0f);
            boolQueryBuilder.must((QueryBuilder)multiMatchQueryBuilder);
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        complexParam.setUserId(user.getUserId());
        complexParam.setDeptId(user.getDeptId());
        complexParam.setRoleIdList(user.getRolesList());
        BoolQueryBuilder permissionQueryBuilder = QueryBuilders.boolQuery();
        permissionQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"permissionAll", (String)"1"));
        if (complexParam.getUserId() != null) {
            permissionQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"permissionUserIds", (Object)complexParam.getUserId()));
        }
        if (complexParam.getDeptId() != null) {
            permissionQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"permissionDeptIds", (Object)complexParam.getDeptId()));
        }
        if (complexParam.getRoleIdList() != null && !complexParam.getRoleIdList().isEmpty()) {
            BoolQueryBuilder roleQueryBuilder = QueryBuilders.boolQuery();
            for (Long l : complexParam.getRoleIdList()) {
                roleQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"permissionRoleIds", (Object)l));
            }
            permissionQueryBuilder.should((QueryBuilder)roleQueryBuilder);
        }
        boolQueryBuilder.filter((QueryBuilder)permissionQueryBuilder);
        if (StringUtils.isNotBlank((CharSequence)complexParam.getId())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)complexParam.getId())));
        }
        if (StringUtils.isNotBlank((CharSequence)complexParam.getTypeMain())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"typeMain", (String)complexParam.getTypeMain())));
        }
        if (complexParam.getKeywords() != null && !complexParam.getKeywords().isEmpty()) {
            List<String> keywordsList = complexParam.getKeywords();
            BoolQueryBuilder keywordsBoolQueryBuilder = QueryBuilders.boolQuery();
            for (String keywords : keywordsList) {
                keywordsBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"keywords.keyword", (String)keywords));
            }
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)keywordsBoolQueryBuilder));
        }
        if (complexParam.getUpLoadUser() != null && !complexParam.getUpLoadUser().equals("")) {
            String upLoadUser = complexParam.getUpLoadUser();
            BoolQueryBuilder contributorBoolQueryBuilder = QueryBuilders.boolQuery();
            contributorBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"contributor.keyword", (String)upLoadUser));
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)contributorBoolQueryBuilder));
        }
        if (complexParam.getUpLoadOrgan() != null && !complexParam.getUpLoadOrgan().equals("")) {
            String upLoadOrgan = complexParam.getUpLoadOrgan();
            BoolQueryBuilder contributorDeptBoolQueryBuilder = QueryBuilders.boolQuery();
            contributorDeptBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"contributorDept.keyword", (String)upLoadOrgan));
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)contributorDeptBoolQueryBuilder));
        }
        if (complexParam.getProcessDate() != null && !complexParam.getProcessDate().isEmpty()) {
            List<Date> processDates = complexParam.getProcessDate();
            Date processDate1 = processDates.get(0);
            Date date = processDates.get(1);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (processDate1 != null) {
                String formatDate1 = simpleDateFormat.format(processDate1);
                if (date != null) {
                    String formatDate2 = simpleDateFormat.format(date);
                    RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"processDate").format("yyyy-MM-dd HH:mm:ss").gte((Object)formatDate1).lte((Object)formatDate2);
                    boolQueryBuilder.filter((QueryBuilder)rangeQueryBuilder);
                } else {
                    RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"processDate").format("yyyy-MM-dd HH:mm:ss").gte((Object)formatDate1);
                    boolQueryBuilder.filter((QueryBuilder)rangeQueryBuilder);
                }
            } else if (date != null) {
                String formatDate2 = simpleDateFormat.format(date);
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"processDate").format("yyyy-MM-dd HH:mm:ss").lte((Object)formatDate2);
                boolQueryBuilder.filter((QueryBuilder)rangeQueryBuilder);
            }
        }
        if (StringUtils.isBlank((CharSequence)complexParam.getSearchType())) {
            complexParam.setSearchType("complex");
        }
        SearchResponse response = this.doQuery((QueryBuilder)boolQueryBuilder, complexParam.getPage(), complexParam.getPageSize(), complexParam.getOrder(), complexParam.getTypeMain(), complexParam.getSearchKeys(), complexParam.getSearchType());
        return this.handleHits(response);
    }

    public ESResponse<Map<String, Object>> multiMatchQueryNoHighlight(ComplexParam complexParam) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)complexParam.getSearchKeys())) {
            MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery((Object)complexParam.getSearchKeys(), (String[])this.FIELDS_OF_DOC);
            multiMatchQueryBuilder.field("title", 5.0f);
            multiMatchQueryBuilder.field("description", 3.0f);
            multiMatchQueryBuilder.field("keywords.keyword", 3.0f);
            boolQueryBuilder.must((QueryBuilder)multiMatchQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)complexParam.getId())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)complexParam.getId())));
        }
        if (StringUtils.isNotBlank((CharSequence)complexParam.getTypeMain())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"typeMain", (String)complexParam.getTypeMain())));
        }
        if (complexParam.getKeywords() != null && !complexParam.getKeywords().isEmpty()) {
            List<String> keywordsList = complexParam.getKeywords();
            BoolQueryBuilder keywordsBoolQueryBuilder = QueryBuilders.boolQuery();
            for (String keywords : keywordsList) {
                keywordsBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"keywords.keyword", (String)keywords));
            }
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)keywordsBoolQueryBuilder));
        }
        if (complexParam.getUpLoadUser() != null && !complexParam.getUpLoadUser().equals("")) {
            String upLoadUser = complexParam.getUpLoadUser();
            BoolQueryBuilder contributorBoolQueryBuilder = QueryBuilders.boolQuery();
            contributorBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"upLoadUser.keyword", (String)upLoadUser));
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)contributorBoolQueryBuilder));
        }
        if (complexParam.getUpLoadOrgan() != null && !complexParam.getUpLoadOrgan().equals("")) {
            String upLoadOrgan = complexParam.getUpLoadOrgan();
            BoolQueryBuilder contributorDeptBoolQueryBuilder = QueryBuilders.boolQuery();
            contributorDeptBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"contributorDept.keyword", (String)upLoadOrgan));
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)contributorDeptBoolQueryBuilder));
        }
        if (complexParam.getProcessDate() != null && !complexParam.getProcessDate().isEmpty()) {
            List<Date> processDates = complexParam.getProcessDate();
            Date processDate1 = processDates.get(0);
            Date processDate2 = processDates.get(1);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (processDate1 != null) {
                String formatDate1 = simpleDateFormat.format(processDate1);
                if (processDate2 != null) {
                    String formatDate2 = simpleDateFormat.format(processDate2);
                    RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"processDate").format("yyyy-MM-dd HH:mm:ss").gte((Object)formatDate1).lte((Object)formatDate2);
                    boolQueryBuilder.filter((QueryBuilder)rangeQueryBuilder);
                } else {
                    RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"processDate").format("yyyy-MM-dd HH:mm:ss").gte((Object)formatDate1);
                    boolQueryBuilder.filter((QueryBuilder)rangeQueryBuilder);
                }
            } else if (processDate2 != null) {
                String formatDate2 = simpleDateFormat.format(processDate2);
                RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"processDate").format("yyyy-MM-dd HH:mm:ss").lte((Object)formatDate2);
                boolQueryBuilder.filter((QueryBuilder)rangeQueryBuilder);
            }
        }
        if (StringUtils.isBlank((CharSequence)complexParam.getSearchType())) {
            complexParam.setSearchType("complex");
        }
        SearchResponse response = this.doQueryNoHighlight((QueryBuilder)boolQueryBuilder, complexParam.getPage(), complexParam.getPageSize(), complexParam.getOrder(), complexParam.getTypeMain(), complexParam.getSearchKeys(), complexParam.getSearchType());
        return this.handleHits(response);
    }

    public ESResponse<Map<String, Object>> recommendMultiMatchQuery(ComplexParam complexParam) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)complexParam.getSearchKeys())) {
            MultiMatchQueryBuilder multiMatchQueryBuilder = QueryBuilders.multiMatchQuery((Object)complexParam.getSearchKeys(), (String[])this.FIELDS_OF_DOC);
            multiMatchQueryBuilder.field("title", 5.0f);
            multiMatchQueryBuilder.field("description", 3.0f);
            multiMatchQueryBuilder.field("keywords.keyword", 3.0f);
            boolQueryBuilder.must((QueryBuilder)multiMatchQueryBuilder);
        }
        BoolQueryBuilder permissionQueryBuilder = QueryBuilders.boolQuery();
        permissionQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"permissionAll", (String)"1"));
        if (complexParam.getUserId() != null) {
            permissionQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"permissionUserIds", (Object)complexParam.getUserId()));
        }
        if (complexParam.getDeptId() != null) {
            permissionQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"permissionDeptIds", (Object)complexParam.getDeptId()));
        }
        if (complexParam.getRoleIdList() != null && !complexParam.getRoleIdList().isEmpty()) {
            BoolQueryBuilder roleQueryBuilder = QueryBuilders.boolQuery();
            for (Long roleId : complexParam.getRoleIdList()) {
                roleQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"permissionRoleIds", (Object)roleId));
            }
            permissionQueryBuilder.should((QueryBuilder)roleQueryBuilder);
        }
        boolQueryBuilder.filter((QueryBuilder)permissionQueryBuilder);
        if (complexParam.getKeywords() != null && !complexParam.getKeywords().isEmpty()) {
            List<String> keywordsList = complexParam.getKeywords();
            BoolQueryBuilder keywordsBoolQueryBuilder = QueryBuilders.boolQuery();
            for (String keywords : keywordsList) {
                keywordsBoolQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"keywords.keyword", (String)keywords));
            }
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)keywordsBoolQueryBuilder));
        }
        if (StringUtils.isBlank((CharSequence)complexParam.getSearchType())) {
            complexParam.setSearchType("complex");
        }
        SearchResponse response = this.doRecommendQuery((QueryBuilder)boolQueryBuilder, complexParam.getPage(), complexParam.getPageSize(), complexParam.getOrder(), complexParam.getTypeMain(), complexParam.getSearchKeys(), complexParam.getSearchType());
        return this.handleHits(response);
    }

    public int updateDocumentsPermission(List<String> docIds, List<Long> permissionUserIds, List<Long> permissionDeptIds, List<Long> permissionRoleIds, String permissionAll) {
        if (docIds == null || docIds.isEmpty()) {
            return 0;
        }
        int successCount = 0;
        for (String docId : docIds) {
            try {
                UpdateRequest updateRequest = new UpdateRequest(this.INDEX_OF_KNOWLEDGEBASE, docId);
                HashMap<String, Object> updateFields = new HashMap<String, Object>();
                if (permissionUserIds != null) {
                    updateFields.put("permissionUserIds", permissionUserIds);
                }
                if (permissionDeptIds != null) {
                    updateFields.put("permissionDeptIds", permissionDeptIds);
                }
                if (permissionRoleIds != null) {
                    updateFields.put("permissionRoleIds", permissionRoleIds);
                }
                if (permissionAll != null) {
                    updateFields.put("permissionAll", permissionAll);
                }
                updateRequest.doc(updateFields);
                UpdateResponse response = this.client.update(updateRequest, RequestOptions.DEFAULT);
                if (response.status().getStatus() != 200) continue;
                ++successCount;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("\u66f4\u65b0\u6587\u6863\u6743\u9650\u5931\u8d25, docId: " + docId + ", \u9519\u8bef: " + e.getMessage());
            }
        }
        return successCount;
    }

    public int updateDocumentPermission(String docId, List<Long> permissionUserIds, List<Long> permissionDeptIds, List<Long> permissionRoleIds, String permissionAll) {
        UpdateRequest updateRequest = new UpdateRequest(this.INDEX_OF_KNOWLEDGEBASE, docId);
        HashMap<String, Object> updateFields = new HashMap<String, Object>();
        if (permissionUserIds != null) {
            updateFields.put("permissionUserIds", permissionUserIds);
        }
        if (permissionDeptIds != null) {
            updateFields.put("permissionDeptIds", permissionDeptIds);
        }
        if (permissionRoleIds != null) {
            updateFields.put("permissionRoleIds", permissionRoleIds);
        }
        if (permissionAll != null) {
            updateFields.put("permissionAll", permissionAll);
        }
        updateRequest.doc(updateFields);
        try {
            UpdateResponse response = this.client.update(updateRequest, RequestOptions.DEFAULT);
            return response.status().getStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public BulkResponse batchUpdateDocumentsPermission(List<PermissionUpdateDTO> permissionUpdateList) {
        if (permissionUpdateList == null || permissionUpdateList.isEmpty()) {
            return null;
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PermissionUpdateDTO updateDTO : permissionUpdateList) {
            UpdateRequest updateRequest = new UpdateRequest(this.INDEX_OF_KNOWLEDGEBASE, updateDTO.getDocId());
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            if (updateDTO.getPermissionUserIds() != null) {
                updateFields.put("permissionUserIds", updateDTO.getPermissionUserIds());
            }
            if (updateDTO.getPermissionDeptIds() != null) {
                updateFields.put("permissionDeptIds", updateDTO.getPermissionDeptIds());
            }
            if (updateDTO.getPermissionRoleIds() != null) {
                updateFields.put("permissionRoleIds", updateDTO.getPermissionRoleIds());
            }
            if (updateDTO.getPermissionAll() != null) {
                updateFields.put("permissionAll", updateDTO.getPermissionAll());
            }
            updateRequest.doc(updateFields);
            bulkRequest.add(updateRequest);
        }
        try {
            return this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u6279\u91cf\u66f4\u65b0\u6743\u9650\u5931\u8d25", e);
        }
    }

    public int updatePermissionByQuery(QueryBuilder queryBuilder, List<Long> permissionUserIds, List<Long> permissionDeptIds, List<Long> permissionRoleIds, String permissionAll) {
        UpdateByQueryRequest request = new UpdateByQueryRequest(new String[]{this.INDEX_OF_KNOWLEDGEBASE});
        request.setQuery(queryBuilder);
        StringBuilder scriptSource = new StringBuilder();
        if (permissionUserIds != null) {
            scriptSource.append("ctx._source.permissionUserIds = params.permissionUserIds;");
        }
        if (permissionDeptIds != null) {
            scriptSource.append("ctx._source.permissionDeptIds = params.permissionDeptIds;");
        }
        if (permissionRoleIds != null) {
            scriptSource.append("ctx._source.permissionRoleIds = params.permissionRoleIds;");
        }
        if (permissionAll != null) {
            scriptSource.append("ctx._source.permissionAll = params.permissionAll;");
        }
        if (scriptSource.length() == 0) {
            return 0;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (permissionUserIds != null) {
            params.put("permissionUserIds", permissionUserIds);
        }
        if (permissionDeptIds != null) {
            params.put("permissionDeptIds", permissionDeptIds);
        }
        if (permissionRoleIds != null) {
            params.put("permissionRoleIds", permissionRoleIds);
        }
        if (permissionAll != null) {
            params.put("permissionAll", permissionAll);
        }
        request.setScript(new Script(ScriptType.INLINE, "painless", scriptSource.toString(), params));
        try {
            BulkByScrollResponse response = this.client.updateByQuery(request, RequestOptions.DEFAULT);
            return (int)response.getUpdated();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u6839\u636e\u67e5\u8be2\u66f4\u65b0\u6743\u9650\u5931\u8d25", e);
        }
    }
}

