/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.service.impl;

import com.jxdinfo.crm.knowledge.knowledge.config.DateConverter;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.dto.ComplexParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.dto.EsParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.model.response.ESResponse;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.elasticsearch.service.SearchService;
import com.jxdinfo.crm.knowledge.knowledge.modular.common.utils.EsUtilNew;
import com.jxdinfo.crm.knowledge.knowledge.modular.front.historysearch.service.HistorySearchService;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchServiceImpl
implements SearchService {
    @Autowired
    private EsUtilNew esUtil;
    @Autowired
    private HistorySearchService historySearchService;

    @Override
    public Map<String, Object> searchIndex(String searchKeys, Integer page, Integer pageSize, String typeMain) {
        if (StringUtils.isNotBlank((CharSequence)searchKeys)) {
            String[] keywords;
            for (String keyword : keywords = searchKeys.split(" ")) {
                this.historySearchService.addHistory(keyword);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> type = new ArrayList<String>();
        if (page == 1) {
            type.add("encyclopedia");
            ComplexParam complexParam = new ComplexParam(searchKeys, 1, (Integer)1, type);
            ESResponse<Map<String, Object>> encyclopedia = this.esUtil.multiMatchQuery(complexParam);
            map.put("encyclopedia", encyclopedia.getItems());
            type.remove(0);
            type.add("picture_collection");
            complexParam = new ComplexParam(searchKeys, 1, (Integer)3, type);
            ESResponse<Map<String, Object>> picture = this.esUtil.multiMatchQuery(complexParam);
            map.put("picture_collection", picture.getItems());
            type.remove(0);
            type.add("video");
            complexParam = new ComplexParam(searchKeys, 1, (Integer)3, type);
            ESResponse<Map<String, Object>> video = this.esUtil.multiMatchQuery(complexParam);
            map.put("video", video.getItems());
            type.remove(0);
            type.add("headline");
            complexParam = new ComplexParam(searchKeys, 1, (Integer)5, type);
            ESResponse<Map<String, Object>> headline = this.esUtil.multiMatchQuery(complexParam);
            map.put("headline", headline.getItems());
        }
        ComplexParam complexParam = new ComplexParam(searchKeys, page, pageSize);
        ESResponse<Map<String, Object>> all = this.esUtil.multiMatchQuery(complexParam);
        map.put("all", all);
        return map;
    }

    @Override
    public ESResponse<Map<String, Object>> search(ComplexParam complexParam) {
        String searchKeys = complexParam.getSearchKeys();
        if (StringUtils.isNotBlank((CharSequence)searchKeys)) {
            String[] keywords;
            for (String keyword : keywords = searchKeys.split(" ")) {
                this.historySearchService.addHistory(keyword);
            }
        }
        return this.esUtil.multiMatchQuery(complexParam);
    }

    @Override
    public ESResponse<Map<String, Object>> getRecommend(ComplexParam complexParam) {
        return this.esUtil.recommendMultiMatchQuery(complexParam);
    }

    @Override
    public int deletFile(String fileId) {
        return this.esUtil.deleteDoc(fileId);
    }

    @Override
    public void updateHot(String fileInfoId, Long hot) {
        if (StringUtils.isNotBlank((CharSequence)fileInfoId) && hot != null) {
            Map<String, Object> doc = this.esUtil.getDoc(fileInfoId);
            EsParam esParam = new EsParam();
            ConvertUtils.register((Converter)new DateConverter(), Date.class);
            try {
                BeanUtils.populate((Object)esParam, doc);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            esParam.setHot(hot);
            this.esUtil.updateDoc(esParam);
        }
    }
}

