/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.modular.front.historysearch.controller;

import com.jxdinfo.crm.knowledge.knowledge.base.BaseController;
import com.jxdinfo.crm.knowledge.knowledge.modular.front.historysearch.entity.HistoryResult;
import com.jxdinfo.crm.knowledge.knowledge.modular.front.historysearch.entity.HistorySearch;
import com.jxdinfo.crm.knowledge.knowledge.modular.front.historysearch.model.params.HistorySearchParam;
import com.jxdinfo.crm.knowledge.knowledge.modular.front.historysearch.service.HistorySearchService;
import com.jxdinfo.crm.knowledge.knowledge.pageInfo.LayuiPageInfo;
import com.jxdinfo.crm.knowledge.knowledge.response.ResponseData;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/historySearch"})
public class HistorySearchController
extends BaseController {
    private String PREFIX = "/historySearch";
    @Autowired
    private HistorySearchService historySearchService;

    @RequestMapping(value={""})
    public String index() {
        return this.PREFIX + "/historySearch.html";
    }

    @RequestMapping(value={"/add"})
    public String add() {
        return this.PREFIX + "/historySearch_add.html";
    }

    @RequestMapping(value={"/edit"})
    public String edit() {
        return this.PREFIX + "/historySearch_edit.html";
    }

    @RequestMapping(value={"/addItem"})
    @ResponseBody
    public ResponseData addItem(HistorySearchParam historySearchParam) {
        this.historySearchService.add(historySearchParam);
        return ResponseData.success();
    }

    @RequestMapping(value={"/editItem"})
    @ResponseBody
    public ResponseData editItem(HistorySearchParam historySearchParam) {
        this.historySearchService.update(historySearchParam);
        return ResponseData.success();
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseData delete(HistorySearchParam historySearchParam) {
        this.historySearchService.delete(historySearchParam);
        return ResponseData.success();
    }

    @RequestMapping(value={"/detail"})
    @ResponseBody
    public ResponseData detail(HistorySearchParam historySearchParam) {
        HistorySearch detail = (HistorySearch)this.historySearchService.getById((Serializable)((Object)historySearchParam.getId()));
        return ResponseData.success(detail);
    }

    @ResponseBody
    @RequestMapping(value={"/list"})
    public LayuiPageInfo list(HistorySearchParam historySearchParam) {
        return this.historySearchService.findPageBySpec(historySearchParam);
    }

    @ResponseBody
    @RequestMapping(value={"/hotSearch"})
    public ResponseData hotHistory() {
        List<HistoryResult> historySearches = this.historySearchService.hotHistory();
        return ResponseData.success(historySearches);
    }

    @ResponseBody
    @PostMapping(value={"/linkSearch"})
    public ResponseData linkSearch(@RequestBody HistorySearchParam historySearchParam) {
        List<HistoryResult> historySearches = this.historySearchService.linkSearch(historySearchParam.getKeywords());
        return ResponseData.success(historySearches);
    }
}

