/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.knowledge.knowledge.config;

import java.io.IOException;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CreateEsIndices
implements ApplicationListener,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CreateEsIndices.class);
    @Autowired
    RestHighLevelClient client;
    private ApplicationContext applicationContext;
    @Value(value="${elasticsearch.es-index-name}")
    private String indexName;

    public void onApplicationEvent(ApplicationEvent event) {
        try {
            boolean flag = this.existIndex(this.indexName);
            if (!flag) {
                this.createIndices(this.indexName);
            }
        }
        catch (IOException e) {
            log.error("\u521b\u5efaES\u7d22\u5f15\u5f02\u5e38", (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public boolean existIndex(String indexName) throws IOException {
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        return this.client.indices().exists(request, RequestOptions.DEFAULT);
    }

    public void createIndices(String indexName) throws IOException {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        createIndexRequest.source("{\n  \"mappings\": {\n    \"properties\": {\n      \"permissionUserIds\": {\n        \"type\": \"long\",\n        \"store\": true\n      },\n      \"permissionDeptIds\": {\n        \"type\": \"long\", \n        \"store\": true\n      },\n      \"permissionRoleIds\": {\n        \"type\": \"long\",\n        \"store\": true\n      },\n      \"permissionAll\": {\n        \"type\": \"keyword\",\n        \"store\": true\n      },\n      \"auditTime\": {\n        \"type\": \"date\",\n        \"store\": true,\n        \"format\": \"yyyy-MM-dd HH:mm:ss||yyyy-MM-dd||epoch_millis\"\n      },\n      \"content\": {\n        \"type\": \"text\",\n        \"store\": true,\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      },\n      \"contractSerial\": {\n        \"type\": \"keyword\",\n        \"store\": true\n      },\n      \"contributor\": {\n        \"type\": \"text\",\n        \"store\": true,\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"text\",\n            \"analyzer\": \"comma\",\n            \"fielddata\": true\n          }\n        },\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      },\n      \"contributorDept\": {\n        \"type\": \"text\",\n        \"store\": true,\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"text\",\n            \"analyzer\": \"comma\",\n            \"fielddata\": true\n          }\n        },\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      },\n      \"description\": {\n        \"type\": \"text\",\n        \"store\": true,\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      },\n      \"hot\": {\n        \"type\": \"long\",\n        \"store\": true\n      },\n      \"size\": {\n        \"type\": \"long\",\n        \"store\": true\n      },\n      \"id\": {\n        \"type\": \"keyword\",\n        \"store\": true\n      },\n      \"keywords\": {\n        \"type\": \"text\",\n        \"store\": true,\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"text\",\n            \"analyzer\": \"comma\",\n            \"fielddata\": true\n          }\n        },\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      },\n      \"levelType\": {\n        \"type\": \"keyword\",\n        \"store\": true\n      },\n      \"parentId\": {\n        \"type\": \"keyword\",\n        \"store\": true\n      },\n      \"parentName\": {\n        \"type\": \"text\",\n        \"store\": true,\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      },\n      \"processDate\": {\n        \"type\": \"date\",\n        \"store\": true,\n        \"format\": \"yyyy-MM-dd HH:mm:ss||yyyy-MM-dd||epoch_millis\"\n      },\n      \"produceDate\": {\n        \"type\": \"date\",\n        \"store\": true,\n        \"format\": \"yyyy-MM-dd HH:mm:ss||yyyy-MM-dd||epoch_millis\"\n      },\n      \"securityLevel\": {\n        \"type\": \"keyword\",\n        \"store\": true\n      },\n      \"techCategoryId\": {\n        \"type\": \"text\",\n        \"store\": true,\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"text\",\n            \"analyzer\": \"comma\",\n            \"fielddata\": true\n          }\n        },\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      },\n      \"title\": {\n        \"type\": \"text\",\n        \"store\": true,\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      },\n      \"type\": {\n        \"type\": \"keyword\",\n        \"store\": true\n      },\n      \"typeMain\": {\n        \"type\": \"keyword\",\n        \"store\": true\n      },\n      \"wdCategoryId\": {\n        \"type\": \"text\",\n        \"store\": true,\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"text\",\n            \"analyzer\": \"comma\",\n            \"fielddata\": true\n          }\n        },\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      },\n      \"weaponCategoryId\": {\n        \"type\": \"text\",\n        \"store\": true,\n        \"fields\": {\n          \"keyword\": {\n            \"type\": \"text\",\n            \"analyzer\": \"comma\",\n            \"fielddata\": true\n          }\n        },\n        \"analyzer\": \"ik_max_word\",\n        \"search_analyzer\": \"ik_smart\"\n      }\n    }\n  },\n  \"settings\": {\n    \"index\": {\n      \"number_of_shards\": \"3\",\n      \"analysis\": {\n        \"analyzer\": {\n          \"comma\": {\n            \"pattern\": \",\",\n            \"type\": \"pattern\"\n          }\n        }\n      },\n      \"number_of_replicas\": \"1\"\n    }\n  }\n}", XContentType.JSON);
        IndicesClient indices = this.client.indices();
        CreateIndexResponse createIndexResponse = null;
        createIndexResponse = indices.create(createIndexRequest, RequestOptions.DEFAULT);
        boolean acknowledged = createIndexResponse.isAcknowledged();
        log.info("\u521b\u5efa\u6210\u529f" + acknowledged);
    }
}

