/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.dataRightManage.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.dataRightManage.vo.DataRightVO;
import com.jxdinfo.crm.common.api.organUser.vo.DeptVo;
import com.jxdinfo.crm.common.dataRightManage.dao.DataRightManageMapper;
import com.jxdinfo.crm.common.dataRightManage.dto.DataRightDto;
import com.jxdinfo.crm.common.dataRightManage.dto.DivisionsLeaderDto;
import com.jxdinfo.crm.common.dataRightManage.model.DataRightEntity;
import com.jxdinfo.crm.common.dataRightManage.service.IDataRightManageService;
import com.jxdinfo.crm.common.organUser.service.IOrganUserService;
import com.jxdinfo.crm.common.organUser.service.IUserService;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DataRightManageServiceImpl
extends ServiceImpl<DataRightManageMapper, DataRightEntity>
implements IDataRightManageService {
    @Resource
    private IUserService userService;
    @Resource
    private IOrganUserService organUserService;
    @Resource
    private ISysDicRefService sysDicRefService;

    @Override
    public List<DataRightVO> listByRoleId(DataRightDto dto) {
        List<DataRightEntity> unInitDataRight = ((DataRightManageMapper)this.baseMapper).getUnInitDataRight(dto);
        String userName = BaseSecurityUtil.getUser().getUserName();
        if (CollectionUtil.isNotEmpty(unInitDataRight)) {
            for (DataRightEntity dataRightEntity : unInitDataRight) {
                dataRightEntity.setDataRightType("1");
                dataRightEntity.setCreatorName(userName);
            }
            this.saveBatch(unInitDataRight);
        }
        List<DataRightVO> dataRightVOList = ((DataRightManageMapper)this.baseMapper).listDataRight(dto);
        return this.transferDept(dataRightVOList);
    }

    @Override
    public List<DataRightVO> getDataRightVOList(List<Long> roleIdList) {
        if (CollectionUtil.isEmpty(roleIdList)) {
            return null;
        }
        List dicSingleList = this.sysDicRefService.getDicListByType("data_right_moudle");
        if (CollectionUtil.isEmpty((Collection)dicSingleList)) {
            return null;
        }
        ArrayList<DataRightVO> initDataRightVOList = new ArrayList<DataRightVO>();
        for (DicVo dicVo : dicSingleList) {
            DataRightVO dataRightVO2 = new DataRightVO();
            dataRightVO2.setDataRightType("1");
            dataRightVO2.setDataRightTypes(Collections.singletonList("1"));
            dataRightVO2.setDataRightModule(dicVo.getValue());
            dataRightVO2.setDataRightModuleName(dicVo.getLabel());
            initDataRightVOList.add(dataRightVO2);
        }
        DataRightDto dto = new DataRightDto();
        dto.setRoleIdList(roleIdList);
        List<Object> dataRightVOList = ((DataRightManageMapper)this.baseMapper).listDataRight(dto);
        if (CollectionUtil.isEmpty(dataRightVOList)) {
            return initDataRightVOList;
        }
        Map<String, List<DataRightVO>> groupedDataRightVOList = dataRightVOList.stream().collect(Collectors.groupingBy(DataRightVO::getDataRightModule));
        dataRightVOList = groupedDataRightVOList.entrySet().stream().flatMap(entry -> {
            DataRightVO returnDateRightVO = new DataRightVO();
            String module = (String)entry.getKey();
            List dataRightVOs = (List)entry.getValue();
            List dataRightTypeList = dataRightVOs.stream().map(DataRightVO::getDataRightType).distinct().collect(Collectors.toList());
            returnDateRightVO.setDataRightModule(module);
            returnDateRightVO.setDataRightModuleName(((DataRightVO)dataRightVOs.get(0)).getDataRightModuleName());
            returnDateRightVO.setDataRightTypes(dataRightTypeList);
            List deptIdList = dataRightVOs.stream().filter(dataRightVO -> StringUtils.isNotBlank((CharSequence)dataRightVO.getDeptIds())).flatMap(dataRightVO -> Arrays.stream(dataRightVO.getDeptIds().split(","))).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(deptIdList)) {
                returnDateRightVO.setDeptIds(StringUtils.join(deptIdList, (String)","));
            }
            return Stream.of(returnDateRightVO);
        }).collect(Collectors.toList());
        Map<String, DataRightVO> dataRightVOMap = dataRightVOList.stream().collect(Collectors.toMap(DataRightVO::getDataRightModule, dataRightVO -> dataRightVO));
        ArrayList<DataRightVO> returnDataRightVOList = new ArrayList<DataRightVO>();
        for (DataRightVO dataRightVO3 : initDataRightVOList) {
            returnDataRightVOList.add(dataRightVOMap.getOrDefault(dataRightVO3.getDataRightModule(), dataRightVO3));
        }
        return this.transferDept(returnDataRightVOList);
    }

    private List<DataRightVO> transferDept(List<DataRightVO> dataRightVOList) {
        if (CollectionUtil.isNotEmpty(dataRightVOList)) {
            Set<Long> deptIdSet = dataRightVOList.stream().filter(dataRightEntity -> StringUtils.isNotBlank((CharSequence)dataRightEntity.getDeptIds())).flatMap(dataRightEntity -> Arrays.stream(dataRightEntity.getDeptIds().split(","))).map(Long::parseLong).collect(Collectors.toSet());
            if (CollectionUtil.isNotEmpty(deptIdSet)) {
                List<DeptVo> deptVoList = this.organUserService.getDeptList(deptIdSet);
                Map<Long, DeptVo> deptVoMap = deptVoList.stream().collect(Collectors.toMap(DeptVo::getDeptId, deptVo -> deptVo));
                if (CollectionUtil.isNotEmpty(deptVoList)) {
                    for (DataRightVO dataRightVO : dataRightVOList) {
                        ArrayList<DeptVo> deptVoList1 = new ArrayList<DeptVo>();
                        if (StringUtils.isNotBlank((CharSequence)dataRightVO.getDeptIds())) {
                            String[] deptIds;
                            for (String deptId : deptIds = dataRightVO.getDeptIds().split(",")) {
                                deptVoList1.add(deptVoMap.get(Long.parseLong(deptId)));
                            }
                        }
                        dataRightVO.setDeptVoList(deptVoList1);
                    }
                }
            }
            return dataRightVOList;
        }
        return null;
    }

    @Override
    public int saveOrUpdate(List<DataRightDto> dtoList) {
        if (CollectionUtil.isNotEmpty(dtoList)) {
            List dataRightEntityList = BeanUtil.copyProperties(dtoList, DataRightEntity.class);
            String userName = BaseSecurityUtil.getUser().getUserName();
            dataRightEntityList.forEach(dataRightEntity -> {
                if (dataRightEntity.getDataRightId() != null) {
                    dataRightEntity.setLastEditorName(userName);
                } else {
                    dataRightEntity.setCreatorName(userName);
                }
            });
            if (this.saveOrUpdateBatch(dataRightEntityList)) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public DataRightVO getDataRightVOList(List<Long> roleIdList, String module) {
        DataRightDto dto = new DataRightDto();
        dto.setRoleIdList(roleIdList);
        dto.setDataRightModule(module);
        List<DataRightVO> dataRightVOList = ((DataRightManageMapper)this.baseMapper).listDataRight(dto);
        if (CollectionUtil.isEmpty(dataRightVOList)) {
            DataRightVO dataRightVO2 = new DataRightVO();
            dataRightVO2.setDataRightModule(module);
            dataRightVO2.setDataRightType("1");
            dataRightVO2.setDataRightTypes(Collections.singletonList("1"));
            return dataRightVO2;
        }
        DataRightVO returnDateRightVO = new DataRightVO();
        List dataRightTypeList = dataRightVOList.stream().map(DataRightVO::getDataRightType).distinct().collect(Collectors.toList());
        returnDateRightVO.setDataRightModule(module);
        returnDateRightVO.setDataRightTypes(dataRightTypeList);
        List deptIdList = dataRightVOList.stream().filter(dataRightVO -> StringUtils.isNotBlank((CharSequence)dataRightVO.getDeptIds())).flatMap(dataRightVO -> Arrays.stream(dataRightVO.getDeptIds().split(","))).distinct().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(deptIdList)) {
            returnDateRightVO.setDeptIds(String.join((CharSequence)",", deptIdList));
        }
        return returnDateRightVO;
    }

    @Override
    public List<SysRoleFunctions> functionListByUser(DivisionsLeaderDto dto) {
        if (dto.getUserId() == null) {
            return null;
        }
        SecurityUser user = this.userService.selectSecurityByUserId(dto.getUserId());
        List roleIdList = user.getRolesList();
        if (CollectionUtil.isEmpty((Collection)roleIdList)) {
            return null;
        }
        return ((DataRightManageMapper)this.baseMapper).functionListByUser(user.getRolesList());
    }

    @Override
    public List<SysRoleResource> resourceListByUser(DivisionsLeaderDto dto) {
        if (dto.getUserId() == null) {
            return null;
        }
        SecurityUser user = this.userService.selectSecurityByUserId(dto.getUserId());
        List roleIdList = user.getRolesList();
        if (CollectionUtil.isEmpty((Collection)roleIdList)) {
            return null;
        }
        List<SysRoleResource> roleResourceList = ((DataRightManageMapper)this.baseMapper).resourceListByUser(user.getRolesList());
        HashMap<Long, SysRoleResource> map = new HashMap<Long, SysRoleResource>();
        for (SysRoleResource roleResource : roleResourceList) {
            Long resourceId = roleResource.getResourceId();
            if (!map.containsKey(resourceId)) {
                map.put(resourceId, roleResource);
            }
            System.out.println("resourceId::: " + resourceId);
            if (!map.containsKey(resourceId) || StringUtils.equals((CharSequence)((SysRoleResource)map.get(resourceId)).getRelationSource(), (CharSequence)roleResource.getRelationSource()) || !"1".equals(roleResource.getRelationSource())) continue;
            map.put(resourceId, roleResource);
        }
        return HussarUtils.isNotEmpty(map) ? new ArrayList(map.values()) : new ArrayList();
    }

    @Override
    public List<DataRightVO> dataRightListByUser(DivisionsLeaderDto dto) {
        SecurityUser securityUser = this.userService.selectSecurityByUserId(dto.getUserId());
        if (securityUser != null) {
            return this.getDataRightVOList(securityUser.getRolesList());
        }
        return null;
    }

    @Override
    public List<Long> getPermissionProduct(Long userId) {
        return ((DataRightManageMapper)this.baseMapper).getProductByUserId(userId);
    }
}

