/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.organUser.external.servie.impl;

import com.jxdinfo.crm.common.api.associativeQuery.vo.ProvinceVo;
import com.jxdinfo.crm.common.api.organUser.IStruUserAPIService;
import com.jxdinfo.crm.common.organUser.service.IStruUserService;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class StruUserAPIServiceImpl
implements IStruUserAPIService {
    @Resource
    private IStruUserService struUserService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysOrganService organService;

    public List<SysStru> getDeptList(String deptName, List<String> excludeDepts) {
        return this.struUserService.getDeptList(deptName, excludeDepts);
    }

    public List<SysUsers> getUserList(String userName, List<String> excludeUsers) {
        return this.struUserService.getUserList(userName, excludeUsers);
    }

    public List<ProvinceVo> getProvinceList(String provinceName, List<Long> excludeIds) {
        return this.struUserService.getProvinceList(provinceName, excludeIds);
    }

    public SysStru getCompanyInfoByCurrentDeptId(String deptId) {
        Boolean findFlag = true;
        String companyId = deptId;
        SysStru res = null;
        while (findFlag.booleanValue()) {
            SysStru one = (SysStru)this.sysStruService.getById((Serializable)((Object)companyId));
            if ("1".equals(one.getStruType())) {
                findFlag = false;
                res = one;
                continue;
            }
            companyId = one.getParentId().toString();
        }
        if (null != res) {
            Long organId = res.getOrganId();
            SysOrgan organInfo = (SysOrgan)this.organService.getById((Serializable)organId);
            res.setOrganAlias(null == organInfo ? res.getOrganAlias() : organInfo.getOrganName());
        }
        return res;
    }

    public SysStru getCompanyInfoByUserId(String userId) {
        SysUsers userInfo = this.sysUsersService.getById(Long.valueOf(userId));
        if (null == userInfo) {
            return null;
        }
        String companyId = String.valueOf(userInfo.getCorporationId());
        Boolean findFlag = true;
        SysStru res = null;
        while (findFlag.booleanValue()) {
            SysStru one = (SysStru)this.sysStruService.getById((Serializable)((Object)companyId));
            if ("1".equals(one.getStruType())) {
                findFlag = false;
                res = one;
                continue;
            }
            companyId = one.getParentId().toString();
        }
        if (null != res) {
            res.setInforLevel(userInfo.getSecurityLevel() + "");
            Long organId = res.getOrganId();
            SysOrgan organInfo = (SysOrgan)this.organService.getById((Serializable)organId);
            res.setOrganAlias(null == organInfo ? res.getOrganAlias() : organInfo.getOrganName());
        }
        return res;
    }
}

