/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.dataRightManage.external.servie.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.common.api.dataRightManage.vo.DataRightVO;
import com.jxdinfo.crm.common.api.dataRightManage.vo.UserDepartmentVo;
import com.jxdinfo.crm.common.api.organUser.vo.DeptVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.common.dataRightManage.dto.DivisionsLeaderDto;
import com.jxdinfo.crm.common.dataRightManage.model.DivisionsLeader;
import com.jxdinfo.crm.common.dataRightManage.service.ICommonDataRightService;
import com.jxdinfo.crm.common.dataRightManage.service.IDataRightManageService;
import com.jxdinfo.crm.common.dataRightManage.service.IDivisionsLeaderService;
import com.jxdinfo.crm.common.organUser.service.IOrganUserService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DataRightBoServiceImpl
implements IDataRightBoService {
    @Resource
    private ICommonDataRightService commonDataRightService;
    @Resource
    private IDataRightManageService dataRightManageService;
    @Resource
    private IDivisionsLeaderService divisionsLeaderService;
    @Resource
    private IOrganUserService organUserService;

    public List<Long> getChargeDepartmentList() {
        return this.commonDataRightService.getChargeDepartmentList();
    }

    public List<Long> getChargeDepartmentHasDivisions() {
        return this.commonDataRightService.getChargeDepartmentHasDivisions();
    }

    public Map<Long, List<SecurityUser>> getChargePersonList(List<Long> departIdList) {
        return this.commonDataRightService.getChargePersonList(departIdList);
    }

    public List<Long> getSalesUserList(@Nullable Long userId, List<UserDepartmentVo> userDepartmentVoList) {
        return this.commonDataRightService.getSalesUserList(userId, userDepartmentVoList);
    }

    public List<Long> getAllSalesUserList(@Nullable Long userId, List<UserDepartmentVo> userDepartmentVoList) {
        return this.commonDataRightService.getAllSalesUserList(userId, userDepartmentVoList);
    }

    public PermissionDto getUserRolePermission(String module, SecurityUser user) {
        return this.commonDataRightService.getUserRolePermission(module, user);
    }

    public PermissionDto getCurrentUserRolePermissions(String module) {
        return this.commonDataRightService.getCurrentUserRolePermissions(module);
    }

    public PermissionDto getUserRolePermissionsByUserId(String module, Long userId) {
        return this.commonDataRightService.getUserRolePermissionsByUserId(module, userId);
    }

    public DataRightVO getUserDataRightByModule(String module, SecurityUser user) {
        List userRoles = user.getRolesList();
        return this.dataRightManageService.getDataRightVOList(userRoles, module);
    }

    public PermissionDto getPermissionInfo(String module, SecurityUser user) {
        PermissionDto permissionDto = new PermissionDto();
        permissionDto.setCurrentUserId(user.getUserId());
        DataRightVO dataRightVO = this.getUserDataRightByModule(module, user);
        if (dataRightVO == null) {
            permissionDto.setPermissionUserId(user.getId());
            return permissionDto;
        }
        ArrayList<Long> deptIdList = new ArrayList<Long>();
        boolean olnySelf = true;
        if (dataRightVO.getDataRightTypes().contains("4")) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
            return permissionDto;
        }
        if (dataRightVO.getDataRightTypes().contains("2")) {
            olnySelf = false;
            deptIdList.add(user.getDeptId());
        }
        if (dataRightVO.getDataRightTypes().contains("3")) {
            DivisionsLeaderDto divisionsLeaderDto = new DivisionsLeaderDto();
            divisionsLeaderDto.setUserId(user.getUserId());
            List<DeptVo> deptVoList = this.divisionsLeaderService.deptListByUser(divisionsLeaderDto);
            if (CollectionUtil.isNotEmpty(deptVoList)) {
                List<Long> divisionIdList = deptVoList.stream().map(DeptVo::getDeptId).collect(Collectors.toList());
                divisionIdList = this.organUserService.getOrganByParentIdContainsParent(divisionIdList);
                deptIdList.addAll(divisionIdList);
            }
            olnySelf = false;
        }
        if (dataRightVO.getDataRightTypes().contains("5")) {
            if (StringUtils.isNotEmpty((CharSequence)dataRightVO.getDeptIds())) {
                List thisDeptIdList = Arrays.stream(dataRightVO.getDeptIds().split(",")).map(Long::parseLong).collect(Collectors.toList());
                deptIdList.addAll(thisDeptIdList);
            }
            olnySelf = false;
        }
        if (olnySelf) {
            permissionDto.setPermissionUserId(user.getId());
        }
        if (deptIdList.isEmpty()) {
            deptIdList.add(-1L);
        }
        permissionDto.setPermissionDeptIds(deptIdList.stream().distinct().collect(Collectors.toList()));
        permissionDto.setPermissionProductIds(this.dataRightManageService.getPermissionProduct(user.getId()));
        return permissionDto;
    }

    public List<Long> getChargeDepartment(Long userId) {
        return this.commonDataRightService.getChargeDepartmentHasDivisions(userId);
    }

    public List<Long> getUserIdByDeptChargerDeptIds(List<Long> deptIds) {
        return this.divisionsLeaderService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{DivisionsLeader::getUserId}).in(DivisionsLeader::getDeptId, deptIds), s -> (Long)s);
    }

    public List<SysUsers> getChargePersonByDeptIds(List<Long> deptIdList) {
        List list = this.divisionsLeaderService.list((Wrapper)new LambdaQueryWrapper().in(DivisionsLeader::getDeptId, deptIdList));
        return list.stream().map(divisionsLeader -> {
            SysUsers user = new SysUsers();
            user.setId(divisionsLeader.getUserId());
            user.setDepartmentId(divisionsLeader.getDeptId());
            return user;
        }).collect(Collectors.toList());
    }
}

