/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.label.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.dto.SaveLabelDto;
import com.jxdinfo.crm.common.api.label.vo.LabelGroupVo;
import com.jxdinfo.crm.common.api.label.vo.LabelPermissionVo;
import com.jxdinfo.crm.common.api.label.vo.LabelVo;
import com.jxdinfo.crm.common.label.Constant.OperateLogEnum;
import com.jxdinfo.crm.common.label.dao.CrmLabelMapper;
import com.jxdinfo.crm.common.label.dto.BatchLabelPermissionDto;
import com.jxdinfo.crm.common.label.dto.ChangeLabelGroupDto;
import com.jxdinfo.crm.common.label.dto.LabelDto;
import com.jxdinfo.crm.common.label.dto.SearchLabelDto;
import com.jxdinfo.crm.common.label.dto.SortLabelGroupDto;
import com.jxdinfo.crm.common.label.model.CrmLabel;
import com.jxdinfo.crm.common.label.model.CrmLabelGroup;
import com.jxdinfo.crm.common.label.model.CrmLabelPermission;
import com.jxdinfo.crm.common.label.model.OperateLogEntity;
import com.jxdinfo.crm.common.label.service.ICrmLabelGroupService;
import com.jxdinfo.crm.common.label.service.ICrmLabelPermissionService;
import com.jxdinfo.crm.common.label.service.ICrmLabelService;
import com.jxdinfo.crm.common.label.service.OperateLogService;
import com.jxdinfo.crm.common.label.vo.SaveLabelVo;
import com.jxdinfo.crm.common.organUser.service.IOrganUserService;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.base.HussarDelflagEntity;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CrmLabelServiceImpl
extends HussarBaseServiceImpl<CrmLabelMapper, CrmLabel>
implements ICrmLabelService {
    @Resource
    private ICrmLabelPermissionService labelPermissionService;
    @Resource
    private ICrmLabelGroupService labelGroupService;
    @Resource
    private CrmCommonProperties crmCommonProperties;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private OperateLogService operateLogService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IOrganUserService organUserService;
    @Resource
    private CrmLabelMapper crmLabelMapper;

    @Override
    public Page<LabelVo> selectLabelList(SearchLabelDto labelDto) {
        Page page = new Page();
        page.setSize((long)labelDto.getSize().intValue());
        page.setCurrent((long)labelDto.getCurrent().intValue());
        if ("3".equals(labelDto.getLabelCategory())) {
            Long personalGroupId = Long.parseLong(this.crmBaseConfigBoService.getCrmBaseConfigByKey("personal_label_group").getConfigValue());
            labelDto.setLabelGroupId(personalGroupId);
            SecurityUser user = BaseSecurityUtil.getUser();
            List userRoles = user.getRolesList();
            Long userId = user.getId();
            if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getLabelManager()))) {
                userId = null;
            }
            List<LabelVo> list = ((CrmLabelMapper)this.baseMapper).selectPersonalLabelList((Page<LabelVo>)page, labelDto, userId);
            page.setRecords(list);
        } else {
            List<LabelVo> list = ((CrmLabelMapper)this.baseMapper).selectLabelList((Page<LabelVo>)page, labelDto);
            if (list.size() != 0) {
                List idList = list.stream().map(o -> o.getLabelId()).collect(Collectors.toList());
                List crmLabelPermissionList = ((LambdaQueryChainWrapper)this.labelPermissionService.lambdaQuery().in(CrmLabelPermission::getBusinessId, idList)).list();
                for (LabelVo labelVo : list) {
                    List<CrmLabelPermission> permissionList = crmLabelPermissionList.stream().filter(o -> labelVo.getLabelId().equals(o.getBusinessId())).collect(Collectors.toList());
                    labelVo.setPermissionName(this.getPermissionName(permissionList));
                }
            }
            page.setRecords(list);
        }
        return page;
    }

    @Override
    public List<LabelVo> selectUserLabelListByGroupId(SearchLabelDto labelDto) {
        Long personalGroupId = Long.parseLong(this.crmBaseConfigBoService.getCrmBaseConfigByKey("personal_label_group").getConfigValue());
        if ("3".equals(labelDto.getLabelCategory()) || personalGroupId.equals(labelDto.getLabelGroupId())) {
            labelDto.setLabelGroupId(personalGroupId);
            SecurityUser user = BaseSecurityUtil.getUser();
            List userRoles = user.getRolesList();
            Long userId = user.getId();
            if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getLabelManager()))) {
                userId = null;
            }
            return ((CrmLabelMapper)this.baseMapper).selectPersonalLabelList(labelDto, userId);
        }
        return this.getLabelListForUserByGroupId(labelDto.getLabelGroupId().toString());
    }

    @Override
    public List<LabelPermissionVo> loadBefore() {
        List<CrmLabel> crmLabelList = ((CrmLabelMapper)this.baseMapper).selectListByUser(BaseSecurityUtil.getUser().getId());
        if (ToolUtil.isEmpty(crmLabelList)) {
            return new ArrayList<LabelPermissionVo>();
        }
        CrmLabel crmLabel = crmLabelList.get(0);
        List<LabelPermissionVo> labelPermissionVoList = this.labelPermissionService.selectLabelPermissionVo(crmLabel.getLabelId());
        if (labelPermissionVoList.size() > 0) {
            return labelPermissionVoList;
        }
        return new ArrayList<LabelPermissionVo>();
    }

    private String getPermissionName(List<CrmLabelPermission> permissionList) {
        String permissionName = "";
        if (CollectionUtil.isNotEmpty(permissionList)) {
            StringBuilder deptName = new StringBuilder();
            List deptPermissionList = permissionList.stream().filter(permission -> permission.getStruType().equals("2") || permission.getStruType().equals("1")).map(CrmLabelPermission::getStruId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(deptPermissionList)) {
                List sysStruList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysStruService.lambdaQuery().in(SysStru::getId, deptPermissionList)).in(SysStru::getStruType, Arrays.asList(1, 2))).orderByAsc(SysStru::getStruOrder)).list();
                for (SysStru sysStru : sysStruList) {
                    deptName.append("\u3001").append(sysStru.getOrganAlias());
                }
            }
            StringBuilder userName = new StringBuilder();
            List userPermissionList = permissionList.stream().filter(permission -> permission.getStruType().equals("9")).map(CrmLabelPermission::getStruId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(userPermissionList)) {
                List sysUsersList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sysUsersService.lambdaQuery().in(SysUsers::getId, userPermissionList)).orderByAsc(SysUsers::getUserOrder)).list();
                for (SysUsers sysUsers : sysUsersList) {
                    userName.append("\u3001").append(sysUsers.getUserName());
                }
            }
            if (deptName.length() > 0) {
                permissionName = "\u7ec4\u7ec7\uff1a" + deptName.substring(1);
            }
            if (userName.length() > 0) {
                if (permissionName.length() > 0) {
                    permissionName = permissionName + "\uff1b";
                }
                permissionName = permissionName + "\u4eba\u5458\uff1a" + userName.substring(1);
            }
        }
        return permissionName;
    }

    @Override
    @HussarTransactional
    public String addLabel(LabelDto labelDto) {
        if (StringUtil.isBlank((CharSequence)labelDto.getLabelName())) {
            throw new BaseException("\u8bf7\u8f93\u5165\u6807\u7b7e\u540d\u79f0");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        String labelNames = labelDto.getLabelName().replaceAll(" ", "");
        List labelNameList = Stream.of(labelNames.split("\\r?\\n")).distinct().collect(Collectors.toList());
        ArrayList<CrmLabel> labelEntityList = new ArrayList<CrmLabel>();
        if (ToolUtil.isEmpty((Object)labelDto.getLabelGroupId())) {
            labelDto.setLabelGroupId(Long.valueOf(this.crmBaseConfigBoService.getCrmBaseConfigByKey("personal_label_group").getConfigValue()));
        }
        CrmLabelGroup crmLabelGroup = (CrmLabelGroup)((Object)this.labelGroupService.getById(labelDto.getLabelGroupId()));
        List<String> alreadyLabelName = this.selectAlreadyLabelName(labelDto.getLabelGroupId(), new ArrayList<Long>(), labelDto.getModuleId(), crmLabelGroup.getLabelCategory(), BaseSecurityUtil.getUser().getId());
        StringBuilder sb = new StringBuilder();
        sb.append("\u5df2\u5b58\u5728");
        boolean repeat = false;
        Integer showOrder = this.getMaxShowOrder(labelDto.getLabelGroupId());
        Integer order = 0;
        for (String labelName : labelNameList) {
            if (alreadyLabelName.contains(labelName)) {
                sb.append(labelName).append("\uff0c");
                repeat = true;
            }
            if (repeat) continue;
            CrmLabel labelEntity = this.initLabelEntity(labelName, showOrder + order, labelDto.getModuleId(), user, date, labelDto.getLabelGroupId());
            labelEntityList.add(labelEntity);
            Integer n = order;
            order = order + 1;
            Integer n2 = order;
        }
        if (repeat) {
            String repeatLabelName = sb.substring(0, sb.length() - 1);
            repeatLabelName = repeatLabelName + "\u6807\u7b7e\uff0c\u7981\u6b62\u91cd\u590d";
            throw new BaseException(repeatLabelName);
        }
        this.saveBatch(labelEntityList);
        LinkedList<CrmLabelPermission> labelPermissionEntityList = new LinkedList<CrmLabelPermission>();
        if (CollectionUtil.isNotEmpty(labelDto.getLabelPermissionList())) {
            for (CrmLabel labelEntity : labelEntityList) {
                List<CrmLabelPermission> list = labelDto.getLabelPermissionList();
                for (CrmLabelPermission labelPermission : list) {
                    CrmLabelPermission labelPermissionEntity = new CrmLabelPermission();
                    labelPermissionEntity.setBusinessId(labelEntity.getLabelId());
                    labelPermissionEntity.setBusinessType(labelPermission.getBusinessType());
                    labelPermissionEntity.setStruId(labelPermission.getStruId());
                    labelPermissionEntity.setStruType(labelPermission.getStruType());
                    labelPermissionEntityList.add(labelPermissionEntity);
                }
            }
            this.labelPermissionService.saveBatch(labelPermissionEntityList);
        }
        return "";
    }

    @Override
    @HussarTransactional
    public String updateLabel(LabelDto labelDto) {
        if (StringUtil.isBlank((CharSequence)labelDto.getLabelName()) || ToolUtil.isEmpty((Object)labelDto.getLabelGroupId())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        CrmLabelGroup crmLabelGroup = (CrmLabelGroup)((Object)this.labelGroupService.getById(labelDto.getLabelGroupId()));
        List<String> alreadyLabelNames = this.selectAlreadyLabelName(labelDto.getLabelGroupId(), Arrays.asList(labelDto.getLabelId()), labelDto.getModuleId(), crmLabelGroup.getLabelCategory(), labelDto.getCreator());
        if (alreadyLabelNames.contains(labelDto.getLabelName())) {
            throw new BaseException("\u5f53\u524d\u5206\u7ec4\u4e0b\u5df2\u5b58\u5728\u8be5\u6807\u7b7e\uff0c\u7981\u6b62\u91cd\u590d");
        }
        CrmLabel labelEntity = (CrmLabel)((Object)BeanUtil.copy((Object)labelDto, CrmLabel.class));
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        labelEntity.setLastTime(date);
        labelEntity.setLastEditor(user.getUserId());
        labelEntity.setLastEditorName(user.getUserName());
        this.labelPermissionService.remove((Wrapper)new LambdaQueryWrapper().eq(CrmLabelPermission::getBusinessId, (Object)labelDto.getLabelId()));
        List<CrmLabelPermission> labelPermissionEntityList = labelDto.getLabelPermissionList();
        LinkedList<CrmLabelPermission> newLabelPermissionEntityList = new LinkedList<CrmLabelPermission>();
        if (ToolUtil.isNotEmpty(labelPermissionEntityList)) {
            for (CrmLabelPermission labelPermissionEntity : labelPermissionEntityList) {
                CrmLabelPermission labelPermission = new CrmLabelPermission();
                labelPermission.setBusinessType(labelPermissionEntity.getBusinessType());
                labelPermission.setBusinessId(labelDto.getLabelId());
                labelPermission.setStruId(labelPermissionEntity.getStruId());
                labelPermission.setStruType(labelPermissionEntity.getStruType());
                newLabelPermissionEntityList.add(labelPermission);
            }
        }
        this.updateById((BaseEntity)labelEntity);
        this.labelPermissionService.saveBatch(newLabelPermissionEntityList);
        return "";
    }

    public boolean removeByIds(Collection<?> idList) {
        SecurityUser user = BaseSecurityUtil.getUser();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(HussarBaseEntity::getLastEditor, (Object)user.getId())).set(CrmLabel::getLastEditorName, (Object)user.getUserName())).set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now())).set(HussarDelflagEntity::getDelFlag, (Object)"1")).in(CrmLabel::getLabelId, idList)).update();
    }

    @Override
    public Boolean disable(LabelDto labelDto) {
        if (ToolUtil.isEmpty((Object)labelDto.getLabelId()) || ToolUtil.isEmpty((Object)labelDto.getDisableFlag())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        String userName = BaseSecurityUtil.getUser().getUserName();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(CrmLabel::getDisableFlag, (Object)labelDto.getDisableFlag())).set(CrmLabel::getLastEditorName, (Object)userName)).set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now())).eq(CrmLabel::getLabelId, (Object)labelDto.getLabelId())).update();
    }

    @Override
    public Boolean changeLabelGroup(ChangeLabelGroupDto dto) {
        if (ToolUtil.isEmpty(dto.getLabelIdList()) || ToolUtil.isEmpty((Object)dto.getLabelGroupId())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        List crmLabelList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmLabel::getLabelId, dto.getLabelIdList())).list();
        if (ToolUtil.isEmpty((Object)crmLabelList)) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        CrmLabelGroup crmLabelGroup = (CrmLabelGroup)((Object)this.labelGroupService.getById(dto.getLabelGroupId()));
        List<String> alreadyLabelName = this.selectAlreadyLabelName(dto.getLabelGroupId(), dto.getLabelIdList(), "", crmLabelGroup.getLabelCategory(), BaseSecurityUtil.getUser().getId());
        StringBuilder sb = new StringBuilder();
        sb.append("\u76ee\u6807\u5206\u7ec4\u4e0b\u5df2\u5b58\u5728");
        boolean repeat = false;
        for (CrmLabel crmLabel : crmLabelList) {
            if (!alreadyLabelName.contains(crmLabel.getLabelName())) continue;
            sb.append(crmLabel.getLabelName()).append("\uff0c");
            repeat = true;
        }
        if (repeat) {
            String repeatLabelName = sb.substring(0, sb.length() - 1);
            repeatLabelName = repeatLabelName + "\u6807\u7b7e\uff0c\u65e0\u6cd5\u8f6c\u79fb";
            throw new BaseException(repeatLabelName);
        }
        String userName = BaseSecurityUtil.getUser().getUserName();
        Long userId = BaseSecurityUtil.getUser().getId();
        crmLabelList.stream().map(label -> {
            label.setLabelGroupId(dto.getLabelGroupId());
            label.setLastTime(LocalDateTime.now());
            label.setLastEditor(userId);
            label.setLastEditorName(userName);
            return label;
        }).collect(Collectors.toList());
        return this.saveOrUpdateBatch(crmLabelList);
    }

    @Override
    public Boolean sortLabelGroup(SortLabelGroupDto dto) {
        List<Long> idList = dto.getIdList();
        if (ToolUtil.isEmpty(idList)) {
            throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userName = BaseSecurityUtil.getUser().getUserName();
        ArrayList<CrmLabel> crmLabelList = new ArrayList<CrmLabel>();
        int i = 0;
        while (i < idList.size()) {
            CrmLabel crmLabel = new CrmLabel();
            crmLabel.setLabelId(idList.get(i));
            crmLabel.setShowOrder(++i);
            crmLabel.setLastEditorName(userName);
            crmLabelList.add(crmLabel);
        }
        return this.updateBatchById(crmLabelList);
    }

    @Override
    public Boolean sortLabelForPersonal(SortLabelGroupDto dto) {
        List<Long> idList = dto.getIdList();
        if (ToolUtil.isEmpty(idList)) {
            throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userName = BaseSecurityUtil.getUser().getUserName();
        List crmLabelList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmLabel::getLabelId, idList)).list();
        List orderNum = crmLabelList.stream().map(CrmLabel::getShowOrder).sorted().collect(Collectors.toList());
        Integer index = 0;
        for (Long id : idList) {
            if (index >= orderNum.size()) {
                throw new BaseException("\u83b7\u53d6\u5206\u7ec4\u5e8f\u53f7\u5f02\u5e38");
            }
            for (CrmLabel crmLabel : crmLabelList) {
                if (!id.equals(crmLabel.getLabelId())) continue;
                crmLabel.setShowOrder((Integer)orderNum.get(index));
                crmLabel.setLastEditorName(userName);
                break;
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return this.saveOrUpdateBatch(crmLabelList);
    }

    @Override
    public Integer getMaxShowOrder(Long labelGroupId) {
        Integer showOrder = ((CrmLabelMapper)this.baseMapper).getMaxShowOrder(labelGroupId);
        return showOrder == null ? 1 : Integer.valueOf(showOrder + 1);
    }

    @Override
    public List<LabelVo> getLabelListForUserByModule(String moduleId) {
        return this.getLabelListForUserByModule(moduleId, null, null);
    }

    @Override
    public List<LabelVo> getLabelListForUserByModule(String moduleId, String searchKey, List<String> exclueLabels) {
        if (ToolUtil.isEmpty((Object)moduleId)) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        LabelModuleEnum moduleEnum = LabelModuleEnum.getEnumByModuleId((String)moduleId);
        if (moduleEnum == null) {
            throw new BaseException("\u5f53\u524d\u5bf9\u8c61\u4e0d\u652f\u6301\u6807\u7b7e\u529f\u80fd");
        }
        List<LabelVo> commonLabelList = this.getLabelListForUser(moduleId, searchKey, exclueLabels);
        List<LabelVo> personalLabelList = this.getLabelListForUserOfPersonal(moduleId, searchKey);
        personalLabelList.stream().map(o -> {
            o.setGroupName("\u4e2a\u4eba\u6807\u7b7e\u9ed8\u8ba4\u5206\u7ec4");
            o.setGroupShowOrder(Integer.valueOf(1));
            o.setLabelCategory("3");
            return o;
        }).collect(Collectors.toList());
        commonLabelList.addAll(personalLabelList);
        return commonLabelList;
    }

    @Override
    public List<LabelGroupVo> listByModuleId(String moduleId, String searchKey, Boolean showDisable) {
        return this.listByModuleId(moduleId, searchKey, null, showDisable);
    }

    @Override
    public List<LabelGroupVo> listByModuleId(String moduleId, String searchKey, String groupSearchKey, Boolean showDisable) {
        if (ToolUtil.isEmpty((Object)moduleId)) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        LabelModuleEnum moduleEnum = LabelModuleEnum.getEnumByModuleId((String)moduleId);
        if (moduleEnum == null) {
            throw new BaseException("\u5f53\u524d\u5bf9\u8c61\u4e0d\u652f\u6301\u6807\u7b7e\u529f\u80fd");
        }
        List<Object> labelList = this.getLabelListForUser(moduleId, searchKey, groupSearchKey, null);
        if (ToolUtil.isEmpty((Object)showDisable) || !showDisable.booleanValue()) {
            labelList = labelList.stream().filter(o -> "0".equals(o.getDisableFlag())).collect(Collectors.toList());
        }
        Map<Long, List<LabelVo>> labelMap = labelList.stream().collect(Collectors.groupingBy(LabelVo::getLabelGroupId));
        ArrayList<LabelGroupVo> labelGroupList = new ArrayList<LabelGroupVo>();
        for (Long key : labelMap.keySet()) {
            LabelGroupVo groupVo = new LabelGroupVo();
            List<LabelVo> labelVos = labelMap.get(key);
            groupVo.setGroupId(key);
            groupVo.setGroupName(labelVos.get(0).getGroupName());
            groupVo.setShowOrder(labelVos.get(0).getGroupShowOrder());
            groupVo.setLabelCategory(labelVos.get(0).getLabelCategory());
            groupVo.setLabelList(labelVos);
            labelGroupList.add(groupVo);
        }
        List<LabelGroupVo> labelGroupListSorted = labelGroupList.stream().sorted(Comparator.comparing(LabelGroupVo::getLabelCategory).thenComparing(LabelGroupVo::getShowOrder)).collect(Collectors.toList());
        for (LabelGroupVo labelGroupVo : labelGroupListSorted) {
            List labelSorted = labelGroupVo.getLabelList().stream().sorted(Comparator.comparing(LabelVo::getShowOrder)).collect(Collectors.toList());
            labelGroupVo.setLabelList(labelSorted);
        }
        return labelGroupListSorted;
    }

    @Override
    public List<LabelVo> listByModuleIdForPersonal(String moduleId, String searchKey) {
        if (ToolUtil.isEmpty((Object)moduleId)) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        LabelModuleEnum moduleEnum = LabelModuleEnum.getEnumByModuleId((String)moduleId);
        if (moduleEnum == null) {
            throw new BaseException("\u5f53\u524d\u5bf9\u8c61\u4e0d\u652f\u6301\u6807\u7b7e\u529f\u80fd");
        }
        return this.getLabelListForUserOfPersonal(moduleId, searchKey).stream().filter(o -> "0".equals(o.getDisableFlag())).collect(Collectors.toList());
    }

    private List<LabelVo> getLabelListForUserOfPersonal(String moduleId, String searchKey) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmLabel::getModuleId, (Object)moduleId)).like(ToolUtil.isNotEmpty((Object)searchKey), CrmLabel::getLabelName, (Object)searchKey)).eq(HussarBaseEntity::getCreator, (Object)BaseSecurityUtil.getUser().getId())).orderByAsc(CrmLabel::getShowOrder)).list().stream().map(o -> (LabelVo)BeanUtil.copy((Object)o, LabelVo.class)).collect(Collectors.toList());
    }

    @Override
    public List<SaveLabelVo> listByBusinessId(String moduleId, Long businessId) {
        if (ToolUtil.isEmpty((Object)moduleId)) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        LabelModuleEnum moduleEnum = LabelModuleEnum.getEnumByModuleId((String)moduleId);
        if (moduleEnum == null) {
            throw new BaseException("\u5f53\u524d\u5bf9\u8c61\u4e0d\u652f\u6301\u6807\u7b7e\u529f\u80fd");
        }
        List<String> labelIdsList = ((CrmLabelMapper)this.baseMapper).getLabelByBusinessId(moduleEnum.getTableName(), moduleEnum.getPrimaryFieldName(), moduleEnum.getLabelFieldName(), businessId);
        if (ToolUtil.isEmpty(labelIdsList) || labelIdsList.size() == 0) {
            if (LabelModuleEnum.OPPORTUNITY.getModuleId().equals(moduleId)) {
                labelIdsList = ((CrmLabelMapper)this.baseMapper).getLabelByBusinessId(LabelModuleEnum.OPPORTUNITY_POOL_OPPO.getTableName(), LabelModuleEnum.OPPORTUNITY_POOL_OPPO.getPrimaryFieldName(), LabelModuleEnum.OPPORTUNITY_POOL_OPPO.getLabelFieldName(), businessId);
            }
            if (ToolUtil.isEmpty(labelIdsList) || labelIdsList.size() == 0) {
                throw new BaseException("\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728");
            }
        }
        String labelIds = String.join((CharSequence)",", labelIdsList);
        List labeledList = null;
        if (!ToolUtil.isNotEmpty((Object)labelIds)) {
            return new ArrayList<SaveLabelVo>();
        }
        String[] labelIdArr = labelIds.split(",");
        labeledList = Arrays.asList(labelIdArr).stream().distinct().collect(Collectors.toList());
        List<LabelVo> labelList = this.getLabelListForUser(moduleId, null, null);
        ArrayList<Object> resultLabelListCommon = new ArrayList<Object>();
        for (LabelVo labelVo : labelList) {
            if (!labeledList.contains(String.valueOf(labelVo.getLabelId()))) continue;
            resultLabelListCommon.add(BeanUtil.copy((Object)labelVo, SaveLabelVo.class));
        }
        List<LabelVo> labelVoList = this.getLabelListForUserOfPersonal(moduleId, null);
        ArrayList<SaveLabelVo> resultLabelListPersonal = new ArrayList<SaveLabelVo>();
        for (LabelVo labelVo : labelVoList) {
            if (!labeledList.contains(String.valueOf(labelVo.getLabelId()))) continue;
            SaveLabelVo saveLabelVo = (SaveLabelVo)BeanUtil.copy((Object)labelVo, SaveLabelVo.class);
            saveLabelVo.setLabelCategory("3");
            resultLabelListPersonal.add(saveLabelVo);
        }
        ArrayList<Object> resultLabelList = new ArrayList<Object>();
        resultLabelList.addAll(resultLabelListCommon);
        resultLabelList.addAll(resultLabelListPersonal);
        return resultLabelList.stream().sorted((a, b) -> {
            int comparison = a.getLabelCategory().compareTo(b.getLabelCategory());
            if (comparison == 0 && (comparison = ToolUtil.isEmpty((Object)a.getGroupShowOrder()) && ToolUtil.isEmpty((Object)b.getGroupShowOrder()) ? 0 : (ToolUtil.isEmpty((Object)a.getGroupShowOrder()) ? 1 : (ToolUtil.isEmpty((Object)b.getGroupShowOrder()) ? -1 : a.getGroupShowOrder().compareTo(b.getGroupShowOrder())))) == 0) {
                comparison = a.getShowOrder().compareTo(b.getShowOrder());
            }
            return comparison;
        }).collect(Collectors.toList());
    }

    @Override
    @HussarTransactional
    public Boolean userSaveLabel(SaveLabelDto labelDto) {
        if (labelDto == null || ToolUtil.isEmpty((Object)labelDto.getModuleId())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        if (labelDto.getChooseBatch().booleanValue() && CollectionUtil.isEmpty((Collection)labelDto.getBusinessIds()) && CollectionUtil.isEmpty((Collection)labelDto.getAddLabelIds())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        if (!labelDto.getChooseBatch().booleanValue() && HussarUtils.isNotEmpty((Object)labelDto.getBusinessId()) && CollectionUtil.isEmpty((Collection)labelDto.getBusinessIds())) {
            labelDto.setBusinessIds((List)CollectionUtil.toList((Object[])new Long[]{labelDto.getBusinessId()}));
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        LabelModuleEnum moduleEnum = LabelModuleEnum.getEnumByModuleId((String)labelDto.getModuleId());
        if (moduleEnum == null) {
            throw new BaseException("\u5f53\u524d\u5bf9\u8c61\u4e0d\u652f\u6301\u6807\u7b7e\u529f\u80fd");
        }
        LinkedList<OperateLogEntity> operateLogVoList = new LinkedList<OperateLogEntity>();
        for (Long businessId : labelDto.getBusinessIds()) {
            this.labelOperate(operateLogVoList, moduleEnum, businessId, labelDto, user, date);
        }
        if (CollectionUtil.isNotEmpty(operateLogVoList)) {
            this.operateLogService.saveBatch(operateLogVoList);
        }
        return true;
    }

    @Override
    public List<LabelVo> getLabelListForUser(String moduleId, String searchKey, List<String> exclueLabels) {
        return this.getLabelListForUser(moduleId, searchKey, null, exclueLabels);
    }

    @Override
    public Boolean deleteLabel(SaveLabelDto labelDto) {
        if (labelDto == null || ToolUtil.isEmpty((Object)labelDto.getModuleId())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        if (labelDto.getChooseBatch().booleanValue() && CollectionUtil.isEmpty((Collection)labelDto.getBusinessIds()) && CollectionUtil.isEmpty((Collection)labelDto.getAddLabelIds()) || labelDto.getChooseBatch().booleanValue() && HussarUtils.isEmpty((Object)labelDto.getBusinessId())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        LabelModuleEnum moduleEnum = LabelModuleEnum.getEnumByModuleId((String)labelDto.getModuleId());
        if (moduleEnum == null) {
            throw new BaseException("\u5f53\u524d\u5bf9\u8c61\u4e0d\u652f\u6301\u6807\u7b7e\u529f\u80fd");
        }
        LinkedList<OperateLogEntity> operateLogVoList = new LinkedList<OperateLogEntity>();
        ArrayList<Long> businessIds = new ArrayList<Long>();
        if (labelDto.getChooseBatch().booleanValue()) {
            businessIds.addAll(labelDto.getBusinessIds());
            for (Long businessId : labelDto.getBusinessIds()) {
                this.labelOperate(operateLogVoList, moduleEnum, businessId, labelDto, user, date);
            }
        } else {
            Long businessId = labelDto.getBusinessId();
            businessIds.add(businessId);
            this.labelOperate(operateLogVoList, moduleEnum, businessId, labelDto, user, date);
        }
        if (CollectionUtil.isNotEmpty(operateLogVoList)) {
            this.operateLogService.saveBatch(operateLogVoList);
        }
        return true;
    }

    private List<LabelVo> getLabelListForUser(String moduleId, String searchKey, String groupSearchKey, List<String> exclueLabels) {
        SysStru sysStru;
        SecurityUser user = BaseSecurityUtil.getUser();
        String struPidStr = null;
        if (ToolUtil.isNotEmpty((Object)user.getDeptId()) && ToolUtil.isNotEmpty((Object)(sysStru = (SysStru)this.sysStruService.getById((Serializable)user.getDeptId())))) {
            struPidStr = sysStru.getStruFid();
        }
        ArrayList<String> StruList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(struPidStr)) {
            if (struPidStr.startsWith("/")) {
                struPidStr = struPidStr.replaceFirst("/", "");
            }
            if (struPidStr.endsWith("/")) {
                struPidStr = struPidStr.substring(0, struPidStr.length() - 1);
            }
            String[] struPidArr = struPidStr.split("/");
            List<String> asList = Arrays.asList(struPidArr);
            StruList.addAll(asList);
        } else {
            StruList.add("100001");
        }
        List<LabelVo> list = ((CrmLabelMapper)this.baseMapper).getLabelListByModuleId(user.getUserId(), StruList, moduleId, searchKey, groupSearchKey, exclueLabels);
        return list.stream().distinct().collect(Collectors.toList());
    }

    private List<LabelVo> getLabelListForUserByGroupId(String groupId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String struPidStr = null;
        if (ToolUtil.isNotEmpty((Object)user.getDeptId())) {
            struPidStr = ((SysStru)this.sysStruService.getById((Serializable)user.getDeptId())).getStruFid();
        }
        ArrayList<String> StruList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(struPidStr)) {
            if (struPidStr.startsWith("/")) {
                struPidStr = struPidStr.replaceFirst("/", "");
            }
            if (struPidStr.endsWith("/")) {
                struPidStr = struPidStr.substring(0, struPidStr.length() - 1);
            }
            String[] struPidArr = struPidStr.split("/");
            List<String> asList = Arrays.asList(struPidArr);
            StruList.addAll(asList);
        } else {
            StruList.add("100001");
        }
        List<LabelVo> list = ((CrmLabelMapper)this.baseMapper).getLabelListByGroupId(user.getUserId(), StruList, groupId);
        return list.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public String isUsedByLabelId(List<Long> labelIds) {
        String labelName = "";
        for (Long labelId : labelIds) {
            CrmLabel labelEntity = (CrmLabel)((Object)this.getById(labelId));
            if (ToolUtil.isEmpty((Object)((Object)labelEntity)) || ToolUtil.isEmpty((Object)labelEntity.getLabelGroupId())) {
                throw new BaseException("\u6807\u7b7e\u4e0d\u5b58\u5728");
            }
            if (this.crmBaseConfigBoService.getCrmBaseConfigByKey("personal_label_group").getConfigValue().equals(String.valueOf(labelEntity.getLabelGroupId()))) {
                LabelModuleEnum moduleEnum = LabelModuleEnum.getEnumByModuleId((String)labelEntity.getModuleId());
                if (moduleEnum == null) {
                    throw new BaseException("\u5f53\u524d\u5bf9\u8c61\u4e0d\u652f\u6301\u6807\u7b7e\u529f\u80fd");
                }
                Long count = ((CrmLabelMapper)this.baseMapper).getUsedCountByLabelId(moduleEnum.getTableName(), moduleEnum.getLabelFieldName(), labelId);
                if (count <= 0L) continue;
                labelName = labelName + "\u3001" + labelEntity.getLabelName();
                continue;
            }
            CrmLabelGroup labelGroupEntity = (CrmLabelGroup)((Object)this.labelGroupService.getById(labelEntity.getLabelGroupId()));
            if (ToolUtil.isEmpty((Object)labelGroupEntity.getModuleId())) {
                throw new BaseException("\u6807\u7b7e\u5206\u7ec4\u4e0d\u5b58\u5728");
            }
            LabelModuleEnum moduleEnum = LabelModuleEnum.getEnumByModuleId((String)labelGroupEntity.getModuleId());
            if (moduleEnum == null) {
                throw new BaseException("\u5f53\u524d\u5bf9\u8c61\u4e0d\u652f\u6301\u6807\u7b7e\u529f\u80fd");
            }
            Long count = ((CrmLabelMapper)this.baseMapper).getUsedCountByLabelId(moduleEnum.getTableName(), moduleEnum.getLabelFieldName(), labelId);
            if (count <= 0L) continue;
            labelName = labelName + "\u3001" + labelEntity.getLabelName();
        }
        return (labelName = Arrays.stream(labelName.split("\u3001")).distinct().collect(Collectors.joining("\u3001"))).length() > 0 ? "\u3010" + labelName.substring(1) + "\u3011\u5df2\u4f7f\u7528" : labelName;
    }

    @Override
    @HussarTransactional
    public Boolean BatchLabelPermission(BatchLabelPermissionDto labelPermissionDto) {
        if (ToolUtil.isEmpty((Object)labelPermissionDto) || ToolUtil.isEmpty(labelPermissionDto.getLabelIds()) || ToolUtil.isEmpty(labelPermissionDto.getLabelPermissionList())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        String userName = BaseSecurityUtil.getUser().getUserName();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(CrmLabel::getLastEditorName, (Object)userName)).set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now())).in(CrmLabel::getLabelId, labelPermissionDto.getLabelIds())).update();
        this.labelPermissionService.remove((Wrapper)new LambdaQueryWrapper().in(CrmLabelPermission::getBusinessId, labelPermissionDto.getLabelIds()));
        ArrayList<CrmLabelPermission> permissionEntityList = new ArrayList<CrmLabelPermission>();
        for (CrmLabelPermission permissionEntity : labelPermissionDto.getLabelPermissionList()) {
            for (Long labelId : labelPermissionDto.getLabelIds()) {
                CrmLabelPermission labelPermissionEntity = new CrmLabelPermission();
                labelPermissionEntity.setBusinessType("1");
                labelPermissionEntity.setBusinessId(labelId);
                labelPermissionEntity.setStruType(permissionEntity.getStruType());
                labelPermissionEntity.setStruId(permissionEntity.getStruId());
                permissionEntityList.add(labelPermissionEntity);
            }
        }
        return this.labelPermissionService.saveOrUpdateBatch(permissionEntityList);
    }

    @Override
    public List<LabelVo> selectLabelListByGroup(long labelGroupId) {
        return ((CrmLabelMapper)this.baseMapper).selectLabelListByGroup(labelGroupId);
    }

    @Override
    public LabelVo getDetail(Long labelId) {
        if (ToolUtil.isEmpty((Object)labelId)) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        CrmLabel labelEntity = (CrmLabel)((Object)this.getById(labelId));
        if (labelEntity == null || "0".equals((Object)labelEntity)) {
            return null;
        }
        LabelVo labelVo = (LabelVo)BeanUtil.copy((Object)((Object)labelEntity), LabelVo.class);
        if (labelVo == null) {
            throw new BaseException("\u83b7\u53d6\u6807\u7b7e\u5f02\u5e38");
        }
        CrmLabelGroup labelGroup = (CrmLabelGroup)((Object)this.labelGroupService.getById(labelEntity.getLabelGroupId()));
        labelVo.setGroupName(labelGroup.getGroupName());
        List<LabelPermissionVo> labelPermissionVoList = this.labelPermissionService.selectLabelPermissionVo(labelId);
        labelVo.setLabelPermissionVoList(labelPermissionVoList);
        return labelVo;
    }

    private CrmLabel initLabelEntity(String labelName, Integer showOrder, String moduleId, SecurityUser user, LocalDateTime date, Long labelGroupId) {
        CrmLabel labelEntity = new CrmLabel();
        labelEntity.setLabelName(labelName);
        labelEntity.setLabelGroupId(labelGroupId);
        labelEntity.setShowOrder(showOrder);
        labelEntity.setModuleId(moduleId);
        labelEntity.setDisableFlag("0");
        labelEntity.setLabelType("0");
        labelEntity.setCreator(user.getUserId());
        labelEntity.setCreatorName(user.getUserName());
        labelEntity.setCreateTime(date);
        labelEntity.setLastEditor(user.getUserId());
        labelEntity.setLastEditorName(user.getUserName());
        labelEntity.setLastTime(date);
        labelEntity.setDelFlag("0");
        return labelEntity;
    }

    private List<String> selectAlreadyLabelName(Long labelGroupId, List<Long> labelIds, String moduleId, String labelCategory, Long userId) {
        if (!"3".equals(labelCategory)) {
            return this.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{CrmLabel::getLabelName}).notIn(labelIds.size() > 0, CrmLabel::getLabelId, labelIds)).eq(CrmLabel::getLabelGroupId, (Object)labelGroupId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"), s -> s.toString());
        }
        return this.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{CrmLabel::getLabelName}).notIn(labelIds.size() > 0, CrmLabel::getLabelId, labelIds)).eq(CrmLabel::getModuleId, (Object)moduleId)).eq(HussarBaseEntity::getCreator, (Object)userId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"), s -> s.toString());
    }

    private void labelOperate(List<OperateLogEntity> operateLogEntities, LabelModuleEnum moduleEnum, Long businessId, SaveLabelDto labelDto, SecurityUser user, LocalDateTime date) {
        List<String> labelIdsList = ((CrmLabelMapper)this.baseMapper).getLabelByBusinessId(moduleEnum.getTableName(), moduleEnum.getPrimaryFieldName(), moduleEnum.getLabelFieldName(), businessId);
        if (ToolUtil.isEmpty(labelIdsList) || labelIdsList.size() == 0) {
            throw new BaseException("\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        String labelIds = labelIdsList.get(0);
        ArrayList<String> labelList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)labelIds)) {
            String[] labelIdArr = labelIds.split(",");
            List<String> asList = Arrays.asList(labelIdArr);
            labelList.addAll(asList);
        }
        if (labelDto.getChooseBatch().booleanValue()) {
            if (ToolUtil.isNotEmpty((Object)labelDto.getAddLabelIds())) {
                ArrayList addLabelIds = new ArrayList(labelDto.getAddLabelIds());
                addLabelIds.removeAll(labelList);
                if (CollectionUtil.isNotEmpty(addLabelIds)) {
                    List labelNames = this.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{CrmLabel::getLabelName}).in(CrmLabel::getLabelId, addLabelIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"), s -> s.toString());
                    String labelIdStr = String.join((CharSequence)",", addLabelIds);
                    String labelNameStr = String.join((CharSequence)",", labelNames);
                    OperateLogEntity operateLogVo = this.operateLogService.getOperateLogEntity(user, date, LabelModuleEnum.LABEL.getModuleId(), OperateLogEnum.SAVE_LABEL.getId(), labelNameStr, businessId, labelIdStr);
                    operateLogEntities.add(operateLogVo);
                    labelList.addAll(addLabelIds);
                }
            }
        } else {
            OperateLogEntity operateLogVo;
            String labelNameStr;
            String labelIdStr;
            List labelNames;
            if (ToolUtil.isNotEmpty((Object)labelDto.getAddLabelIds())) {
                labelList.addAll(labelDto.getAddLabelIds());
                labelNames = this.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{CrmLabel::getLabelName}).in(CrmLabel::getLabelId, (Collection)labelDto.getAddLabelIds())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"), s -> s.toString());
                labelIdStr = String.join((CharSequence)",", labelDto.getAddLabelIds());
                labelNameStr = String.join((CharSequence)",", labelNames);
                operateLogVo = this.operateLogService.getOperateLogEntity(user, date, LabelModuleEnum.LABEL.getModuleId(), OperateLogEnum.SAVE_LABEL.getId(), labelNameStr, labelDto.getBusinessId(), labelIdStr);
                operateLogEntities.add(operateLogVo);
            }
            if (ToolUtil.isNotEmpty((Object)labelDto.getDelLabelIds())) {
                labelList.removeAll(labelDto.getDelLabelIds());
                labelNames = this.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{CrmLabel::getLabelName}).in(CrmLabel::getLabelId, (Collection)labelDto.getDelLabelIds())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"), s -> s.toString());
                labelIdStr = String.join((CharSequence)",", labelDto.getDelLabelIds());
                labelNameStr = String.join((CharSequence)",", labelNames);
                operateLogVo = this.operateLogService.getOperateLogEntity(user, date, LabelModuleEnum.LABEL.getModuleId(), OperateLogEnum.DELETE_LABEL.getId(), labelNameStr, labelDto.getBusinessId(), labelIdStr);
                operateLogEntities.add(operateLogVo);
            }
        }
        String labelStr = "";
        if (ToolUtil.isNotEmpty(labelList)) {
            labelStr = String.join((CharSequence)",", labelList);
        }
        if (labelStr.length() > 30000) {
            throw new BaseException("\u6240\u6253\u6807\u7b7e\u8d85\u51fa\u6700\u5927\u9650\u5236\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        if ("customer".equals(moduleEnum.getModuleId())) {
            ((CrmLabelMapper)this.baseMapper).updateLabelByBusinessId("CRM_CUSTOMER", moduleEnum.getPrimaryFieldName(), moduleEnum.getLabelFieldName(), businessId, labelStr);
        } else {
            ((CrmLabelMapper)this.baseMapper).updateLabelByBusinessId(moduleEnum.getTableName(), moduleEnum.getPrimaryFieldName(), moduleEnum.getLabelFieldName(), businessId, labelStr);
        }
    }
}

