/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.api.util.operateRecord;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.crm.common.api.util.operateRecord.ChangeLog;
import com.jxdinfo.crm.common.api.util.operateRecord.Dict;
import com.jxdinfo.crm.common.api.util.operateRecord.DictUtil;
import com.jxdinfo.crm.common.api.util.operateRecord.FieldName;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataCompareUtils {
    public static List<ChangeLog> compare(Object oldObj, Object newObj) throws IllegalAccessException {
        Field[] fields;
        ArrayList<ChangeLog> changeLogs = new ArrayList<ChangeLog>();
        if (newObj == null) {
            throw new IllegalArgumentException("\u65b0\u5bf9\u8c61(newObj)\u4e0d\u53ef\u4e3anull");
        }
        Class<?> clazz = newObj.getClass();
        if ("CrmDistributionPlanMaster".equals(clazz.getSimpleName())) {
            return DataCompareUtils.handleCrmDistributionPlanMaster(oldObj, newObj);
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            FieldName fieldNameAnno;
            Object oldValue;
            field.setAccessible(true);
            String fieldName = field.getName();
            Object newValue = field.get(newObj);
            Object object = oldValue = oldObj == null ? null : field.get(oldObj);
            if (DataCompareUtils.equals(oldValue, newValue) || (fieldNameAnno = field.getAnnotation(FieldName.class)) == null) continue;
            String fieldCnName = fieldNameAnno != null ? fieldNameAnno.value() : fieldName;
            Dict dictAnno = field.getAnnotation(Dict.class);
            if (dictAnno != null) {
                String dictCode = dictAnno.code();
                Map<String, String> dictMap = DictUtil.getDictValue(dictCode, oldValue + "", newValue + "");
                oldValue = dictMap.get("oldValue");
                newValue = dictMap.get("newValue");
            }
            oldValue = DataCompareUtils.formatDateTime(oldValue);
            newValue = DataCompareUtils.formatDateTime(newValue);
            changeLogs.add(new ChangeLog(fieldName, fieldCnName, oldValue, newValue));
        }
        return changeLogs;
    }

    private static List<ChangeLog> handleCrmDistributionPlanMaster(Object oldObj, Object newObj) throws IllegalAccessException {
        Field[] fields;
        ArrayList<ChangeLog> changeLogs = new ArrayList<ChangeLog>();
        Class<?> clazz = newObj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            FieldName fieldNameAnno;
            Object oldValue;
            field.setAccessible(true);
            String fieldName = field.getName();
            if ("agreementList".equals(fieldName)) continue;
            Object newValue = field.get(newObj);
            Object object = oldValue = oldObj == null ? null : field.get(oldObj);
            if (DataCompareUtils.equals(oldValue, newValue) || (fieldNameAnno = field.getAnnotation(FieldName.class)) == null) continue;
            String fieldCnName = fieldNameAnno.value();
            Dict dictAnno = field.getAnnotation(Dict.class);
            if (dictAnno != null) {
                String dictCode = dictAnno.code();
                Map<String, String> dictMap = DictUtil.getDictValue(dictCode, oldValue == null ? "" : oldValue.toString(), newValue == null ? "" : newValue.toString());
                oldValue = dictMap.get("oldValue");
                newValue = dictMap.get("newValue");
            }
            oldValue = DataCompareUtils.formatDateTime(oldValue);
            newValue = DataCompareUtils.formatDateTime(newValue);
            changeLogs.add(new ChangeLog(fieldName, fieldCnName, oldValue, newValue));
        }
        DataCompareUtils.handleAgreementList(oldObj, newObj, changeLogs);
        return changeLogs;
    }

    private static void handleAgreementList(Object oldObj, Object newObj, List<ChangeLog> changeLogs) throws IllegalAccessException {
        Field agreementListField;
        if (oldObj == null && newObj == null) {
            return;
        }
        try {
            agreementListField = newObj.getClass().getDeclaredField("agreementList");
            agreementListField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            return;
        }
        List oldList = oldObj == null ? null : (List)agreementListField.get(oldObj);
        List newList = (List)agreementListField.get(newObj);
        if ((oldList == null || oldList.isEmpty()) && (newList == null || newList.isEmpty())) {
            return;
        }
        DataCompareUtils.handleModifiedAgreements(oldList, newList, changeLogs);
    }

    private static void handleModifiedAgreements(List<?> oldList, List<?> newList, List<ChangeLog> changeLogs) throws IllegalAccessException {
        String agreementId;
        HashMap oldAgreementMap = new HashMap();
        HashMap newAgreementMap = new HashMap();
        for (Object obj : oldList) {
            agreementId = DataCompareUtils.getAgreementId(obj);
            if (agreementId == null) continue;
            oldAgreementMap.put(agreementId, obj);
        }
        for (Object obj : newList) {
            agreementId = DataCompareUtils.getAgreementId(obj);
            if (agreementId == null) continue;
            newAgreementMap.put(agreementId, obj);
        }
        for (Map.Entry entry : newAgreementMap.entrySet()) {
            agreementId = (String)entry.getKey();
            Object newAgreement = entry.getValue();
            Object oldAgreement = oldAgreementMap.get(agreementId);
            if (oldAgreement == null) continue;
            DataCompareUtils.checkAndAddAgreementFieldChange(newAgreement, oldAgreement, changeLogs);
        }
    }

    private static void checkAndAddAgreementFieldChange(Object newAgreement, Object oldAgreement, List<ChangeLog> changeLogs) throws IllegalAccessException {
        Field[] fields;
        if (newAgreement == null && oldAgreement == null) {
            return;
        }
        Class<?> agreementClass = (newAgreement != null ? newAgreement : oldAgreement).getClass();
        for (Field field : fields = agreementClass.getDeclaredFields()) {
            boolean shouldRecord;
            FieldName fieldNameAnno;
            field.setAccessible(true);
            String fieldName = field.getName();
            if ("agreementName".equals(fieldName) || (fieldNameAnno = field.getAnnotation(FieldName.class)) == null) continue;
            Object newValue = newAgreement != null ? field.get(newAgreement) : null;
            Object oldValue = oldAgreement != null ? field.get(oldAgreement) : null;
            boolean bl = shouldRecord = !DataCompareUtils.equals(oldValue, newValue);
            if (!shouldRecord) continue;
            String fieldCnName = fieldNameAnno.value();
            Dict dictAnno = field.getAnnotation(Dict.class);
            if (dictAnno != null) {
                String dictCode = dictAnno.code();
                Map<String, String> dictMap = DictUtil.getDictValue(dictCode, oldValue == null ? "" : oldValue.toString(), newValue == null ? "" : newValue.toString());
                oldValue = dictMap.get("oldValue");
                newValue = dictMap.get("newValue");
            }
            oldValue = DataCompareUtils.formatDateTime(oldValue);
            newValue = DataCompareUtils.formatDateTime(newValue);
            String agreementName = DataCompareUtils.getAgreementName(newAgreement);
            String fullFieldName = "\u7f16\u8f91" + fieldCnName + "(" + agreementName + ")";
            String fullFieldKey = "agreementList." + fieldName + "." + agreementName;
            changeLogs.add(new ChangeLog(fullFieldKey, fullFieldName, oldValue, newValue));
        }
    }

    private static String getAgreementName(Object agreement) throws IllegalAccessException {
        if (agreement == null) {
            return null;
        }
        try {
            Field agreementNameField = agreement.getClass().getDeclaredField("agreementName");
            agreementNameField.setAccessible(true);
            Object value = agreementNameField.get(agreement);
            return value != null ? value.toString() : "\u672a\u77e5\u5408\u540c";
        }
        catch (NoSuchFieldException e) {
            return "\u672a\u77e5\u5408\u540c";
        }
    }

    private static String getAgreementId(Object agreement) throws IllegalAccessException {
        if (agreement == null) {
            return null;
        }
        try {
            Field agreementIdField = agreement.getClass().getDeclaredField("agreementId");
            agreementIdField.setAccessible(true);
            Object value = agreementIdField.get(agreement);
            return value != null ? value.toString() : "\u672a\u77e5\u5408\u540c";
        }
        catch (NoSuchFieldException e) {
            return "\u672a\u77e5\u5408\u540c";
        }
    }

    private static Object formatDateTime(Object value) {
        if (value == null) {
            return null;
        }
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            return localDate.format(dateFormatter);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return localDateTime.format(dateFormatter);
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            return localDate.format(dateFormatter);
        }
        if (value instanceof Date) {
            Date sqlDate = (Date)value;
            return sqlDate.toLocalDate().format(dateFormatter);
        }
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            return timestamp.toLocalDateTime().format(dateFormatter);
        }
        return value;
    }

    private static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (HussarUtils.isEmpty((Object)a) && HussarUtils.isEmpty((Object)b)) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static Map<String, String> getRecordInfo(Object oldObj, Object newObj) {
        HashMap<String, String> map = new HashMap<String, String>();
        String changeFlag = "false";
        try {
            List<ChangeLog> changeLogs = DataCompareUtils.compare(oldObj, newObj);
            System.out.println("===== \u6570\u636e\u53d8\u66f4\u65e5\u5fd7 =====");
            ArrayList changeField = new ArrayList();
            HashMap<String, Object> before = new HashMap<String, Object>();
            HashMap<String, Object> after = new HashMap<String, Object>();
            for (ChangeLog log : changeLogs) {
                changeFlag = "true";
                System.out.printf("\u5b57\u6bb5\uff1a%s\uff08%s\uff09\uff0c\u65e7\u503c\uff1a%s\uff0c\u65b0\u503c\uff1a%s%n", log.getFieldCnName(), log.getFieldName(), log.getOldValue(), log.getNewValue());
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("field", log.getFieldName());
                field.put("fieldName", log.getFieldCnName());
                changeField.add(field);
                before.put(log.getFieldName(), log.getOldValue());
                after.put(log.getFieldName(), log.getNewValue());
            }
            if (changeFlag.equals("true")) {
                String oldJson = JSON.toJSONString(before);
                String newJson = JSON.toJSONString(after);
                String changeFieldStr = JSON.toJSONString(changeField);
                map.put("oldJson", oldJson);
                map.put("newJson", newJson);
                map.put("changeFieldStr", changeFieldStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        map.put("changeFlag", changeFlag);
        return map;
    }
}

