/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.intelligentanalysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.OppoDistributeMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.OpportunityConversionDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.OpportunitySuccessRateDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.IOpportunityStageAnalysisService;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityQueryDto;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityStatisticsDto;
import com.jxdinfo.crm.core.api.opportunity.dto.StageRecordDto;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunitySuccessRateAPIService;
import com.jxdinfo.crm.core.api.opportunity.service.IStageRecordAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityConversionVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityStageRecordVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunitySuccessRateStageVo;
import com.jxdinfo.crm.core.api.product.service.IProductAPIService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.model.OpportunitySuccessRateConfig;
import com.jxdinfo.crm.core.opportunity.service.IOpportunityPermissionService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunityStageAnalysisServiceImpl
implements IOpportunityStageAnalysisService {
    @Resource
    private IStageRecordAPIService stageRecordAPIService;
    @Resource
    private IOpportunitySuccessRateAPIService opportunitySuccessRateAPIService;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private IOpportunityPermissionService opportunityPermissionService;
    @Resource
    private OppoDistributeMapper oppoDistributeMapper;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private IStageProcessService stageProcessService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private IProductAPIService productService;

    @Override
    public OpportunityConversionVo getConversionList(OpportunityConversionDto dto) {
        List opportunityIdList = this.opportunityPermissionService.getOpportunityIdListByPermission(null);
        if (CollectionUtil.isNotEmpty(dto.getDeptIds())) {
            List deptIds = dto.getDeptIds();
            deptIds = this.organUserBoService.getOrganByParentIdContainsParent(deptIds);
            dto.setDeptIds(deptIds);
        }
        StageRecordDto stageRecordDto = new StageRecordDto();
        BeanUtil.copyProperties((Object)((Object)dto), (Object)stageRecordDto);
        stageRecordDto.setOpportunityIdList(opportunityIdList);
        return this.opportunitySuccessRateAPIService.getConversionInfo(stageRecordDto);
    }

    @Override
    public List<OpportunitySuccessRateStageVo> getOpportunitySuccess(OpportunitySuccessRateDto dto) {
        List pids;
        OpportunitySuccessRateConfig rateConfig = (OpportunitySuccessRateConfig)HussarUtils.readJson((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("success_rate_config").getConfigValue(), OpportunitySuccessRateConfig.class);
        if (!rateConfig.getModelsInUse().contains("1")) {
            return new ArrayList<OpportunitySuccessRateStageVo>();
        }
        if ("1".equals(rateConfig.getModelOneConfig().getDistinguishProduct())) {
            dto.setProducts(new ArrayList<Long>());
            dto.setProductIdList(new ArrayList<Long>());
        }
        List<Long> products = dto.getProducts();
        List<Long> productIdList = dto.getProductIdList();
        List<Long> stageProcessIds = new ArrayList<Long>();
        if (ToolUtil.isEmpty((Object)dto.getStageProcessId())) {
            stageProcessIds = this.stageProcessService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{StageProcessEntity::getStageProcessId}).eq(StageProcessEntity::getDelFlag, (Object)"0")).eq(StageProcessEntity::getPublishStatus, (Object)"1"), s -> Long.valueOf(s.toString()));
        } else {
            stageProcessIds.add(dto.getStageProcessId());
        }
        List customerStageIds = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).in(OpportunityStage::getStageProcessId, stageProcessIds)).eq(OpportunityStage::getDelFlag, (Object)"0"), s -> Long.valueOf(s.toString()));
        if (CollectionUtil.isEmpty((Collection)customerStageIds)) {
            return new ArrayList<OpportunitySuccessRateStageVo>();
        }
        if (HussarUtils.isNotEmpty(productIdList)) {
            List pids2;
            if (CollectionUtil.isNotEmpty(dto.getCategoryIds()) && CollectionUtil.isNotEmpty((Collection)(pids2 = this.productService.selectAllProductIdByCategory(dto.getCategoryIds())))) {
                productIdList.addAll(pids2);
            }
            return this.opportunitySuccessRateAPIService.getOpportunitySuccessStage(productIdList, customerStageIds, stageProcessIds);
        }
        if (CollectionUtil.isNotEmpty(dto.getCategoryIds()) && CollectionUtil.isNotEmpty((Collection)(pids = this.productService.selectAllProductIdByCategory(dto.getCategoryIds())))) {
            products.addAll(pids);
        }
        return this.opportunitySuccessRateAPIService.getOpportunitySuccessStage(products, customerStageIds, stageProcessIds);
    }

    @Override
    public Page<OpportunityAPIVo> conversionOpportunityList(OpportunityConversionDto dto) {
        if (dto.getStageId() == null || StringUtil.isEmpty((Object)dto.getType())) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        if (CollectionUtil.isNotEmpty(dto.getDeptIds())) {
            List deptIds = dto.getDeptIds();
            deptIds = this.organUserBoService.getOrganByParentIdContainsParent(deptIds);
            dto.setDeptIds(deptIds);
        }
        Page opportunityAPIVoPage = new Page();
        List permissionIdList = this.opportunityPermissionService.getOpportunityIdListByPermission(null);
        List opportunityStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getDelFlag, (Object)"0")).eq(OpportunityStage::getStageProcessId, (Object)dto.getProcessId()));
        Map<String, List<OpportunityStage>> typeStageMap = opportunityStageList.stream().collect(Collectors.groupingBy(OpportunityStage::getStageType));
        List<Object> loseStageId = new ArrayList();
        List<Object> abandonStageId = new ArrayList();
        List<Object> convertStageId = new ArrayList();
        if (typeStageMap.get("21") != null) {
            loseStageId = typeStageMap.get("21").stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        }
        if (typeStageMap.get("22") != null) {
            abandonStageId = typeStageMap.get("22").stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        }
        if (typeStageMap.get("23") != null) {
            convertStageId = typeStageMap.get("23").stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        }
        if (typeStageMap.get("00").stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList()).contains(dto.getStageId()) && "0".equals(dto.getType())) {
            OpportunityStatisticsDto opportunityStatisticsDto = new OpportunityStatisticsDto();
            BeanUtil.copyProperties((Object)((Object)dto), (Object)opportunityStatisticsDto);
            opportunityAPIVoPage.setSize(dto.getSize());
            opportunityAPIVoPage.setCurrent(dto.getCurrent());
            opportunityAPIVoPage = this.opportunityAPIService.selectListIfNullAll(permissionIdList, opportunityStatisticsDto, opportunityAPIVoPage);
            List opportunityAPIVoList = opportunityAPIVoPage.getRecords();
            if (CollectionUtil.isNotEmpty((Collection)opportunityAPIVoList)) {
                for (OpportunityAPIVo opportunityAPIVo : opportunityAPIVoList) {
                    opportunityAPIVo.setOpportunityAmount(CommonUtills.transferAmount((String)opportunityAPIVo.getOpportunityAmount()));
                }
            }
            return opportunityAPIVoPage;
        }
        if (typeStageMap.get("20").stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList()).contains(dto.getStageId()) && "0".equals(dto.getType())) {
            OpportunityStatisticsDto opportunityStatisticsDto = new OpportunityStatisticsDto();
            BeanUtil.copyProperties((Object)((Object)dto), (Object)opportunityStatisticsDto);
            opportunityAPIVoPage.setSize(dto.getSize());
            opportunityAPIVoPage.setCurrent(dto.getCurrent());
            opportunityStatisticsDto.setCustomerStageIds(typeStageMap.get("20").stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList()));
            opportunityAPIVoPage = this.opportunityAPIService.selectListIfNullAll(permissionIdList, opportunityStatisticsDto, opportunityAPIVoPage);
            List opportunityAPIVoList = opportunityAPIVoPage.getRecords();
            if (CollectionUtil.isNotEmpty((Collection)opportunityAPIVoList)) {
                for (OpportunityAPIVo opportunityAPIVo : opportunityAPIVoList) {
                    opportunityAPIVo.setOpportunityAmount(CommonUtills.transferAmount((String)opportunityAPIVo.getOpportunityAmount()));
                }
            }
            return opportunityAPIVoPage;
        }
        StageRecordDto stageRecordDto = new StageRecordDto();
        BeanUtil.copyProperties((Object)((Object)dto), (Object)stageRecordDto);
        ArrayList<Long> afterStageIdList = new ArrayList<Long>();
        ArrayList<Long> beforeStageIdList = new ArrayList<Long>();
        ArrayList currentStageIdList = new ArrayList();
        switch (dto.getType()) {
            case "0": {
                afterStageIdList.add(dto.getStageId());
                break;
            }
            case "1": {
                beforeStageIdList.add(dto.getStageId());
                afterStageIdList.addAll(loseStageId);
                afterStageIdList.addAll(abandonStageId);
                afterStageIdList.addAll(convertStageId);
                currentStageIdList.addAll(loseStageId);
                currentStageIdList.addAll(abandonStageId);
                currentStageIdList.addAll(convertStageId);
                break;
            }
            case "2": {
                beforeStageIdList.add(dto.getStageId());
                afterStageIdList.addAll(loseStageId);
                currentStageIdList.addAll(loseStageId);
                break;
            }
            case "3": {
                beforeStageIdList.add(dto.getStageId());
                afterStageIdList.addAll(abandonStageId);
                currentStageIdList.addAll(abandonStageId);
                break;
            }
            case "4": {
                beforeStageIdList.add(dto.getStageId());
                afterStageIdList.addAll(convertStageId);
                currentStageIdList.addAll(convertStageId);
            }
        }
        if (CollectionUtil.isNotEmpty(beforeStageIdList)) {
            stageRecordDto.setBeforeStageIdList(beforeStageIdList);
        }
        if (CollectionUtil.isNotEmpty(afterStageIdList)) {
            stageRecordDto.setAfterStageIdList(afterStageIdList);
        }
        if (CollectionUtil.isNotEmpty(currentStageIdList)) {
            stageRecordDto.setCurrentStageIdList(currentStageIdList);
        }
        stageRecordDto.setOpportunityIdList(permissionIdList);
        List recordVoList = this.stageRecordAPIService.getStageRecordList(stageRecordDto, dto.getType());
        if (CollectionUtil.isEmpty((Collection)recordVoList)) {
            return opportunityAPIVoPage;
        }
        if (CollectionUtil.isEmpty(recordVoList = recordVoList.stream().filter(opportunityStageRecordVo -> opportunityStageRecordVo.getOpportunityId() != null).collect(Collectors.toList()))) {
            return opportunityAPIVoPage;
        }
        Map<Long, List<OpportunityStageRecordVo>> recordVoListMap = recordVoList.stream().collect(Collectors.groupingBy(OpportunityStageRecordVo::getOpportunityId));
        if (CollectionUtil.isEmpty(recordVoListMap)) {
            return opportunityAPIVoPage;
        }
        ArrayList<Long> opportunityIdList = new ArrayList<Long>(recordVoListMap.keySet());
        if (CollectionUtil.isEmpty(opportunityIdList)) {
            return opportunityAPIVoPage;
        }
        OpportunityQueryDto opportunityQueryDto = new OpportunityQueryDto();
        opportunityQueryDto.setOpportunityIdList(opportunityIdList);
        opportunityQueryDto.setCurrent(dto.getCurrent());
        opportunityQueryDto.setSize(dto.getSize());
        opportunityQueryDto.setSearchKey(dto.getSearchKey());
        return this.opportunityAPIService.selectList(opportunityQueryDto);
    }
}

