/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.customerprofile.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.crm.analysis.customerprofile.dao.CustomerProfileMapper;
import com.jxdinfo.crm.analysis.customerprofile.dto.CustomerBriefingDto;
import com.jxdinfo.crm.analysis.customerprofile.dto.CustomerProfileOpptyDto;
import com.jxdinfo.crm.analysis.customerprofile.model.SingleCustomerMetricsEntity;
import com.jxdinfo.crm.analysis.customerprofile.service.ICustomerProfileService;
import com.jxdinfo.crm.analysis.customerprofile.service.ISingleCustomerMetricsService;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerActivityLevelVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerBriefingVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerInfoVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerInteractiveVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerOpptyStatsVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerProductCoverageVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerTrendVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.FollowupDistributionVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.ProductAmountVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.ProductTrendVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.SalespersonAnalysisMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.SalespersonAnalysisContactDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.ContractVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.IncomeVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.InvoiceVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.OpportunityProductVo;
import com.jxdinfo.crm.analysis.unify.service.OpportunityAndAnalysisService;
import com.jxdinfo.crm.analysis.unify.vo.PortalFunnelVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.OsApiProperties;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.label.vo.LabelVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.dto.TrackRecordAPIDto;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordCusVo;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.contact.dto.ContactAPIDto;
import com.jxdinfo.crm.core.api.contact.service.IContactAPIService;
import com.jxdinfo.crm.core.api.contact.vo.ContactAPIVo;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityAPIService;
import com.jxdinfo.crm.core.api.marketingactivity.vo.MarketingActivityAPIVo;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunitySuccessRateAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.api.opportunity.vo.SuccessRateVo;
import com.jxdinfo.crm.core.api.product.service.IProductAPIService;
import com.jxdinfo.crm.core.api.product.vo.ProductAPIVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageSelectDto;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.vo.SalesFunnelVo;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.model.OpportunitySuccessRateConfig;
import com.jxdinfo.crm.core.opportunity.model.SuccessRateDic;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityEntityVo;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.crm.core.unify.dao.UnifyPortalMapper;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.general.dict.vo.DictVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.io.Serializable;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerProfileServiceImpl
implements ICustomerProfileService {
    @Resource
    private CustomerProfileMapper customerProfileMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private SalespersonAnalysisMapper salespersonAnalysisMapper;
    @Resource
    private ISingleCustomerMetricsService singleCustomerMetricsService;
    @Resource
    private UnifyPortalMapper unifyPortalMapper;
    @Resource
    private IMarketingActivityAPIService marketingActivityAPIService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private ILabelService labelService;
    @Resource
    private IContactAPIService contactAPIService;
    @Resource
    private IProductAPIService productAPIService;
    @Resource
    private SysDicSingleMapper dicSingleMapper;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private IOpportunitySuccessRateAPIService opportunitySuccessRateAPIService;
    @Resource
    private OsApiProperties osApiProperties;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private OpportunityAndAnalysisService opportunityAndAnalysisService;
    @Resource
    private IStageProcessService stageProcessService;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    @Override
    public CustomerInfoVo getCustomerInfo(String customerId) {
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageLose(true);
        stageTypeDto.setStageAbandonConvert(true);
        stageTypeDto.setStageWin(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        ArrayList<String> stageList = new ArrayList<String>();
        stageList.addAll(stageSelectDto.getStageLose().stream().map(String::valueOf).collect(Collectors.toList()));
        stageList.addAll(stageSelectDto.getStageAbandonConvert().stream().map(String::valueOf).collect(Collectors.toList()));
        CustomerInfoVo customerInfoVo = this.customerProfileMapper.getCustomerInfo(Long.parseLong(customerId));
        List<Map<String, Object>> coveredProductList = this.customerProfileMapper.getCoveredProduct(Long.parseLong(customerId), stageList);
        if (ToolUtil.isNotEmpty(coveredProductList)) {
            customerInfoVo.setCoveredProductList(coveredProductList.stream().map(product -> (String)product.get("SHORT_NAME")).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty((Object)customerInfoVo.getCorporateImpact())) {
            List<String> impactList = Arrays.asList(customerInfoVo.getCorporateImpact().split(","));
            customerInfoVo.setCorporateImpactList(impactList);
        }
        if (ToolUtil.isNotEmpty((Object)customerInfoVo)) {
            customerInfoVo = this.transferCustomerInfoDict(customerInfoVo);
        }
        List winStageIdList = stageSelectDto.getStageWin();
        int count = this.customerProfileMapper.getOpptyCountByStageIds(Long.parseLong(customerId), winStageIdList);
        if (count == 0) {
            customerInfoVo.setTransactionStatus("\u672a\u6210\u4ea4");
        } else if (count == 1) {
            customerInfoVo.setTransactionStatus("\u521d\u6b21\u6210\u4ea4");
        } else {
            customerInfoVo.setTransactionStatus("\u591a\u6b21\u6210\u4ea4");
        }
        List<OperateRecordAPIVo> list = this.customerProfileMapper.getCustomerTransferList(Long.parseLong(customerId));
        customerInfoVo.setTransferList(list);
        return customerInfoVo;
    }

    private CustomerInfoVo transferCustomerInfoDict(CustomerInfoVo customerInfoVo) {
        List dictVoList = this.sysDicRefService.getDictVosByTypeNames(Arrays.asList("customer_level", "listing_status", "corporate_impact", "customer_relation", "customer_risk", "customer_risk_point", "deal_state", "industry", "customer_stage", "customer_source"));
        for (DictVo dictVo : dictVoList) {
            DicSingle dicSingle;
            List dicSingles;
            List singleList = dictVo.getSingleList();
            if ("customer_level".equals(dictVo.getTypeName()) && ToolUtil.isNotEmpty((Object)customerInfoVo.getCustomerLevel())) {
                dicSingles = singleList.stream().filter(dic -> dic.getValue().equals(customerInfoVo.getCustomerLevel())).collect(Collectors.toList());
                dicSingle = new DicSingle();
                if (ToolUtil.isNotEmpty(dicSingles)) {
                    dicSingle = (DicSingle)dicSingles.get(0);
                    customerInfoVo.setCustomerLevel(dicSingle.getLabel());
                }
            }
            if ("listing_status".equals(dictVo.getTypeName()) && ToolUtil.isNotEmpty((Object)customerInfoVo.getListingStatus())) {
                dicSingles = singleList.stream().filter(dic -> dic.getValue().equals(customerInfoVo.getListingStatus())).collect(Collectors.toList());
                dicSingle = new DicSingle();
                if (ToolUtil.isNotEmpty(dicSingles)) {
                    dicSingle = (DicSingle)dicSingles.get(0);
                    customerInfoVo.setListingStatus(dicSingle.getLabel());
                }
            }
            if ("corporate_impact".equals(dictVo.getTypeName()) && ToolUtil.isNotEmpty((Object)customerInfoVo.getCorporateImpact())) {
                List<String> impactList = customerInfoVo.getCorporateImpactList();
                ArrayList<String> newImpactList = new ArrayList<String>();
                for (String s : impactList) {
                    List dicSingles2 = singleList.stream().filter(dic -> dic.getValue().equals(s)).collect(Collectors.toList());
                    if (!ToolUtil.isNotEmpty(dicSingles2)) continue;
                    newImpactList.add(((DicSingle)dicSingles2.get(0)).getLabel());
                }
                customerInfoVo.setCorporateImpactList(newImpactList);
            }
            if ("customer_relation".equals(dictVo.getTypeName()) && ToolUtil.isNotEmpty((Object)customerInfoVo.getCustomerRelation())) {
                dicSingles = singleList.stream().filter(dic -> dic.getValue().equals(customerInfoVo.getCustomerRelation())).collect(Collectors.toList());
                dicSingle = new DicSingle();
                if (ToolUtil.isNotEmpty(dicSingles)) {
                    dicSingle = (DicSingle)dicSingles.get(0);
                    customerInfoVo.setCustomerRelation(dicSingle.getLabel());
                }
            }
            if ("customer_risk".equals(dictVo.getTypeName()) && ToolUtil.isNotEmpty((Object)customerInfoVo.getCustomerRisk())) {
                dicSingles = singleList.stream().filter(dic -> dic.getValue().equals(customerInfoVo.getCustomerRisk())).collect(Collectors.toList());
                dicSingle = new DicSingle();
                if (ToolUtil.isNotEmpty(dicSingles)) {
                    dicSingle = (DicSingle)dicSingles.get(0);
                    customerInfoVo.setCustomerRisk(dicSingle.getLabel());
                }
            }
            if ("customer_risk_point".equals(dictVo.getTypeName()) && ToolUtil.isNotEmpty((Object)customerInfoVo.getCustomerRiskPoint())) {
                List<String> riskPointList = Arrays.asList(customerInfoVo.getCustomerRiskPoint().split(","));
                ArrayList<String> labelList = new ArrayList<String>();
                for (String point : riskPointList) {
                    if ("7".equals(point)) {
                        if (!ToolUtil.isNotEmpty((Object)customerInfoVo.getOtherCustomerRiskPoint())) continue;
                        labelList.add(customerInfoVo.getOtherCustomerRiskPoint());
                        continue;
                    }
                    String finalPoint = point;
                    List dicSingles3 = singleList.stream().filter(dic -> dic.getValue().equals(finalPoint)).collect(Collectors.toList());
                    if (!ToolUtil.isNotEmpty(dicSingles3)) continue;
                    point = ((DicSingle)dicSingles3.get(0)).getLabel();
                    labelList.add(point);
                }
                customerInfoVo.setCustomerRiskPointList(labelList);
            }
            if ("deal_state".equals(dictVo.getTypeName()) && ToolUtil.isNotEmpty((Object)customerInfoVo.getTransactionStatus())) {
                dicSingles = singleList.stream().filter(dic -> dic.getValue().equals(customerInfoVo.getTransactionStatus())).collect(Collectors.toList());
                dicSingle = new DicSingle();
                if (ToolUtil.isNotEmpty(dicSingles)) {
                    dicSingle = (DicSingle)dicSingles.get(0);
                    customerInfoVo.setTransactionStatus(dicSingle.getLabel());
                }
            }
            if ("industry".equals(dictVo.getTypeName()) && ToolUtil.isNotEmpty((Object)customerInfoVo.getTrade())) {
                if ("19".equals(customerInfoVo.getTrade())) {
                    if (ToolUtil.isNotEmpty((Object)customerInfoVo.getOtherTrade())) {
                        customerInfoVo.setTrade("\u5176\u4ed6/" + customerInfoVo.getOtherTrade());
                    } else {
                        customerInfoVo.setTrade("\u5176\u4ed6");
                    }
                } else {
                    dicSingles = singleList.stream().filter(dic -> dic.getValue().equals(customerInfoVo.getTrade())).collect(Collectors.toList());
                    if (ToolUtil.isNotEmpty(dicSingles)) {
                        customerInfoVo.setTrade(((DicSingle)dicSingles.get(0)).getLabel());
                    }
                }
            }
            if ("customer_stage".equals(dictVo.getTypeName()) && ToolUtil.isNotEmpty((Object)customerInfoVo.getCustomerStage())) {
                dicSingles = singleList.stream().filter(dic -> dic.getValue().equals(customerInfoVo.getCustomerStage())).collect(Collectors.toList());
                dicSingle = new DicSingle();
                if (ToolUtil.isNotEmpty(dicSingles)) {
                    dicSingle = (DicSingle)dicSingles.get(0);
                    customerInfoVo.setCustomerStage(dicSingle.getLabel());
                }
            }
            if (!"customer_source".equals(dictVo.getTypeName()) || !ToolUtil.isNotEmpty((Object)customerInfoVo.getCustomerFrom())) continue;
            dicSingles = singleList.stream().filter(dic -> dic.getValue().equals(customerInfoVo.getCustomerFrom())).collect(Collectors.toList());
            dicSingle = new DicSingle();
            if (!ToolUtil.isNotEmpty(dicSingles)) continue;
            dicSingle = (DicSingle)dicSingles.get(0);
            customerInfoVo.setCustomerFrom(dicSingle.getLabel());
        }
        return customerInfoVo;
    }

    @Override
    public Map<String, Object> getTransactionFlag(String customerId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List winStageIdList = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        result.put("transactionFlag", this.customerProfileMapper.getOpptyCountByStageIds(Long.parseLong(customerId), winStageIdList) > 0);
        CustomerAPIVo customerAPIVo = this.customerAPIService.selectOne(Long.valueOf(Long.parseLong(customerId)));
        if (ToolUtil.isNotEmpty((Object)customerAPIVo)) {
            result.put("customerCreateTime", customerAPIVo.getCreateTime());
        }
        ObjectMapper objectMapper = new ObjectMapper();
        CrmBaseConfigVo baseConfig = this.crmBaseConfigBoService.getCrmBaseConfigByKey("amount_display");
        try {
            Map map = (Map)objectMapper.readValue(baseConfig.getConfigValue(), Map.class);
            result.put("amountConfig", map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public CustomerBriefingVo getOpportunityListOrWinOrderList(CustomerBriefingDto dto) {
        HashMap<String, Object> singleMap;
        int count;
        double d;
        int countTotal;
        CustomerBriefingVo resultVo = new CustomerBriefingVo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List winStageIdList = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin().stream().map(String::valueOf).collect(Collectors.toList());
        if ("0".equals(dto.getSearchType())) {
            map.put("timeOrder", "1");
        } else if ("1".equals(dto.getSearchType())) {
            map.put("timeOrder", "31");
            map.put("customerStageIds", winStageIdList);
        }
        map.put("customerId", dto.getCustomerId());
        List opportunityAPIVoList = (List)this.opportunityAPIService.selectCrmOpportunityListNoPermission(map, null);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if ("0".equals(dto.getSearchType())) {
            countTotal = 0;
            d = 0.0;
            for (Object opportunityAPIVo : opportunityAPIVoList) {
                if (!ToolUtil.isNotEmpty((Object)opportunityAPIVo.getCreateTime())) continue;
                ++countTotal;
                d += Double.parseDouble(opportunityAPIVo.getOpportunityAmount());
            }
            resultVo.setOpportunityCount(countTotal);
            resultVo.setOpportunityAmount(this.processingAmountFormat(d, null));
            if ("0".equals(dto.getTimeFlag())) {
                List<String> monthList = this.generatePreviousMonths(6);
                for (String string : monthList) {
                    int count2 = 0;
                    double amount = 0.0;
                    HashMap<String, Object> singleMap2 = new HashMap<String, Object>();
                    for (OpportunityAPIVo opportunityAPIVo : opportunityAPIVoList) {
                        if (!this.compareTime(string, opportunityAPIVo.getCreateTime()).booleanValue()) continue;
                        ++count2;
                        amount += Double.parseDouble(opportunityAPIVo.getOpportunityAmount());
                    }
                    singleMap2.put("opportunityCount", count2);
                    singleMap2.put("opportunityAmount", amount);
                    singleMap2.put("date", string);
                    mapList.add(singleMap2);
                }
            } else if ("1".equals(dto.getTimeFlag())) {
                int earliestYear;
                LocalDateTime earliestCreateDate = null;
                if (ToolUtil.isNotEmpty((Object)opportunityAPIVoList)) {
                    for (Object opportunityAPIVo : opportunityAPIVoList) {
                        if (!ToolUtil.isNotEmpty((Object)opportunityAPIVo.getCreateTime())) continue;
                        earliestCreateDate = opportunityAPIVo.getCreateTime();
                        break;
                    }
                    if (ToolUtil.isEmpty(earliestCreateDate)) {
                        earliestCreateDate = dto.getCustomerCreateTime();
                    }
                    earliestYear = dto.getCustomerCreateTime().isBefore(earliestCreateDate) ? dto.getCustomerCreateTime().getYear() : earliestCreateDate.getYear();
                } else {
                    earliestYear = dto.getCustomerCreateTime().getYear();
                }
                List<String> list = this.generatePreviousYears(earliestYear);
                for (String year : list) {
                    count = 0;
                    double amount = 0.0;
                    singleMap = new HashMap<String, Object>();
                    for (OpportunityAPIVo opportunityAPIVo : opportunityAPIVoList) {
                        if (!year.equals(String.valueOf(opportunityAPIVo.getCreateTime().getYear()))) continue;
                        ++count;
                        amount += Double.parseDouble(opportunityAPIVo.getOpportunityAmount());
                    }
                    singleMap.put("opportunityCount", count);
                    singleMap.put("opportunityAmount", amount);
                    singleMap.put("date", year);
                    mapList.add(singleMap);
                }
            }
        } else if ("1".equals(dto.getSearchType())) {
            countTotal = 0;
            d = 0.0;
            for (Object opportunityAPIVo : opportunityAPIVoList) {
                ++countTotal;
                d += Double.parseDouble(opportunityAPIVo.getOpportunityAmount());
            }
            resultVo.setOpportunityCount(countTotal);
            resultVo.setOpportunityAmount(this.processingAmountFormat(d, null));
            if ("0".equals(dto.getTimeFlag())) {
                List<String> monthList = this.generatePreviousMonths(6);
                for (String string : monthList) {
                    int count3 = 0;
                    double amount = 0.0;
                    HashMap<String, Object> singleMap3 = new HashMap<String, Object>();
                    for (OpportunityAPIVo opportunityAPIVo : opportunityAPIVoList) {
                        if (!this.compareTime(string, opportunityAPIVo.getSuccessDate()).booleanValue()) continue;
                        ++count3;
                        amount += Double.parseDouble(opportunityAPIVo.getOpportunityAmount());
                    }
                    singleMap3.put("opportunityCount", count3);
                    singleMap3.put("opportunityAmount", amount);
                    singleMap3.put("date", string);
                    mapList.add(singleMap3);
                }
            } else if ("1".equals(dto.getTimeFlag())) {
                int earliestYear;
                String earliestSuccessDate = null;
                if (ToolUtil.isNotEmpty((Object)opportunityAPIVoList)) {
                    for (Object opportunityAPIVo : opportunityAPIVoList) {
                        if (!ToolUtil.isNotEmpty((Object)opportunityAPIVo.getSuccessDate())) continue;
                        earliestSuccessDate = opportunityAPIVo.getSuccessDate();
                        break;
                    }
                    earliestYear = ToolUtil.isEmpty(earliestSuccessDate) ? dto.getCustomerCreateTime().getYear() : Math.min(dto.getCustomerCreateTime().getYear(), Integer.parseInt(earliestSuccessDate.substring(0, 4)));
                } else {
                    earliestYear = dto.getCustomerCreateTime().getYear();
                }
                List<String> list = this.generatePreviousYears(earliestYear);
                for (String year : list) {
                    count = 0;
                    double amount = 0.0;
                    singleMap = new HashMap();
                    for (OpportunityAPIVo opportunityAPIVo : opportunityAPIVoList) {
                        if (!ToolUtil.isNotEmpty((Object)opportunityAPIVo.getSuccessDate()) || !year.equals(opportunityAPIVo.getSuccessDate().substring(0, 4))) continue;
                        ++count;
                        amount += Double.parseDouble(opportunityAPIVo.getOpportunityAmount());
                    }
                    singleMap.put("opportunityCount", count);
                    singleMap.put("opportunityAmount", amount);
                    singleMap.put("date", year);
                    mapList.add(singleMap);
                }
            }
            SingleCustomerMetricsEntity metricsEntity = (SingleCustomerMetricsEntity)this.singleCustomerMetricsService.getOne((Wrapper)new LambdaQueryWrapper().eq(SingleCustomerMetricsEntity::getCustomerId, (Object)dto.getCustomerId()));
            String temp = "\u9ad8\u4e8e";
            if (ToolUtil.isNotEmpty((Object)metricsEntity) && ToolUtil.isNotEmpty((Object)metricsEntity.getAverageWinningCycle())) {
                Double d2 = Double.parseDouble(this.crmBaseConfigBoService.getCrmBaseConfigByKey("common_average_winning_cycle").getConfigValue());
                if (metricsEntity.getAverageWinningCycle() <= d2) {
                    temp = "\u4f4e\u4e8e";
                }
                String result = String.format("\u5e73\u5747\u8d62\u5355\u5468\u671f\uff1a%.0f\u5929\uff0c%s\u516c\u53f8\u5e73\u5747\u8d62\u5355\u5468\u671f", metricsEntity.getAverageWinningCycle(), temp);
                resultVo.setCopywriting(result);
            }
        }
        for (Map map2 : mapList) {
            if (!map2.containsKey("opportunityAmount")) continue;
            map2.put("opportunityAmount", this.processingAmountFormat((Double)map2.get("opportunityAmount"), dto.getAmountConfig()));
        }
        resultVo.setOpportunityList(mapList);
        return resultVo;
    }

    @Override
    public Object getCustomerPortraitOpportunityList(CustomerBriefingDto dto) {
        String timeStr;
        Page page = new Page();
        page.setSize((long)dto.getSize().intValue());
        page.setCurrent((long)dto.getCurrent().intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List winStageIdList = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin().stream().map(String::valueOf).collect(Collectors.toList());
        if ("0".equals(dto.getSearchType())) {
            map.put("timeOrder", "1");
            if ("0".equals(dto.getTimeFlag())) {
                map.put("createTimeFlag", "6");
                timeStr = dto.getDate();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
                LocalDate localDateStart = LocalDate.parse(timeStr + "01", formatter.withResolverStyle(ResolverStyle.LENIENT));
                int year = Integer.parseInt(timeStr.substring(0, 4));
                int month = Integer.parseInt(timeStr.substring(4, 6));
                LocalDate lastDayOfMonth = LocalDate.of(year, month, 1).with(TemporalAdjusters.lastDayOfMonth());
                map.put("startTime", localDateStart);
                map.put("finalTime", lastDayOfMonth);
            } else if ("1".equals(dto.getTimeFlag())) {
                map.put("createTimeFlag", "6");
                timeStr = dto.getDate();
                int year = Integer.parseInt(timeStr);
                LocalDate firstDayOfYear = LocalDate.of(year, 1, 1);
                LocalDate lastDayOfYear = firstDayOfYear.with(TemporalAdjusters.lastDayOfYear());
                map.put("startTime", firstDayOfYear);
                map.put("finalTime", lastDayOfYear);
            }
        } else if ("1".equals(dto.getSearchType())) {
            map.put("timeOrder", "31");
            map.put("customerStageIds", winStageIdList);
            if ("0".equals(dto.getTimeFlag())) {
                timeStr = dto.getDate();
                int year = Integer.parseInt(timeStr.substring(0, 4));
                int month = Integer.parseInt(timeStr.substring(4, 6));
                LocalDate localDateStart = LocalDate.of(year, month, 1);
                LocalDate localDateEnd = localDateStart.with(TemporalAdjusters.lastDayOfMonth());
                map.put("successStartDate", localDateStart);
                map.put("successEndDate", localDateEnd);
            } else if ("1".equals(dto.getTimeFlag())) {
                timeStr = dto.getDate();
                int year = Integer.parseInt(timeStr);
                LocalDate firstDayOfYear = LocalDate.of(year, 1, 1);
                LocalDate lastDayOfYear = firstDayOfYear.with(TemporalAdjusters.lastDayOfYear());
                map.put("successStartDate", firstDayOfYear);
                map.put("successEndDate", lastDayOfYear);
            }
        }
        map.put("customerId", dto.getCustomerId());
        if (ToolUtil.isNotEmpty(dto.getStates())) {
            map.put("states", dto.getStates());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getOverdueFollow())) {
            map.put("overdueFollow", dto.getOverdueFollow());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getSearchKey())) {
            map.put("searchKeyCustomerProfile", dto.getSearchKey());
        }
        if (ToolUtil.isNotEmpty((Object)(page = (Page)this.opportunityAPIService.selectCrmOpportunityListNoPermission(map, page)))) {
            for (Object oppty : page.getRecords()) {
                ((OpportunityAPIVo)oppty).setCustomerName(((OpportunityAPIVo)oppty).getCustomerReferredName());
            }
        }
        for (Object record : page.getRecords()) {
            ((OpportunityAPIVo)record).setOpportunityAmount(String.valueOf(this.processingAmountFormat(Double.parseDouble(((OpportunityAPIVo)record).getOpportunityAmount()), dto.getAmountConfig())));
        }
        return page;
    }

    @Override
    public CustomerBriefingVo getTrackRecordCount(CustomerBriefingDto dto) {
        CustomerBriefingVo resultVo = new CustomerBriefingVo();
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        List<String> monthList = this.generatePreviousMonths(6);
        List list = (List)this.selectTrackRecordByCustomerId(dto.getCustomerId(), null, null);
        resultVo.setRecordCount(list.size());
        for (String month : monthList) {
            int count = 0;
            HashMap<String, Object> singleMap = new HashMap<String, Object>();
            for (TrackRecordCusVo vo : list) {
                if (!this.compareTime(month, vo.getPublicTime()).booleanValue()) continue;
                ++count;
            }
            singleMap.put("trackRecordCount", count);
            singleMap.put("date", month);
            mapList.add(singleMap);
        }
        resultVo.setTrackRecordList(mapList);
        SingleCustomerMetricsEntity metricsEntity = (SingleCustomerMetricsEntity)this.singleCustomerMetricsService.getOne((Wrapper)new LambdaQueryWrapper().eq(SingleCustomerMetricsEntity::getCustomerId, (Object)dto.getCustomerId()));
        String temp = "\u8f83\u4f4e";
        if (ToolUtil.isNotEmpty((Object)metricsEntity) && ToolUtil.isNotEmpty((Object)metricsEntity.getMonthlyTrack())) {
            double commonTrack = Double.parseDouble(this.crmBaseConfigBoService.getCrmBaseConfigByKey("common_customer_monthly_track").getConfigValue());
            if (Math.ceil(metricsEntity.getMonthlyTrack()) >= commonTrack) {
                temp = "\u6b63\u5e38";
            }
        }
        resultVo.setCopywriting("\u6708\u5747\u8ddf\u8fdb\u9891\u7387" + temp);
        return resultVo;
    }

    @Override
    public Object getCustomerPortraitTrackRecordList(CustomerBriefingDto dto) {
        Page page = new Page();
        page.setSize((long)dto.getSize().intValue());
        page.setCurrent((long)dto.getCurrent().intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> childMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)dto.getDate())) {
            String timeStr = dto.getDate();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            LocalDate localDateStart = LocalDate.parse(timeStr + "01", formatter.withResolverStyle(ResolverStyle.LENIENT));
            int year = Integer.parseInt(timeStr.substring(0, 4));
            int month = Integer.parseInt(timeStr.substring(4, 6));
            LocalDate lastDayOfMonth = LocalDate.of(year, month, 1).with(TemporalAdjusters.lastDayOfMonth());
            childMap.put("startTime", localDateStart);
            childMap.put("endTime", lastDayOfMonth);
            childMap.put("timeRange", "6");
            ArrayList<HashMap<String, Object>> tempList = new ArrayList<HashMap<String, Object>>();
            tempList.add(childMap);
            map.put("createTimeList", tempList);
        }
        if (ToolUtil.isNotEmpty((Object)dto.getRecordType())) {
            map.put("recordType", dto.getRecordType());
        }
        page = (Page)this.selectTrackRecordByCustomerId(dto.getCustomerId(), page, map);
        return page;
    }

    @Override
    public CustomerBriefingVo getProductCoverDegree(CustomerBriefingDto dto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CrmBaseConfigVo configVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("strategy_products");
        List<Long> productList = Arrays.asList(configVo.getConfigValue().split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
        List productAPIVoList = this.productAPIService.getProductListByIds(productList);
        int productCount = productList.size();
        List<Map<String, Object>> productMapList = this.customerProfileMapper.selectChildProductsByProductList(productList);
        List childProductList = productMapList.stream().map(map1 -> (Long)map1.get("CHILD_PRODUCT_ID")).collect(Collectors.toList());
        ArrayList<Long> mergeList = new ArrayList<Long>();
        mergeList.addAll(productList);
        mergeList.addAll(childProductList);
        map.put("products", mergeList);
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageLose(true);
        stageTypeDto.setStageAbandonConvert(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List stageList = stageSelectDto.getStageLose();
        stageList.addAll(stageSelectDto.getStageAbandonConvert());
        map.put("excludeCustomerStageIds", stageList);
        List list = (List)this.selectProductsByCustomerId(dto.getCustomerId(), null, map);
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        for (Object opportunityEntityVo : list) {
            Long productId = Long.parseLong(opportunityEntityVo.getProductId());
            ArrayList tempList = new ArrayList();
            if (productList.contains(productId)) {
                hashMap.put(productId, "1");
                continue;
            }
            if (!ToolUtil.isNotEmpty(productMapList.stream().filter(product -> ((Long)product.get("CHILD_PRODUCT_ID")).equals(productId)).collect(Collectors.toList()))) continue;
            Long productAId = (Long)((Map)productMapList.stream().filter(product -> ((Long)product.get("CHILD_PRODUCT_ID")).equals(productId)).collect(Collectors.toList()).get(0)).get("PRODUCT_ID");
            hashMap.put(productAId, "1");
        }
        int count = 0;
        for (Long productId : productList) {
            if (!hashMap.containsKey(productId)) continue;
            ++count;
        }
        CustomerBriefingVo result = new CustomerBriefingVo();
        result.setStrategyProducts(productAPIVoList.stream().map(ProductAPIVo::getShortName).collect(Collectors.toList()));
        result.setProductCount(count);
        result.setProductCoverDegree(Double.parseDouble(String.format("%.2f", (double)count / (double)productCount * 100.0)));
        if (result.getProductCoverDegree() < 30.0) {
            result.setCopywriting(String.format("\u4ea7\u54c1\u8986\u76d6\u5ea6\u8f83%s", "\u4f4e"));
        } else if (result.getProductCoverDegree() > 50.0) {
            result.setCopywriting(String.format("\u4ea7\u54c1\u8986\u76d6\u5ea6\u8f83%s", "\u9ad8"));
        }
        return result;
    }

    @Override
    public Object getCustomerPortraitOpportunityProductList(CustomerBriefingDto dto) {
        Page page = new Page();
        page.setSize((long)dto.getSize().intValue());
        page.setCurrent((long)dto.getCurrent().intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        CrmBaseConfigVo configVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("strategy_products");
        List<Long> productList = Arrays.asList(configVo.getConfigValue().split(",")).stream().map(Long::parseLong).collect(Collectors.toList());
        int productCount = productList.size();
        List<Map<String, Object>> productMapList = this.customerProfileMapper.selectChildProductsByProductList(productList);
        List childProductList = productMapList.stream().map(map1 -> (Long)map1.get("CHILD_PRODUCT_ID")).collect(Collectors.toList());
        ArrayList<Long> mergeList = new ArrayList<Long>();
        mergeList.addAll(productList);
        mergeList.addAll(childProductList);
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageLose(true);
        stageTypeDto.setStageAbandonConvert(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List stageList = stageSelectDto.getStageLose();
        stageList.addAll(stageSelectDto.getStageAbandonConvert());
        if (ToolUtil.isNotEmpty(dto.getProductIds())) {
            map.put("products", dto.getProductIds());
        } else {
            map.put("products", mergeList);
        }
        if (ToolUtil.isNotEmpty(dto.getStageIds())) {
            map.put("stageIds", dto.getStageIds());
        } else {
            map.put("excludeCustomerStageIds", stageList);
        }
        if (ToolUtil.isNotEmpty((Object)dto.getSearchKey())) {
            map.put("searchKey", dto.getSearchKey());
        }
        page = (Page)this.selectProductsByCustomerId(dto.getCustomerId(), page, map);
        for (Object record : page.getRecords()) {
            ((OpportunityEntityVo)record).setOpportunityAmount(String.valueOf(this.processingAmountFormat(Double.parseDouble(((OpportunityEntityVo)record).getOpportunityAmount()), dto.getAmountConfig())));
            ((OpportunityEntityVo)record).setProductAccount(String.valueOf(this.processingAmountFormat(Double.parseDouble(((OpportunityEntityVo)record).getProductAccount()), dto.getAmountConfig())));
        }
        return page;
    }

    @Override
    public CustomerBriefingVo getContactCount(CustomerBriefingDto dto) {
        List<Map<String, Object>> list = this.customerProfileMapper.selectContactByCustomerId(dto.getCustomerId());
        for (Map<String, Object> map : list) {
            map.put("customerId", map.get("CUSTOMER_ID"));
        }
        List dicSingles = this.sysDicRefService.getDictByType("opport_role");
        List unknowRole = dicSingles.stream().filter(dic -> dic.getLabel().equals("\u672a\u77e5")).collect(Collectors.toList());
        dicSingles = dicSingles.stream().filter(dic -> !dic.getLabel().equals("\u672a\u77e5")).collect(Collectors.toList());
        int roleCount = dicSingles.size();
        HashMap<Long, String> contactIdHashMap = new HashMap<Long, String>();
        HashMap<Long, String> roleHashMap = new HashMap<Long, String>();
        for (Map<String, Object> map : list) {
            Long contactId = (Long)map.get("CONTACT_ID");
            String roleStr = (String)map.get("ROLE");
            List<String> roleList = Arrays.asList(roleStr.split(","));
            contactIdHashMap.put(contactId, "1");
            for (String s : roleList) {
                if (ToolUtil.isNotEmpty(unknowRole)) {
                    if ("-1".equals(s) || s.equals(((DicSingle)unknowRole.get(0)).getValue())) continue;
                    roleHashMap.put(Long.parseLong(s), "1");
                    continue;
                }
                if ("-1".equals(s)) continue;
                roleHashMap.put(Long.parseLong(s), "1");
            }
        }
        CustomerBriefingVo result = new CustomerBriefingVo();
        result.setCopywriting2(String.format("\u5173\u952e\u89d2\u8272\u53d6\u81ea\u5546\u673a\u5e72\u7cfb\u4eba\u4e2d\u89d2\u8272\uff0c\u5305\u542b\uff1a%s", dicSingles.stream().map(DicSingle::getLabel).collect(Collectors.joining("\u3001"))));
        result.setContactCount(contactIdHashMap.keySet().size());
        result.setKeyRoleCoverDegree(Double.parseDouble(String.format("%.2f", (double)roleHashMap.keySet().size() / (double)roleCount * 100.0)));
        if (result.getKeyRoleCoverDegree() > 50.0) {
            result.setCopywriting("\u5173\u952e\u89d2\u8272\u57fa\u672c\u8986\u76d6");
        } else if (!result.getKeyRoleCoverDegree().equals(0.0)) {
            result.setCopywriting("\u5173\u952e\u89d2\u8272\u8986\u76d6\u5ea6\u8f83\u4f4e");
        }
        return result;
    }

    @Override
    public Object getCustomerPortraitContactList(CustomerBriefingDto dto) {
        SalespersonAnalysisContactDto salespersonAnalysisContactDto = new SalespersonAnalysisContactDto();
        salespersonAnalysisContactDto.setDelFlag("0");
        salespersonAnalysisContactDto.setCustomerId(dto.getCustomerId());
        salespersonAnalysisContactDto.setContactScreening(dto.getSearchKey());
        Page page = new Page();
        page.setSize((long)dto.getSize().intValue());
        page.setCurrent((long)dto.getCurrent().intValue());
        PermissionDto dto1 = new PermissionDto();
        List<ContactEntity> list = this.salespersonAnalysisMapper.selectContactList(Arrays.asList(salespersonAnalysisContactDto), page, null, null, dto1);
        page.setRecords(list);
        return page;
    }

    @Override
    public CustomerBriefingVo getContributionLevel(CustomerBriefingDto dto) {
        LocalDateTime customerCreateTime = dto.getCustomerCreateTime();
        int yearNum = LocalDateTime.now().getYear() - customerCreateTime.getYear() + 1;
        SingleCustomerMetricsEntity singleMetrice = (SingleCustomerMetricsEntity)this.singleCustomerMetricsService.getOne((Wrapper)new LambdaQueryWrapper().eq(SingleCustomerMetricsEntity::getCustomerId, (Object)dto.getCustomerId()));
        CustomerBriefingVo result = new CustomerBriefingVo();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (ToolUtil.isNotEmpty((Object)singleMetrice)) {
            String rankStr = singleMetrice.getWinningAmountRank();
            List rankList = Arrays.asList(rankStr.split(",")).stream().map(rank -> Integer.parseInt(rank)).collect(Collectors.toList());
            for (int i = 0; i < yearNum; ++i) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("rank", rankList.get(rankList.size() - 2 - i));
                temp.put("date", LocalDateTime.now().getYear() - i);
                list.add(temp);
            }
            Collections.reverse(list);
            result.setContributionLevelTotal((Integer)rankList.get(rankList.size() - 1));
        }
        result.setContributionLevelList(list);
        return result;
    }

    @Override
    public CustomerBriefingVo getContractAmount(CustomerBriefingDto dto) {
        CustomerBriefingVo result;
        block18: {
            result = new CustomerBriefingVo();
            Long customerId = dto.getCustomerId();
            CustomerAPIVo customerAPIVo = this.customerAPIService.selectById(customerId);
            if (ToolUtil.isNotEmpty((Object)dto.getTimeFlag())) {
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("customer", customerAPIVo.getCustomerName());
                HashMap<String, HashMap<String, String>> param = new HashMap<String, HashMap<String, String>>();
                param.put("body", body);
                try {
                    if (this.osApiProperties.isOsEnable()) {
                        ApiResponse contractJSON = EimPushUtil.post((String)this.osApiProperties.getIncomeByCustomer(), param);
                        List contractVoList = (List)((JSONObject)contractJSON.getData()).get((Object)"dataList");
                        Double amountTotal = 0.0;
                        int countTotal = 0;
                        for (Map map : contractVoList) {
                            ++countTotal;
                            amountTotal = amountTotal + Double.parseDouble((String)map.get("htje"));
                        }
                        result.setAllContractAmount(this.processingAmountFormat(amountTotal, null));
                        result.setAllContractCount(countTotal);
                        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
                        if ("0".equals(dto.getTimeFlag())) {
                            List<String> monthList = this.generatePreviousMonths(6);
                            for (String month : monthList) {
                                double amount = 0.0;
                                int count = 0;
                                HashMap<String, Object> singleMap = new HashMap<String, Object>();
                                for (Map map : contractVoList) {
                                    String date;
                                    if (!ToolUtil.isNotEmpty(map.get("finishTime")) || !this.compareTime(month, date = ((String)map.get("finishTime")).substring(0, 10)).booleanValue()) continue;
                                    amount += Double.parseDouble((String)map.get("htje"));
                                    ++count;
                                }
                                singleMap.put("contractAmount", amount);
                                singleMap.put("contractCount", count);
                                singleMap.put("date", month);
                                mapList.add(singleMap);
                            }
                        } else if ("1".equals(dto.getTimeFlag())) {
                            int dateYear = 0;
                            dateYear = ToolUtil.isNotEmpty((Object)dto.getCustomerCreateTime()) ? dto.getCustomerCreateTime().getYear() : customerAPIVo.getCreateTime().getYear();
                            List<String> list = this.generatePreviousYears(dateYear);
                            for (String year : list) {
                                double amount = 0.0;
                                int count = 0;
                                HashMap<String, Object> singleMap = new HashMap<String, Object>();
                                for (Map map : contractVoList) {
                                    String date;
                                    if (!ToolUtil.isNotEmpty(map.get("finishTime")) || !year.equals(date = ((String)map.get("finishTime")).substring(0, 4))) continue;
                                    amount += Double.parseDouble((String)map.get("htje"));
                                    ++count;
                                }
                                singleMap.put("contractAmount", amount);
                                singleMap.put("contractCount", count);
                                singleMap.put("date", year);
                                mapList.add(singleMap);
                            }
                        }
                        for (Map map : mapList) {
                            if (!map.containsKey("contractAmount")) continue;
                            map.put("contractAmount", this.processingAmountFormat((Double)map.get("contractAmount"), dto.getAmountConfig()));
                        }
                        result.setContractList(mapList);
                    }
                    this.emptyContract(customerAPIVo, dto, result);
                }
                catch (Exception e) {
                    this.emptyContract(customerAPIVo, dto, result);
                    return result;
                }
            } else {
                try {
                    if (this.osApiProperties.isOsEnable()) {
                        HashMap<String, String> body = new HashMap<String, String>();
                        body.put("customer", customerAPIVo.getCustomerName());
                        HashMap<String, HashMap<String, String>> param = new HashMap<String, HashMap<String, String>>();
                        param.put("body", body);
                        ApiResponse contractJSON = EimPushUtil.post((String)this.osApiProperties.getIncomeDataByCustomer(), param);
                        JSONObject contractVoMap = (JSONObject)contractJSON.getData();
                        if (ToolUtil.isEmpty((Object)contractVoMap)) {
                            result.setAllContractCount(Integer.parseInt((String)contractVoMap.get((Object)"htNum")));
                            result.setAllContractAmount(this.processingAmountFormat(Double.parseDouble((String)contractVoMap.get((Object)"htje")), dto.getAmountConfig()));
                            result.setNetContractAmount(this.processingAmountFormat(Double.parseDouble((String)contractVoMap.get((Object)"jhte")), dto.getAmountConfig()));
                        }
                        break block18;
                    }
                    return result;
                }
                catch (Exception e) {
                    return result;
                }
            }
        }
        return result;
    }

    private void emptyContract(CustomerAPIVo customerAPIVo, CustomerBriefingDto dto, CustomerBriefingVo result) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if ("0".equals(dto.getTimeFlag())) {
            List<String> monthList = this.generatePreviousMonths(6);
            for (String month : monthList) {
                double amount = 0.0;
                int count = 0;
                HashMap<String, Object> singleMap = new HashMap<String, Object>();
                singleMap.put("contractAmount", amount);
                singleMap.put("contractCount", count);
                singleMap.put("date", month);
                mapList.add(singleMap);
            }
        } else if ("1".equals(dto.getTimeFlag())) {
            int dateYear = 0;
            dateYear = ToolUtil.isNotEmpty((Object)dto.getCustomerCreateTime()) ? dto.getCustomerCreateTime().getYear() : customerAPIVo.getCreateTime().getYear();
            List<String> yearList = this.generatePreviousYears(dateYear);
            for (String year : yearList) {
                double amount = 0.0;
                int count = 0;
                HashMap<String, Object> singleMap = new HashMap<String, Object>();
                singleMap.put("contractAmount", amount);
                singleMap.put("contractCount", count);
                singleMap.put("date", year);
                mapList.add(singleMap);
            }
        }
        result.setContractList(mapList);
    }

    @Override
    public Object getCustomerPortraitContractDataList(CustomerBriefingDto dto) {
        Long customerId = dto.getCustomerId();
        CustomerAPIVo customerAPIVo = this.customerAPIService.selectById(customerId);
        Page page = new Page();
        page.setSize((long)dto.getSize().intValue());
        page.setCurrent((long)dto.getCurrent().intValue());
        try {
            List<Object> resultList;
            int right;
            int left;
            int current;
            int size;
            ContractVo contractVo;
            List<Object> returnContractVoList;
            String date;
            if (!this.osApiProperties.isOsEnable()) {
                return page;
            }
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("customer", customerAPIVo.getCustomerName());
            HashMap<String, HashMap<String, String>> param = new HashMap<String, HashMap<String, String>>();
            param.put("body", body);
            ApiResponse contractJSON = EimPushUtil.post((String)this.osApiProperties.getIncomeByCustomer(), param);
            List contractVoList = (List)((JSONObject)contractJSON.getData()).get((Object)"dataList");
            int count = Integer.parseInt((String)((JSONObject)contractJSON.getData()).get((Object)"count"));
            if ("0".equals(dto.getTimeFlag())) {
                date = dto.getDate();
                returnContractVoList = new ArrayList();
                for (Map contractVoMap : contractVoList) {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    LocalDateTime finishTime = StringUtil.isEmpty(contractVoMap.get("finishTime")) ? null : LocalDateTime.parse((String)contractVoMap.get("finishTime"), formatter);
                    if (!ToolUtil.isNotEmpty(finishTime) || !this.compareTime(date, finishTime).booleanValue()) continue;
                    contractVo = new ContractVo();
                    contractVo.setContractNumber((String)contractVoMap.get("htbh"));
                    contractVo.setContractAmount(Double.parseDouble((String)contractVoMap.get("htje")));
                    contractVo.setNetContractAmount(Double.parseDouble((String)contractVoMap.get("jhte")));
                    contractVo.setContractReceivableAmount(Double.parseDouble((String)contractVoMap.get("htys")));
                    contractVo.setSignTime(StringUtil.isEmpty(contractVoMap.get("sxrq")) ? null : LocalDate.parse(((String)contractVoMap.get("sxrq")).substring(0, 10)));
                    contractVo.setFinishTime(StringUtil.isEmpty(contractVoMap.get("finishTime")) ? null : LocalDateTime.parse((CharSequence)contractVoMap.get("finishTime"), formatter));
                    contractVo.setChargePersonName((String)contractVoMap.get("htfzr"));
                    contractVo.setOwnDepartmentName((String)contractVoMap.get("createdept"));
                    returnContractVoList.add(contractVo);
                }
                if (ToolUtil.isNotEmpty((Object)dto.getSearchKey())) {
                    returnContractVoList = returnContractVoList.stream().filter(vo -> vo.getContractNumber().equals(dto.getSearchKey())).collect(Collectors.toList());
                }
                size = dto.getSize();
                current = dto.getCurrent();
                left = (current - 1) * size;
                right = Math.min(left + size, returnContractVoList.size());
                resultList = returnContractVoList.subList(left, right);
                page.setRecords(resultList);
                page.setTotal((long)returnContractVoList.size());
            } else if ("1".equals(dto.getTimeFlag())) {
                date = dto.getDate();
                returnContractVoList = new ArrayList();
                for (Map contractVoMap : contractVoList) {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    LocalDateTime finishTime = StringUtil.isEmpty(contractVoMap.get("finishTime")) ? null : LocalDateTime.parse((String)contractVoMap.get("finishTime"), formatter);
                    if (!ToolUtil.isNotEmpty(finishTime) || !String.valueOf(finishTime.getYear()).equals(date)) continue;
                    contractVo = new ContractVo();
                    contractVo.setContractNumber((String)contractVoMap.get("htbh"));
                    contractVo.setContractAmount(Double.parseDouble((String)contractVoMap.get("htje")));
                    contractVo.setNetContractAmount(Double.parseDouble((String)contractVoMap.get("jhte")));
                    contractVo.setContractReceivableAmount(Double.parseDouble((String)contractVoMap.get("htys")));
                    contractVo.setSignTime(StringUtil.isEmpty(contractVoMap.get("sxrq")) ? null : LocalDate.parse(((String)contractVoMap.get("sxrq")).substring(0, 10)));
                    contractVo.setFinishTime(StringUtil.isEmpty(contractVoMap.get("finishTime")) ? null : LocalDateTime.parse((String)contractVoMap.get("finishTime"), formatter));
                    contractVo.setChargePersonName((String)contractVoMap.get("htfzr"));
                    contractVo.setOwnDepartmentName((String)contractVoMap.get("createdept"));
                    returnContractVoList.add(contractVo);
                }
                if (ToolUtil.isNotEmpty((Object)dto.getSearchKey())) {
                    returnContractVoList = returnContractVoList.stream().filter(vo -> vo.getContractNumber().equals(dto.getSearchKey())).collect(Collectors.toList());
                }
                size = dto.getSize();
                current = dto.getCurrent();
                left = (current - 1) * size;
                right = Math.min(left + size, returnContractVoList.size());
                resultList = returnContractVoList.subList(left, right);
                page.setRecords(resultList);
                page.setTotal((long)returnContractVoList.size());
            } else {
                List<Object> returnContractVoList2 = new ArrayList();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                for (Map contractVoMap : contractVoList) {
                    ContractVo contractVo2 = new ContractVo();
                    contractVo2.setContractNumber((String)contractVoMap.get("htbh"));
                    contractVo2.setContractAmount(Double.parseDouble((String)contractVoMap.get("htje")));
                    contractVo2.setNetContractAmount(Double.parseDouble((String)contractVoMap.get("jhte")));
                    contractVo2.setContractReceivableAmount(Double.parseDouble((String)contractVoMap.get("htys")));
                    contractVo2.setSignTime(StringUtil.isEmpty(contractVoMap.get("sxrq")) ? null : LocalDate.parse(((String)contractVoMap.get("sxrq")).substring(0, 10)));
                    contractVo2.setFinishTime(StringUtil.isEmpty(contractVoMap.get("finishTime")) ? null : LocalDateTime.parse((CharSequence)contractVoMap.get("finishTime"), formatter));
                    contractVo2.setChargePersonName((String)contractVoMap.get("htfzr"));
                    contractVo2.setOwnDepartmentName((String)contractVoMap.get("createdept"));
                    returnContractVoList2.add(contractVo2);
                }
                if (ToolUtil.isNotEmpty((Object)dto.getSearchKey())) {
                    returnContractVoList2 = returnContractVoList2.stream().filter(vo -> vo.getContractNumber().equals(dto.getSearchKey())).collect(Collectors.toList());
                }
                size = dto.getSize();
                current = dto.getCurrent();
                left = (current - 1) * size;
                right = Math.min(left + size, returnContractVoList2.size());
                resultList = returnContractVoList2.subList(left, right);
                page.setRecords(resultList);
                page.setTotal((long)returnContractVoList2.size());
            }
        }
        catch (Exception e) {
            return page;
        }
        for (ContractVo record : page.getRecords()) {
            record.setContractAmount(this.processingAmountFormat(record.getContractAmount(), dto.getAmountConfig()));
            record.setNetContractAmount(this.processingAmountFormat(record.getNetContractAmount(), dto.getAmountConfig()));
            record.setContractReceivableAmount(this.processingAmountFormat(record.getContractReceivableAmount(), dto.getAmountConfig()));
        }
        return page;
    }

    private void defaultPaymentList(CustomerBriefingDto dto, CustomerBriefingVo result, CustomerAPIVo customerAPIVo) {
        if ("0".equals(dto.getSearchType())) {
            result.setPaymentCount(0);
            result.setPaymentAmount(0.0);
            result.setNoPaymentAmount(0.0);
            result.setPaymentPatio(0.0);
        } else if ("1".equals(dto.getSearchType())) {
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
            if ("0".equals(dto.getTimeFlag())) {
                List<String> monthList = this.generatePreviousMonths(6);
                for (String month : monthList) {
                    double amount = 0.0;
                    HashMap<String, Object> singleMap = new HashMap<String, Object>();
                    singleMap.put("estimatePayment", 0.0);
                    singleMap.put("payment", 0.0);
                    singleMap.put("date", month);
                    mapList.add(singleMap);
                }
            } else if ("1".equals(dto.getTimeFlag())) {
                String earliestYear = String.valueOf(customerAPIVo.getCreateTime().getYear());
                List<String> yearList = this.generatePreviousYears(Integer.parseInt(earliestYear));
                for (String year : yearList) {
                    HashMap<String, Object> singleMap = new HashMap<String, Object>();
                    singleMap.put("estimatePayment", 0.0);
                    singleMap.put("payment", 0.0);
                    singleMap.put("date", year);
                    mapList.add(singleMap);
                }
            }
            result.setPaymentList(mapList);
        }
    }

    @Override
    public CustomerBriefingVo getContractPayment(CustomerBriefingDto dto) {
        CustomerBriefingVo result;
        block21: {
            result = new CustomerBriefingVo();
            Long customerId = dto.getCustomerId();
            CustomerAPIVo customerAPIVo = this.customerAPIService.selectById(customerId);
            if (this.osApiProperties.isOsEnable()) {
                this.defaultPaymentList(dto, result, customerAPIVo);
                return result;
            }
            try {
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("customer", customerAPIVo.getCustomerName());
                HashMap<String, HashMap<String, String>> param = new HashMap<String, HashMap<String, String>>();
                param.put("body", body);
                ApiResponse contractJSON = EimPushUtil.post((String)this.osApiProperties.getReturnedMoneyByCustomer(), param);
                List paymentList = (List)((JSONObject)contractJSON.getData()).get((Object)"dataList");
                ApiResponse contractJs = EimPushUtil.post((String)this.osApiProperties.getIncomeByCustomer(), param);
                List contractVoList = (List)((JSONObject)contractJs.getData()).get((Object)"dataList");
                if ("0".equals(dto.getSearchType())) {
                    HashMap<String, Double> contractMap = new HashMap<String, Double>();
                    Double paymentAmount = 0.0;
                    Double totalAmount = 0.0;
                    for (Map map2 : paymentList) {
                        String contractId = (String)map2.get("htbh");
                        if (!contractMap.containsKey(contractId)) {
                            contractMap.put(contractId, Double.parseDouble((String)map2.get("htje")));
                        }
                        paymentAmount = paymentAmount + Double.parseDouble((String)map2.get("hkje"));
                    }
                    for (Map map2 : contractVoList) {
                        totalAmount = totalAmount + Double.parseDouble((String)map2.get("htje"));
                    }
                    result.setPaymentCount(paymentList.size());
                    result.setPaymentAmount(this.processingAmountFormat(paymentAmount, dto.getAmountConfig()));
                    result.setNoPaymentAmount(this.processingAmountFormat(totalAmount - paymentAmount, dto.getAmountConfig()));
                    if (totalAmount.equals(0.0)) {
                        result.setPaymentPatio(0.0);
                    } else {
                        result.setPaymentPatio(Double.parseDouble(String.format("%.2f", (totalAmount - paymentAmount) / totalAmount * 100.0)));
                    }
                    break block21;
                }
                if (!"1".equals(dto.getSearchType())) break block21;
                ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
                if ("0".equals(dto.getTimeFlag())) {
                    body.put("customer", customerAPIVo.getCustomerName());
                    body.put("yearOrMonth", "M");
                    HashMap<String, HashMap<String, String>> paramTemp = new HashMap<String, HashMap<String, String>>();
                    paramTemp.put("body", body);
                    ApiResponse estimatedJSON = EimPushUtil.post((String)this.osApiProperties.getEstimatedPaymentByCustomer(), paramTemp);
                    List estimatedPaymentList = (List)estimatedJSON.getData();
                    for (Object map3 : estimatedPaymentList) {
                        String month = ((String)map3.get("rq")).replace("-", "");
                        map3.put("rq", month);
                    }
                    List<String> monthList = this.generatePreviousMonths(6);
                    for (String month : monthList) {
                        double amount = 0.0;
                        HashMap<String, Object> singleMap = new HashMap<String, Object>();
                        for (Map map4 : paymentList) {
                            String date;
                            if (!ToolUtil.isNotEmpty(map4.get("rlsj")) || !this.compareTime(month, date = ((String)map4.get("rlsj")).substring(0, 10)).booleanValue()) continue;
                            amount += Double.parseDouble((String)map4.get("hkje"));
                        }
                        List tempList = estimatedPaymentList.stream().filter(map -> ((String)map.get("rq")).equals(month)).collect(Collectors.toList());
                        if (ToolUtil.isNotEmpty(tempList)) {
                            singleMap.put("estimatePayment", this.processingAmountFormat(Double.parseDouble((String)((Map)tempList.get(0)).get("yghk")), dto.getAmountConfig()));
                        }
                        singleMap.put("payment", this.processingAmountFormat(amount, dto.getAmountConfig()));
                        singleMap.put("date", month);
                        mapList.add(singleMap);
                    }
                } else if ("1".equals(dto.getTimeFlag())) {
                    body.put("customer", customerAPIVo.getCustomerName());
                    body.put("yearOrMonth", "Y");
                    HashMap<String, HashMap<String, String>> paramTemp = new HashMap<String, HashMap<String, String>>();
                    paramTemp.put("body", body);
                    ApiResponse estimatedJSON = EimPushUtil.post((String)this.osApiProperties.getEstimatedPaymentByCustomer(), paramTemp);
                    List estimatedPaymentList = (List)estimatedJSON.getData();
                    for (Object map5 : estimatedPaymentList) {
                        String month = ((String)map5.get("rq")).replace("-", "");
                        map5.put("rq", month);
                    }
                    String earliestYear = "";
                    for (Map map6 : estimatedPaymentList) {
                        if (!ToolUtil.isNotEmpty(map6.get("rq"))) continue;
                        String year = ((String)map6.get("rq")).substring(0, 4);
                        if (!ToolUtil.isEmpty((Object)earliestYear) && Integer.parseInt(earliestYear) <= Integer.parseInt(year)) continue;
                        earliestYear = year;
                    }
                    List<String> yearList = this.generatePreviousYears(Integer.parseInt(earliestYear));
                    for (String year : yearList) {
                        double amount = 0.0;
                        HashMap<String, Object> singleMap = new HashMap<String, Object>();
                        for (Map map7 : paymentList) {
                            String date;
                            if (!ToolUtil.isNotEmpty(map7.get("rlsj")) || !(date = ((String)map7.get("rlsj")).substring(0, 4)).equals(year)) continue;
                            amount += Double.parseDouble((String)map7.get("hkje"));
                        }
                        List tempList = estimatedPaymentList.stream().filter(map -> ((String)map.get("rq")).equals(year)).collect(Collectors.toList());
                        if (ToolUtil.isNotEmpty(tempList)) {
                            singleMap.put("estimatePayment", this.processingAmountFormat(Double.parseDouble((String)((Map)tempList.get(0)).get("yghk")), dto.getAmountConfig()));
                        }
                        singleMap.put("payment", this.processingAmountFormat(amount, dto.getAmountConfig()));
                        singleMap.put("date", year);
                        mapList.add(singleMap);
                    }
                }
                result.setPaymentList(mapList);
            }
            catch (Exception e) {
                this.defaultPaymentList(dto, result, customerAPIVo);
                return result;
            }
        }
        return result;
    }

    @Override
    public Object getCustomerPortraitPaymentList(CustomerBriefingDto dto) {
        Long customerId = dto.getCustomerId();
        CustomerAPIVo customerAPIVo = this.customerAPIService.selectById(customerId);
        Page page = new Page();
        page.setSize((long)dto.getSize().intValue());
        page.setCurrent((long)dto.getCurrent().intValue());
        try {
            if (!this.osApiProperties.isOsEnable()) {
                return page;
            }
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("customer", customerAPIVo.getCustomerName());
            HashMap<String, HashMap<String, String>> param = new HashMap<String, HashMap<String, String>>();
            param.put("body", body);
            ApiResponse paymentJSON = EimPushUtil.post((String)this.osApiProperties.getReturnedMoneyByCustomer(), param);
            List paymentList = (List)((JSONObject)paymentJSON.getData()).get((Object)"dataList");
            if ("0".equals(dto.getTimeFlag())) {
                String dateStr = dto.getDate();
                List<Object> returnIncomeVoList = new ArrayList();
                for (Map incomeVoMap : paymentList) {
                    String date;
                    if (ToolUtil.isEmpty(incomeVoMap.get("rlsj")) || ((String)incomeVoMap.get("rlsj")).length() < 10 || !this.compareTime(dateStr, date = ((String)incomeVoMap.get("rlsj")).substring(0, 10)).booleanValue()) continue;
                    IncomeVo incomeVo = new IncomeVo();
                    incomeVo.setIncomeCode((String)incomeVoMap.get("hkbh"));
                    incomeVo.setIncomeAmount(String.valueOf(this.processingAmountFormat(Double.parseDouble((String)incomeVoMap.get("hkje")), dto.getAmountConfig())));
                    incomeVo.setContractAmount(String.valueOf(this.processingAmountFormat(Double.parseDouble((String)incomeVoMap.get("htje")), dto.getAmountConfig())));
                    incomeVo.setContractCode((String)incomeVoMap.get("htbh"));
                    incomeVo.setContractName((String)incomeVoMap.get("htmc"));
                    incomeVo.setIncomeDepartment((String)incomeVoMap.get("hkjfmc"));
                    incomeVo.setClaimPersonName((String)incomeVoMap.get("rlrmc"));
                    incomeVo.setClaimDate((String)incomeVoMap.get("rlsj"));
                    returnIncomeVoList.add(incomeVo);
                }
                if (ToolUtil.isNotEmpty((Object)dto.getSearchKey())) {
                    returnIncomeVoList = returnIncomeVoList.stream().filter(vo -> vo.getContractCode().equals(dto.getSearchKey())).collect(Collectors.toList());
                }
                int size = dto.getSize();
                int current = dto.getCurrent();
                int left = (current - 1) * size;
                int right = Math.min(left + size, returnIncomeVoList.size());
                List<Object> resultList = returnIncomeVoList.subList(left, right);
                page.setRecords(resultList);
                page.setTotal((long)returnIncomeVoList.size());
            } else if ("1".equals(dto.getTimeFlag())) {
                String dateStr = dto.getDate();
                List<Object> returnIncomeVoList = new ArrayList();
                for (Map incomeVoMap : paymentList) {
                    String date;
                    if (ToolUtil.isEmpty(incomeVoMap.get("rlsj")) || ((String)incomeVoMap.get("rlsj")).length() < 4 || !dateStr.equals(date = ((String)incomeVoMap.get("rlsj")).substring(0, 4))) continue;
                    IncomeVo incomeVo = new IncomeVo();
                    incomeVo.setIncomeCode((String)incomeVoMap.get("hkbh"));
                    incomeVo.setIncomeAmount(String.valueOf(this.processingAmountFormat(Double.parseDouble((String)incomeVoMap.get("hkje")), dto.getAmountConfig())));
                    incomeVo.setContractAmount(String.valueOf(this.processingAmountFormat(Double.parseDouble((String)incomeVoMap.get("htje")), dto.getAmountConfig())));
                    incomeVo.setContractCode((String)incomeVoMap.get("htbh"));
                    incomeVo.setContractName((String)incomeVoMap.get("htmc"));
                    incomeVo.setIncomeDepartment((String)incomeVoMap.get("hkjfmc"));
                    incomeVo.setClaimPersonName((String)incomeVoMap.get("rlrmc"));
                    incomeVo.setClaimDate((String)incomeVoMap.get("rlsj"));
                    returnIncomeVoList.add(incomeVo);
                }
                if (ToolUtil.isNotEmpty((Object)dto.getSearchKey())) {
                    returnIncomeVoList = returnIncomeVoList.stream().filter(vo -> vo.getContractCode().equals(dto.getSearchKey())).collect(Collectors.toList());
                }
                int size = dto.getSize();
                int current = dto.getCurrent();
                int left = (current - 1) * size;
                int right = Math.min(left + size, returnIncomeVoList.size());
                List<Object> resultList = returnIncomeVoList.subList(left, right);
                page.setRecords(resultList);
                page.setTotal((long)returnIncomeVoList.size());
            } else {
                List<Object> returnIncomeVoList = new ArrayList();
                for (Map incomeVoMap : paymentList) {
                    IncomeVo incomeVo = new IncomeVo();
                    incomeVo.setIncomeCode((String)incomeVoMap.get("hkbh"));
                    incomeVo.setIncomeAmount(String.valueOf(this.processingAmountFormat(Double.parseDouble((String)incomeVoMap.get("hkje")), dto.getAmountConfig())));
                    incomeVo.setContractAmount(String.valueOf(this.processingAmountFormat(Double.parseDouble((String)incomeVoMap.get("htje")), dto.getAmountConfig())));
                    incomeVo.setContractCode((String)incomeVoMap.get("htbh"));
                    incomeVo.setContractName((String)incomeVoMap.get("htmc"));
                    incomeVo.setIncomeDepartment((String)incomeVoMap.get("hkjfmc"));
                    incomeVo.setClaimPersonName((String)incomeVoMap.get("rlrmc"));
                    incomeVo.setClaimDate((String)incomeVoMap.get("rlsj"));
                    returnIncomeVoList.add(incomeVo);
                }
                if (ToolUtil.isNotEmpty((Object)dto.getSearchKey())) {
                    returnIncomeVoList = returnIncomeVoList.stream().filter(vo -> vo.getContractCode().equals(dto.getSearchKey())).collect(Collectors.toList());
                }
                int size = dto.getSize();
                int current = dto.getCurrent();
                int left = (current - 1) * size;
                int right = Math.min(left + size, returnIncomeVoList.size());
                List<Object> resultList = returnIncomeVoList.subList(left, right);
                page.setRecords(resultList);
                page.setTotal((long)returnIncomeVoList.size());
            }
        }
        catch (Exception e) {
            return page;
        }
        return page;
    }

    @Override
    public CustomerBriefingVo getAverageAccountAge(String customerId) {
        CustomerAPIVo customerAPIVo = this.customerAPIService.selectById(Long.valueOf(Long.parseLong(customerId)));
        CustomerBriefingVo result = new CustomerBriefingVo();
        CrmBaseConfigVo configVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("account_age_risk_value");
        result.setRiskValue(Double.parseDouble(configVo.getConfigValue()));
        configVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("account_age_total_risk_value");
        result.setTotalValue(Double.parseDouble(configVo.getConfigValue()));
        try {
            if (this.osApiProperties.isOsEnable()) {
                HashMap<String, String> body = new HashMap<String, String>();
                body.put("customer", customerAPIVo.getCustomerName());
                HashMap<String, HashMap<String, String>> param = new HashMap<String, HashMap<String, String>>();
                param.put("body", body);
                ApiResponse contractJSON = EimPushUtil.post((String)this.osApiProperties.getIncomeDataByCustomer(), param);
                JSONObject contractVoMap = (JSONObject)contractJSON.getData();
                result.setAverageAccountAge(Double.parseDouble((String)contractVoMap.get((Object)"zl")));
            } else {
                result.setAverageAccountAge(null);
            }
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }

    @Override
    public CustomerBriefingVo getContractInvoice(CustomerBriefingDto dto) {
        CustomerAPIVo customerAPIVo = this.customerAPIService.selectById(dto.getCustomerId());
        CustomerBriefingVo result = new CustomerBriefingVo();
        try {
            if (!this.osApiProperties.isOsEnable()) {
                return result;
            }
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("customer", customerAPIVo.getCustomerName());
            HashMap<String, HashMap<String, String>> param = new HashMap<String, HashMap<String, String>>();
            param.put("body", body);
            ApiResponse contractJSON = EimPushUtil.post((String)this.osApiProperties.getIncomeDataByCustomer(), param);
            JSONObject contractVoMap = (JSONObject)contractJSON.getData();
            result.setInvoiceQuantity(Integer.parseInt((String)contractVoMap.get((Object)"fpNum")));
            result.setInvoiceAmount(Double.parseDouble((String)contractVoMap.get((Object)"ykje")));
            Double contractAmount = Double.parseDouble((String)contractVoMap.get((Object)"htje"));
            if (contractAmount.equals(0.0)) {
                result.setInvoiceRatio(0.0);
            } else {
                result.setInvoiceRatio(Double.parseDouble(String.format("%.2f", result.getInvoiceAmount() / contractAmount)));
            }
            result.setInvoiceAmount(this.processingAmountFormat(Double.parseDouble((String)contractVoMap.get((Object)"ykje")), dto.getAmountConfig()));
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }

    @Override
    public Object getCustomerPortraitInvoiceList(CustomerBriefingDto dto) {
        Long customerId = dto.getCustomerId();
        CustomerAPIVo customerAPIVo = this.customerAPIService.selectById(customerId);
        Page page = new Page();
        page.setSize((long)dto.getSize().intValue());
        page.setCurrent((long)dto.getCurrent().intValue());
        try {
            if (!this.osApiProperties.isOsEnable()) {
                return page;
            }
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("customer", customerAPIVo.getCustomerName());
            HashMap<String, HashMap<String, String>> param = new HashMap<String, HashMap<String, String>>();
            param.put("body", body);
            ApiResponse contractJSON = EimPushUtil.post((String)this.osApiProperties.getReceiptListByCustomer(), param);
            List contractVoList = (List)((JSONObject)contractJSON.getData()).get((Object)"dataList");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            List<Object> returnInvoiceVoList = new ArrayList();
            for (Map invoiceVoMap : contractVoList) {
                InvoiceVo invoiceVo = new InvoiceVo();
                invoiceVo.setInvoiceCode((String)invoiceVoMap.get("fpbh"));
                invoiceVo.setInvoiceAmount(String.valueOf(this.processingAmountFormat(Double.parseDouble((String)invoiceVoMap.get("fpje")), dto.getAmountConfig())));
                invoiceVo.setContractAmount(String.valueOf(this.processingAmountFormat(Double.parseDouble((String)invoiceVoMap.get("htje")), dto.getAmountConfig())));
                invoiceVo.setContractCode((String)invoiceVoMap.get("htbh"));
                invoiceVo.setContractName((String)invoiceVoMap.get("htmc"));
                invoiceVo.setInvoiceDepartmentName((String)invoiceVoMap.get("kpdw"));
                invoiceVo.setApplyPersonName((String)invoiceVoMap.get("createuser"));
                invoiceVo.setApplyDate((String)invoiceVoMap.get("createdate"));
                invoiceVo.setFinishTime((String)invoiceVoMap.get("finishTime"));
                returnInvoiceVoList.add(invoiceVo);
            }
            if (ToolUtil.isNotEmpty((Object)dto.getSearchKey())) {
                returnInvoiceVoList = returnInvoiceVoList.stream().filter(vo -> vo.getInvoiceCode().equals(dto.getSearchKey())).collect(Collectors.toList());
            }
            int size = dto.getSize();
            int current = dto.getCurrent();
            int left = (current - 1) * size;
            int right = Math.min(left + size, returnInvoiceVoList.size());
            List<Object> resultList = returnInvoiceVoList.subList(left, right);
            page.setRecords(resultList);
            page.setTotal((long)returnInvoiceVoList.size());
        }
        catch (Exception e) {
            return page;
        }
        return page;
    }

    public Object selectTrackRecordByCustomerId(Long customerId, Page page, Map<String, Object> map) {
        TrackRecordAPIDto dto = new TrackRecordAPIDto();
        if (ToolUtil.isNotEmpty(map)) {
            dto = (TrackRecordAPIDto)BeanUtil.copy(map, TrackRecordAPIDto.class);
        }
        dto.setCustomerId(customerId);
        List<TrackRecordCusVo> list = this.customerProfileMapper.getTrackRecordByCustomer(dto, (Page<TrackRecordCusVo>)page);
        if (ToolUtil.isNotEmpty((Object)page)) {
            page.setRecords(list);
            return page;
        }
        return list;
    }

    public Object selectProductsByCustomerId(Long customerId, Page page, Map<String, Object> map) {
        SalesStatisticsDto dto = new SalesStatisticsDto();
        if (ToolUtil.isNotEmpty(map)) {
            dto = (SalesStatisticsDto)BeanUtil.copy(map, SalesStatisticsDto.class);
        }
        dto.setCustomerId(customerId);
        dto.setDelFlag("0");
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin().stream().map(String::valueOf).collect(Collectors.toList());
        List list = this.unifyPortalMapper.saleProductList(dto, page, stageWin, new PermissionDto(), new PermissionDto());
        if (ToolUtil.isNotEmpty((Object)page)) {
            page.setRecords(list);
            return page;
        }
        return list;
    }

    public List<String> generatePreviousMonths(int monthCount) {
        ArrayList<String> monthList = new ArrayList<String>();
        LocalDate currentDate = LocalDate.now();
        for (int i = 0; i < monthCount; ++i) {
            LocalDate previousMonth = currentDate.minusMonths(i);
            String monthString = previousMonth.format(DateTimeFormatter.ofPattern("yyyyMM"));
            monthList.add(monthString);
        }
        Collections.reverse(monthList);
        return monthList;
    }

    public List<String> generatePreviousYears(int earliesrYear) {
        ArrayList<String> yearList = new ArrayList<String>();
        LocalDate currentDate = LocalDate.now();
        int currentYear = currentDate.getYear();
        for (int i = 0; i <= currentYear - earliesrYear; ++i) {
            LocalDate previousYear = currentDate.minusYears(i);
            String yearString = previousYear.format(DateTimeFormatter.ofPattern("yyyy"));
            yearList.add(yearString);
        }
        Collections.reverse(yearList);
        return yearList;
    }

    public Boolean compareTime(String date1, LocalDateTime date2) {
        if (ToolUtil.isEmpty((Object)date2)) {
            return false;
        }
        LocalDate localDate = date2.toLocalDate();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
        String formattedDate = localDate.format(formatter);
        return date1.equals(formattedDate);
    }

    public Boolean compareTime(String date1, String date2) {
        if (ToolUtil.isEmpty((Object)date2)) {
            return false;
        }
        DateTimeFormatter date2Formatter = null;
        date2Formatter = date2.length() > 10 ? DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss") : DateTimeFormatter.ofPattern("yyyy-MM-dd");
        try {
            LocalDate localDate2 = LocalDate.parse(date2, date2Formatter);
            int year = Integer.parseInt(date1.substring(0, 4));
            int month = Integer.parseInt(date1.substring(4));
            YearMonth yearMonth = YearMonth.of(year, month);
            return yearMonth.getYear() == localDate2.getYear() && yearMonth.getMonth() == localDate2.getMonth();
        }
        catch (Exception e) {
            System.err.println("Error parsing dates: " + e.getMessage());
            return false;
        }
    }

    public double processingAmountFormat(double amount, Map<String, Object> amountConfig) {
        return Double.parseDouble(CommonUtills.transferAmount((Double)amount));
    }

    @Override
    public Map<Long, CustomerActivityLevelVo> getCustomerActivityLevel() {
        return this.customerProfileMapper.getCustomerActivityLevel().stream().collect(Collectors.toMap(CustomerActivityLevelVo::getCustomerId, vo -> vo));
    }

    @Override
    public ApiResponse<CustomerOpptyStatsVo> getCustomerOpptyStats(Long customerId) {
        CustomerOpptyStatsVo vo = new CustomerOpptyStatsVo();
        ICrmBaseConfigBoService crmBaseConfigBoService = (ICrmBaseConfigBoService)SpringUtils.getBean(ICrmBaseConfigBoService.class);
        CrmBaseConfigVo configVo = crmBaseConfigBoService.getCrmBaseConfigByKey("amount_display");
        String amountDisplay = configVo.getConfigValue();
        Integer userSecurityLevel = BaseSecurityUtil.getUser().getSecurityLevel();
        CustomerOpptyStatsVo vo1 = this.customerProfileMapper.selectCustomerOpptyNumAndAmount(customerId, null, userSecurityLevel);
        vo.setOpptyCount(vo1.getOpptyCount());
        vo.setOpptyAmount(CommonUtills.transferAmount((String)vo1.getOpptyAmount(), (String)amountDisplay));
        CustomerOpptyStatsVo vo2 = this.customerProfileMapper.selectCustomerOpptyNumAndAmount(customerId, "2", userSecurityLevel);
        vo.setInFollowUpCount(vo2.getOpptyCount());
        vo.setInFollowUpAmount(CommonUtills.transferAmount((String)vo2.getOpptyAmount(), (String)amountDisplay));
        LocalDate now = LocalDate.now();
        LocalDate sevenDaysLater = now.minus(Period.ofDays(7));
        LocalDate fifteenDaysLater = now.minus(Period.ofDays(15));
        LocalDate thirtyDaysLater = now.minus(Period.ofDays(30));
        int toBeFollowNum = this.customerProfileMapper.selectNotFollowOpptyNumByCustomerId(customerId, "0", sevenDaysLater, fifteenDaysLater, thirtyDaysLater, userSecurityLevel);
        vo.setToBeFollowUpAmount(toBeFollowNum);
        int stfCount = this.customerProfileMapper.selectNotFollowOpptyNumByCustomerId(customerId, "1", sevenDaysLater, fifteenDaysLater, thirtyDaysLater, userSecurityLevel);
        vo.setSevenNoFollowUpAmount(stfCount);
        int fttCount = this.customerProfileMapper.selectNotFollowOpptyNumByCustomerId(customerId, "2", sevenDaysLater, fifteenDaysLater, thirtyDaysLater, userSecurityLevel);
        vo.setFifteenNoFollowUpAmount(fttCount);
        int tCount = this.customerProfileMapper.selectNotFollowOpptyNumByCustomerId(customerId, "3", sevenDaysLater, fifteenDaysLater, thirtyDaysLater, userSecurityLevel);
        vo.setThirtyNoFollowUpAmount(tCount);
        return ApiResponse.success((Object)vo);
    }

    @Override
    public ApiResponse<ProductAmountVo> getCustomerProductCoverage(CustomerProfileOpptyDto dto) {
        CustomerProfileOpptyDto dtoFinal = this.customerStageIdHandle(dto);
        ProductAmountVo vo = new ProductAmountVo();
        List<CustomerProductCoverageVo> productList = this.customerProfileMapper.selectCustomerProductAmount(dtoFinal);
        double amount = productList.stream().mapToDouble(p -> Double.parseDouble(p.getAmount())).sum();
        vo.setTotalAmount(CommonUtills.transferAmount((Double)amount));
        for (CustomerProductCoverageVo coverageVo : productList) {
            double percentNum = Double.parseDouble(coverageVo.getAmount()) / amount;
            NumberFormat percentFormat = NumberFormat.getPercentInstance();
            percentFormat.setMinimumFractionDigits(0);
            String percent = percentFormat.format(percentNum);
            coverageVo.setAmountProportion(percent);
            coverageVo.setAmount(CommonUtills.transferAmount((String)coverageVo.getAmount()));
        }
        vo.setProductList(productList);
        return ApiResponse.success((Object)vo);
    }

    private CustomerProfileOpptyDto customerStageIdHandle(CustomerProfileOpptyDto dto) {
        if (ToolUtil.isNotEmpty(dto.getStageIds())) {
            ArrayList<String> customerStageIdSplit = new ArrayList<String>();
            for (String stageId : dto.getStageIds()) {
                if (!ToolUtil.isNotEmpty((Object)stageId)) continue;
                customerStageIdSplit.addAll(Arrays.asList(stageId.split(",")));
            }
            dto.setStageIds(customerStageIdSplit);
        }
        return dto;
    }

    @Override
    public ApiResponse<List<ProductTrendVo>> getCustomerProductCoverageTrend(CustomerProfileOpptyDto dto) {
        LocalDate queryDateStart = LocalDate.now().minusYears(4L).with(TemporalAdjusters.firstDayOfYear());
        dto.setQueryDateStart(queryDateStart);
        CustomerProfileOpptyDto dtoFinal = this.customerStageIdHandle(dto);
        List<OpportunityProductVo> productVoList = this.customerProfileMapper.getCustomerProductCoverageTrend(dtoFinal);
        if (CollectionUtil.isEmpty(productVoList)) {
            return ApiResponse.success();
        }
        ArrayList<ProductTrendVo> productTrendVoList = new ArrayList<ProductTrendVo>();
        Map<Long, List<OpportunityProductVo>> map = productVoList.stream().collect(Collectors.groupingBy(OpportunityProductVo::getProductId));
        for (Map.Entry<Long, List<OpportunityProductVo>> entry : map.entrySet()) {
            double[] amounts = new double[5];
            for (OpportunityProductVo vo : entry.getValue()) {
                if (!vo.getCreateTime().isAfter(queryDateStart.plusYears(1L).atStartOfDay())) {
                    amounts[0] = amounts[0] + vo.getSellPrice();
                }
                if (!vo.getCreateTime().isAfter(queryDateStart.plusYears(2L).atStartOfDay())) {
                    amounts[1] = amounts[1] + vo.getSellPrice();
                }
                if (!vo.getCreateTime().isAfter(queryDateStart.plusYears(3L).atStartOfDay())) {
                    amounts[2] = amounts[2] + vo.getSellPrice();
                }
                if (!vo.getCreateTime().isAfter(queryDateStart.plusYears(4L).atStartOfDay())) {
                    amounts[3] = amounts[3] + vo.getSellPrice();
                }
                if (vo.getCreateTime().isAfter(queryDateStart.plusYears(5L).atStartOfDay())) continue;
                amounts[4] = amounts[4] + vo.getSellPrice();
            }
            ProductTrendVo productTrendVo = new ProductTrendVo();
            productTrendVo.setProductId(entry.getKey());
            productTrendVo.setProductName(entry.getValue().get(0).getProductName());
            ArrayList<Map<String, Object>> yearlyAmount = new ArrayList<Map<String, Object>>();
            int year = LocalDate.now().minusYears(4L).getYear();
            for (int i = 0; i < 5; ++i) {
                HashMap<String, Object> mapTemp = new HashMap<String, Object>();
                mapTemp.put("amount", CommonUtills.transferAmount((Double)amounts[i]));
                double amountNew = i == 0 ? amounts[0] : amounts[i] - amounts[i - 1];
                mapTemp.put("amountNew", CommonUtills.transferAmount((Double)amountNew));
                mapTemp.put("statisticalTime", year);
                yearlyAmount.add(mapTemp);
                ++year;
            }
            productTrendVo.setYearlyAmount(yearlyAmount);
            productTrendVoList.add(productTrendVo);
        }
        return ApiResponse.success(productTrendVoList);
    }

    @Override
    public PortalFunnelVo funnelCustomer(SalesStatisticsDto dto) {
        OpportunityDto funnelDto = this.initOppoParam();
        funnelDto.setEndTime(dto.getTimeRange());
        funnelDto.setStartDate(dto.getStartTime());
        funnelDto.setEndDate(dto.getEndTime());
        funnelDto.setSuccessTimeRange(dto.getSuccessTimeRange());
        funnelDto.setSuccessStartDate(dto.getSuccessStartDate());
        funnelDto.setSuccessEndDate(dto.getSuccessEndDate());
        funnelDto.setTimeRange(dto.getTimeRange());
        funnelDto.setCustomerId(dto.getCustomerId().toString());
        List stageIds = new ArrayList();
        stageIds = ToolUtil.isNotEmpty((Object)dto.getStageProcessId()) ? this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).eq(OpportunityStage::getDelFlag, (Object)"0")).in(OpportunityStage::getStageType, Arrays.asList("00", "10", "20"))).eq(OpportunityStage::getStageProcessId, (Object)dto.getStageProcessId()), s -> Long.valueOf(s.toString())) : this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).eq(OpportunityStage::getDelFlag, (Object)"0")).in(OpportunityStage::getStageType, Arrays.asList("00", "10", "20")), s -> Long.valueOf(s.toString()));
        funnelDto.setStageIds(stageIds);
        PortalFunnelVo funnelVo = new PortalFunnelVo();
        if (dto.getCustomerId() == null || CollectionUtil.isEmpty(stageIds)) {
            return funnelVo;
        }
        List<Map<String, Object>> oppoFunnelList = this.opportunityAndAnalysisService.selectCrmOpportunityFunnelCountNoPermission(funnelDto);
        List successRateVoList = this.opportunitySuccessRateAPIService.getSuccessRate(null, stageIds);
        Map<Long, SuccessRateVo> successRateVoMap = successRateVoList.stream().collect(Collectors.toMap(SuccessRateVo::getStageId, successRateVo -> successRateVo, (key1, key2) -> key1));
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        stageTypeDto.setStageAbandonConvert(true);
        stageTypeDto.setStageLose(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List winStageIdList = stageSelectDto.getStageWin();
        List loseStageIds = stageSelectDto.getStageLose();
        loseStageIds.addAll(stageSelectDto.getStageAbandonConvert());
        ArrayList<SalesFunnelVo> funnelList = new ArrayList<SalesFunnelVo>();
        Double forecastAmount = 0.0;
        Map<Object, Object> successRateDicMap = new HashMap();
        String configStr = this.crmBaseConfigBoService.getCrmBaseConfigByKey("success_rate_config").getConfigValue();
        OpportunitySuccessRateConfig rateConfig = (OpportunitySuccessRateConfig)HussarUtils.readJson((String)configStr, OpportunitySuccessRateConfig.class);
        if ("2".equals(dto.getSuccessRateModel())) {
            List successRateDics = rateConfig.getModelTwoConfig().getSuccessRateDic();
            successRateDicMap = successRateDics.stream().collect(Collectors.toMap(SuccessRateDic::getValue, SuccessRateDic::getSuccessRateValue));
        }
        for (Map map : oppoFunnelList) {
            SalesFunnelVo salesFunnelVo = (SalesFunnelVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)map), SalesFunnelVo.class);
            Long stageId = Long.valueOf(salesFunnelVo.getStageId());
            Double rate = 0.0;
            if (winStageIdList.contains(stageId)) {
                if ("1".equals(dto.getSuccessRateModel()) && "1".equals(rateConfig.getModelOneConfig().getIncludeWin()) || "2".equals(dto.getSuccessRateModel()) && "1".equals(rateConfig.getModelTwoConfig().getIncludeWin())) {
                    rate = 1.0;
                }
            } else if (!loseStageIds.contains(stageId)) {
                if ("1".equals(dto.getSuccessRateModel())) {
                    SuccessRateVo successRateVo2 = successRateVoMap.get(stageId);
                    if (successRateVo2 != null && StringUtil.isNotEmpty((Object)successRateVo2.getSuccessRate()) && !"--".equals(successRateVo2.getSuccessRate())) {
                        rate = Double.parseDouble(successRateVo2.getSuccessRate().replace("%", "")) / 100.0;
                    }
                } else if ("2".equals(dto.getSuccessRateModel()) && successRateDicMap.containsKey(salesFunnelVo.getOpportunityWinRate())) {
                    rate = Double.valueOf(((Integer)successRateDicMap.get(salesFunnelVo.getOpportunityWinRate())).intValue()) / 100.0;
                }
            }
            forecastAmount = forecastAmount + rate * Double.parseDouble(salesFunnelVo.getOpportunityAmount());
            salesFunnelVo.setOpportunityAmount(CommonUtills.transferAmount((String)salesFunnelVo.getOpportunityAmount()));
            funnelList.add(salesFunnelVo);
        }
        HashMap<String, SalesFunnelVo> mergedMap = new HashMap<String, SalesFunnelVo>();
        for (SalesFunnelVo vo : funnelList) {
            String stageName = vo.getStageName();
            if (mergedMap.containsKey(stageName)) {
                SalesFunnelVo existingVo = (SalesFunnelVo)mergedMap.get(stageName);
                existingVo.setStageId(existingVo.getStageId() + "," + vo.getStageId());
                existingVo.setOpportunityCount(Integer.valueOf(existingVo.getOpportunityCount() + vo.getOpportunityCount()));
                existingVo.setOpportunityAmount(String.valueOf(Double.parseDouble(existingVo.getOpportunityAmount()) + Double.parseDouble(vo.getOpportunityAmount())));
                continue;
            }
            mergedMap.put(stageName, new SalesFunnelVo(vo.getStageId(), stageName, vo.getOpportunityCount(), vo.getOpportunityAmount()));
        }
        List list = this.sysDicRefService.getDicListByType("salesProcess_StageList");
        funnelList = new ArrayList();
        for (DicVo dicVo : list) {
            if (mergedMap.get(dicVo.getLabel()) == null) continue;
            funnelList.add((SalesFunnelVo)mergedMap.get(dicVo.getLabel()));
        }
        funnelVo.setFunnel(funnelList);
        funnelVo.setForecastAmount(CommonUtills.transferAmount((Double)forecastAmount));
        return funnelVo;
    }

    @Override
    public List<CustomerTrendVo> getCustomerProfileTrends(Long customerId) {
        List trackRecordAPIVoList;
        CustomerTrendVo customerTrendVo;
        ArrayList<CustomerTrendVo> customerTrendVoList = new ArrayList<CustomerTrendVo>();
        CustomerProfileOpptyDto dto = new CustomerProfileOpptyDto();
        dto.setCustomerId(customerId);
        List<OpportunityProductVo> opportunityProductVoList = this.customerProfileMapper.getCustomerAllProduct(dto);
        HashSet<Long> opportunityIdSet = new HashSet<Long>();
        for (OpportunityProductVo opportunityProductVo : opportunityProductVoList) {
            if (opportunityProductVo.getProductId() != null) {
                long createTime;
                long opportunityCreateTime;
                if ("\u5b98\u7f51".equals(opportunityProductVo.getOpportunityName()) && "\u7cfb\u7edf".equals(opportunityProductVo.getOpportunityCreatePersonName()) && (opportunityCreateTime = opportunityProductVo.getOpportunityCreateTime().toEpochSecond(ZoneOffset.of("+8"))) - (createTime = opportunityProductVo.getCreateTime().toEpochSecond(ZoneOffset.of("+8"))) < 60L) {
                    customerTrendVo = new CustomerTrendVo();
                    customerTrendVo.setTrendTime(opportunityProductVo.getOpportunityCreateTime().toLocalDate());
                    customerTrendVo.setTrendContant("\u5b98\u7f51\u7559\u54a8\uff1a" + opportunityProductVo.getProductShortNames());
                    customerTrendVoList.add(customerTrendVo);
                    continue;
                }
                CustomerTrendVo customerTrendVo2 = new CustomerTrendVo();
                customerTrendVo2.setTrendTime(opportunityProductVo.getCreateTime().toLocalDate());
                customerTrendVo2.setTrendContant("\u5bf9\u3010" + opportunityProductVo.getProductShortNames() + "\u3011\u4ea7\u54c1\u611f\u5174\u8da3");
                customerTrendVoList.add(customerTrendVo2);
            }
            if (!StringUtil.isNotEmpty((Object)opportunityProductVo.getSearchTerm()) || !opportunityIdSet.add(opportunityProductVo.getOpportunityId())) continue;
            CustomerTrendVo customerTrendVo3 = new CustomerTrendVo();
            customerTrendVo3.setTrendTime(opportunityProductVo.getOpportunityCreateTime().toLocalDate());
            customerTrendVo3.setTrendContant("\u641c\u7d22\u8bcd\uff1a\u3010" + opportunityProductVo.getSearchTerm() + "\u3011\u6587\u6848");
            customerTrendVoList.add(customerTrendVo3);
        }
        List marketingActivityAPIVoList = this.marketingActivityAPIService.selectAllCampaignByCustomerId(customerId);
        HashSet<Long> campaignIdSet = new HashSet<Long>();
        if (CollectionUtil.isNotEmpty((Collection)marketingActivityAPIVoList)) {
            for (MarketingActivityAPIVo marketingActivityAPIVo : marketingActivityAPIVoList) {
                String startDate;
                if (!campaignIdSet.add(marketingActivityAPIVo.getCampaignId()) || StringUtil.isEmpty((Object)(startDate = marketingActivityAPIVo.getStartDate()))) continue;
                LocalDate trendTime = LocalDate.parse(startDate);
                customerTrendVo = new CustomerTrendVo();
                customerTrendVo.setTrendTime(trendTime);
                customerTrendVo.setTrendContant("\u53c2\u52a0\u4e86\uff1a\u3010" + marketingActivityAPIVo.getCampaignName() + "\u3011\u6d3b\u52a8");
                customerTrendVoList.add(customerTrendVo);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(trackRecordAPIVoList = this.trackRecordAPIService.queryTrackRecordList(customerId)))) {
            for (TrackRecordAPIVo trackRecordAPIVo : trackRecordAPIVoList) {
                if (!RecordProductTypeEnum.PRODUCE_SYSTEM.getId().equals(trackRecordAPIVo.getProduceType()) && StringUtil.isEmpty((Object)trackRecordAPIVo.getRecordType())) continue;
                CustomerTrendVo customerTrendVo4 = new CustomerTrendVo();
                customerTrendVo4.setTrendTime(trackRecordAPIVo.getCreateTime().toLocalDate());
                switch (trackRecordAPIVo.getRecordType()) {
                    case "1": {
                        customerTrendVo4.setTrendContant("\u8fdb\u884c\u4e86\u7535\u8bdd\u4ea4\u6d41");
                        customerTrendVoList.add(customerTrendVo4);
                        break;
                    }
                    case "2": {
                        customerTrendVo4.setTrendContant("\u8fdb\u884c\u4e86\u73b0\u573a\u4ea4\u6d41");
                        customerTrendVoList.add(customerTrendVo4);
                        break;
                    }
                    case "3": {
                        customerTrendVo4.setTrendContant("\u53c2\u52a0\u4e86\u7ebf\u4e0a\u6c9f\u901a\u4f1a");
                        customerTrendVoList.add(customerTrendVo4);
                        break;
                    }
                    case "5": {
                        customerTrendVo4.setTrendContant("\u4e3b\u52a8\u6765\u516c\u53f8\u53c2\u89c2\u4ea4\u6d41");
                        customerTrendVoList.add(customerTrendVo4);
                        break;
                    }
                    case "7": {
                        customerTrendVo4.setTrendContant("\u9080\u8bf7\u6765\u516c\u53f8\u53c2\u89c2\u4ea4\u6d41");
                        customerTrendVoList.add(customerTrendVo4);
                    }
                }
            }
        }
        customerTrendVoList.sort(Comparator.comparing(CustomerTrendVo::getTrendTime).reversed());
        return customerTrendVoList;
    }

    @Override
    public List<LabelVo> getCustomerLabel(Long customerId) {
        List commonLabelList;
        String aiTags;
        ArrayList<String> labelIdStrList;
        List labelIdList;
        List aiLabelList;
        ArrayList<LabelVo> labelVoList = new ArrayList<LabelVo>();
        CustomerAPIVo customerAPIVo = this.customerAPIService.selectById(customerId);
        if (customerAPIVo != null && StringUtil.isNotEmpty((Object)customerAPIVo.getAiTags()) && CollectionUtil.isNotEmpty((Collection)(aiLabelList = this.labelService.listByIds(labelIdList = (labelIdStrList = new ArrayList<String>(Arrays.asList((aiTags = customerAPIVo.getAiTags()).split(",")))).stream().map(Long::parseLong).collect(Collectors.toList()))))) {
            labelVoList.addAll(aiLabelList);
        }
        if (CollectionUtil.isNotEmpty((Collection)(commonLabelList = this.labelService.listByBusinessId(LabelModuleEnum.CUSTOMER.getModuleId(), customerId)))) {
            labelVoList.addAll(commonLabelList);
        }
        return labelVoList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CustomerInteractiveVo getCustomerInteractive(Long customerId) {
        List trackRecordAPIVoList;
        List dictSingleList;
        CustomerInteractiveVo customerInteractiveVo = new CustomerInteractiveVo();
        ContactAPIDto contactAPIDto = new ContactAPIDto();
        contactAPIDto.setCustomerId(customerId);
        List contactAPIVoList = this.contactAPIService.selectCrmContactCustomer(contactAPIDto);
        if (CollectionUtil.isNotEmpty((Collection)contactAPIVoList)) {
            customerInteractiveVo.setContactCount(contactAPIVoList.size());
            if (CollectionUtil.isNotEmpty((Collection)contactAPIVoList)) {
                Object[] topPositionRules;
                CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("top_position_rule");
                ArrayList topPositionContact = new ArrayList();
                if (crmBaseConfigVo != null && StringUtil.isNotEmpty((Object)crmBaseConfigVo.getConfigValue()) && CollectionUtil.isNotEmpty((Object[])(topPositionRules = crmBaseConfigVo.getConfigValue().split(",")))) {
                    for (Object rule : topPositionRules) {
                        List<Object> levelList = new ArrayList();
                        if (!StringUtil.isNotEmpty((Object)rule)) continue;
                        levelList = Arrays.asList(((String)rule).split("/"));
                        for (String string : levelList) {
                            List positionContactList = contactAPIVoList.stream().filter(contactAPIVo -> StringUtil.isNotEmpty((Object)contactAPIVo.getPosition()) && contactAPIVo.getPosition().contains(levelStr)).collect(Collectors.toList());
                            topPositionContact.addAll(positionContactList);
                        }
                        if (CollectionUtil.isNotEmpty(topPositionContact)) break;
                    }
                }
                String topPostContactName = "";
                String topPostContactId = "";
                if (CollectionUtil.isNotEmpty(topPositionContact)) {
                    topPostContactName = topPositionContact.stream().map(contactAPIVo -> contactAPIVo.getContactName() + "(" + contactAPIVo.getPosition() + ")").collect(Collectors.joining(","));
                    topPostContactId = topPositionContact.stream().map(ContactAPIVo::getContactId).map(String::valueOf).collect(Collectors.joining(","));
                }
                customerInteractiveVo.setTopPostContactId(topPostContactId);
                customerInteractiveVo.setTopPostContactName(topPostContactName);
            }
        }
        ArrayList<String> typeNameList = new ArrayList<String>();
        typeNameList.add("common_follow");
        List dictVoList = this.dicSingleMapper.getDictVosByTypeNames(typeNameList);
        Map<Object, Object> dictMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)dictVoList) && CollectionUtil.isNotEmpty((Collection)(dictSingleList = ((DictVo)dictVoList.get(0)).getSingleList()))) {
            dictMap = dictSingleList.stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
        }
        if (CollectionUtil.isNotEmpty((Collection)(trackRecordAPIVoList = this.trackRecordAPIService.queryTrackRecordList(customerId)))) {
            Map<String, Long> groups;
            trackRecordAPIVoList = trackRecordAPIVoList.stream().filter(trackRecordAPIVo -> RecordProductTypeEnum.PRODUCE_SYSTEM.getId().equals(trackRecordAPIVo.getProduceType())).collect(Collectors.toList());
            customerInteractiveVo.setFollowupCount(trackRecordAPIVoList.size());
            trackRecordAPIVoList = trackRecordAPIVoList.stream().filter(trackRecordAPIVo -> StringUtil.isNotEmpty((Object)trackRecordAPIVo.getRecordType())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(trackRecordAPIVoList) && CollectionUtil.isNotEmpty(groups = trackRecordAPIVoList.stream().filter(trackRecordAPIVo -> StringUtil.isNotEmpty((Object)trackRecordAPIVo.getContactId())).collect(Collectors.groupingBy(TrackRecordAPIVo::getContactId, Collectors.counting())))) {
                long maxCount = groups.values().stream().max(Long::compare).get();
                List contactIdList = groups.entrySet().stream().filter(entry -> (Long)entry.getValue() == maxCount).map(Map.Entry::getKey).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(contactIdList)) {
                    void var14_21;
                    String contactIds = "";
                    String string = "";
                    for (String contactId : contactIdList) {
                        if (StringUtil.isEmpty((Object)contactId)) continue;
                        contactIds = contactIds + "," + contactId;
                        String string2 = (String)var14_21 + "," + (String)trackRecordAPIVoList.stream().filter(trackRecordAPIVo -> StringUtil.isNotEmpty((Object)trackRecordAPIVo.getContactId())).filter(trackRecordAPIVo -> contactId.equals(trackRecordAPIVo.getContactId())).map(TrackRecordAPIVo::getContactName).distinct().collect(Collectors.toList()).get(0);
                    }
                    customerInteractiveVo.setCommandContactId(contactIds.replaceFirst(",", ""));
                    customerInteractiveVo.setCommandContactName(var14_21.replaceFirst(",", ""));
                }
            }
            trackRecordAPIVoList = trackRecordAPIVoList.stream().sorted(Comparator.comparing(TrackRecordAPIVo::getCreateTime).reversed()).collect(Collectors.toList());
            long nowSecond = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
            Long second = nowSecond - ((TrackRecordAPIVo)trackRecordAPIVoList.get(0)).getCreateTime().toEpochSecond(ZoneOffset.of("+8"));
            customerInteractiveVo.setLatestFollowup(CrmDateUtils.secondToDay((Long)second, (String)"day").replace(CrmDateUtils.TIME_DAY_SHOW, ""));
            Map<String, List<TrackRecordAPIVo>> trackRecordListMap = trackRecordAPIVoList.stream().collect(Collectors.groupingBy(TrackRecordAPIVo::getRecordType));
            ArrayList<FollowupDistributionVo> followupDistributionVoList = new ArrayList<FollowupDistributionVo>();
            for (String trackType : trackRecordListMap.keySet()) {
                FollowupDistributionVo followupDistributionVo = new FollowupDistributionVo();
                followupDistributionVo.setRecordType(trackType);
                List<TrackRecordAPIVo> trackRecordList = trackRecordListMap.get(trackType);
                followupDistributionVo.setRecordType(trackType);
                if (CollectionUtil.isNotEmpty(trackRecordList)) {
                    followupDistributionVo.setRecordCount(trackRecordList.size());
                } else {
                    followupDistributionVo.setRecordCount(0);
                }
                followupDistributionVo.setRecordName((String)dictMap.get(trackType));
                followupDistributionVoList.add(followupDistributionVo);
            }
            customerInteractiveVo.setFollowupDistributionList(followupDistributionVoList);
        }
        List metricsEntityList = this.singleCustomerMetricsService.list((Wrapper)new LambdaQueryWrapper().eq(SingleCustomerMetricsEntity::getCustomerId, (Object)customerId));
        String temp = "\u8f83\u4f4e";
        if (CollectionUtil.isNotEmpty((Collection)metricsEntityList) && ((SingleCustomerMetricsEntity)metricsEntityList.get(0)).getMonthlyTrack() != null) {
            SingleCustomerMetricsEntity metricsEntity = (SingleCustomerMetricsEntity)metricsEntityList.get(0);
            Double commonTrack = Double.parseDouble(this.crmBaseConfigBoService.getCrmBaseConfigByKey("common_customer_monthly_track").getConfigValue());
            if (metricsEntity.getMonthlyTrack() >= commonTrack) {
                temp = "\u6b63\u5e38";
            }
        }
        customerInteractiveVo.setContactFrequency(temp);
        return customerInteractiveVo;
    }

    @Override
    public ApiResponse<SingleCustomerMetricsEntity> getCustomerAiAnalysis(Long customerId) {
        SingleCustomerMetricsEntity entity = (SingleCustomerMetricsEntity)this.singleCustomerMetricsService.getOne((Wrapper)new LambdaQueryWrapper().eq(SingleCustomerMetricsEntity::getCustomerId, (Object)customerId));
        return ApiResponse.success((Object)entity);
    }

    @Override
    public Page<OpportunityEntity> funnelOpportunityList(SalesStatisticsDto dto) {
        List opportunityStageList;
        DateConvertVo dateConvertVo;
        Page page = new Page();
        page.setCurrent((long)dto.getCurrent().intValue());
        page.setSize((long)dto.getSize().intValue());
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime())) {
            dto.setTimeRange(dto.getEndTime());
            dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getTimeRange());
            if (dateConvertVo != null) {
                dto.setStartTime(dateConvertVo.getStartDate());
                dto.setEndTime(dateConvertVo.getEndDate());
            }
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getSuccessTimeRange())) {
            dto.setSuccessTimeRange(dto.getSuccessTimeRange());
            dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getSuccessTimeRange());
            if (dateConvertVo != null) {
                dto.setSuccessStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
                dto.setSuccessEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
            }
        }
        List stageIds = Arrays.stream(dto.getCustomerStageId().split(",")).map(Long::parseLong).collect(Collectors.toList());
        dto.setStageIds(stageIds);
        if (ToolUtil.isNotEmpty((Object)dto.getCustomerStageId())) {
            OpportunityStage opportunityStage = (OpportunityStage)this.opportunityStageService.getById((Serializable)((Object)dto.getCustomerStageId()));
            dto.setStageType(opportunityStage.getStageType());
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getStageIds()) && CollectionUtil.isNotEmpty((Collection)(opportunityStageList = this.opportunityStageService.listByIds(stageIds)))) {
            List ongoingStageIds = opportunityStageList.stream().filter(stage -> !"20".equals(stage.getStageType())).map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
            List successStageIds = opportunityStageList.stream().filter(stage -> "20".equals(stage.getStageType())).map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
            dto.setOngoingStageIds(ongoingStageIds);
            dto.setSuccessStageIds(successStageIds);
            dto.setStageIds(stageIds);
        }
        char winStageFlag = '0';
        if (CollectionUtil.isNotEmpty((Collection)dto.getSuccessStageIds())) {
            winStageFlag = '1';
        }
        dto.setCustomerStageId(null);
        dto.setDelFlag("0");
        dto.setSearchKey(CommonUtills.escapeLike((String)dto.getSearchKey()));
        List list = this.unifyPortalMapper.saleOpportunityList(dto, page, winStageFlag, dto.getSuccessStageIds(), new PermissionDto(), new PermissionDto());
        page.setRecords(list);
        return page;
    }

    private OpportunityDto initOppoParam() {
        OpportunityDto oppDto = new OpportunityDto();
        oppDto.setOpportunityView("1");
        oppDto.setWinMoney(0.0);
        oppDto.setTimeOrder("6");
        oppDto.setIsMobile("1");
        oppDto.setSelectType("2");
        oppDto.setAbandonOpportunity("1");
        return oppDto;
    }
}

