/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.customerprofile.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.analysis.customerprofile.dao.CustomerProfileMapper;
import com.jxdinfo.crm.analysis.customerprofile.dao.SingleCustomerMetricsMapper;
import com.jxdinfo.crm.analysis.customerprofile.dto.CustomerProfileOpptyDto;
import com.jxdinfo.crm.analysis.customerprofile.model.SingleCustomerMetricsEntity;
import com.jxdinfo.crm.analysis.customerprofile.service.ICustomerProfileService;
import com.jxdinfo.crm.analysis.customerprofile.service.ISingleCustomerMetricsService;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerActivityLevelVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerFollowUpMonthsVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerOpptyStatsVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerPredictedAmountVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.ProductRecommendScoreVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.ProductRelationVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.ProductWeightVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.ProductWinCustomerProfileVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.ProductWinFeatureVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.TransactionCasesVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.OpportunityProductVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunitySuccessRateAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityStageSuccessRate;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunitySuccessRateVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageSelectDto;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SingleCustomerMetricsServiceImpl
extends ServiceImpl<SingleCustomerMetricsMapper, SingleCustomerMetricsEntity>
implements ISingleCustomerMetricsService {
    @Resource
    private ICustomerProfileService customerProfileService;
    @Resource
    private CustomerProfileMapper customerProfileMapper;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private SingleCustomerMetricsMapper singleCustomerMetricsMapper;
    @Resource
    private IOpportunitySuccessRateAPIService opportunitySuccessRateAPIService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    /*
     * Could not resolve type clashes
     */
    @Override
    @Transactional
    public ProcessResult updateCustomerProfileMetrics() {
        this.singleCustomerMetricsMapper.delete(null);
        ArrayList<Object> list = new ArrayList<Object>();
        List allCustomerIdList = this.customerAPIService.getAllCustomerList();
        for (Long customerId : allCustomerIdList) {
            SingleCustomerMetricsEntity entity = new SingleCustomerMetricsEntity();
            entity.setCustomerId(customerId);
            list.add(entity);
        }
        ICrmBaseConfigBoService crmBaseConfigBoService = (ICrmBaseConfigBoService)SpringUtils.getBean(ICrmBaseConfigBoService.class);
        CrmBaseConfigVo configVo = crmBaseConfigBoService.getCrmBaseConfigByKey("amount_display");
        String amountDisplay = configVo.getConfigValue();
        JSONObject amountDisplayJsonObject = JSONObject.parseObject((String)amountDisplay);
        CustomerProfileOpptyDto dto = new CustomerProfileOpptyDto();
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        dto.setStageIds(stageWin.stream().map(String::valueOf).collect(Collectors.toList()));
        List<Map<String, Object>> customerList = this.customerProfileMapper.selectCustomerWinningOrderCycle(dto);
        HashMap cycleMap = new HashMap();
        for (Map<String, Object> map : customerList) {
            Long customerId = (Long)map.get("CUSTOMER_ID");
            if (ToolUtil.isEmpty((Object)map.get("CREATE_TIME")) || ToolUtil.isEmpty((Object)map.get("SUCCESS_DATE"))) continue;
            LocalDate createDate = ((LocalDateTime)map.get("CREATE_TIME")).toLocalDate();
            LocalDate successDate = ((LocalDateTime)map.get("SUCCESS_DATE")).toLocalDate();
            long daysBetween = ChronoUnit.DAYS.between(createDate, successDate);
            if (cycleMap.containsKey(customerId)) {
                ((Map)cycleMap.get(customerId)).put("winningOpptyCount", (Integer)((Map)cycleMap.get(customerId)).get("winningOpptyCount") + 1);
                ((Map)cycleMap.get(customerId)).put("winningOpptyCycle", (Long)((Map)cycleMap.get(customerId)).get("winningOpptyCycle") + daysBetween);
                continue;
            }
            HashMap<String, Number> tempMap = new HashMap<String, Number>();
            tempMap.put("winningOpptyCount", 1);
            tempMap.put("winningOpptyCycle", daysBetween);
            cycleMap.put(customerId, tempMap);
        }
        long cycleTotal = 0L;
        int opptyTotal = 0;
        for (Map.Entry entry : cycleMap.entrySet()) {
            Map map = (Map)entry.getValue();
            Long customerId = (Long)entry.getKey();
            Object singleMetrics = null;
            List tempList = list.stream().filter(customer -> customer.getCustomerId().equals(customerId)).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(tempList)) {
                singleMetrics = (SingleCustomerMetricsEntity)tempList.get(0);
            } else {
                singleMetrics = new SingleCustomerMetricsEntity();
                ((SingleCustomerMetricsEntity)singleMetrics).setCustomerId(customerId);
            }
            long cycle = (Long)map.get("winningOpptyCycle");
            int opptyCount = (Integer)map.get("winningOpptyCount");
            cycleTotal += cycle;
            opptyTotal += opptyCount;
            ((SingleCustomerMetricsEntity)singleMetrics).setAverageWinningCycle((double)cycle / (double)opptyCount);
            if (!ToolUtil.isEmpty(tempList)) continue;
            list.add(singleMetrics);
        }
        crmBaseConfigBoService.updateConfigValue(String.format("%.2f", (double)cycleTotal / (double)opptyTotal), "common_average_winning_cycle");
        Map<Long, CustomerActivityLevelVo> activityLevelVos = this.customerProfileService.getCustomerActivityLevel();
        List<CustomerFollowUpMonthsVo> customerFollowUpMonths = this.customerProfileMapper.selectCustomerFollowUpMonths();
        Map<Long, List> cusMonthMap = customerFollowUpMonths.stream().collect(Collectors.groupingBy(CustomerFollowUpMonthsVo::getCustomerId, Collectors.collectingAndThen(Collectors.toList(), voList -> voList.stream().sorted(Comparator.comparing(CustomerFollowUpMonthsVo::getRecordCreateMonth)).collect(Collectors.toList()))));
        HashMap<Long, Integer> cusMonthCountMap = new HashMap<Long, Integer>();
        for (Iterator entry : cusMonthMap.entrySet()) {
            Long customerId = (Long)entry.getKey();
            LocalDateTime successTime = activityLevelVos.get(customerId).getLastSuccessDate();
            int countMonth = 1;
            YearMonth dateTemp = YearMonth.from(((CustomerFollowUpMonthsVo)((List)entry.getValue()).get(0)).getRecordCreateMonth());
            for (CustomerFollowUpMonthsVo monthsVo : (List)entry.getValue()) {
                if (successTime != null && !successTime.isAfter(monthsVo.getRecordCreateMonth()) || !dateTemp.isBefore(YearMonth.from(monthsVo.getRecordCreateMonth()))) continue;
                ++countMonth;
                dateTemp = YearMonth.from(monthsVo.getRecordCreateMonth());
            }
            cusMonthCountMap.put(customerId, countMonth);
        }
        HashMap<Long, Double> updateCustomerAvgRecordMap = new HashMap<Long, Double>();
        for (Map.Entry entry : activityLevelVos.entrySet()) {
            double avgRecord;
            Long customerId = (Long)entry.getKey();
            CustomerActivityLevelVo vo = (CustomerActivityLevelVo)entry.getValue();
            if (cusMonthCountMap.get(entry.getKey()) == null || vo.getCountRecord() == null) {
                avgRecord = 0.0;
            } else {
                double monthBetween = ((Integer)cusMonthCountMap.get(entry.getKey())).intValue();
                avgRecord = Double.valueOf(vo.getCountRecord().intValue()) / monthBetween;
            }
            updateCustomerAvgRecordMap.put(customerId, avgRecord);
        }
        for (SingleCustomerMetricsEntity entity : list) {
            if (updateCustomerAvgRecordMap.get(entity.getCustomerId()) != null) {
                entity.setMonthlyTrack((Double)updateCustomerAvgRecordMap.get(entity.getCustomerId()));
                continue;
            }
            entity.setMonthlyTrack(0.0);
        }
        List<CustomerPredictedAmountVo> predictedAmountList = this.singleCustomerMetricsMapper.selectPredictedAmountList();
        List successRateVoList = ((OpportunitySuccessRateVo)this.opportunitySuccessRateAPIService.getOpportunitySuccess(null).get(0)).getStageSuccessRate();
        Map<Long, String> successRateMap = successRateVoList.stream().collect(Collectors.toMap(OpportunityStageSuccessRate::getStageId, OpportunityStageSuccessRate::getSuccessRate));
        Map<Long, List<CustomerPredictedAmountVo>> amountMap = predictedAmountList.stream().collect(Collectors.groupingBy(CustomerPredictedAmountVo::getCustomerId));
        StageTypeDto stageTypeDto2 = new StageTypeDto();
        stageTypeDto.setStageStart(true);
        stageTypeDto.setStageOnGoing(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto2);
        ArrayList stageIds = new ArrayList();
        stageIds.addAll(stageSelectDto.getStageOnGoing());
        stageIds.addAll(stageSelectDto.getStageStart());
        for (SingleCustomerMetricsEntity entity : list) {
            Long customerId = entity.getCustomerId();
            if (CollectionUtils.isEmpty((Collection)amountMap.get(customerId))) {
                entity.setPredictedAmount(0.0);
                continue;
            }
            double sumAmount = 0.0;
            for (CustomerPredictedAmountVo vo : amountMap.get(customerId)) {
                if (stageIds.contains(vo.getOpportunityStage())) {
                    sumAmount += vo.getSumAmount() * Double.parseDouble(successRateMap.get(vo.getOpportunityStage()).replace("%", "")) * 0.01;
                    continue;
                }
                if (stageWin.contains(vo.getOpportunityStage())) {
                    sumAmount += vo.getSumAmount().doubleValue();
                    continue;
                }
                sumAmount += 0.0;
            }
            entity.setPredictedAmount(sumAmount);
        }
        List customerTradeList = this.customerAPIService.selectCustomerTradeList();
        Map<Long, String> customerIdTradeMap = customerTradeList.stream().collect(Collectors.toMap(CustomerAPIVo::getCustomerId, CustomerAPIVo::getTrade));
        Map<Long, String> productRecommendationMap = this.calculateProductRecommendations();
        List<CustomerOpptyStatsVo> winCustomerOpptyStatsVos = this.singleCustomerMetricsMapper.selectCustomerOppty(null, stageWin);
        Map<Long, List<CustomerOpptyStatsVo>> winListMap = winCustomerOpptyStatsVos.stream().collect(Collectors.groupingBy(CustomerOpptyStatsVo::getCustomerId));
        List<CustomerOpptyStatsVo> inFollowingCustomerOpptyStatsVos = this.singleCustomerMetricsMapper.selectCustomerOppty("2", null);
        Map<Long, List<CustomerOpptyStatsVo>> inFollowingMap = inFollowingCustomerOpptyStatsVos.stream().collect(Collectors.groupingBy(CustomerOpptyStatsVo::getCustomerId));
        CrmBaseConfigVo baseConfigVo = crmBaseConfigBoService.getCrmBaseConfigByKey("common_customer_monthly_track");
        Double companyAvgRecord = Double.valueOf(baseConfigVo.getConfigValue());
        String content1_1 = crmBaseConfigBoService.getCrmBaseConfigByKey("content1_1").getConfigValue();
        String content1_2 = crmBaseConfigBoService.getCrmBaseConfigByKey("content1_2").getConfigValue();
        String content1_3 = crmBaseConfigBoService.getCrmBaseConfigByKey("content1_3").getConfigValue();
        String content1_4 = crmBaseConfigBoService.getCrmBaseConfigByKey("content1_4").getConfigValue();
        String content2_1 = crmBaseConfigBoService.getCrmBaseConfigByKey("content2_1").getConfigValue();
        String content3_1 = crmBaseConfigBoService.getCrmBaseConfigByKey("content3_1").getConfigValue();
        for (SingleCustomerMetricsEntity customer2 : list) {
            Long customerId = customer2.getCustomerId();
            String content1 = "";
            String content2 = "";
            Object content3 = "";
            if (HussarUtils.isEmpty((Object)activityLevelVos.get(customerId).getLastSuccessDate()) || winListMap.get(customerId) == null) {
                if (HussarUtils.isNotEmpty(inFollowingMap.get(customerId)) && HussarUtils.isNotEmpty((Object)inFollowingMap.get(customerId).get(0).getOpptyCount()) && inFollowingMap.get(customerId).get(0).getOpptyCount() > 0) {
                    Double avgRecord;
                    content1 = content1_3;
                    String inFollowingAmount = CommonUtills.transferAmount((String)inFollowingMap.get(customerId).get(0).getOpptyAmount(), (String)amountDisplay);
                    String predictedTotalAmount = CommonUtills.transferAmount((Double)customer2.getPredictedAmount(), (String)amountDisplay);
                    if ("2".equals(amountDisplayJsonObject.get((Object)"unit"))) {
                        inFollowingAmount = inFollowingAmount + "\u4e07";
                        predictedTotalAmount = predictedTotalAmount + "\u4e07";
                    }
                    String monthlyTrackTime = (avgRecord = (Double)updateCustomerAvgRecordMap.get(customerId)) != null ? String.valueOf((long)Math.ceil(avgRecord)) : "0";
                    String belowOrAbove = (double)Long.parseLong(monthlyTrackTime) >= companyAvgRecord ? "\u9ad8\u4e8e" : "\u4f4e\u4e8e";
                    content1 = content1.replace("${inFollowingNum}", String.valueOf(inFollowingMap.get(customerId).get(0).getOpptyCount())).replace("${inFollowingAmount}", inFollowingAmount).replace("${predictedTotalAmount}", predictedTotalAmount).replace("${monthlyTrackTime}", monthlyTrackTime).replace("${belowOrAbove}", belowOrAbove);
                    TransactionCasesVo transactionCases = this.selectTransactionCases(customerId, customerIdTradeMap.get(customerId));
                    if (transactionCases != null) {
                        content3 = content3_1;
                        content3 = ((String)content3).replace("${chargePersonName}", transactionCases.getChargePersonName()).replace("${recentOpptyName}", "#{recentOpptyName}").replace("${successOpptyName}", "#{successOpptyName}");
                        customer2.setRecentOpptyName(transactionCases.getCustomerOpptyName());
                        customer2.setSuccessOpptyName(transactionCases.getOpportunityName());
                        customer2.setRecentOpptyId(transactionCases.getCustomerOpptyId());
                        customer2.setSuccessOpptyId(transactionCases.getOpportunityId());
                    }
                } else {
                    content1 = content1_4;
                    String historicalTrackTime = "0";
                    if (activityLevelVos.get(customerId) != null) {
                        historicalTrackTime = String.valueOf(activityLevelVos.get(customerId).getCountRecord());
                    }
                    content1 = content1.replace("${historicalTrackTime}", historicalTrackTime);
                }
            } else {
                if (HussarUtils.isNotEmpty(inFollowingMap.get(customerId))) {
                    Object avgRecord;
                    content1 = content1_1;
                    String predictedTotalAmount = CommonUtills.transferAmount((Double)customer2.getPredictedAmount(), (String)amountDisplay);
                    String successAmount = CommonUtills.transferAmount((String)winListMap.get(customerId).get(0).getOpptyAmount(), (String)amountDisplay);
                    String inFollowingAmount = CommonUtills.transferAmount((String)inFollowingMap.get(customerId).get(0).getOpptyAmount(), (String)amountDisplay);
                    if ("2".equals(amountDisplayJsonObject.get((Object)"unit"))) {
                        successAmount = successAmount + "\u4e07";
                        inFollowingAmount = inFollowingAmount + "\u4e07";
                        predictedTotalAmount = predictedTotalAmount + "\u4e07";
                    }
                    String monthlyTrackTime = (avgRecord = (Double)updateCustomerAvgRecordMap.get(customerId)) != null ? String.valueOf((long)Math.ceil((Double)avgRecord)) : "0";
                    String belowOrAbove = (double)Long.parseLong(monthlyTrackTime) >= companyAvgRecord ? "\u9ad8\u4e8e" : "\u4f4e\u4e8e";
                    content1 = content1.replace("${successNum}", String.valueOf(winListMap.get(customerId).get(0).getOpptyCount())).replace("${inFollowingNum}", String.valueOf(inFollowingMap.get(customerId).get(0).getOpptyCount())).replace("${predictedTotalAmount}", predictedTotalAmount).replace("${successAmount}", successAmount).replace("${inFollowingAmount}", inFollowingAmount).replace("${monthlyTrackTime}", monthlyTrackTime).replace("${belowOrAbove}", belowOrAbove);
                    TransactionCasesVo transactionCases = this.selectTransactionCases(customerId, customerIdTradeMap.get(customerId));
                    if (transactionCases != null) {
                        content3 = content3_1;
                        content3 = ((String)content3).replace("${chargePersonName}", transactionCases.getChargePersonName()).replace("${recentOpptyName}", "#{recentOpptyName}").replace("${successOpptyName}", "#{successOpptyName}");
                        customer2.setRecentOpptyName(transactionCases.getCustomerOpptyName());
                        customer2.setSuccessOpptyName(transactionCases.getOpportunityName());
                        customer2.setRecentOpptyId(transactionCases.getCustomerOpptyId());
                        customer2.setSuccessOpptyId(transactionCases.getOpportunityId());
                    }
                } else {
                    content1 = content1_2;
                    String successAmount = CommonUtills.transferAmount((String)winListMap.get(customerId).get(0).getOpptyAmount(), (String)amountDisplay);
                    if ("2".equals(amountDisplayJsonObject.get((Object)"unit"))) {
                        successAmount = successAmount + "\u4e07";
                    }
                    Object historicalTrackTime = "0";
                    if (activityLevelVos.get(customerId) != null) {
                        historicalTrackTime = String.valueOf(activityLevelVos.get(customerId).getCountRecord());
                    }
                    content1 = content1.replace("${successNum}", String.valueOf(winListMap.get(customerId).get(0).getOpptyCount())).replace("${successAmount}", successAmount).replace("${historicalTrackTime}", (CharSequence)historicalTrackTime);
                }
                if (HussarUtils.isNotEmpty((Object)productRecommendationMap.get(customerId))) {
                    content2 = content2_1;
                    content2 = content2.replace("${productName}", productRecommendationMap.get(customerId));
                }
            }
            customer2.setAiContent1(content1);
            customer2.setAiContent2(content2);
            customer2.setAiContent3((String)content3);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("customerStageIds", stageWin);
        List opportunityAPIVoList = (List)this.opportunityAPIService.selectCrmOpportunityListNoPermission(map, null);
        LocalDateTime nowDate = LocalDateTime.now();
        int year = nowDate.getYear();
        HashMap rankList = new HashMap();
        for (SingleCustomerMetricsEntity entity : list) {
            rankList.put(entity.getCustomerId(), new ArrayList());
        }
        List customerAPIVoList = this.customerAPIService.getCustomerListByIds(allCustomerIdList);
        int earliestCreateTime = LocalDateTime.now().getYear();
        for (CustomerAPIVo customerAPIVo : customerAPIVoList) {
            int yearInt;
            if (!ToolUtil.isNotEmpty((Object)customerAPIVo.getCreateTime()) || (yearInt = customerAPIVo.getCreateTime().getYear()) >= earliestCreateTime) continue;
            earliestCreateTime = yearInt;
        }
        for (int i = earliestCreateTime; i <= year; ++i) {
            int yearNum = i;
            List currentOpptyList = opportunityAPIVoList.stream().filter(oppty -> {
                String successDate = oppty.getSuccessDate();
                if (ToolUtil.isNotEmpty((Object)successDate)) {
                    return Integer.parseInt(successDate.substring(0, 4)) == yearNum && ToolUtil.isNotEmpty((Object)oppty.getCustomerId());
                }
                return false;
            }).collect(Collectors.toList());
            HashMap<Long, Double> winAmountMap = new HashMap<Long, Double>();
            for (OpportunityAPIVo opportunityAPIVo : currentOpptyList) {
                Double amount = 0.0;
                if (ToolUtil.isNotEmpty((Object)opportunityAPIVo.getCustomerId())) {
                    amount = ToolUtil.isNotEmpty(winAmountMap.get(opportunityAPIVo.getCustomerId())) ? Double.valueOf((Double)winAmountMap.get(opportunityAPIVo.getCustomerId()) + (ToolUtil.isNotEmpty((Object)opportunityAPIVo.getOpportunityAmount()) ? Double.parseDouble(opportunityAPIVo.getOpportunityAmount()) : 0.0)) : Double.valueOf(ToolUtil.isNotEmpty((Object)opportunityAPIVo.getOpportunityAmount()) ? Double.parseDouble(opportunityAPIVo.getOpportunityAmount()) : 0.0);
                }
                if (amount.equals(0.0)) continue;
                winAmountMap.put(opportunityAPIVo.getCustomerId(), amount);
            }
            ArrayList sortedList = new ArrayList(winAmountMap.entrySet());
            sortedList.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
            LinkedHashMap rankedMap = new LinkedHashMap();
            int rank = 1;
            int blankCount = 0;
            for (Map.Entry entry : sortedList) {
                rankedMap.put(entry.getKey(), rank);
                if (sortedList.indexOf(entry) < sortedList.size() - 1 && Objects.equals(entry.getValue(), ((Map.Entry)sortedList.get(sortedList.indexOf(entry) + 1)).getValue())) {
                    ++blankCount;
                    continue;
                }
                for (int j = 0; j < blankCount + 1; ++j) {
                    ++rank;
                }
                blankCount = 0;
            }
            for (SingleCustomerMetricsEntity entity : list) {
                if (!rankedMap.containsKey(entity.getCustomerId())) {
                    ((List)rankList.get(entity.getCustomerId())).add(rankedMap.size() + 1);
                    continue;
                }
                ((List)rankList.get(entity.getCustomerId())).add(rankedMap.get(entity.getCustomerId()));
            }
        }
        HashMap<Long, Double> winAmountMap = new HashMap<Long, Double>();
        for (OpportunityAPIVo opportunityAPIVo : opportunityAPIVoList) {
            Double amount = 0.0;
            if (ToolUtil.isNotEmpty((Object)opportunityAPIVo.getCustomerId())) {
                amount = ToolUtil.isNotEmpty(winAmountMap.get(opportunityAPIVo.getCustomerId())) ? Double.valueOf((Double)winAmountMap.get(opportunityAPIVo.getCustomerId()) + (ToolUtil.isNotEmpty((Object)opportunityAPIVo.getOpportunityAmount()) ? Double.parseDouble(opportunityAPIVo.getOpportunityAmount()) : 0.0)) : Double.valueOf(ToolUtil.isNotEmpty((Object)opportunityAPIVo.getOpportunityAmount()) ? Double.parseDouble(opportunityAPIVo.getOpportunityAmount()) : 0.0);
            }
            if (amount.equals(0.0)) continue;
            winAmountMap.put(opportunityAPIVo.getCustomerId(), amount);
        }
        ArrayList sortedList = new ArrayList(winAmountMap.entrySet());
        sortedList.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        LinkedHashMap rankedMap = new LinkedHashMap();
        int rank = 1;
        int blankCount = 0;
        for (Map.Entry entry : sortedList) {
            rankedMap.put(entry.getKey(), rank);
            if (sortedList.indexOf(entry) < sortedList.size() - 1 && Objects.equals(entry.getValue(), ((Map.Entry)sortedList.get(sortedList.indexOf(entry) + 1)).getValue())) {
                ++blankCount;
                continue;
            }
            for (int j = 0; j < blankCount + 1; ++j) {
                ++rank;
            }
            blankCount = 0;
        }
        for (SingleCustomerMetricsEntity entity : list) {
            if (!rankedMap.containsKey(entity.getCustomerId())) {
                ((List)rankList.get(entity.getCustomerId())).add(rankedMap.size() + 1);
                continue;
            }
            ((List)rankList.get(entity.getCustomerId())).add(rankedMap.get(entity.getCustomerId()));
        }
        for (SingleCustomerMetricsEntity entity : list) {
            if (!ToolUtil.isNotEmpty(rankList.get(entity.getCustomerId()))) continue;
            entity.setWinningAmountRank(((List)rankList.get(entity.getCustomerId())).stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        this.saveOrUpdateBatch(list);
        return new ProcessResult(true);
    }

    private Map<Long, String> calculateProductRecommendations() {
        List<ProductRelationVo> limsProductList = this.singleCustomerMetricsMapper.selectLimsProductRelation();
        List limsIdList = limsProductList.stream().map(ProductRelationVo::getProductId).collect(Collectors.toList());
        String limsName = limsProductList.get(0).getName();
        List<ProductWinFeatureVo> allWinProductList = this.singleCustomerMetricsMapper.getAllWinProductList();
        Map<Long, List<ProductWinFeatureVo>> productMap = allWinProductList.stream().collect(Collectors.groupingBy(ProductWinFeatureVo::getProductId));
        HashMap<Long, ProductWinCustomerProfileVo> productWinCustomerProfileMap = new HashMap<Long, ProductWinCustomerProfileVo>();
        for (Map.Entry<Long, List<ProductWinFeatureVo>> entry : productMap.entrySet()) {
            HashMap aiTagNum = new HashMap();
            HashMap<String, Integer> labelNum = new HashMap<String, Integer>();
            HashMap<String, Integer> tradeNum = new HashMap<String, Integer>();
            HashMap<String, Integer> attributeNum = new HashMap<String, Integer>();
            HashMap<String, Integer> provinceNum = new HashMap<String, Integer>();
            HashMap<String, Integer> staffNumberNum = new HashMap<String, Integer>();
            for (ProductWinFeatureVo productWinFeatureVo : entry.getValue()) {
                if (HussarUtils.isNotEmpty((Object)productWinFeatureVo.getAiTags())) {
                    String[] aiTags;
                    for (String aiTag : aiTags = productWinFeatureVo.getAiTags().split(",")) {
                        if (HussarUtils.isEmpty(aiTagNum.get(aiTag))) {
                            aiTagNum.put(aiTag, 1);
                            continue;
                        }
                        aiTagNum.put(aiTag, (Integer)aiTagNum.get(aiTag) + 1);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)productWinFeatureVo.getLabelId())) {
                    String[] labelIds;
                    for (String labelId : labelIds = productWinFeatureVo.getLabelId().split(",")) {
                        if (HussarUtils.isEmpty(labelNum.get(labelId))) {
                            labelNum.put(labelId, 1);
                            continue;
                        }
                        labelNum.put(labelId, (Integer)labelNum.get(labelId) + 1);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)productWinFeatureVo.getTrade())) {
                    String trade = productWinFeatureVo.getTrade();
                    if (HussarUtils.isEmpty(tradeNum.get(trade))) {
                        tradeNum.put(trade, 1);
                    } else {
                        tradeNum.put(trade, (Integer)tradeNum.get(trade) + 1);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)productWinFeatureVo.getAttribute())) {
                    String attribute = productWinFeatureVo.getAttribute();
                    if (HussarUtils.isEmpty(attributeNum.get(attribute))) {
                        attributeNum.put(attribute, 1);
                    } else {
                        attributeNum.put(attribute, (Integer)attributeNum.get(attribute) + 1);
                    }
                }
                if (HussarUtils.isNotEmpty((Object)productWinFeatureVo.getProvince())) {
                    String province = productWinFeatureVo.getProvince();
                    if (HussarUtils.isEmpty(provinceNum.get(province))) {
                        provinceNum.put(province, 1);
                    } else {
                        provinceNum.put(province, (Integer)provinceNum.get(province) + 1);
                    }
                }
                if (!HussarUtils.isNotEmpty((Object)productWinFeatureVo.getStaffNumber())) continue;
                String staffNumber = productWinFeatureVo.getStaffNumber();
                if (HussarUtils.isEmpty(staffNumberNum.get(staffNumber))) {
                    staffNumberNum.put(staffNumber, 1);
                    continue;
                }
                staffNumberNum.put(staffNumber, (Integer)staffNumberNum.get(staffNumber) + 1);
            }
            double halfCount = (double)entry.getValue().size() / 2.0;
            aiTagNum.entrySet().removeIf(entry1 -> (double)((Integer)entry1.getValue()).intValue() < halfCount);
            labelNum.entrySet().removeIf(entry1 -> (double)((Integer)entry1.getValue()).intValue() < halfCount);
            tradeNum.entrySet().removeIf(entry1 -> (double)((Integer)entry1.getValue()).intValue() < halfCount);
            attributeNum.entrySet().removeIf(entry1 -> (double)((Integer)entry1.getValue()).intValue() < halfCount);
            provinceNum.entrySet().removeIf(entry1 -> (double)((Integer)entry1.getValue()).intValue() < halfCount);
            staffNumberNum.entrySet().removeIf(entry1 -> (double)((Integer)entry1.getValue()).intValue() < halfCount);
            ProductWinCustomerProfileVo profile = new ProductWinCustomerProfileVo(entry.getKey(), new ArrayList<String>(aiTagNum.keySet()), new ArrayList<String>(labelNum.keySet()), new ArrayList<String>(tradeNum.keySet()), new ArrayList<String>(attributeNum.keySet()), new ArrayList<String>(provinceNum.keySet()), new ArrayList<String>(staffNumberNum.keySet()));
            productWinCustomerProfileMap.put(entry.getKey(), profile);
        }
        List<ProductWeightVo> list = this.singleCustomerMetricsMapper.selectProductWeight();
        ArrayList<ProductWeightVo> defaultProductWeight = new ArrayList<ProductWeightVo>();
        for (ProductWeightVo vo : list) {
            if (vo.getProductId() != null) continue;
            defaultProductWeight.add(vo);
        }
        list.removeIf(productWeightVo -> productWeightVo.getProductId() == null);
        Map<Long, List<ProductWeightVo>> productWeightVoListMap = list.stream().collect(Collectors.groupingBy(ProductWeightVo::getProductId));
        Map<Long, List<ProductWinFeatureVo>> customerMap = allWinProductList.stream().collect(Collectors.groupingBy(ProductWinFeatureVo::getCustomerId));
        HashMap<Long, String> customerProductMap = new HashMap<Long, String>();
        for (Map.Entry<Long, List<ProductWinFeatureVo>> entry : customerMap.entrySet()) {
            Object id22;
            ProductWinFeatureVo customer = entry.getValue().get(0);
            List winProductIdList = entry.getValue().stream().map(ProductWinFeatureVo::getProductId).collect(Collectors.toList());
            for (Object id22 : winProductIdList) {
                if (!limsIdList.contains(id22)) continue;
                winProductIdList.addAll(limsIdList);
                break;
            }
            ArrayList<ProductRecommendScoreVo> arrayList = new ArrayList<ProductRecommendScoreVo>();
            id22 = productWinCustomerProfileMap.entrySet().iterator();
            while (id22.hasNext()) {
                Map.Entry productEntry = (Map.Entry)id22.next();
                if (winProductIdList.contains(productEntry.getKey())) continue;
                List<Object> weightVoList = new ArrayList();
                if (productWeightVoListMap.get(productEntry.getKey()) != null) {
                    weightVoList = productWeightVoListMap.get(productEntry.getKey());
                }
                double score = 0.0;
                for (ProductWeightVo weightVo : weightVoList) {
                    if ("1".equals(weightVo.getType()) && HussarUtils.isNotEmpty((Object)customer.getAiTags())) {
                        for (String aiTag : ((ProductWinCustomerProfileVo)productEntry.getValue()).getAiTag()) {
                            if (!customer.getAiTags().contains(aiTag)) continue;
                            if (score == 0.0) {
                                score = weightVo.getMark() * weightVo.getWeight();
                                continue;
                            }
                            score *= (double)(weightVo.getMark() * weightVo.getWeight());
                        }
                        continue;
                    }
                    if ("2".equals(weightVo.getType()) && HussarUtils.isNotEmpty((Object)customer.getLabelId())) {
                        for (String labelId : ((ProductWinCustomerProfileVo)productEntry.getValue()).getLabelId()) {
                            if (!customer.getLabelId().contains(labelId)) continue;
                            if (score == 0.0) {
                                score = weightVo.getMark() * weightVo.getWeight();
                                continue;
                            }
                            score *= (double)(weightVo.getMark() * weightVo.getWeight());
                        }
                        continue;
                    }
                    if ("3".equals(weightVo.getType()) && HussarUtils.isNotEmpty((Object)customer.getTrade())) {
                        for (String trade : ((ProductWinCustomerProfileVo)productEntry.getValue()).getTrade()) {
                            if (!customer.getTrade().equals(trade)) continue;
                            if (score == 0.0) {
                                score = weightVo.getMark() * weightVo.getWeight();
                                continue;
                            }
                            score *= (double)(weightVo.getMark() * weightVo.getWeight());
                        }
                        continue;
                    }
                    if ("4".equals(weightVo.getType()) && HussarUtils.isNotEmpty((Object)customer.getAttribute())) {
                        for (String attribute : ((ProductWinCustomerProfileVo)productEntry.getValue()).getAttribute()) {
                            if (!customer.getAttribute().equals(attribute)) continue;
                            if (score == 0.0) {
                                score = weightVo.getMark() * weightVo.getWeight();
                                continue;
                            }
                            score *= (double)(weightVo.getMark() * weightVo.getWeight());
                        }
                        continue;
                    }
                    if ("5".equals(weightVo.getType()) && HussarUtils.isNotEmpty((Object)customer.getProvince())) {
                        for (String province : ((ProductWinCustomerProfileVo)productEntry.getValue()).getProvince()) {
                            if (!customer.getProvince().equals(province)) continue;
                            if (score == 0.0) {
                                score = weightVo.getMark() * weightVo.getWeight();
                                continue;
                            }
                            score *= (double)(weightVo.getMark() * weightVo.getWeight());
                        }
                        continue;
                    }
                    if (!"6".equals(weightVo.getType()) || !HussarUtils.isNotEmpty((Object)customer.getStaffNumber())) continue;
                    for (String staffNumber : ((ProductWinCustomerProfileVo)productEntry.getValue()).getStaffNumber()) {
                        if (!customer.getStaffNumber().equals(staffNumber)) continue;
                        if (score == 0.0) {
                            score = weightVo.getMark() * weightVo.getWeight();
                            continue;
                        }
                        score *= (double)(weightVo.getMark() * weightVo.getWeight());
                    }
                }
                arrayList.add(new ProductRecommendScoreVo((Long)productEntry.getKey(), score, productMap.get(productEntry.getKey()).get(0).getProductName()));
            }
            ArrayList<String> productName = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(arrayList)) {
                arrayList.sort((e1, e2) -> e2.getScore().compareTo(e1.getScore()));
                boolean limsFlag = false;
                int i = 0;
                for (ProductRecommendScoreVo productRecommendScore : arrayList) {
                    if (i >= 3 || productRecommendScore.getScore() <= 0.0) break;
                    if (limsFlag && limsIdList.contains(productRecommendScore.getProductId())) continue;
                    if (limsIdList.contains(productRecommendScore.getProductId())) {
                        limsFlag = true;
                        productName.add(limsName);
                    } else {
                        productName.add(productRecommendScore.getProductName());
                    }
                    ++i;
                }
            }
            customerProductMap.put(entry.getKey(), String.join((CharSequence)"\u3001", productName));
        }
        return customerProductMap;
    }

    private TransactionCasesVo selectTransactionCases(Long customerId, String trade) {
        if (trade == null) {
            return null;
        }
        List<OpportunityProductVo> productList = this.singleCustomerMetricsMapper.selectLastTrackProduct(customerId);
        if (CollectionUtils.isEmpty(productList) || productList.get(0).getTrackTime() == null) {
            return null;
        }
        Long productId = productList.get(0).getProductId();
        List<TransactionCasesVo> list = this.singleCustomerMetricsMapper.selectTransactionCases(productId, customerId, trade);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        list.sort((e1, e2) -> e2.getOpportunityAmount().compareTo(e1.getOpportunityAmount()));
        for (TransactionCasesVo tc : list) {
            if (!"3".equals(tc.getCustLevel())) continue;
            TransactionCasesVo transactionCasesVo = tc;
        }
        TransactionCasesVo transactionCases = list.get(0);
        String opptyName = productList.get(0).getOpportunityName();
        transactionCases.setCustomerOpptyName(opptyName);
        transactionCases.setCustomerOpptyId(productList.get(0).getOpportunityId());
        return transactionCases;
    }
}

