/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum WorkOrderEnum {
    NOT_SUBMIT("0", "\u5f85\u63d0\u4ea4", "td", "\u63d0\u5355", "0"),
    TO_DO_DISPATCH("1", "\u5f85\u6d3e\u5355", "pd", "\u6d3e\u5355", "1"),
    TO_DO_ACCEPT("2", "\u5f85\u63a5\u5355", "jd", "\u63a5\u5355", "1"),
    ACCEPTING("3", "\u53d7\u7406\u4e2d", "slz", "\u53d7\u7406\u4e2d", "1"),
    TO_DO_EVALUATION("4", "\u5f85\u8bc4\u4ef7", "fwpj", "\u670d\u52a1\u8bc4\u4ef7", "1"),
    TO_DO_CONFIRM("5", "\u5f85\u786e\u8ba4", "jgqr", "\u7ed3\u679c\u786e\u8ba4", "1"),
    CONFIRMED("6", "\u5df2\u5b8c\u6210", "", "", "0");

    private String status;
    private String statusName;
    private String nodeCode;
    private String nodeName;
    private String analysis;
    private static Map<String, String> nodeStatusMap;
    private static LinkedHashMap<String, String> statusNodeNameMap;
    private static LinkedHashMap<String, String> statusNodeCodeMap;
    private static List<WorkOrderEnum> analysisNodeList;

    private WorkOrderEnum(String status, String statusName, String nodeCode, String nodeName, String analysis) {
        this.status = status;
        this.statusName = statusName;
        this.nodeCode = nodeCode;
        this.nodeName = nodeName;
        this.analysis = analysis;
    }

    public static String getStatusByNodeCode(String nodeCode) {
        return nodeStatusMap.get(nodeCode == null ? "" : nodeCode);
    }

    public static String getNodeCodeByStatus(String status) {
        return statusNodeCodeMap.get(status);
    }

    public static List<WorkOrderEnum> getAnalysisNodeList() {
        return analysisNodeList;
    }

    public static LinkedHashMap<String, String> getStatusNodeNameMap() {
        return statusNodeNameMap;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public String getNodeCode() {
        return this.nodeCode;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getAnalysis() {
        return this.analysis;
    }

    static {
        nodeStatusMap = Arrays.stream(WorkOrderEnum.values()).collect(Collectors.toMap(WorkOrderEnum::getNodeCode, WorkOrderEnum::getStatus));
        statusNodeNameMap = Arrays.stream(WorkOrderEnum.values()).collect(Collectors.toMap(WorkOrderEnum::getStatus, WorkOrderEnum::getNodeName, (existing, replacement) -> existing, LinkedHashMap::new));
        statusNodeCodeMap = Arrays.stream(WorkOrderEnum.values()).collect(Collectors.toMap(WorkOrderEnum::getStatus, WorkOrderEnum::getNodeCode, (existing, replacement) -> existing, LinkedHashMap::new));
        analysisNodeList = Arrays.stream(WorkOrderEnum.values()).filter(workOrderEnum -> "1".equals(workOrderEnum.getAnalysis())).collect(Collectors.toList());
    }
}

