/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.userClient.survey.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.enums.QuestionTypeEnum;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.model.CrmCsatOption;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.service.ICrmCsatOptionService;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.csat.vo.CrmCsatTemplateDetailVO;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatanswer.model.CrmCsatAnswer;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatanswer.service.CrmCsatAnswerService;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatanswerdetails.model.CrmCsatAnswerDetails;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatanswerdetails.service.CrmCsatAnswerDetailsService;
import com.jxdinfo.crm.afterservice.crm.mydhf.crmcsatsurvey.service.CrmSurveyService;
import com.jxdinfo.crm.afterservice.crm.userClient.survey.dao.CrmCsatSurveyMobileMapper;
import com.jxdinfo.crm.afterservice.crm.userClient.survey.dto.CrmCsatAnswerDetailsDto;
import com.jxdinfo.crm.afterservice.crm.userClient.survey.dto.CrmCsatAnswerDto;
import com.jxdinfo.crm.afterservice.crm.userClient.survey.dto.CrmCsatSurveyMobilePageDto;
import com.jxdinfo.crm.afterservice.crm.userClient.survey.service.CrmCsatSurveyMobileService;
import com.jxdinfo.crm.afterservice.crm.userClient.survey.vo.CrmCsatSurveyMobileVO;
import com.jxdinfo.crm.afterservice.crm.utils.AfterServiceDictEnum;
import com.jxdinfo.crm.afterservice.crm.utils.CommonUtils;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CrmCsatSurveyMobileServiceImpl
implements CrmCsatSurveyMobileService {
    @Resource
    private CrmCsatSurveyMobileMapper crmCsatSurveyMobileMapper;
    @Resource
    private CrmSurveyService crmSurveyService;
    @Resource
    private CrmCsatAnswerService crmCsatAnswerService;
    @Resource
    private CrmCsatAnswerDetailsService crmCsatAnswerDetailsService;
    @Resource
    private ICrmCsatOptionService crmCsatOptionService;
    @Resource
    private ISysDicRefService sysDicRefService;

    @Override
    public ApiResponse<Integer> getProgressNum(CrmCsatSurveyMobilePageDto pageDTO) {
        pageDTO.setCurrentTime(LocalDateTime.now());
        Integer progressNum = this.crmCsatSurveyMobileMapper.getProgressNum(pageDTO);
        return ApiResponse.success((Object)(progressNum == null ? 0 : progressNum));
    }

    @Override
    public ApiResponse<Page<CrmCsatSurveyMobileVO>> selectSurveyPage(CrmCsatSurveyMobilePageDto pageDTO) {
        try {
            Page pager = pageDTO.getPage();
            pageDTO.setCurrentTime(LocalDateTime.now());
            if (HussarUtils.isNotEmpty((Object)pageDTO.getSurveyName())) {
                pageDTO.setSurveyName(pageDTO.getSurveyName().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_"));
            }
            List<CrmCsatSurveyMobileVO> list = this.crmCsatSurveyMobileMapper.selectSurveyPage(pager, pageDTO);
            LinkedHashMap serviceStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.SURVEY_ANSWER_STATUS.getValue());
            for (CrmCsatSurveyMobileVO surveyMobileVO : list) {
                surveyMobileVO.setSurveyStatusName(serviceStatusMap.get(surveyMobileVO.getSurveyStatus()) == null ? "" : serviceStatusMap.get(surveyMobileVO.getSurveyStatus()).toString());
            }
            pager.setRecords(list);
            return ApiResponse.success(pager);
        }
        catch (Exception e) {
            throw new HussarException("\u8868\u683c\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public CrmCsatTemplateDetailVO getSurveyAnswerDetail(Long templateId, Long answerId) {
        return this.crmSurveyService.getSurveyAnswerDetail(templateId, answerId);
    }

    @Override
    @HussarTransactional
    public Boolean submitAnswer(CrmCsatAnswerDto answerDTO) {
        AssertUtil.isNotEmpty((String)answerDTO.getResponder(), (String)"\u4f5c\u7b54\u4eba\u5458\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)answerDTO.getContactTel(), (String)"\u8054\u7cfb\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)answerDTO.getCustId(), (String)"\u5ba2\u6237ID\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)answerDTO.getSurveyId(), (String)"\u6ee1\u610f\u5ea6\u56de\u8bbfID\u4e0d\u53ef\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmCsatAnswer::getSurveyId, (Object)answerDTO.getSurveyId())).eq(CrmCsatAnswer::getCustId, (Object)answerDTO.getCustId())).eq(CrmCsatAnswer::getContactTel, (Object)answerDTO.getContactTel());
        List answerList = this.crmCsatAnswerService.list((Wrapper)queryWrapper);
        AssertUtil.isEmpty((Collection)answerList, (String)"\u5f53\u524d\u6ee1\u610f\u5ea6\u56de\u8bbf\u5df2\u4f5c\u7b54\uff0c\u4e0d\u53ef\u91cd\u590d\u4f5c\u7b54");
        answerDTO.setAnswerId(CommonUtils.generateAssignId());
        answerDTO.setSubmitTime(LocalDateTime.now());
        List detailList = BeanUtil.copy(answerDTO.getDetailList(), CrmCsatAnswerDetails.class);
        if (HussarUtils.isNotEmpty((Object)detailList)) {
            List optionIdList = answerDTO.getDetailList().stream().filter(detail -> QuestionTypeEnum.SINGLE_CHOICE.getStatus().equals(detail.getQuestionType())).map(CrmCsatAnswerDetailsDto::getAnswerContent).collect(Collectors.toList());
            Map<Object, Object> optionScoreMap = new HashMap();
            if (HussarUtils.isNotEmpty(optionIdList)) {
                List optionList = this.crmCsatOptionService.listByIds(optionIdList);
                optionScoreMap = optionList.stream().collect(Collectors.toMap(option -> option.getOptionId().toString(), CrmCsatOption::getOptionScore));
            }
            Integer totalScore = 0;
            for (CrmCsatAnswerDetails crmCsatAnswerDetails : detailList) {
                crmCsatAnswerDetails.setDetailId(CommonUtils.generateAssignId());
                crmCsatAnswerDetails.setAnswerId(answerDTO.getAnswerId());
                Integer score = (Integer)optionScoreMap.get(crmCsatAnswerDetails.getAnswerContent());
                if (score == null) continue;
                totalScore = totalScore + score;
            }
            answerDTO.setSurveyScoring(totalScore.toString());
        }
        CrmCsatAnswer crmCsatAnswer = new CrmCsatAnswer();
        BeanUtil.copyProperties((Object)answerDTO, (Object)crmCsatAnswer);
        boolean flag = this.crmCsatAnswerService.save(crmCsatAnswer);
        if (flag && HussarUtils.isNotEmpty((Object)detailList)) {
            this.crmCsatAnswerDetailsService.saveBatch(detailList);
        }
        return flag;
    }
}

