/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.afterservice.crm.userClient.workOrder.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktFlowDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.dto.CrmTktNodeDto;
import com.jxdinfo.crm.afterservice.crm.afterServiceConfig.flow.service.ICrmTktFlowService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.dao.CrmWorkOrderMapper;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.ServiceStatusEnum;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.ServiceTypeEnum;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.enums.WorkOrderEnum;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmWorkOrder.service.CrmWorkOrderService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktacceptrecords.model.CrmTktAcceptRecords;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktacceptrecords.service.CrmTktAcceptRecordsService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktdispatchrecords.model.CrmTktDispatchRecords;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktevaluaterecords.model.CrmTktEvaluateRecords;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktevaluaterecords.service.CrmTktEvaluateRecordsService;
import com.jxdinfo.crm.afterservice.crm.fwgd.crmtktworkorders.model.CrmTktWorkOrders;
import com.jxdinfo.crm.afterservice.crm.userClient.workOrder.dao.WorkOrderMobileUserMapper;
import com.jxdinfo.crm.afterservice.crm.userClient.workOrder.dto.CustomerContactDto;
import com.jxdinfo.crm.afterservice.crm.userClient.workOrder.dto.CustomerLoginDto;
import com.jxdinfo.crm.afterservice.crm.userClient.workOrder.dto.WorkOrderMobileParamUserDto;
import com.jxdinfo.crm.afterservice.crm.userClient.workOrder.dto.WorkOrderMobileUserDto;
import com.jxdinfo.crm.afterservice.crm.userClient.workOrder.enums.WorkOrderMobileStatusEnum;
import com.jxdinfo.crm.afterservice.crm.userClient.workOrder.service.IWorkOrderMobileUserService;
import com.jxdinfo.crm.afterservice.crm.userClient.workOrder.vo.WorkOrderMobileVO;
import com.jxdinfo.crm.afterservice.crm.utils.AfterServiceDictEnum;
import com.jxdinfo.crm.afterservice.crm.utils.CommonUtils;
import com.jxdinfo.crm.afterservice.crm.utils.WorkOrderNumberUtil;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.core.api.contact.vo.ContactAPIVo;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class WorkOrderMobileUserServiceImpl
extends HussarServiceImpl<WorkOrderMobileUserMapper, CrmTktWorkOrders>
implements IWorkOrderMobileUserService {
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ICrmTktFlowService crmTktFlowService;
    @Resource
    private CrmWorkOrderService crmWorkOrderService;
    @Resource
    private CrmWorkOrderMapper crmWorkOrderMapper;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private CrmTktEvaluateRecordsService crmTktEvaluateRecordsService;
    @Resource
    private CrmTktAcceptRecordsService crmTktAcceptRecordsService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private ICustomerAPIService customerAPIService;
    private static DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    @Override
    public CustomerContactDto getCustomerContact(CustomerLoginDto dto) {
        List customerList = this.customerAPIService.selectCustomerByNameAndTel(dto.getCustomerName(), dto.getMobilePhone());
        boolean flag = HussarUtils.isNotEmpty((Object)customerList) && HussarUtils.isNotEmpty((Object)((CustomerAPIVo)customerList.get(0)).getContactAPIVoList());
        AssertUtil.isTrue((boolean)flag, (String)"\u5ba2\u6237\u540d\u79f0\u6216\u8054\u7cfb\u7535\u8bdd\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        CustomerContactDto customerContactDto = new CustomerContactDto();
        customerContactDto.setContactId(((ContactAPIVo)((CustomerAPIVo)customerList.get(0)).getContactAPIVoList().get(0)).getContactId());
        customerContactDto.setContactName(((ContactAPIVo)((CustomerAPIVo)customerList.get(0)).getContactAPIVoList().get(0)).getContactName());
        customerContactDto.setCustomerId(((CustomerAPIVo)customerList.get(0)).getCustomerId());
        customerContactDto.setCustomerName(((CustomerAPIVo)customerList.get(0)).getCustomerName());
        customerContactDto.setMobilePhone(dto.getMobilePhone());
        return customerContactDto;
    }

    @Override
    public IPage<WorkOrderMobileVO> getWorkOrderPage(WorkOrderMobileParamUserDto param) {
        AssertUtil.isNotEmpty((String)param.getMobilePhone(), (String)"\u624b\u673a\u53f7\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)param.getCustId(), (String)"\u5ba2\u6237ID\u4e0d\u53ef\u4e3a\u7a7a");
        Page pages = param.getPage();
        param.setCurrentTime(LocalDateTime.now());
        if (HussarUtils.isNotEmpty((Object)param.getServiceTopic())) {
            param.setServiceTopic(param.getServiceTopic().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
        }
        IPage<WorkOrderMobileVO> workOrderPage = ((WorkOrderMobileUserMapper)this.baseMapper).getWorkOrderPage(pages, param);
        LinkedHashMap businessTypeMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_BUSINESS_TYPE.getValue());
        LinkedHashMap urgencyLevelMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.URGENCY_LEVEL.getValue());
        LinkedHashMap serviceStatusMap = this.sysDicRefService.getDictMapByType(AfterServiceDictEnum.WORK_ORDER_STATUS_MOBILE.getValue());
        Iterator iterator = workOrderPage.getRecords().iterator();
        while (iterator.hasNext()) {
            WorkOrderMobileVO record;
            record.setServiceStatusName(serviceStatusMap.get((record = (WorkOrderMobileVO)iterator.next()).getServiceStatusName()) == null ? "" : serviceStatusMap.get(record.getServiceStatusName()).toString());
            record.setBusinessType(businessTypeMap.get(record.getBusinessType()) == null ? "" : businessTypeMap.get(record.getBusinessType()).toString());
            record.setUrgencyLevel(urgencyLevelMap.get(record.getUrgencyLevel()) == null ? "" : urgencyLevelMap.get(record.getUrgencyLevel()).toString());
        }
        return workOrderPage;
    }

    @Override
    public WorkOrderMobileUserDto getDetail(Long woId) {
        CrmTktWorkOrders crmTktWorkOrders = (CrmTktWorkOrders)((WorkOrderMobileUserMapper)this.baseMapper).selectById(woId);
        WorkOrderMobileUserDto workOrderMobileDto = new WorkOrderMobileUserDto();
        BeanUtil.copy((Object)crmTktWorkOrders, (Object)workOrderMobileDto);
        if (crmTktWorkOrders == null) {
            return workOrderMobileDto;
        }
        if ("4".equals(workOrderMobileDto.getServiceStatus()) && workOrderMobileDto.getServiceTimeliness() != null && LocalDateTime.now().isAfter(workOrderMobileDto.getServiceTimeliness())) {
            workOrderMobileDto.setServiceStatus("5");
        }
        workOrderMobileDto.setServiceStatusName(this.getServiceStatusName(crmTktWorkOrders));
        workOrderMobileDto.setFileIdList(((WorkOrderMobileUserMapper)this.baseMapper).getFileIdListByBusinessId(woId));
        QueryWrapper acceptQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)acceptQueryWrapper.lambda().eq(CrmTktAcceptRecords::getWoId, (Object)crmTktWorkOrders.getWoId())).eq(CrmTktAcceptRecords::getCorrectionCount, (Object)crmTktWorkOrders.getCorrectionCount());
        List acceptRecordList = this.crmTktAcceptRecordsService.list((Wrapper)acceptQueryWrapper);
        workOrderMobileDto.setAcceptRecord(HussarUtils.isEmpty((Object)acceptRecordList) ? new CrmTktAcceptRecords() : (CrmTktAcceptRecords)acceptRecordList.get(0));
        if (HussarUtils.isNotEmpty((Object)acceptRecordList) && HussarUtils.isNotEmpty((Object)((CrmTktAcceptRecords)acceptRecordList.get(0)).getAcceptId())) {
            workOrderMobileDto.setAcceptFileIdList(((WorkOrderMobileUserMapper)this.baseMapper).getFileIdListByBusinessId(((CrmTktAcceptRecords)acceptRecordList.get(0)).getAcceptId()));
        }
        QueryWrapper evaluateQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)evaluateQueryWrapper.lambda().eq(CrmTktEvaluateRecords::getWoId, (Object)crmTktWorkOrders.getWoId())).eq(CrmTktEvaluateRecords::getCorrectionCount, (Object)crmTktWorkOrders.getCorrectionCount());
        List evaluateRecordList = this.crmTktEvaluateRecordsService.list((Wrapper)evaluateQueryWrapper);
        workOrderMobileDto.setEvaluateRecord(HussarUtils.isEmpty((Object)evaluateRecordList) ? new CrmTktEvaluateRecords() : (CrmTktEvaluateRecords)evaluateRecordList.get(0));
        return workOrderMobileDto;
    }

    private String getServiceStatusName(CrmTktWorkOrders crmTktWorkOrders) {
        boolean flag;
        String serviceStatusName = WorkOrderMobileStatusEnum.getStatusNameByStatus(crmTktWorkOrders.getServiceStatus());
        boolean bl = flag = ServiceTypeEnum.REMIND.getStatus().equals(crmTktWorkOrders.getServiceType()) || ServiceTypeEnum.SUGGEST.getStatus().equals(crmTktWorkOrders.getServiceType());
        if (flag && WorkOrderMobileStatusEnum.ACCEPTING.getStatus().equals(crmTktWorkOrders.getServiceStatus())) {
            serviceStatusName = WorkOrderMobileStatusEnum.TO_DO_CONFIRM.getStatusName();
        }
        if (ServiceStatusEnum.NOT_SUBMIT.getStatusVal().equals(crmTktWorkOrders.getServiceStatus()) && "1".equals(crmTktWorkOrders.getIsReview())) {
            serviceStatusName = flag ? WorkOrderMobileStatusEnum.TO_DO_CONFIRM.getStatusName() : WorkOrderMobileStatusEnum.ACCEPTING.getStatusName();
        }
        return serviceStatusName;
    }

    private String getServiceStatusName(WorkOrderMobileVO crmTktWorkOrders) {
        boolean flag;
        String serviceStatusName = WorkOrderMobileStatusEnum.getStatusNameByStatus(crmTktWorkOrders.getServiceStatus());
        boolean bl = flag = ServiceTypeEnum.REMIND.getStatus().equals(crmTktWorkOrders.getServiceType()) || ServiceTypeEnum.SUGGEST.getStatus().equals(crmTktWorkOrders.getServiceType());
        if (flag && ServiceStatusEnum.TO_DO_ACCEPT.getStatusVal().equals(crmTktWorkOrders.getServiceStatus())) {
            serviceStatusName = WorkOrderMobileStatusEnum.TO_DO_CONFIRM.getStatusName();
        }
        if (ServiceStatusEnum.NOT_SUBMIT.getStatusVal().equals(crmTktWorkOrders.getServiceStatus()) && "1".equals(crmTktWorkOrders.getIsReview())) {
            serviceStatusName = flag ? WorkOrderMobileStatusEnum.TO_DO_CONFIRM.getStatusName() : WorkOrderMobileStatusEnum.ACCEPTING.getStatusName();
        }
        return serviceStatusName;
    }

    @Override
    public boolean insertOrUpdate(WorkOrderMobileUserDto dto) {
        boolean flag = dto.getWoId() == null ? this.addWorkOrder(dto) : this.editWorkOrder(dto);
        return flag;
    }

    @HussarTransactional
    private boolean addWorkOrder(WorkOrderMobileUserDto dto) {
        AssertUtil.isNotEmpty((String)dto.getServiceType(), (String)"\u670d\u52a1\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)dto.getCustId(), (String)"\u5ba2\u6237\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktFlowDto crmTktFlowDto = this.crmTktFlowService.getCrmFlowByServiceTypeAndCust(dto.getServiceType(), dto.getCustId());
        AssertUtil.isNotNull((Object)crmTktFlowDto, (String)"\u6682\u65e0\u6743\u9650");
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)BeanUtil.copy((Object)dto, CrmTktWorkOrders.class);
        if (workOrder.getExpectedTime() != null) {
            workOrder.setExpectedTime(LocalDateTime.parse(workOrder.getExpectedTime().format(YYYY_MM_DD) + "T23:59:59"));
        }
        workOrder.setWoId(CommonUtils.generateAssignId());
        workOrder.setFlowId(crmTktFlowDto.getFlowId());
        workOrder.setNodeNow(crmTktFlowDto.getNodeList().get(0).getNodeId());
        String nextNodeCode = crmTktFlowDto.getNodeList().get(0).getNodeCode();
        boolean isSubmit = false;
        workOrder.setIsReview("0");
        workOrder.setIsReject("0");
        if (HussarUtils.isEmpty((Object)workOrder.getServiceStatus()) || "0".equals(workOrder.getServiceStatus())) {
            workOrder.setAssigneeName(workOrder.getContactPerson());
        } else {
            isSubmit = true;
            CrmTktNodeDto nextNode = crmTktFlowDto.getNodeList().get(1);
            workOrder.setNodeNow(nextNode.getNodeId());
            nextNodeCode = nextNode.getNodeCode();
            if ("0".equals(nextNode.getIsFixed())) {
                workOrder.setAssigneeId(null);
                workOrder.setAssigneeName(null);
                workOrder.setAssigneeDept(null);
                workOrder.setIsReview("1");
                workOrder.setServiceStatus("0");
            } else {
                workOrder.setAssigneeId(null);
                workOrder.setAssigneeName(null);
                workOrder.setAssigneeDept(null);
                workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(nextNode.getNodeCode()));
            }
            workOrder.setServiceNumber(WorkOrderNumberUtil.getOrderNumber(workOrder.getServiceType()));
        }
        workOrder.setCorrectionCount(0);
        LocalDateTime currentTime = LocalDateTime.now();
        workOrder.setCreatorName(workOrder.getContactPerson());
        workOrder.setCreateTime(currentTime);
        workOrder.setLastTime(currentTime);
        boolean flag = this.save(workOrder);
        if (flag) {
            if (HussarUtils.isNotEmpty(dto.getFileIdList())) {
                this.crmWorkOrderMapper.updateBusinessIdByFileIdList(dto.getFileIdList(), workOrder.getWoId());
            }
            if (isSubmit) {
                this.saveOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE, workOrder.getServiceTopic(), workOrder.getWoId(), dto.getContactPerson(), "\u5ba2\u6237\u63d0\u4ea4");
            }
            SecurityUser user = new SecurityUser();
            user.setUserName(workOrder.getContactPerson());
            this.crmWorkOrderService.sendMessage(workOrder, nextNodeCode, null, user);
        }
        return flag;
    }

    @HussarTransactional
    private boolean editWorkOrder(WorkOrderMobileUserDto dto) {
        AssertUtil.isNotNull((Object)dto.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)dto.getServiceType(), (String)"\u670d\u52a1\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)dto.getCustId(), (String)"\u5ba2\u6237\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)BeanUtil.copy((Object)dto, CrmTktWorkOrders.class);
        CrmTktWorkOrders oldWorkOrder = (CrmTktWorkOrders)((WorkOrderMobileUserMapper)this.baseMapper).selectById(dto.getWoId());
        AssertUtil.isNotNull((Object)oldWorkOrder, (String)"\u5f53\u524d\u5de5\u5355\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        AssertUtil.isTrue((oldWorkOrder.getNodeNow() == null || oldWorkOrder.getNodeNow().equals(dto.getNodeNow()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u5de5\u5355\u5df2\u63d0\u4ea4\uff0c\u8bf7\u5237\u65b0\u5217\u8868");
        if (HussarUtils.isNotEmpty((Object)workOrder.getServiceNumber())) {
            CrmTktWorkOrders oldData = (CrmTktWorkOrders)((WorkOrderMobileUserMapper)this.baseMapper).selectById(dto.getWoId());
            AssertUtil.isTrue((boolean)oldData.getServiceType().equals(dto.getServiceType()), (String)"\u64a4\u56de\u540e\u670d\u52a1\u7c7b\u578b\u4e0d\u53ef\u4fee\u6539");
        }
        if (workOrder.getExpectedTime() != null) {
            workOrder.setExpectedTime(LocalDateTime.parse(workOrder.getExpectedTime().format(YYYY_MM_DD) + "T23:59:59"));
        }
        boolean isSubmit = false;
        String nextNodeCode = null;
        workOrder.setIsReview("0");
        workOrder.setIsReject("0");
        if (HussarUtils.isEmpty((Object)workOrder.getServiceStatus()) || "0".equals(workOrder.getServiceStatus())) {
            workOrder.setAssigneeName(workOrder.getContactPerson());
        } else {
            isSubmit = true;
            CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
            workOrder.setNodeNow(nextNode.getNodeId());
            nextNodeCode = nextNode.getNodeCode();
            if ("0".equals(nextNode.getIsFixed())) {
                workOrder.setAssigneeId(null);
                workOrder.setAssigneeName(null);
                workOrder.setAssigneeDept(null);
                workOrder.setIsReview("1");
                workOrder.setServiceStatus("0");
            } else {
                workOrder.setAssigneeId(null);
                workOrder.setAssigneeName(null);
                workOrder.setAssigneeDept(null);
                workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(nextNode.getNodeCode()));
            }
            if (HussarUtils.isEmpty((Object)workOrder.getServiceNumber())) {
                workOrder.setServiceNumber(WorkOrderNumberUtil.getOrderNumber(workOrder.getServiceType()));
            }
        }
        workOrder.setIsReject("0");
        workOrder.setCorrectionCount(oldWorkOrder.getCorrectionCount());
        workOrder.setLastTime(LocalDateTime.now());
        boolean flag = this.updateById(workOrder);
        if (flag) {
            this.deleteFile(workOrder.getWoId(), dto.getFileIdList());
            if (HussarUtils.isNotEmpty(dto.getFileIdList())) {
                this.crmWorkOrderMapper.updateBusinessIdByFileIdList(dto.getFileIdList(), workOrder.getWoId());
            }
            if (isSubmit) {
                this.saveOperateLog(RecordProductTypeEnum.PRODUCE_CHANGE, workOrder.getServiceTopic(), workOrder.getWoId(), dto.getContactPerson(), "\u5ba2\u6237\u63d0\u4ea4");
            }
            SecurityUser user = new SecurityUser();
            user.setUserName(workOrder.getContactPerson());
            this.crmWorkOrderService.sendMessage(workOrder, nextNodeCode, null, user);
        }
        return flag;
    }

    private void deleteFile(Long businessId, List<Long> fileIdList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(AttachmentManagerModel::getBusinessId, (Object)businessId)).notIn(HussarUtils.isNotEmpty(fileIdList), AttachmentManagerModel::getId, fileIdList);
        this.attachmentManagerService.remove((Wrapper)queryWrapper);
    }

    @Override
    @HussarTransactional
    public ApiResponse serviceEvaluation(CrmTktEvaluateRecords record) {
        boolean overtime;
        AssertUtil.isNotNull((Object)record.getWoId(), (String)"\u5de5\u5355ID\u4e0d\u53ef\u4e3a\u7a7a");
        CrmTktWorkOrders workOrder = (CrmTktWorkOrders)((WorkOrderMobileUserMapper)this.baseMapper).selectById(record.getWoId());
        List<CrmTktEvaluateRecords> list = this.getEvaluateRecord(workOrder.getWoId(), workOrder.getCorrectionCount());
        if (HussarUtils.isNotEmpty(list)) {
            return ApiResponse.success((Object)-1);
        }
        boolean bl = overtime = WorkOrderEnum.TO_DO_EVALUATION.getStatus().equals(workOrder.getServiceStatus()) && HussarUtils.isNotEmpty((Object)workOrder.getServiceTimeliness()) && LocalDateTime.now().isAfter(workOrder.getServiceTimeliness());
        if (overtime) {
            return ApiResponse.success((Object)-2);
        }
        CrmTktNodeDto nextNode = this.crmTktFlowService.getNextNode(workOrder.getFlowId(), workOrder.getNodeNow());
        workOrder.setNodeNow(nextNode == null ? null : nextNode.getNodeId());
        workOrder.setResponsibleId(null);
        workOrder.setResponsibleName(workOrder.getContactPerson());
        workOrder.setResponsibleDeptId(null);
        workOrder.setResponsibleDept(null);
        if (nextNode == null) {
            workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(""));
        } else if ("1".equals(nextNode.getIsFixed())) {
            workOrder.setServiceStatus(WorkOrderEnum.getStatusByNodeCode(nextNode.getNodeCode()));
            workOrder.setIsReview("0");
            workOrder.setIsReject("0");
            CrmTktDispatchRecords crmTktDispatchRecords = this.crmWorkOrderService.getDispatcher(workOrder.getWoId(), workOrder.getCorrectionCount());
            if (crmTktDispatchRecords != null) {
                workOrder.setAssigneeId(crmTktDispatchRecords.getDispatcherId());
                workOrder.setAssigneeName(crmTktDispatchRecords.getDispatcher());
                workOrder.setAssigneeDept(crmTktDispatchRecords.getDispatcherDept());
            } else {
                workOrder.setAssigneeId(null);
                workOrder.setAssigneeName(null);
                workOrder.setAssigneeDept(null);
            }
        } else {
            workOrder.setIsReview("1");
            workOrder.setIsReject("0");
            workOrder.setAssigneeId(null);
            workOrder.setAssigneeName(null);
            workOrder.setAssigneeDept(null);
        }
        LocalDateTime currentTime = LocalDateTime.now();
        workOrder.setLastTime(currentTime);
        record.setCreateTime(currentTime);
        record.setCorrectionCount(workOrder.getCorrectionCount());
        record.setEvaluateId(CommonUtils.generateAssignId());
        record.setCreator(workOrder.getContactPerson());
        boolean flag = this.updateById(workOrder);
        if (flag) {
            this.crmTktEvaluateRecordsService.save(record);
            SecurityUser user = new SecurityUser();
            user.setUserName(workOrder.getContactPerson());
            this.crmWorkOrderService.sendMessage(workOrder, nextNode == null ? null : nextNode.getNodeCode(), null, user);
        }
        return ApiResponse.success((Object)flag);
    }

    private void saveOperateLog(RecordProductTypeEnum productTypeEnum, String serviceTopic, Long woId, String userName, String recordContent) {
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(productTypeEnum.getId());
        operateRecordDO.setRecordContent(recordContent);
        ArrayList<Long> businessIds = new ArrayList<Long>();
        businessIds.add(woId);
        SecurityUser user = new SecurityUser();
        user.setUserName(userName);
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.AFTER_SERVICE, woId, serviceTopic, LocalDateTime.now(), false, businessIds, user);
    }

    private List<CrmTktEvaluateRecords> getEvaluateRecord(Long woId, Integer correctionCount) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(CrmTktEvaluateRecords::getWoId, (Object)woId)).eq(CrmTktEvaluateRecords::getCorrectionCount, (Object)correctionCount);
        return this.crmTktEvaluateRecordsService.list((Wrapper)queryWrapper);
    }
}

