/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.OrderByVisitor;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.ValidationContext;
import net.sf.jsqlparser.util.validation.ValidationException;
import net.sf.jsqlparser.util.validation.Validator;
import net.sf.jsqlparser.util.validation.feature.FeatureContext;
import net.sf.jsqlparser.util.validation.feature.FeatureSetValidation;
import net.sf.jsqlparser.util.validation.metadata.DatabaseMetaDataValidation;
import net.sf.jsqlparser.util.validation.metadata.MetadataContext;
import net.sf.jsqlparser.util.validation.metadata.Named;
import net.sf.jsqlparser.util.validation.metadata.NamedObject;
import net.sf.jsqlparser.util.validation.validator.ExpressionValidator;
import net.sf.jsqlparser.util.validation.validator.ItemsListValidator;
import net.sf.jsqlparser.util.validation.validator.OrderByValidator;
import net.sf.jsqlparser.util.validation.validator.SelectValidator;

public abstract class AbstractValidator<S>
implements Validator<S> {
    private ValidationContext context = new ValidationContext();
    private final Map<ValidationCapability, Set<ValidationException>> errors = new HashMap<ValidationCapability, Set<ValidationException>>();
    private final Map<Class<? extends AbstractValidator<?>>, AbstractValidator<?>> validatorForwards = new HashMap();

    public <T extends AbstractValidator<?>> T getValidator(Class<T> type) {
        return (T)((AbstractValidator)type.cast(this.validatorForwards.computeIfAbsent(type, this::newObject)));
    }

    private <E extends Validator<?>> E newObject(Class<E> type) {
        try {
            Validator e = (Validator)type.cast(type.getConstructor(new Class[0]).newInstance(new Object[0]));
            e.setContext(this.context());
            return (E)e;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Type " + type + " cannot be constructed by empty constructor!");
        }
    }

    protected Consumer<ValidationException> getMessageConsumer(ValidationCapability c) {
        return s -> this.putError(c, (ValidationException)s);
    }

    protected ValidationContext context() {
        return this.context(true);
    }

    protected ValidationContext context(boolean reInit) {
        return this.context.reinit(reInit);
    }

    protected void putError(ValidationCapability capability, ValidationException error) {
        this.errors.computeIfAbsent(capability, k -> new HashSet()).add(error);
    }

    @Override
    public final Map<ValidationCapability, Set<ValidationException>> getValidationErrors() {
        HashMap<ValidationCapability, Set<ValidationException>> map = new HashMap<ValidationCapability, Set<ValidationException>>();
        map.putAll(this.errors);
        for (AbstractValidator<?> v : this.validatorForwards.values()) {
            for (Map.Entry<ValidationCapability, Set<ValidationException>> e : v.getValidationErrors().entrySet()) {
                Set set = (Set)map.get(e.getKey());
                if (set == null) {
                    map.put(e.getKey(), e.getValue());
                    continue;
                }
                set.addAll((Collection)e.getValue());
            }
        }
        return map;
    }

    public Collection<ValidationCapability> getCapabilities() {
        return this.context().getCapabilities();
    }

    @Override
    public final void setContext(ValidationContext context) {
        this.context = context;
    }

    protected <E> void validateOptional(E element, Consumer<E> elementConsumer) {
        if (element != null) {
            elementConsumer.accept(element);
        }
    }

    protected <E, V extends Validator<?>> void validateOptionalList(List<E> elementList, Supplier<V> validatorSupplier, BiConsumer<E, V> elementConsumer) {
        if (this.isNotEmpty(elementList)) {
            Validator validator = (Validator)validatorSupplier.get();
            elementList.forEach(e -> elementConsumer.accept(e, validator));
        }
    }

    protected void validateOptionalMultiExpressionList(MultiExpressionList multiExprList) {
        if (multiExprList != null) {
            ExpressionValidator v = this.getValidator(ExpressionValidator.class);
            multiExprList.getExpressionLists().stream().map(ExpressionList::getExpressions).flatMap(Collection::stream).forEach(e -> e.accept(v));
        }
    }

    protected void validateOptionalExpression(Expression expression) {
        this.validateOptional(expression, e -> e.accept(this.getValidator(ExpressionValidator.class)));
    }

    protected void validateOptionalExpression(Expression expression, ExpressionValidator v) {
        this.validateOptional(expression, e -> e.accept(v));
    }

    protected void validateOptionalExpressions(List<? extends Expression> expressions) {
        this.validateOptionalList(expressions, () -> this.getValidator(ExpressionValidator.class), (o, v) -> o.accept((ExpressionVisitor)v));
    }

    protected void validateOptionalFromItems(FromItem ... fromItems) {
        this.validateOptionalFromItems(Arrays.asList(fromItems));
    }

    protected void validateOptionalFromItems(List<? extends FromItem> fromItems) {
        this.validateOptionalList(fromItems, () -> this.getValidator(SelectValidator.class), this::validateOptionalFromItem);
    }

    protected void validateOptionalOrderByElements(List<OrderByElement> orderByElements) {
        this.validateOptionalList(orderByElements, () -> this.getValidator(OrderByValidator.class), (o, v) -> o.accept((OrderByVisitor)v));
    }

    protected void validateOptionalFromItem(FromItem fromItem) {
        this.validateOptional(fromItem, i -> i.accept(this.getValidator(SelectValidator.class)));
    }

    protected void validateOptionalFromItem(FromItem fromItem, SelectValidator v) {
        this.validateOptional(fromItem, i -> i.accept(v));
    }

    protected void validateOptionalItemsList(ItemsList itemsList) {
        this.validateOptional(itemsList, i -> i.accept(this.getValidator(ItemsListValidator.class)));
    }

    protected void validateFeature(Feature feature) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, feature);
        }
    }

    protected void validateFeatureAndName(Feature feature, NamedObject namedObject, String fqn) {
        this.validateFeatureAndNameWithAlias(feature, namedObject, fqn, null);
    }

    protected void validateFeatureAndNameWithAlias(Feature feature, NamedObject namedObject, String fqn, String alias) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, feature);
            this.validateNameWithAlias(c, namedObject, fqn, alias, true, new NamedObject[0]);
        }
    }

    protected void validateName(NamedObject namedObject, String fqn) {
        this.validateNameWithAlias(namedObject, fqn, null);
    }

    protected void validateNameWithAlias(NamedObject namedObject, String fqn, String alias) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateNameWithAlias(c, namedObject, fqn, alias, true, new NamedObject[0]);
        }
    }

    protected void validateFeature(ValidationCapability capability, boolean condition, Feature feature) {
        if (condition) {
            this.validateFeature(capability, feature);
        }
    }

    protected void validateOptionalFeature(ValidationCapability capability, List<?> elements, Feature feature) {
        this.validateFeature(capability, this.isNotEmpty(elements), feature);
    }

    protected void validateOptionalFeature(ValidationCapability capability, Object element, Feature feature) {
        this.validateFeature(capability, element != null, feature);
    }

    protected void validateFeature(ValidationCapability capability, Feature feature) {
        if (capability instanceof FeatureSetValidation) {
            capability.validate(this.context().put(FeatureContext.feature, (Object)feature), this.getMessageConsumer(capability));
        }
    }

    protected void validateNameWithAlias(ValidationCapability capability, NamedObject namedObject, String fqn, String alias) {
        this.validateNameWithAlias(capability, namedObject, fqn, alias, true, new NamedObject[0]);
    }

    protected void validateName(ValidationCapability capability, NamedObject namedObject, String fqn) {
        this.validateNameWithAlias(capability, namedObject, fqn, null, true, new NamedObject[0]);
    }

    protected void validateNameWithAlias(ValidationCapability capability, NamedObject namedObject, String fqn, String alias, boolean exists, NamedObject ... parents) {
        if (capability instanceof DatabaseMetaDataValidation) {
            capability.validate(this.context().put(MetadataContext.named, new Named(namedObject, fqn).setAlias(alias).setParents(Arrays.asList(parents))).put(MetadataContext.exists, exists), this.getMessageConsumer(capability));
        }
    }

    protected void validateName(ValidationCapability capability, NamedObject namedObject, String fqn, boolean exists, NamedObject ... parents) {
        this.validateNameWithAlias(capability, namedObject, fqn, null, exists, parents);
    }

    protected void validateOptionalColumnName(ValidationCapability capability, String name) {
        this.validateOptionalName(capability, NamedObject.column, name, null, true, new NamedObject[0]);
    }

    protected void validateOptionalColumnNameWithAlias(ValidationCapability capability, String name, String alias) {
        this.validateOptionalName(capability, NamedObject.column, name, alias, true, new NamedObject[0]);
    }

    protected void validateOptionalColumnNames(ValidationCapability capability, List<String> columnNames, NamedObject ... parents) {
        this.validateOptionalColumnNames(capability, columnNames, true, parents);
    }

    protected void validateOptionalColumnNames(ValidationCapability capability, List<String> columnNames, boolean exists, NamedObject ... parents) {
        if (columnNames != null) {
            columnNames.forEach(n -> this.validateOptionalName(capability, NamedObject.column, (String)n, null, exists, parents));
        }
    }

    protected void validateOptionalNameWithAlias(ValidationCapability capability, NamedObject namedObject, String name, String alias, NamedObject ... parents) {
        this.validateOptionalName(capability, namedObject, name, alias, true, parents);
    }

    protected void validateOptionalName(ValidationCapability capability, NamedObject namedObject, String name, NamedObject ... parents) {
        this.validateOptionalNameWithAlias(capability, namedObject, name, null, parents);
    }

    protected void validateOptionalName(ValidationCapability capability, NamedObject namedObject, String name, String alias, boolean exists, NamedObject ... parents) {
        if (name != null) {
            this.validateNameWithAlias(capability, namedObject, name, alias, exists, parents);
        }
    }

    protected boolean isNotEmpty(Collection<?> c) {
        return c != null && !c.isEmpty();
    }

    protected boolean isNotEmpty(String c) {
        return c != null && !c.isEmpty();
    }
}

