/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.feature;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.util.validation.feature.DatabaseType;
import net.sf.jsqlparser.util.validation.feature.Version;

public enum SqlServerVersion implements Version
{
    V2019("2019", EnumSet.of(Feature.jdbcParameter, new Feature[]{Feature.jdbcNamedParameter, Feature.exprLike, Feature.select, Feature.selectInto, Feature.withItem, Feature.selectGroupBy, Feature.function, Feature.tableFunction, Feature.selectHaving, Feature.orderBy, Feature.distinct, Feature.withItem, Feature.withItemRecursive, Feature.top, Feature.offset, Feature.offsetParam, Feature.fetch, Feature.fetchFirst, Feature.fetchNext, Feature.setOperation, Feature.setOperationUnion, Feature.setOperationIntersect, Feature.setOperationExcept, Feature.values, Feature.join, Feature.joinSimple, Feature.joinRight, Feature.joinFull, Feature.joinLeft, Feature.joinCross, Feature.joinOuter, Feature.joinInner, Feature.joinApply, Feature.insert, Feature.insertValues, Feature.insertFromSelect, Feature.update, Feature.updateFrom, Feature.delete, Feature.truncate, Feature.drop, Feature.dropTable, Feature.dropIndex, Feature.dropView, Feature.dropSchema, Feature.dropSequence, Feature.dropTableIfExists, Feature.dropIndexIfExists, Feature.dropViewIfExists, Feature.dropSchemaIfExists, Feature.dropSequenceIfExists, Feature.execute, Feature.executeExec, Feature.executeExecute, Feature.set, Feature.alterTable, Feature.alterSequence, Feature.alterView, Feature.alterIndex, Feature.createIndex, Feature.createSequence, Feature.createTable, Feature.createTableTableOptionStrings, Feature.createTableFromSelect, Feature.functionalStatement, Feature.createProcedure, Feature.createFunction, Feature.block, Feature.declare, Feature.createSchema, Feature.createView, Feature.createTrigger, Feature.merge, Feature.grant, Feature.commit, Feature.selectForXmlPath, Feature.use, Feature.allowSquareBracketQuotation, Feature.pivot, Feature.unpivot, Feature.pivotXml, Feature.selectGroupByGroupingSets}));

    private final Set<Feature> features;
    private final String versionString;

    private SqlServerVersion(String versionString, Set<Feature> featuresSupported) {
        this(versionString, featuresSupported, Collections.emptySet());
    }

    private SqlServerVersion(String versionString, Set<Feature> featuresSupported, Set<Feature> unsupported) {
        this.versionString = versionString;
        this.features = featuresSupported;
        this.features.removeAll(unsupported);
    }

    @Override
    public String getVersionString() {
        return this.versionString;
    }

    @Override
    public Set<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public String getName() {
        return DatabaseType.SQLSERVER.getName() + " " + this.getVersionString();
    }
}

