/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class GroupByDeParser
extends AbstractDeParser<GroupByElement> {
    private ExpressionVisitor expressionVisitor;

    GroupByDeParser() {
        super(new StringBuilder());
    }

    public GroupByDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
        this.buffer = buffer;
    }

    @Override
    public void deParse(GroupByElement groupBy) {
        List<Expression> expressions;
        this.buffer.append("GROUP BY ");
        if (groupBy.isUsingBrackets()) {
            this.buffer.append("( ");
        }
        if ((expressions = groupBy.getGroupByExpressionList().getExpressions()) != null) {
            Iterator<Expression> iter = expressions.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this.expressionVisitor);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (groupBy.isUsingBrackets()) {
            this.buffer.append(" )");
        }
        if (!groupBy.getGroupingSets().isEmpty()) {
            this.buffer.append("GROUPING SETS (");
            boolean first = true;
            for (Object o : groupBy.getGroupingSets()) {
                if (first) {
                    first = false;
                } else {
                    this.buffer.append(", ");
                }
                if (o instanceof Expression) {
                    this.buffer.append(o);
                    continue;
                }
                if (!(o instanceof ExpressionList)) continue;
                ExpressionList list = (ExpressionList)o;
                this.buffer.append(list.getExpressions() == null ? "()" : list.toString());
            }
            this.buffer.append(")");
        }
    }

    void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }
}

