/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.statement.select.GroupByVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class GroupByElement {
    private ExpressionList groupByExpressions = new ExpressionList().withUsingBrackets(false);
    private List groupingSets = new ArrayList();

    public boolean isUsingBrackets() {
        return this.groupByExpressions.isUsingBrackets();
    }

    public void setUsingBrackets(boolean usingBrackets) {
        this.groupByExpressions.setUsingBrackets(usingBrackets);
    }

    public GroupByElement withUsingBrackets(boolean usingBrackets) {
        this.groupByExpressions.setUsingBrackets(usingBrackets);
        return this;
    }

    public void accept(GroupByVisitor groupByVisitor) {
        groupByVisitor.visit(this);
    }

    public ExpressionList getGroupByExpressionList() {
        return this.groupByExpressions;
    }

    public void setGroupByExpressionList(ExpressionList groupByExpressions) {
        this.groupByExpressions = groupByExpressions;
    }

    @Deprecated
    public List<Expression> getGroupByExpressions() {
        return this.groupByExpressions.getExpressions();
    }

    @Deprecated
    public void setGroupByExpressions(List<Expression> groupByExpressions) {
        this.groupByExpressions.setExpressions(groupByExpressions);
    }

    @Deprecated
    public void addGroupByExpression(Expression groupByExpression) {
        if (this.groupByExpressions.getExpressions() == null) {
            this.groupByExpressions.setExpressions(new ArrayList<Expression>());
        }
        this.groupByExpressions.getExpressions().add(groupByExpression);
    }

    public List getGroupingSets() {
        return this.groupingSets;
    }

    public void setGroupingSets(List groupingSets) {
        this.groupingSets = groupingSets;
    }

    public void addGroupingSet(Expression expr) {
        this.groupingSets.add(expr);
    }

    public void addGroupingSet(ExpressionList list) {
        this.groupingSets.add(list);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GROUP BY ");
        if (this.groupByExpressions.getExpressions() != null && this.groupByExpressions.getExpressions().size() > 0) {
            if (this.groupByExpressions.isUsingBrackets()) {
                b.append("( ");
            }
            b.append(PlainSelect.getStringList(this.groupByExpressions.getExpressions()));
            if (this.groupByExpressions.isUsingBrackets()) {
                b.append(" )");
            }
        } else if (this.groupingSets.size() > 0) {
            b.append("GROUPING SETS (");
            boolean first = true;
            for (Object o : this.groupingSets) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                if (o instanceof Expression) {
                    b.append(o);
                    continue;
                }
                if (!(o instanceof ExpressionList)) continue;
                ExpressionList list = (ExpressionList)o;
                b.append(list.getExpressions() == null ? "()" : list.toString());
            }
            b.append(")");
        } else if (this.groupByExpressions.isUsingBrackets()) {
            b.append("()");
        }
        return b.toString();
    }

    public GroupByElement withGroupByExpressions(List<Expression> groupByExpressions) {
        this.setGroupByExpressions(groupByExpressions);
        return this;
    }

    public GroupByElement withGroupingSets(List groupingSets) {
        this.setGroupingSets(groupingSets);
        return this;
    }

    public GroupByElement addGroupByExpressions(Expression ... groupByExpressions) {
        List collection = Optional.ofNullable(this.getGroupByExpressions()).orElseGet(ArrayList::new);
        Collections.addAll(collection, groupByExpressions);
        return this.withGroupByExpressions(collection);
    }

    public GroupByElement addGroupByExpressions(Collection<? extends Expression> groupByExpressions) {
        List collection = Optional.ofNullable(this.getGroupByExpressions()).orElseGet(ArrayList::new);
        collection.addAll(groupByExpressions);
        return this.withGroupByExpressions(collection);
    }

    public GroupByElement addGroupingSets(Object ... groupingSets) {
        List collection = Optional.ofNullable(this.getGroupingSets()).orElseGet(ArrayList::new);
        Collections.addAll(collection, groupingSets);
        return this.withGroupingSets(collection);
    }

    public GroupByElement addGroupingSets(Collection<? extends Object> groupingSets) {
        List collection = Optional.ofNullable(this.getGroupingSets()).orElseGet(ArrayList::new);
        collection.addAll(groupingSets);
        return this.withGroupingSets(collection);
    }
}

