/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.grant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;

public class Grant
implements Statement {
    private String role;
    private List<String> privileges;
    private final List<String> objectName = new ArrayList<String>();
    private List<String> users;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public List<String> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(List<String> privileges) {
        this.privileges = privileges;
    }

    public String getObjectName() {
        return this.objectName.size() == 0 ? null : this.objectName.stream().map(part -> part == null ? "" : part).collect(Collectors.joining("."));
    }

    public List<String> getObjectNameParts() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName.clear();
        this.objectName.add(objectName);
    }

    public void setObjectName(List<String> objectName) {
        this.objectName.clear();
        this.objectName.addAll(objectName);
    }

    public List<String> getUsers() {
        return this.users;
    }

    public void setUsers(List<String> users) {
        this.users = users;
    }

    public String toString() {
        int i;
        StringBuilder buffer = new StringBuilder();
        buffer.append("GRANT ");
        if (this.role != null) {
            buffer.append(this.role);
        } else {
            for (i = 0; i < this.getPrivileges().size(); ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.privileges.get(i));
            }
            buffer.append(" ON ");
            buffer.append(this.getObjectName());
        }
        buffer.append(" TO ");
        for (i = 0; i < this.getUsers().size(); ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.users.get(i));
        }
        return buffer.toString();
    }

    public Grant withRole(String role) {
        this.setRole(role);
        return this;
    }

    public Grant withPrivileges(List<String> privileges) {
        this.setPrivileges(privileges);
        return this;
    }

    public Grant withObjectName(String objectName) {
        this.setObjectName(objectName);
        return this;
    }

    public Grant withObjectName(List<String> objectName) {
        this.setObjectName(objectName);
        return this;
    }

    public Grant withUsers(List<String> users) {
        this.setUsers(users);
        return this;
    }

    public Grant addPrivileges(String ... privileges) {
        List collection = Optional.ofNullable(this.getPrivileges()).orElseGet(ArrayList::new);
        Collections.addAll(collection, privileges);
        return this.withPrivileges(collection);
    }

    public Grant addPrivileges(Collection<String> privileges) {
        List collection = Optional.ofNullable(this.getPrivileges()).orElseGet(ArrayList::new);
        collection.addAll(privileges);
        return this.withPrivileges(collection);
    }

    public Grant addUsers(String ... users) {
        List collection = Optional.ofNullable(this.getUsers()).orElseGet(ArrayList::new);
        Collections.addAll(collection, users);
        return this.withUsers(collection);
    }

    public Grant addUsers(Collection<String> users) {
        List collection = Optional.ofNullable(this.getUsers()).orElseGet(ArrayList::new);
        collection.addAll(users);
        return this.withUsers(collection);
    }
}

