/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import cn.beecp.BeeDataSource;
import cn.beecp.BeeDataSourceConfig;
import com.baomidou.dynamic.datasource.creator.AbstractDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.beecp.BeeCpConfig;
import com.baomidou.dynamic.datasource.toolkit.ConfigMergeCreator;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class BeeCpDataSourceCreator
extends AbstractDataSourceCreator
implements DataSourceCreator,
InitializingBean {
    private static final ConfigMergeCreator<BeeCpConfig, BeeDataSourceConfig> MERGE_CREATOR = new ConfigMergeCreator<BeeCpConfig, BeeDataSourceConfig>("BeeCp", BeeCpConfig.class, BeeDataSourceConfig.class);
    private static Method copyToMethod = null;
    private BeeCpConfig gConfig;

    @Override
    public DataSource doCreateDataSource(DataSourceProperty dataSourceProperty) {
        BeeDataSource beeDataSource = new BeeDataSource();
        try {
            BeeDataSourceConfig config = MERGE_CREATOR.create(this.gConfig, dataSourceProperty.getBeecp());
            config.setUsername(dataSourceProperty.getUsername());
            config.setPassword(dataSourceProperty.getPassword());
            config.setJdbcUrl(dataSourceProperty.getUrl());
            config.setPoolName(dataSourceProperty.getPoolName());
            String driverClassName = dataSourceProperty.getDriverClassName();
            if (!StringUtils.isEmpty((Object)driverClassName)) {
                config.setDriverClassName(driverClassName);
            }
            if (Boolean.FALSE.equals(dataSourceProperty.getLazy())) {
                return new BeeDataSource(config);
            }
            try {
                copyToMethod.invoke((Object)config, beeDataSource);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (IntrospectionException e1) {
            e1.printStackTrace();
        }
        return beeDataSource;
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null || "cn.beecp.BeeDataSource".equals(type.getName());
    }

    public void afterPropertiesSet() throws Exception {
        this.gConfig = this.properties.getBeecp();
    }

    static {
        try {
            copyToMethod = BeeDataSourceConfig.class.getDeclaredMethod("copyTo", BeeDataSourceConfig.class);
            copyToMethod.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

