/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.enums.SeataMode;
import com.baomidou.dynamic.datasource.event.DataSourceInitEvent;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DatasourceInitProperties;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.support.ScriptRunner;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.jxdinfo.hussar.platform.core.BooleanUtil;
import com.p6spy.engine.spy.P6DataSource;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.xa.DataSourceProxyXA;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AbstractDataSourceCreator
implements DataSourceCreator {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataSourceCreator.class);
    @Autowired
    protected DynamicDataSourceProperties properties;
    @Autowired
    protected DataSourceInitEvent dataSourceInitEvent;

    public abstract DataSource doCreateDataSource(DataSourceProperty var1);

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        Boolean lazy;
        String publicKey = dataSourceProperty.getPublicKey();
        if (StringUtils.isEmpty((Object)publicKey)) {
            publicKey = this.properties.getPublicKey();
            dataSourceProperty.setPublicKey(publicKey);
        }
        if ((lazy = dataSourceProperty.getLazy()) == null) {
            lazy = this.properties.getLazy();
            dataSourceProperty.setLazy(lazy);
        }
        this.dataSourceInitEvent.beforeCreate(dataSourceProperty);
        DataSource dataSource = this.doCreateDataSource(dataSourceProperty);
        this.dataSourceInitEvent.afterCreate(dataSource);
        this.runScrip(dataSource, dataSourceProperty);
        return this.wrapDataSource(dataSource, dataSourceProperty);
    }

    private void runScrip(DataSource dataSource, DataSourceProperty dataSourceProperty) {
        DatasourceInitProperties initProperty = dataSourceProperty.getInit();
        String schema = initProperty.getSchema();
        String data = initProperty.getData();
        if (StringUtils.hasText((String)schema) || StringUtils.hasText((String)data)) {
            ScriptRunner scriptRunner = new ScriptRunner(initProperty.isContinueOnError(), initProperty.getSeparator());
            if (StringUtils.hasText((String)schema)) {
                scriptRunner.runScript(dataSource, schema);
            }
            if (StringUtils.hasText((String)data)) {
                scriptRunner.runScript(dataSource, data);
            }
        }
    }

    private DataSource wrapDataSource(DataSource dataSource, DataSourceProperty dataSourceProperty) {
        DbType databaseType;
        String name = dataSourceProperty.getPoolName();
        DataSource targetDataSource = dataSource;
        Boolean enabledP6spy = this.properties.getP6spy() != false && dataSourceProperty.getP6spy() != false;
        if (enabledP6spy.booleanValue()) {
            targetDataSource = new P6DataSource(dataSource);
            log.debug("dynamic-datasource [{}] wrap p6spy plugin", (Object)name);
        }
        if (DbType.POSTGRE_SQL.equals((Object)(databaseType = JdbcUtils.getDbType((String)dataSourceProperty.getUrl()))) || BooleanUtil.isTrue((Boolean)dataSourceProperty.getIsGauss())) {
            databaseType = DbType.GAUSS;
        }
        Boolean enabledSeata = this.properties.getSeata() != false && dataSourceProperty.getSeata() != false;
        SeataMode seataMode = this.properties.getSeataMode();
        if (enabledSeata.booleanValue()) {
            targetDataSource = SeataMode.XA == seataMode ? new DataSourceProxyXA(targetDataSource) : new DataSourceProxy(targetDataSource);
            log.debug("dynamic-datasource [{}] wrap seata plugin transaction mode ", (Object)name);
        }
        return new ItemDataSource(name, databaseType, dataSourceProperty.getDriverClassName(), dataSourceProperty.getUrl(), dataSourceProperty.getUsername(), dataSourceProperty.getPassword(), dataSource, targetDataSource, enabledP6spy, enabledSeata, seataMode, dataSourceProperty.getSchemaName(), dataSourceProperty.getDbMode());
    }
}

