/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.toolkit;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DsConfigUtil {
    private static final Pattern LINE_PATTERN = Pattern.compile("-(\\w)");

    public static String lineToUpper(String str) {
        Matcher matcher = LINE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, Object> mergeConfig(Map<String, Object> c, Map<String, Object> g) {
        int size = 1 + (int)((double)(c.size() + g.size()) / 0.75);
        HashMap<String, Object> map = new HashMap<String, Object>(size);
        map.putAll(g);
        map.putAll(c);
        return map;
    }

    public static Map<String, Method> getSetterMethods(Class<?> clazz) {
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                Method writeMethod = pd.getWriteMethod();
                if (writeMethod == null) continue;
                methodMap.put(pd.getName(), writeMethod);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return methodMap;
    }
}

