/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.util;

import com.google.common.base.Preconditions;
import java.util.List;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.table.TableSlice;
import tech.tablesaw.table.TableSliceGroup;

public class DoubleArrays {
    public static double[] toN(int n) {
        double[] result = new double[n];
        for (int i = 0; i < n; ++i) {
            result[i] = i;
        }
        return result;
    }

    public static double[][] to2dArray(NumericColumn<?> ... columns) {
        Preconditions.checkArgument((columns.length >= 1 ? 1 : 0) != 0);
        int obs = columns[0].size();
        double[][] allVals = new double[obs][columns.length];
        for (int r = 0; r < obs; ++r) {
            for (int c = 0; c < columns.length; ++c) {
                allVals[r][c] = columns[c].getDouble(r);
            }
        }
        return allVals;
    }

    public static double[][] to2dArray(List<NumericColumn<?>> columnList) {
        return DoubleArrays.to2dArray(columnList.toArray(new NumericColumn[0]));
    }

    public static double[][] to2dArray(TableSliceGroup views, int columnNumber) {
        int viewCount = views.size();
        double[][] allVals = new double[viewCount][];
        for (int viewNumber = 0; viewNumber < viewCount; ++viewNumber) {
            TableSlice view = views.get(viewNumber);
            allVals[viewNumber] = new double[view.rowCount()];
            NumericColumn<?> numberColumn = view.numberColumn(columnNumber);
            for (int r = 0; r < view.rowCount(); ++r) {
                allVals[viewNumber][r] = numberColumn.getDouble(r);
            }
        }
        return allVals;
    }

    public static double[][] to2dArray(double[] x, double[] y) {
        double[][] allVals = new double[x.length][2];
        for (int i = 0; i < x.length; ++i) {
            allVals[i][0] = x[i];
            allVals[i][1] = y[i];
        }
        return allVals;
    }

    public static double[][] to2dArray(NumericColumn<?> x, NumericColumn<?> y) {
        double[][] allVals = new double[x.size()][2];
        for (int i = 0; i < x.size(); ++i) {
            allVals[i][0] = x.getDouble(i);
            allVals[i][1] = y.getDouble(i);
        }
        return allVals;
    }
}

