/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import it.unimi.dsi.fastutil.ints.IntIterator;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

@Immutable
public final class Rows {
    private Rows() {
    }

    public static void copyRowsToTable(Selection rows, Table oldTable, Table newTable) {
        for (int columnIndex = 0; columnIndex < oldTable.columnCount(); ++columnIndex) {
            Column<?> oldColumn = oldTable.column(columnIndex);
            int r = 0;
            IntIterator intIterator = rows.iterator();
            while (intIterator.hasNext()) {
                int i = (Integer)intIterator.next();
                newTable.column(columnIndex).set(r, oldColumn, i);
                ++r;
            }
        }
    }

    public static void copyRowsToTable(int[] rows, Table oldTable, Table newTable) {
        for (int columnIndex = 0; columnIndex < oldTable.columnCount(); ++columnIndex) {
            Column<?> oldColumn = oldTable.column(columnIndex);
            int r = 0;
            for (int i : rows) {
                newTable.column(columnIndex).set(r, oldColumn, i);
                ++r;
            }
        }
    }

    public static void appendRowToTable(int row, Table oldTable, Table newTable) {
        int[] rows = new int[]{row};
        for (int columnIndex = 0; columnIndex < oldTable.columnCount(); ++columnIndex) {
            Column<?> oldColumn = oldTable.column(columnIndex);
            for (int i : rows) {
                newTable.column(columnIndex).append(oldColumn, i);
            }
        }
    }

    public static boolean compareRows(int rowInOriginal, Table original, Table tempTable) {
        int columnCount = original.columnCount();
        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
            ColumnType columnType = original.column(columnIndex).type();
            boolean result = columnType.compare(rowInOriginal, tempTable.column(columnIndex), original.column(columnIndex));
            if (result) continue;
            return false;
        }
        return true;
    }

    public static void head(int rowCount, Table oldTable, Table newTable) {
        BitmapBackedSelection rows = new BitmapBackedSelection(rowCount);
        int i = 0;
        while (i < rowCount) {
            rows.add(i++);
        }
        Rows.copyRowsToTable(rows, oldTable, newTable);
    }

    public static void tail(int rowsToInclude, Table oldTable, Table newTable) {
        int oldTableSize = oldTable.rowCount();
        int start = oldTableSize - rowsToInclude;
        BitmapBackedSelection rows = new BitmapBackedSelection(rowsToInclude);
        int i = start;
        while (i < oldTableSize) {
            rows.add(i++);
        }
        Rows.copyRowsToTable(rows, oldTable, newTable);
    }
}

