/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.times;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.columns.TemporalColumnFormatter;
import tech.tablesaw.columns.times.PackedLocalTime;
import tech.tablesaw.columns.times.TimeColumnType;

@Immutable
public class TimeColumnFormatter
extends TemporalColumnFormatter {
    public TimeColumnFormatter(DateTimeFormatter format) {
        super(format);
    }

    public TimeColumnFormatter() {
    }

    public TimeColumnFormatter(DateTimeFormatter format, String missingValueString) {
        super(format, missingValueString);
    }

    public String format(int value) {
        DateTimeFormatter format = this.getFormat();
        if (value == TimeColumnType.missingValueIndicator()) {
            return this.getMissingString();
        }
        if (format == null) {
            return PackedLocalTime.toShortTimeString(value);
        }
        LocalTime time = PackedLocalTime.asLocalTime(value);
        if (time == null) {
            return "";
        }
        return format.format(time);
    }

    public String toString() {
        return "TimeColumnFormatter{format=" + this.getFormat() + ", missingString='" + this.getMissingString() + '\'' + '}';
    }
}

