/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.log.impl;

import tech.powerjob.common.enums.LogLevel;
import tech.powerjob.common.model.LogConfig;
import tech.powerjob.worker.log.impl.AbstractOmsLogger;

public class OmsStdOutLogger
extends AbstractOmsLogger {
    private static final String PREFIX = "[PowerJob] [%s] ";

    public OmsStdOutLogger(LogConfig logConfig) {
        super(logConfig);
    }

    @Override
    void debug0(String messagePattern, Object ... args) {
        System.out.println(OmsStdOutLogger.buildStdOut(LogLevel.DEBUG, messagePattern, args));
    }

    @Override
    void info0(String messagePattern, Object ... args) {
        System.out.println(OmsStdOutLogger.buildStdOut(LogLevel.INFO, messagePattern, args));
    }

    @Override
    void warn0(String messagePattern, Object ... args) {
        System.out.println(OmsStdOutLogger.buildStdOut(LogLevel.WARN, messagePattern, args));
    }

    @Override
    void error0(String messagePattern, Object ... args) {
        System.err.println(OmsStdOutLogger.buildStdOut(LogLevel.ERROR, messagePattern, args));
    }

    private static String buildStdOut(LogLevel logLevel, String messagePattern, Object ... args) {
        return String.format(PREFIX, logLevel.name()).concat(OmsStdOutLogger.genLogContent(messagePattern, args));
    }
}

