/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import tech.powerjob.worker.common.PowerJobWorkerConfig;

public class ExecutorManager {
    private final ScheduledExecutorService coreExecutor;
    private final ScheduledExecutorService lightweightTaskStatusCheckExecutor;
    private final ExecutorService lightweightTaskExecutorService;

    public ExecutorManager(PowerJobWorkerConfig workerConfig) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        ThreadFactory coreThreadFactory = new ThreadFactoryBuilder().setNameFormat("powerjob-worker-core-%d").build();
        this.coreExecutor = new ScheduledThreadPoolExecutor(3, coreThreadFactory);
        ThreadFactory lightTaskReportFactory = new ThreadFactoryBuilder().setNameFormat("powerjob-worker-light-task-status-check-%d").build();
        this.lightweightTaskStatusCheckExecutor = new ScheduledThreadPoolExecutor(availableProcessors * 10, lightTaskReportFactory);
        ThreadFactory lightTaskExecuteFactory = new ThreadFactoryBuilder().setNameFormat("powerjob-worker-light-task-execute-%d").build();
        this.lightweightTaskExecutorService = new ThreadPoolExecutor(availableProcessors * 10, availableProcessors * 10, 120L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(workerConfig.getMaxLightweightTaskNum() * 2, true), lightTaskExecuteFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public void shutdown() {
        this.coreExecutor.shutdownNow();
    }

    public ScheduledExecutorService getCoreExecutor() {
        return this.coreExecutor;
    }

    public ScheduledExecutorService getLightweightTaskStatusCheckExecutor() {
        return this.lightweightTaskStatusCheckExecutor;
    }

    public ExecutorService getLightweightTaskExecutorService() {
        return this.lightweightTaskExecutorService;
    }
}

