/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.remote.framework.engine.impl;

import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.remote.framework.cs.CSInitializer;

class CSInitializerFactory {
    private static final Logger log = LoggerFactory.getLogger(CSInitializerFactory.class);

    CSInitializerFactory() {
    }

    static CSInitializer build(String targetType) {
        Reflections reflections = new Reflections("tech.powerjob", new Scanner[0]);
        Set cSInitializerClzSet = reflections.getSubTypesOf(CSInitializer.class);
        log.info("[CSInitializerFactory] scan subTypeOf CSInitializer: {}", (Object)cSInitializerClzSet);
        for (Class clz : cSInitializerClzSet) {
            try {
                CSInitializer csInitializer = (CSInitializer)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String type = csInitializer.type();
                log.info("[CSInitializerFactory] new instance for CSInitializer[{}] successfully, type={}, object: {}", new Object[]{clz, type, csInitializer});
                if (!targetType.equalsIgnoreCase(type)) continue;
                return csInitializer;
            }
            catch (Exception e) {
                log.error("[CSInitializerFactory] new instance for CSInitializer[{}] failed, maybe you should provide a non-parameter constructor", (Object)clz);
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
        throw new PowerJobException(String.format("can't load CSInitializer[%s], ensure your package name start with 'tech.powerjob' and import the dependencies!", targetType));
    }
}

