/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.official.processors.impl;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Pattern;
import shade.powerjob.com.alibaba.fastjson.JSON;
import shade.powerjob.com.alibaba.fastjson.JSONArray;
import shade.powerjob.com.google.common.base.Stopwatch;
import shade.powerjob.org.apache.commons.io.FileUtils;
import shade.powerjob.org.apache.commons.lang3.StringUtils;
import tech.powerjob.official.processors.util.SecurityUtils;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.sdk.BroadcastProcessor;
import tech.powerjob.worker.log.OmsLogger;

public class FileCleanupProcessor
implements BroadcastProcessor {
    public ProcessResult preProcess(TaskContext context) throws Exception {
        if (SecurityUtils.disable("powerjob.official-processor.file-cleanup.enable")) {
            String msg = String.format("FileCleanupProcessor is not enabled, please set '-D%s=true' to enable it", "powerjob.official-processor.file-cleanup.enable");
            context.getOmsLogger().warn(msg, new Object[0]);
            return new ProcessResult(false, msg);
        }
        return new ProcessResult(true);
    }

    public ProcessResult process(TaskContext taskContext) throws Exception {
        OmsLogger logger = taskContext.getOmsLogger();
        logger.info("using params: {}", new Object[]{taskContext.getJobParams()});
        LongAdder cleanNum = new LongAdder();
        Stopwatch sw = Stopwatch.createStarted();
        List<CleanupParams> cleanupParamsList = JSONArray.parseArray(taskContext.getJobParams(), CleanupParams.class);
        cleanupParamsList.forEach(params -> {
            logger.info("start to process: {}", new Object[]{JSON.toJSON(params)});
            if (StringUtils.isEmpty(((CleanupParams)params).filePattern) || StringUtils.isEmpty(((CleanupParams)params).dirPath)) {
                logger.warn("skip due to invalid params!", new Object[0]);
                return;
            }
            File dir = new File(((CleanupParams)params).dirPath);
            if (!dir.exists()) {
                logger.warn("skip due to dirPath[{}] not exists", new Object[]{((CleanupParams)params).dirPath});
                return;
            }
            if (!dir.isDirectory()) {
                logger.warn("skip due to dirPath[{}] is not a directory", new Object[]{((CleanupParams)params).dirPath});
                return;
            }
            logger.info("start to search directory: {}", new Object[]{((CleanupParams)params).dirPath});
            Collection<File> files = FileUtils.listFiles(dir, null, true);
            logger.info("total file num: {}", new Object[]{files.size()});
            Pattern filePattern = Pattern.compile(((CleanupParams)params).filePattern);
            files.forEach(file -> {
                String fileName = file.getName();
                String filePath = file.getAbsolutePath();
                if (!filePattern.matcher(fileName).matches()) {
                    logger.info("file[{}] won't be deleted due to filename not match the pattern: {}", new Object[]{fileName, ((CleanupParams)params).filePattern});
                    return;
                }
                int interval = (int)Math.ceil((double)(System.currentTimeMillis() - file.lastModified()) / 3600000.0);
                if (interval < ((CleanupParams)params).retentionTime) {
                    logger.info("file[{}] won't be deleted because it does not meet the time requirement", new Object[]{filePath});
                    return;
                }
                try {
                    FileUtils.forceDelete(file);
                    cleanNum.increment();
                    logger.info("delete file[{}] successfully!", new Object[]{filePath});
                }
                catch (Exception e) {
                    logger.error("delete file[{}] failed!", new Object[]{filePath, e});
                }
            });
        });
        return new ProcessResult(true, String.format("cost:%s,clean:%d", sw.toString(), cleanNum.longValue()));
    }

    public static class CleanupParams {
        private String dirPath;
        private String filePattern;
        private Integer retentionTime;

        public String getDirPath() {
            return this.dirPath;
        }

        public String getFilePattern() {
            return this.filePattern;
        }

        public Integer getRetentionTime() {
            return this.retentionTime;
        }

        public void setDirPath(String dirPath) {
            this.dirPath = dirPath;
        }

        public void setFilePattern(String filePattern) {
            this.filePattern = filePattern;
        }

        public void setRetentionTime(Integer retentionTime) {
            this.retentionTime = retentionTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CleanupParams)) {
                return false;
            }
            CleanupParams other = (CleanupParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$dirPath = this.getDirPath();
            String other$dirPath = other.getDirPath();
            if (this$dirPath == null ? other$dirPath != null : !this$dirPath.equals(other$dirPath)) {
                return false;
            }
            String this$filePattern = this.getFilePattern();
            String other$filePattern = other.getFilePattern();
            if (this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern)) {
                return false;
            }
            Integer this$retentionTime = this.getRetentionTime();
            Integer other$retentionTime = other.getRetentionTime();
            return !(this$retentionTime == null ? other$retentionTime != null : !((Object)this$retentionTime).equals(other$retentionTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CleanupParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dirPath = this.getDirPath();
            result = result * 59 + ($dirPath == null ? 43 : $dirPath.hashCode());
            String $filePattern = this.getFilePattern();
            result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
            Integer $retentionTime = this.getRetentionTime();
            result = result * 59 + ($retentionTime == null ? 43 : ((Object)$retentionTime).hashCode());
            return result;
        }

        public String toString() {
            return "FileCleanupProcessor.CleanupParams(dirPath=" + this.getDirPath() + ", filePattern=" + this.getFilePattern() + ", retentionTime=" + this.getRetentionTime() + ")";
        }
    }
}

